/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars;

import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.TimeBarMarker;
import de.jaret.util.ui.timebars.TimeBarMarkerListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTimeBarMarker
implements TimeBarMarker {
    protected boolean _draggable = true;
    protected List<TimeBarMarkerListener> _listenerList;

    public AbstractTimeBarMarker(boolean draggable) {
        this._draggable = draggable;
    }

    public boolean isDraggable() {
        return this._draggable;
    }

    public void setDraggable(boolean draggable) {
        this._draggable = draggable;
        this.fireMarkerDescriptionChanged(this.getDescription(), this.getDescription());
    }

    public void addTimeBarMarkerListener(TimeBarMarkerListener tbml) {
        if (this._listenerList == null) {
            this._listenerList = new ArrayList<TimeBarMarkerListener>();
        }
        this._listenerList.add(tbml);
    }

    public void remTimeBarMarkerListener(TimeBarMarkerListener tbml) {
        if (this._listenerList != null) {
            this._listenerList.remove(tbml);
        }
    }

    protected void fireMarkerChanged(JaretDate oldDate, JaretDate newDate) {
        if (this._listenerList != null) {
            for (TimeBarMarkerListener listener : this._listenerList) {
                listener.markerMoved(this, oldDate, newDate);
            }
        }
    }

    protected void fireMarkerDescriptionChanged(String oldValue, String newValue) {
        if (this._listenerList != null) {
            for (TimeBarMarkerListener listener : this._listenerList) {
                listener.markerDescriptionChanged(this, oldValue, newValue);
            }
        }
    }
}

