/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars;

public class TickScaler {
    private static final double[] _pixPerSecondLimits = new double[]{1.1574074074074073E-5, 2.3148148148148147E-5, 8.101851851851852E-5, 2.199074074074074E-4, 8.0E-4, 0.0015, 0.0025, 0.005, 0.01, 0.012, 0.05, 0.1, 0.5};
    private static final int[] _majorTickMinutes = new int[]{80640, 40320, 20160, 10080, 1440, 720, 360, 240, 120, 60, 15, 5, 2};
    private static final int[] _minorTickMinutes = new int[]{40320, 20160, 1440, 1440, 240, 120, 60, 60, 30, 15, 5, 1, 1};
    private static final Range[] _range = new Range[]{Range.MONTH, Range.MONTH, Range.WEEK, Range.WEEK, Range.DAY, Range.HOUR, Range.HOUR, Range.HOUR, Range.HOUR, Range.HOUR, Range.HOUR, Range.HOUR, Range.HOUR, Range.HOUR};

    public static int getTickIdx(double pixPerSecond) {
        for (int i = 0; i < _pixPerSecondLimits.length; ++i) {
            if (!(pixPerSecond <= _pixPerSecondLimits[i])) continue;
            return i;
        }
        return _pixPerSecondLimits.length - 1;
    }

    public static int getMajorTickMinutes(int idx) {
        return _majorTickMinutes[idx];
    }

    public static int getMinorTickMinutes(int idx) {
        return _minorTickMinutes[idx];
    }

    public static Range getRange(int idx) {
        return _range[idx];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Range {
        MONTH,
        WEEK,
        DAY,
        HOUR;

    }
}

