/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars;

import de.jaret.util.date.Interval;
import de.jaret.util.date.IntervalImpl;
import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.TimeBarIntervalFilter;
import de.jaret.util.ui.timebars.TimeBarMarker;
import de.jaret.util.ui.timebars.TimeBarMarkerListener;
import de.jaret.util.ui.timebars.TimeBarRowFilter;
import de.jaret.util.ui.timebars.TimeBarRowSorter;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.mod.IntervalModificator;
import de.jaret.util.ui.timebars.model.DefaultRowHeader;
import de.jaret.util.ui.timebars.model.DefaultTimeBarNode;
import de.jaret.util.ui.timebars.model.DefaultTimeBarViewState;
import de.jaret.util.ui.timebars.model.FocussedIntervalListener;
import de.jaret.util.ui.timebars.model.HierarchicalTimeBarModel;
import de.jaret.util.ui.timebars.model.HierarchicalViewState;
import de.jaret.util.ui.timebars.model.HierarchicalViewStateImpl;
import de.jaret.util.ui.timebars.model.ITimeBarChangeListener;
import de.jaret.util.ui.timebars.model.ITimeBarViewState;
import de.jaret.util.ui.timebars.model.ITimeBarViewStateListener;
import de.jaret.util.ui.timebars.model.PPSInterval;
import de.jaret.util.ui.timebars.model.StdHierarchicalTimeBarModel;
import de.jaret.util.ui.timebars.model.TimeBarModel;
import de.jaret.util.ui.timebars.model.TimeBarModelListener;
import de.jaret.util.ui.timebars.model.TimeBarNode;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.model.TimeBarRowHeader;
import de.jaret.util.ui.timebars.model.TimeBarRowListener;
import de.jaret.util.ui.timebars.model.TimeBarSelectionListener;
import de.jaret.util.ui.timebars.model.TimeBarSelectionModel;
import de.jaret.util.ui.timebars.model.TimeBarSelectionModelImpl;
import de.jaret.util.ui.timebars.strategy.DefaultOverlapStrategy;
import de.jaret.util.ui.timebars.strategy.IOverlapStrategy;
import de.jaret.util.ui.timebars.strategy.OverlapInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBarViewerDelegate
implements TimeBarModelListener,
TimeBarSelectionListener,
TimeBarMarkerListener,
PropertyChangeListener {
    private static final double DEFAULT_PIXEL_PER_SECOND = 0.023148148148148147;
    private static final int PADDING_PIXEL = 30;
    private static final int MIN_DRAG_HIERARCHY_WIDTH = 2;
    private static final int MIN_DRAG_HEADER_WIDTH = 2;
    private static final int MIN_ROW_HEIGHT = 10;
    private static final double MILLISCALING = 1000.0;
    private static final int DEFAULT_SEL_DELTA = 2;
    private int _selectionDelta = 2;
    protected final TimeBarViewerInterface _tbvi;
    protected double _pixelPerSeconds = 0.023148148148148147;
    protected boolean _variableXScale = false;
    protected TimeBarNode _xScalePPSIntervalRow;
    protected boolean _milliAccuracy = false;
    protected int _xAxisHeight = 50;
    protected int _yAxisWidth = 150;
    protected int _hierarchyWidth = 0;
    protected boolean _lineDraggingAllowed = true;
    protected TimeBarViewerInterface.Orientation _orientation = TimeBarViewerInterface.Orientation.HORIZONTAL;
    protected TimeBarModel _model;
    protected HierarchicalTimeBarModel _hierarchicalModel;
    protected ITimeBarViewState _timeBarViewState;
    protected HierarchicalViewState _hierarchicalViewState;
    protected String _title;
    protected int _firstRow = 0;
    protected int _firstRowPixelOffset = 0;
    protected List<TimeBarRow> _rowList;
    protected boolean _adjustMinMaxDatesByModel = true;
    protected boolean _optimizeScrolling = true;
    protected JaretDate _startDate = new JaretDate();
    protected JaretDate _endDate = new JaretDate();
    protected JaretDate _minDate;
    protected JaretDate _maxDate;
    protected JaretDate _lastStartDate;
    protected TimeBarRowFilter _rowFilter;
    protected TimeBarRowSorter _rowSorter;
    protected TimeBarIntervalFilter _intervalFilter;
    protected TimeBarSelectionModel _selectionModel = new TimeBarSelectionModelImpl();
    protected List<TimeBarMarker> _markers;
    protected boolean _drawGrid = true;
    protected boolean _drawRowGrid = false;
    protected int _timeScalePosition = 1;
    protected Rectangle _diagramRect = new Rectangle(0, 0, 0, 0);
    protected Rectangle _xAxisRect;
    protected Rectangle _yAxisRect;
    protected Rectangle _titleRect;
    protected Rectangle _hierarchyRect;
    protected int _offsetTop;
    protected int _offsetLeft;
    private boolean _rectSelectionEnabled = true;
    protected TimeBarMarker _draggedMarker;
    protected Interval _changingInterval;
    protected boolean _draggedInterval;
    protected boolean _draggedIntervalEdgeLeft;
    protected boolean _hierarchyLineDragging = false;
    protected boolean _headerLineDragging = false;
    protected boolean _rowHeightDraggingAllowed = false;
    protected TimeBarRow _heightDraggedRow = null;
    protected boolean _autoscroll = true;
    protected Rectangle _selectionRect = null;
    protected Rectangle _lastSelRect;
    protected TimeBarRow _highlightedRow;
    private String _name;
    protected boolean _drawOverlapping = false;
    protected int _keyboardChangeDelta = 3600;
    protected Interval _focussedInterval;
    protected TimeBarRow _focussedRow;
    private TimeBarRowListener _repaintingRowListener;
    private int _autoScaleRows = -1;
    protected List<FocussedIntervalListener> _focussedIntervalListeners;
    protected List<ITimeBarChangeListener> _timeBarChangeListeners = new Vector<ITimeBarChangeListener>();
    protected List<IntervalModificator> _intervalModificators = new ArrayList<IntervalModificator>(2);
    protected boolean _strictClipTimeCheck = false;
    protected int _scrollLookBackMinutes = 120;
    protected int _scrollLookForwardMinutes = 120;
    protected double _timeFactor = 1.0;
    protected IOverlapStrategy _overlapStrategy = new DefaultOverlapStrategy(this);
    protected Point _ctxCoordinate;
    protected TimeBarRow _ctxRow;
    protected Interval _originalInterval;
    protected int _startIntervalDragX;
    protected JaretDate _startIntervalDragDate = null;
    protected JaretDate _lastDragDate;
    protected JaretDate _markerDragStart;
    protected TimeBarRow _intervalDraggedRow;

    public TimeBarViewerDelegate(TimeBarViewerInterface tbvi) {
        this._tbvi = tbvi;
        this._selectionModel.addTimeBarSelectionListener(this);
        this._timeBarViewState = new DefaultTimeBarViewState(this);
        this._timeBarViewState.setDefaultRowHeight(50);
        this._timeBarViewState.addTimeBarViewStateListener(new ITimeBarViewStateListener(){

            public void rowHeightChanged(TimeBarRow row, int newHeight) {
                if (TimeBarViewerDelegate.this._tbvi != null) {
                    TimeBarViewerDelegate.this.updateRowScrollBar();
                    TimeBarViewerDelegate.this._tbvi.repaint();
                }
            }

            public void viewStateChanged() {
                if (TimeBarViewerDelegate.this._tbvi != null) {
                    TimeBarViewerDelegate.this.updateRowScrollBar();
                    TimeBarViewerDelegate.this._tbvi.repaint();
                }
            }
        });
    }

    public void dispose() {
        if (this._model != null) {
            this._model.remTimeBarModelListener(this);
        }
        if (this._selectionModel != null) {
            this._selectionModel.remTimeBarSelectionListener(this);
        }
        if (this._markers != null) {
            for (TimeBarMarker marker : this._markers) {
                marker.remTimeBarMarkerListener(this);
            }
        }
        if (this._rowFilter != null) {
            this._rowFilter.removePropertyChangeListener(this);
        }
        if (this._rowSorter != null) {
            this._rowSorter.removePropertyChangeListener(this);
        }
    }

    public boolean isDisplayed(JaretDate date) {
        return this._startDate.compareTo(date) <= 0 && (this._endDate == null || this._endDate.compareTo(date) >= 0);
    }

    public void setRowFilter(TimeBarRowFilter rowFilter) {
        if (this._rowFilter == null && rowFilter != null || this._rowFilter != null && !this._rowFilter.equals(rowFilter)) {
            TimeBarRowFilter oldFilter = this._rowFilter;
            if (oldFilter != null) {
                oldFilter.removePropertyChangeListener(this);
            }
            this._rowFilter = rowFilter;
            if (this._rowFilter != null) {
                this._rowFilter.addPropertyChangeListener(this);
            }
            this.updateRowList();
            if (this._tbvi != null) {
                this._tbvi.repaint();
                this._tbvi.firePropertyChangeX("RowFilter", oldFilter, rowFilter);
            }
        }
    }

    public TimeBarRowFilter getRowFilter() {
        return this._rowFilter;
    }

    public boolean isFiltered(TimeBarRow row) {
        if (this._rowFilter == null) {
            return false;
        }
        return !this._rowFilter.isInResult(row);
    }

    public void setRowSorter(TimeBarRowSorter rowSorter) {
        if (this._rowSorter == null && rowSorter != null || this._rowSorter != null && !this._rowSorter.equals(rowSorter)) {
            TimeBarRowSorter oldSorter = this._rowSorter;
            if (oldSorter != null) {
                oldSorter.removePropertyChangeListener(this);
            }
            this._rowSorter = rowSorter;
            if (this._rowSorter != null) {
                this._rowSorter.addPropertyChangeListener(this);
            }
            this.updateRowList();
            if (this._tbvi != null) {
                this._tbvi.repaint();
                this._tbvi.firePropertyChangeX("RowSorter", oldSorter, rowSorter);
            }
        }
    }

    public TimeBarRowSorter getRowSorter() {
        return this._rowSorter;
    }

    public void setIntervalFilter(TimeBarIntervalFilter intervalFilter) {
        if (this._intervalFilter == null && intervalFilter != null || this._intervalFilter != null && !this._intervalFilter.equals(intervalFilter)) {
            TimeBarIntervalFilter oldFilter = this._intervalFilter;
            if (oldFilter != null) {
                oldFilter.removePropertyChangeListener(this);
            }
            this._intervalFilter = intervalFilter;
            if (this._intervalFilter != null) {
                this._intervalFilter.addPropertyChangeListener(this);
                this._overlapStrategy.clearCachedData();
            }
            this._tbvi.repaint();
            this._tbvi.firePropertyChangeX("IntervalFilter", oldFilter, intervalFilter);
        }
    }

    public TimeBarIntervalFilter getIntervalFilter() {
        return this._intervalFilter;
    }

    public boolean isFiltered(Interval interval) {
        if (this._intervalFilter == null) {
            return false;
        }
        return !this._intervalFilter.isInResult(interval);
    }

    public void updateRowList() {
        if (this._model != null) {
            int oldRowCount = this._rowList != null ? this._rowList.size() : 0;
            this._rowList = new ArrayList<TimeBarRow>();
            for (int r = 0; r < this._model.getRowCount(); ++r) {
                if (this._rowFilter != null) {
                    if (!this._rowFilter.isInResult(this._model.getRow(r))) continue;
                    this._rowList.add(this._model.getRow(r));
                    continue;
                }
                this._rowList.add(this._model.getRow(r));
            }
            if (this._rowSorter != null) {
                Collections.sort(this._rowList, this._rowSorter);
            }
            if (this.getRowCount() != oldRowCount && this._tbvi != null) {
                this.updateRowScrollBar();
            }
        }
    }

    public TimeBarRow getRow(int idx) {
        return this._rowList.get(idx);
    }

    public int getRowCount() {
        return this._rowList != null ? this._rowList.size() : 0;
    }

    public long getTotalSeconds() {
        return this.getMaxDate().diffSecondsL(this.getMinDate());
    }

    public long getTotalMilliSeconds() {
        return this.getMaxDate().diffMilliSeconds(this.getMinDate());
    }

    public int getSecondsDisplayed() {
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            if (!this._variableXScale) {
                return (int)((double)this._diagramRect.width / this._pixelPerSeconds);
            }
            int endx = this._diagramRect.width;
            JaretDate endDate = this.dateForCoord(endx);
            return endDate.diffSeconds(this._startDate);
        }
        if (!this._variableXScale) {
            return (int)((double)this._diagramRect.height / this._pixelPerSeconds);
        }
        int endy = this._diagramRect.height;
        JaretDate endDate = this.dateForCoord(endy);
        return endDate.diffSeconds(this._startDate);
    }

    public long getMilliSecondsDisplayed() {
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            if (!this._variableXScale) {
                return (int)((double)this._diagramRect.width / this.getPixelPerMilliSecond());
            }
            int endx = this._diagramRect.width;
            JaretDate endDate = this.dateForX(endx);
            return endDate.diffMilliSeconds(this._startDate);
        }
        if (!this._variableXScale) {
            return (int)((double)this._diagramRect.height / this.getPixelPerMilliSecond());
        }
        int endx = this._diagramRect.height;
        JaretDate endDate = this.dateForX(endx);
        return endDate.diffMilliSeconds(this._startDate);
    }

    public TimeBarSelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public void setSelectionModel(TimeBarSelectionModel selectionModel) {
        if (this._selectionModel != null) {
            this._selectionModel.remTimeBarSelectionListener(this);
        }
        this._selectionModel = selectionModel;
        this._selectionModel.addTimeBarSelectionListener(this);
        this._tbvi.repaint();
    }

    public boolean getAdjustMinMaxDatesByModel() {
        return this._adjustMinMaxDatesByModel;
    }

    public void setAdjustMinMaxDatesByModel(boolean adjustMinMaxDatesByModel) {
        this._adjustMinMaxDatesByModel = adjustMinMaxDatesByModel;
    }

    public JaretDate getMaxDate() {
        return this._maxDate;
    }

    public void setMaxDate(JaretDate maxDate) {
        long milliseconds = (int)(30.0 / (this._pixelPerSeconds * 1000.0));
        JaretDate oldVal = this._maxDate;
        this._maxDate = maxDate.copy();
        this._maxDate.advanceMillis(milliseconds);
        if (oldVal == null || !oldVal.equals((Object)maxDate)) {
            this.updateTimeScrollBar();
            if (this._tbvi != null) {
                this._tbvi.repaint();
                this._tbvi.firePropertyChangeX("MaxDate", oldVal, maxDate);
            }
        }
    }

    public JaretDate getMinDate() {
        return this._minDate;
    }

    public void setMinDate(JaretDate minDate) {
        long milliseconds = (int)(30.0 / (this._pixelPerSeconds * 1000.0));
        JaretDate oldVal = this._minDate;
        this._minDate = minDate.copy();
        this._minDate.advanceMillis(-milliseconds);
        if (oldVal == null || !oldVal.equals((Object)minDate)) {
            this.updateTimeScrollBar();
            if (this._tbvi != null) {
                this._tbvi.repaint();
                this._tbvi.firePropertyChangeX("MinDate", oldVal, minDate);
            }
        }
    }

    public JaretDate getStartDate() {
        return this._startDate;
    }

    public synchronized void setStartDate(JaretDate startDate) {
        this._lastStartDate = this._startDate;
        JaretDate oldVal = this._startDate;
        this._startDate = startDate.copy();
        if (!(oldVal != null && oldVal.equals((Object)this._startDate) || this._tbvi == null)) {
            this.updateTimeScrollBar();
            this._tbvi.repaint();
            this._tbvi.firePropertyChangeX("StartDate", oldVal, this._startDate);
        }
    }

    protected void scrollTo(JaretDate startDate) {
        if (!this._optimizeScrolling || this._tbvi == null) {
            this.setStartDate(startDate);
        } else {
            try {
                this._lastStartDate = this._startDate;
                JaretDate oldVal = this._startDate;
                int oldx = this.xForDateAbs(this._startDate);
                int newx = this.xForDateAbs(startDate);
                JaretDate newStartDate = this.dateForCoordAbs(newx);
                int diff = newx - oldx;
                int comp = this._orientation.equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL) ? this._tbvi.getWidth() : this._tbvi.getHeight();
                if (Math.abs(diff) > comp / 2) {
                    this.setStartDate(startDate);
                    return;
                }
                if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                    this._tbvi.doScrollHorizontal(diff);
                } else {
                    this._tbvi.doScrollVertical(diff);
                }
                this._startDate = newStartDate;
                if (!(oldVal != null && oldVal.equals((Object)this._startDate) || this._tbvi == null)) {
                    this.updateTimeScrollBar();
                    this._tbvi.firePropertyChangeX("StartDate", oldVal, this._startDate);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public TimeBarModel getModel() {
        return this._model;
    }

    public void setModel(TimeBarModel model) {
        if (this._model != null) {
            this._model.remTimeBarModelListener(this);
        }
        this._model = model;
        if (model != null) {
            if (this._adjustMinMaxDatesByModel) {
                this._minDate = this._model.getMinDate();
                this._maxDate = this._model.getMaxDate();
                this.setMinDate(this._model.getMinDate());
                this.setMaxDate(this._model.getMaxDate());
                this.setStartDate(this._model.getMinDate().copy());
                this.setMinDate(this._model.getMinDate());
                this.setMaxDate(this._model.getMaxDate());
            } else {
                this._minDate = new JaretDate();
                this._maxDate = new JaretDate();
                this.setStartDate(new JaretDate());
            }
            if (this._hierarchicalModel == null) {
                this._hierarchicalViewState = null;
            }
            this._model.addTimeBarModelListener(this);
        } else {
            this._hierarchicalViewState = null;
        }
        this.updateRowList();
        if (this._tbvi != null) {
            this.updateScrollBars();
            this._tbvi.repaint();
        }
    }

    public void setModel(HierarchicalTimeBarModel hModel) {
        this._hierarchicalViewState = new HierarchicalViewStateImpl();
        this._hierarchicalModel = hModel;
        StdHierarchicalTimeBarModel model = null;
        if (hModel != null) {
            model = new StdHierarchicalTimeBarModel(hModel, this._hierarchicalViewState);
        }
        this.setModel(model);
    }

    public HierarchicalTimeBarModel getHierarchicalModel() {
        return this._hierarchicalModel;
    }

    private void checkAndAdjustMinMax() {
        if (this._adjustMinMaxDatesByModel) {
            this.setMinDate(this._model.getMinDate().copy());
            this.setMaxDate(this._model.getMaxDate().copy());
        }
    }

    public void setPixelPerSecond(double pixelPerSecond) {
        if (pixelPerSecond != this._pixelPerSeconds) {
            double oldValue = this._pixelPerSeconds;
            this._pixelPerSeconds = pixelPerSecond;
            if (this._tbvi != null) {
                this.updateTimeScrollBar();
                this._tbvi.repaint();
                this._tbvi.firePropertyChange("PixelPerSecond", oldValue, pixelPerSecond);
            }
        }
    }

    public double getPixelPerSecond() {
        return this._pixelPerSeconds;
    }

    protected double getPixelPerMilliSecond() {
        return this._pixelPerSeconds / 1000.0;
    }

    public void setRowHeight(int rowHeight) {
        if (rowHeight != this._timeBarViewState.getDefaultRowHeight()) {
            int oldVal = this._timeBarViewState.getDefaultRowHeight();
            this._timeBarViewState.setDefaultRowHeight(rowHeight);
            if (this._tbvi != null) {
                this._tbvi.repaint();
                this.updateRowScrollBar();
                if (this._tbvi != null) {
                    this._tbvi.firePropertyChange("RowHeight", oldVal, rowHeight);
                }
            }
        }
    }

    public int getRowHeight() {
        return this._timeBarViewState.getDefaultRowHeight();
    }

    public JaretDate getEndDate() {
        return this._endDate;
    }

    public void addMarker(TimeBarMarker marker) {
        if (this._markers == null) {
            this._markers = new ArrayList<TimeBarMarker>();
        }
        this._markers.add(marker);
        marker.addTimeBarMarkerListener(this);
        if (this.isDisplayed(marker.getDate())) {
            this._tbvi.repaint();
        }
        if (this._minDate != null && marker.getDate().compareTo(this._minDate) < 0) {
            this.setMinDate(marker.getDate().copy());
        } else if (this._maxDate != null && marker.getDate().compareTo(this._maxDate) > 0) {
            this.setMaxDate(marker.getDate().copy());
        }
    }

    public void remMarker(TimeBarMarker marker) {
        if (this._markers != null) {
            this._markers.remove(marker);
            marker.remTimeBarMarkerListener(this);
            if (this.isDisplayed(marker.getDate())) {
                this._tbvi.repaint();
            }
        }
    }

    public TimeBarMarker getMarkerForXY(int x, int y) {
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            return this.getMarkerForCoord(x);
        }
        return this.getMarkerForCoord(y);
    }

    protected TimeBarMarker getMarkerForCoord(int coord) {
        TimeBarMarker result = null;
        if (this._markers != null) {
            for (int i = 0; i < this._markers.size(); ++i) {
                TimeBarMarker marker = this._markers.get(i);
                int mx = this.xForDate(marker.getDate());
                if (coord - this._selectionDelta >= mx || coord + this._selectionDelta <= mx) continue;
                result = marker;
                break;
            }
        }
        return result;
    }

    public List<TimeBarMarker> getMarkers() {
        return this._markers;
    }

    public void addMarkers(List<TimeBarMarker> markers) {
        if (markers != null) {
            for (TimeBarMarker marker : markers) {
                this.addMarker(marker);
            }
        }
    }

    public void updateScrollBars() {
        if (this._model != null && this._model.getRowCount() != 0) {
            this.updateTimeScrollBar();
            this.updateRowScrollBar();
        }
    }

    private void updateTimeScrollBar() {
        if (this._tbvi != null) {
            if (this.isMilliAccuracy()) {
                long pos;
                long milliSecondsDisplayed = this.getMilliSecondsDisplayed();
                long totalMilliSeconds = this.getTotalMilliSeconds();
                if (totalMilliSeconds - (pos = this._startDate.diffMilliSeconds(this._minDate)) < milliSecondsDisplayed) {
                    milliSecondsDisplayed = totalMilliSeconds - pos;
                }
                int addWidth = this._yAxisWidth + this._hierarchyWidth;
                long addMillis = this._orientation.equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL) ? this.dateForCoord(this._diagramRect.x + this._diagramRect.width).diffMilliSeconds(this.dateForCoord(this._diagramRect.x + this._diagramRect.width - addWidth)) : this.dateForCoord(this._diagramRect.y + this._diagramRect.height).diffMilliSeconds(this.dateForCoord(this._diagramRect.y + this._diagramRect.height - addWidth));
                this.updateTimeScrollBar((int)totalMilliSeconds, (int)pos, (int)(milliSecondsDisplayed + addMillis));
            } else {
                long pos;
                long secondsDisplayed = this.getSecondsDisplayed();
                long totalSeconds = this.getTotalSeconds();
                if (totalSeconds - (pos = this._startDate.diffSecondsL(this._minDate)) < secondsDisplayed) {
                    secondsDisplayed = totalSeconds - pos;
                }
                int addWidth = this._yAxisWidth + this._hierarchyWidth;
                int addSeconds = 0;
                if (this._variableXScale) {
                    addSeconds = this._orientation.equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL) ? this.dateForCoord(this._diagramRect.x + this._diagramRect.width).diffSeconds(this.dateForCoord(this._diagramRect.x + this._diagramRect.width - addWidth)) : this.dateForCoord(this._diagramRect.y + this._diagramRect.height).diffSeconds(this.dateForCoord(this._diagramRect.y + this._diagramRect.height - addWidth));
                }
                int tot = 0;
                int p = 0;
                int displayed = 0;
                if (totalSeconds < Integer.MAX_VALUE) {
                    tot = (int)totalSeconds;
                    p = (int)pos;
                    displayed = (int)(secondsDisplayed + (long)addSeconds);
                    this._timeFactor = 1.0;
                } else {
                    this._timeFactor = 2.147483647E9 / (double)totalSeconds;
                    tot = (int)((double)totalSeconds * this._timeFactor);
                    p = (int)((double)pos * this._timeFactor);
                    displayed = (int)((double)(secondsDisplayed + (long)addSeconds) * this._timeFactor);
                }
                this.updateTimeScrollBar(tot, p, displayed);
            }
        }
    }

    private void updateTimeScrollBar(int max, int pos, int secondsDisplayed) {
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            this._tbvi.updateXScrollBar(max, pos, secondsDisplayed);
        } else if (this._orientation == TimeBarViewerInterface.Orientation.VERTICAL) {
            this._tbvi.updateYScrollBar(max, pos, secondsDisplayed);
        }
    }

    public void handleHorizontalScroll(int value, boolean redirect) {
        if (!redirect || this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            JaretDate date = this.getMinDate().copy();
            if (this.isMilliAccuracy()) {
                date.advanceMillis((long)value);
            } else {
                date.advanceSeconds((double)value / this._timeFactor);
            }
            this.scrollTo(date);
        } else if (this._orientation == TimeBarViewerInterface.Orientation.VERTICAL) {
            this.handleVerticalScroll(value, false);
        } else {
            throw new RuntimeException("illegal");
        }
    }

    private void updateRowScrollBar() {
        int first;
        int rowsDisplayed = this.getRowsDisplayed() - 1;
        int rowCount = this.getRowCount();
        if (rowCount - (first = this.getFirstRow()) < rowsDisplayed) {
            rowsDisplayed = rowCount - first;
        }
        this.updateRowScrollBar(this.getTotalHeight(), this.getAbsPosForRow(first) + this._firstRowPixelOffset, this._diagramRect.height);
    }

    private void updateRowScrollBar(int max, int pos, int thumbSize) {
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            this._tbvi.updateYScrollBar(max, pos, thumbSize);
        } else if (this._orientation == TimeBarViewerInterface.Orientation.VERTICAL) {
            this._tbvi.updateXScrollBar(max, pos, thumbSize);
        }
    }

    public int getRowIdxForAbsoluteOffset(int value) {
        if (!this._timeBarViewState.getUseVariableRowHeights()) {
            int row = value / this._timeBarViewState.getDefaultRowHeight();
            return row;
        }
        int y = 0;
        TimeBarRow row = this.getRow(0);
        int height = this._timeBarViewState.getRowHeight(row);
        for (int i = 0; i < this._rowList.size(); ++i) {
            if (y <= value && value <= y + height) {
                return i;
            }
            y += height;
            if (i + 1 > this._rowList.size() - 1) break;
            row = this.getRow(i + 1);
            height = this._timeBarViewState.getRowHeight(row);
        }
        throw new RuntimeException("could not find row idx for offset");
    }

    public int getRowPixOffsetForAbsoluteOffset(int rowIdx, int value) {
        if (!this._timeBarViewState.getUseVariableRowHeights()) {
            int off = value % this._timeBarViewState.getDefaultRowHeight();
            return off;
        }
        int y = this.getAbsPosForRow(rowIdx);
        return value - y;
    }

    public int getTotalHeight() {
        if (!this._timeBarViewState.getUseVariableRowHeights()) {
            return this.getRowCount() * this._timeBarViewState.getDefaultRowHeight();
        }
        int h = 0;
        for (int i = 0; i < this._rowList.size(); ++i) {
            TimeBarRow row = this.getRow(i);
            h += this._timeBarViewState.getRowHeight(row);
        }
        return h;
    }

    public int getAbsPosForRow(int rowIdx) {
        if (!this._timeBarViewState.getUseVariableRowHeights()) {
            return rowIdx * this._timeBarViewState.getDefaultRowHeight();
        }
        int h = 0;
        for (int i = 0; i < rowIdx; ++i) {
            TimeBarRow row = this.getRow(i);
            h += this._timeBarViewState.getRowHeight(row);
        }
        return h;
    }

    public void handleVerticalScroll(int value, boolean redirect) {
        if (!redirect || this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            int row = this.getRowIdxForAbsoluteOffset(value);
            int offset = this.getRowPixOffsetForAbsoluteOffset(row, value);
            this.setFirstRow(row, offset);
        } else if (this._orientation == TimeBarViewerInterface.Orientation.VERTICAL) {
            this.handleHorizontalScroll(value, false);
        } else {
            throw new RuntimeException("illegal");
        }
    }

    public JaretDate dateForXY(int x, int y) {
        if (this._startDate == null) {
            return null;
        }
        int coord = this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL ? x : y;
        if (!this._variableXScale) {
            return this.dateForCoordPlain(coord);
        }
        return this.dateForCoordVariable(coord);
    }

    public JaretDate dateForX(int x) {
        if (this._startDate == null) {
            return null;
        }
        if (!this._variableXScale) {
            return this.dateForCoordPlain(x);
        }
        return this.dateForCoordVariable(x);
    }

    public JaretDate dateForCoord(int coord) {
        if (this._startDate == null) {
            return null;
        }
        if (!this._variableXScale) {
            return this.dateForCoordPlain(coord);
        }
        return this.dateForCoordVariable(coord);
    }

    public JaretDate dateForCoord(int x, int y) {
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            return this.dateForCoord(x);
        }
        return this.dateForCoord(y);
    }

    private JaretDate dateForCoordPlain(int coord) {
        long pixDif = coord - (this._yAxisWidth + this._hierarchyWidth);
        long diffMilliSec = (long)((double)pixDif / this._pixelPerSeconds * 1000.0);
        JaretDate date = new JaretDate(this._startDate);
        date.advanceMillis(diffMilliSec);
        return date;
    }

    public JaretDate dateForCoordAbs(int coord) {
        if (!this._variableXScale) {
            return this.dateForCoordAbsPlain(coord);
        }
        return this.dateForCoordAbsVariable(coord);
    }

    private JaretDate dateForCoordAbsPlain(int coord) {
        long pixDif = coord - (this._yAxisWidth + this._hierarchyWidth);
        JaretDate date = new JaretDate(this._minDate);
        if (this._milliAccuracy) {
            long diffMilliSec = (long)((double)pixDif / this._pixelPerSeconds * 1000.0);
            date.advanceMillis(diffMilliSec);
        } else {
            long diffSec = (long)((double)pixDif / this._pixelPerSeconds);
            date.advanceSeconds((double)diffSec);
        }
        return date;
    }

    private JaretDate dateForCoordAbsVariable(int coord) {
        int pixelToEndPPS;
        int pixDif;
        if (pixDif <= 0) {
            return this.dateForCoordPlain(coord);
        }
        long milliSeconds = 0L;
        JaretDate d = this._minDate.copy();
        for (int pixelToGo = pixDif = coord - (this._yAxisWidth + this._hierarchyWidth); pixelToGo > 0; pixelToGo -= pixelToEndPPS) {
            JaretDate endPPS;
            PPSInterval interval = this.getPPSInterval(d);
            double pps = 0.0;
            boolean noFollowingPPSInterval = false;
            if (interval == null) {
                pps = this._pixelPerSeconds;
                PPSInterval i = this.nextPPSInterval(d);
                if (i != null) {
                    endPPS = i.getBegin().copy();
                } else {
                    noFollowingPPSInterval = true;
                    endPPS = this.getMaxDate().copy();
                }
            } else {
                pps = interval.getPps();
                endPPS = interval.getEnd().copy();
            }
            long milliSecondsToEndPPS = endPPS.diffMilliSeconds(d);
            pixelToEndPPS = (int)Math.round((double)milliSecondsToEndPPS * pps / 1000.0);
            if (pixelToGo <= pixelToEndPPS || noFollowingPPSInterval) {
                JaretDate result = this._minDate.copy().advanceMillis(milliSeconds += (long)((double)pixelToGo / pps * 1000.0));
                return result;
            }
            long ms = endPPS.diffMilliSeconds(d);
            milliSeconds += ms;
            d = endPPS.copy();
        }
        return null;
    }

    private JaretDate dateForCoordVariable(int coord) {
        int pixelToEndPPS;
        int pixDif;
        if (pixDif <= 0) {
            return this.dateForCoordPlain(coord);
        }
        long milliSeconds = 0L;
        JaretDate d = this._startDate.copy();
        for (int pixelToGo = pixDif = coord - (this._yAxisWidth + this._hierarchyWidth); pixelToGo > 0; pixelToGo -= pixelToEndPPS) {
            JaretDate endPPS;
            PPSInterval interval = this.getPPSInterval(d);
            double pps = 0.0;
            boolean noFollowingPPSInterval = false;
            if (interval == null) {
                pps = this._pixelPerSeconds;
                PPSInterval i = this.nextPPSInterval(d);
                if (i != null) {
                    endPPS = i.getBegin().copy();
                } else {
                    noFollowingPPSInterval = true;
                    endPPS = this.getMaxDate().copy();
                }
            } else {
                pps = interval.getPps();
                endPPS = interval.getEnd().copy();
            }
            long milliSecondsToEndPPS = endPPS.diffMilliSeconds(d);
            pixelToEndPPS = (int)Math.round((double)milliSecondsToEndPPS * pps / 1000.0);
            if (pixelToGo <= pixelToEndPPS || noFollowingPPSInterval) {
                JaretDate result = this._startDate.copy().advanceMillis(milliSeconds += (long)((double)pixelToGo / pps * 1000.0));
                return result;
            }
            long ms = endPPS.diffMilliSeconds(d);
            milliSeconds += ms;
            d = endPPS.copy();
        }
        return null;
    }

    public int xForDate(JaretDate date) {
        if (!this._variableXScale) {
            return this.xForDatePlain(date, false);
        }
        return this.xForDateVariable(date, false);
    }

    public int xForDateAbs(JaretDate date) {
        if (!this._variableXScale) {
            return this.xForDatePlain(date, true);
        }
        return this.xForDateVariable(date, true);
    }

    protected int xForDatePlain(JaretDate date, boolean absolute) {
        int offset;
        int n = offset = this._orientation.equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL) ? this._offsetLeft : this._offsetTop;
        if (this._milliAccuracy) {
            long milliSeconds = !absolute ? date.diffMilliSeconds(this._startDate) : date.diffMilliSeconds(this._minDate);
            int x = this._yAxisWidth + this._hierarchyWidth + offset + (int)Math.round((double)milliSeconds * this._pixelPerSeconds / 1000.0);
            return x;
        }
        int seconds = !absolute ? date.diffSeconds(this._startDate) : date.diffSeconds(this._minDate);
        int x = this._yAxisWidth + this._hierarchyWidth + offset + (int)Math.round((double)seconds * this._pixelPerSeconds);
        return x;
    }

    protected int xForDateVariable(JaretDate date, boolean absolute) {
        long ms;
        long milliSeconds = !absolute ? date.diffMilliSeconds(this._startDate) : date.diffMilliSeconds(this._minDate);
        boolean neg = false;
        if (milliSeconds <= 0L) {
            if (absolute) {
                return 0;
            }
            neg = true;
            milliSeconds = date.diffMilliSeconds(this._minDate);
        }
        JaretDate d = absolute || neg ? this._minDate.copy() : this._startDate.copy();
        int x = 0;
        for (long milliSecondsToGo = milliSeconds; milliSecondsToGo > 0L; milliSecondsToGo -= ms) {
            JaretDate endPPS;
            PPSInterval interval = this.getPPSInterval(d);
            double pps = 0.0;
            boolean noFollowingPPSInterval = false;
            if (interval == null) {
                pps = this._pixelPerSeconds;
                PPSInterval i = this.nextPPSInterval(d);
                if (i != null) {
                    endPPS = i.getBegin().copy();
                } else {
                    noFollowingPPSInterval = true;
                    endPPS = this.getMaxDate().copy();
                }
            } else {
                pps = interval.getPps();
                endPPS = interval.getEnd().copy();
            }
            if (date.compareTo(endPPS) <= 0 || noFollowingPPSInterval) {
                x += (int)Math.round((double)milliSecondsToGo * pps / 1000.0);
                if (absolute) {
                    return x;
                }
                if (neg) {
                    int firstOff = this.xForDateAbs(this._startDate);
                    x -= firstOff;
                }
                return this._yAxisWidth + this._hierarchyWidth + x;
            }
            ms = endPPS.diffMilliSeconds(d);
            x += (int)Math.round((double)ms * pps / 1000.0);
            d = endPPS.copy();
        }
        if (absolute) {
            return x;
        }
        if (neg) {
            int firstOff = this.xForDateAbs(this._startDate);
            x -= firstOff;
        }
        return this._yAxisWidth + this._hierarchyWidth + x;
    }

    public PPSInterval getPPSInterval(JaretDate d) {
        List<Interval> l = this._xScalePPSIntervalRow.getIntervals(d);
        if (l.size() == 0) {
            return null;
        }
        if (l.size() == 1) {
            PPSInterval interval = (PPSInterval)l.get(0);
            if (interval.getEnd().equals((Object)d)) {
                return null;
            }
            return interval;
        }
        if (l.size() == 2) {
            PPSInterval interval1 = (PPSInterval)l.get(0);
            PPSInterval interval2 = (PPSInterval)l.get(1);
            if (interval1.getBegin().equals((Object)d)) {
                return interval1;
            }
            if (interval2.getBegin().equals((Object)d)) {
                return interval2;
            }
        }
        throw new RuntimeException("no overlapping intervals in xscale row");
    }

    public PPSInterval nextPPSInterval(JaretDate d) {
        PPSInterval result = null;
        result = this.getPPSInterval(d);
        if (result != null) {
            return result;
        }
        List<Interval> list = this._xScalePPSIntervalRow.getIntervals();
        for (int i = 0; i < list.size(); ++i) {
            PPSInterval interval = (PPSInterval)list.get(i);
            long diffMilliSecs = d.diffMilliSeconds(interval.getBegin());
            if (diffMilliSecs > 0L) continue;
            result = interval;
            break;
        }
        return result;
    }

    public TimeBarRow rowForXY(int x, int y) {
        if (this._diagramRect.contains(x, y) || this._yAxisRect.contains(x, y) || this._hierarchyRect.contains(x, y)) {
            if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                return this.rowForY(y);
            }
            return this.rowForY(x);
        }
        return null;
    }

    private int rowForCoordInternal(int coord) {
        int rHeight;
        if (!this._timeBarViewState.getUseVariableRowHeights()) {
            if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                return this._firstRow + (coord + this._firstRowPixelOffset - this._diagramRect.y) / this._timeBarViewState.getDefaultRowHeight();
            }
            return this._firstRow + (coord + this._firstRowPixelOffset - this._diagramRect.x) / this._timeBarViewState.getDefaultRowHeight();
        }
        int maxY = 0;
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            coord -= this._diagramRect.y;
            maxY = this._diagramRect.height;
        } else {
            coord -= this._diagramRect.x;
            maxY = this._diagramRect.width;
        }
        int rowStart = -this._firstRowPixelOffset;
        for (int idx = this._firstRow; rowStart < maxY && idx < this._rowList.size(); rowStart += rHeight, ++idx) {
            rHeight = this._timeBarViewState.getRowHeight(this.getRow(idx));
            if (coord < rowStart || coord > rowStart + rHeight) continue;
            return idx;
        }
        return -1;
    }

    public TimeBarRow rowForY(int y) {
        int idx = -1;
        idx = this.rowForCoordInternal(y);
        if (idx < this._rowList.size() && idx >= 0) {
            return this.getRow(idx);
        }
        return null;
    }

    public int yForRow(TimeBarRow row) {
        int offset;
        int height;
        if (!this._timeBarViewState.getUseVariableRowHeights()) {
            int idx = this._rowList.indexOf(row);
            if (idx == -1) {
                throw new RuntimeException("row is not in the row list");
            }
            idx -= this._firstRow;
            if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                return idx * this._timeBarViewState.getDefaultRowHeight() + this._diagramRect.y - this._firstRowPixelOffset;
            }
            return idx * this._timeBarViewState.getDefaultRowHeight() + this._diagramRect.x - this._firstRowPixelOffset;
        }
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            height = this._diagramRect.height;
            offset = this._diagramRect.y;
        } else {
            height = this._diagramRect.width;
            offset = this._diagramRect.x;
        }
        int idx = this._firstRow;
        TimeBarRow r = this.getRow(idx);
        for (int y = -this._firstRowPixelOffset; y <= height; y += this._timeBarViewState.getRowHeight(r)) {
            if (row.equals(r)) {
                return y + offset;
            }
            if (++idx >= this._rowList.size()) break;
            r = this.getRow(idx);
        }
        return -1;
    }

    public int dispIdxForRow(TimeBarRow row) {
        int rIdx = this._rowList.indexOf(row);
        if (rIdx >= this._firstRow && rIdx <= this._firstRow + this.getRowsDisplayed()) {
            return rIdx - this._firstRow;
        }
        return -1;
    }

    public Rectangle getRowBounds(TimeBarRow row) {
        if (!this.isRowDisplayed(row)) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            int y = this.yForRow(row);
            return new Rectangle(0, y, this._tbvi.getWidth(), y + this._timeBarViewState.getRowHeight(row));
        }
        int x = this.yForRow(row);
        return new Rectangle(x, 0, this._timeBarViewState.getRowHeight(row), this._tbvi.getHeight());
    }

    public Rectangle getIntervalBounds(int rowIdx, Interval interval) {
        OverlapInfo oi;
        int width;
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            OverlapInfo oi2;
            int height;
            int x = this.xForDate(interval.getBegin());
            int x2 = this.xForDate(interval.getEnd());
            int width2 = x2 - x;
            int y = rowIdx == -1 ? 0 : this.yForRow(this.getRow(rowIdx));
            int n = height = rowIdx == -1 ? this._tbvi.getHeight() : this._timeBarViewState.getRowHeight(this.getRow(rowIdx));
            if (!this._drawOverlapping && rowIdx != -1 && (oi2 = this._overlapStrategy.getOverlapInfo(this._rowList.get(rowIdx), interval)) != null) {
                y += oi2.pos * (height /= oi2.maxOverlapping + 1);
            }
            return new Rectangle(x, y, width2, height);
        }
        int y = this.xForDate(interval.getBegin());
        int y2 = this.xForDate(interval.getEnd());
        int height = y2 - y;
        int x = rowIdx == -1 ? 0 : this.yForRow(this.getRow(rowIdx));
        int n = width = rowIdx == -1 ? this._tbvi.getWidth() : this._timeBarViewState.getRowHeight(this.getRow(rowIdx));
        if (!this._drawOverlapping && rowIdx != -1 && (oi = this._overlapStrategy.getOverlapInfo(this._rowList.get(rowIdx), interval)) != null) {
            x += oi.pos * (width /= oi.maxOverlapping + 1);
        }
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getIntervalBounds(Interval interval) {
        TimeBarRow row = this._model.getRowForInterval(interval);
        if (row != null) {
            return this.getIntervalBounds(row, interval);
        }
        return null;
    }

    public Rectangle getIntervalBounds(TimeBarRow row, Interval interval) {
        return this.getIntervalBounds(row == null ? -1 : this._rowList.indexOf(row), interval);
    }

    public int getRowsDisplayed() {
        if (!this._timeBarViewState.getUseVariableRowHeights()) {
            if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                return this._diagramRect.height / this._timeBarViewState.getDefaultRowHeight() + 1;
            }
            return this._diagramRect.width / this._timeBarViewState.getDefaultRowHeight() + 1;
        }
        int end = this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL ? this._diagramRect.height : this._diagramRect.width;
        int count = 0;
        int idx = this._firstRow;
        int coord = -this._firstRowPixelOffset;
        while (coord <= end && idx < this._rowList.size()) {
            coord += this._timeBarViewState.getRowHeight(this.getRow(idx++));
            ++count;
        }
        return count;
    }

    public boolean isRowDisplayed(TimeBarRow row) {
        return this._rowList.indexOf(row) - this._firstRow < this.getRowsDisplayed();
    }

    public List<Interval> getIntervalsAt(int x, int y) {
        TimeBarRow row = this.rowForXY(x, y);
        return this.getIntervalsAt(row, x, y);
    }

    public List<Interval> getIntervalsAt(TimeBarRow row, int x, int y) {
        if (row != null) {
            JaretDate date = this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL ? this.dateForCoord(x) : this.dateForCoord(y);
            if (this._milliAccuracy) {
                date.advanceMillis(1L);
            }
            List<Interval> result = row.getIntervals(date);
            if (this._intervalFilter != null) {
                List<Interval> in = result;
                result = new ArrayList<Interval>();
                for (Interval interval : in) {
                    if (!this._intervalFilter.isInResult(interval)) continue;
                    result.add(interval);
                }
            }
            if (result.size() <= 1 || x == -1 || y == -1) {
                return result;
            }
            ArrayList<Interval> newResult = new ArrayList<Interval>(1);
            for (Interval interval : result) {
                Rectangle rect = this.getIntervalBounds(row, interval);
                if (!rect.contains(x, y)) continue;
                newResult.add(interval);
            }
            return newResult;
        }
        ArrayList<Interval> result = new ArrayList<Interval>();
        return result;
    }

    public List<Interval> getIntervalsAt(TimeBarRow row, int x) {
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            return this.getIntervalsAt(row, x, -1);
        }
        return this.getIntervalsAt(row, -1, x);
    }

    @Override
    public void markerMoved(TimeBarMarker marker, JaretDate oldDate, JaretDate currentDate) {
        int width = this._tbvi.getMarkerWidth();
        if (this.isDisplayed(currentDate)) {
            if (this._orientation.equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL)) {
                this._tbvi.repaint(this.xForDate(oldDate) - width / 2 + 1, 0, width / 2 + 1, this._tbvi.getHeight());
                this._tbvi.repaint(this.xForDate(currentDate) - width / 2 + 1, 0, width / 2 + 1, this._tbvi.getHeight());
            } else {
                this._tbvi.repaint(0, this.xForDate(oldDate) - width / 2 + 1, this._tbvi.getWidth(), width / 2 + 1);
                this._tbvi.repaint(0, this.xForDate(currentDate) - width / 2 + 1, this._tbvi.getWidth(), width / 2 + 1);
            }
        }
        if (marker.getDate().compareTo(this._minDate) < 0) {
            this.setMinDate(marker.getDate().copy());
        } else if (marker.getDate().compareTo(this._maxDate) > 0) {
            this.setMaxDate(marker.getDate().copy());
        }
    }

    @Override
    public void markerDescriptionChanged(TimeBarMarker marker, String oldValue, String newValue) {
        int width = this._tbvi.getMarkerWidth();
        if (this.isDisplayed(marker.getDate())) {
            this._tbvi.repaint(this.xForDate(marker.getDate()) - width / 2 + 1, 0, width / 2 + 1, this._tbvi.getHeight());
        }
    }

    @Override
    public void selectionChanged(TimeBarSelectionModel selectionModel) {
        this._tbvi.repaint();
        this._tbvi.fireSelectionChanged();
    }

    @Override
    public void elementAddedToSelection(TimeBarSelectionModel selectionModel, Object element) {
        if (element instanceof TimeBarRow) {
            Rectangle rowRect = this.getRowBounds((TimeBarRow)element);
            this._tbvi.repaint(rowRect);
        } else if (element instanceof Interval) {
            Rectangle intervalRect = this.getIntervalBounds(null, (Interval)element);
            this._tbvi.repaint(intervalRect);
        } else {
            throw new RuntimeException("Unknonw object in elementAddedToSelection " + element.getClass().getName());
        }
        this._tbvi.fireSelectionChanged();
    }

    @Override
    public void elementRemovedFromSelection(TimeBarSelectionModel selectionModel, Object element) {
        if (element instanceof TimeBarRow) {
            if (this._rowList.contains((TimeBarRow)element)) {
                Rectangle rowRect = this.getRowBounds((TimeBarRow)element);
                this._tbvi.repaint(rowRect);
            }
        } else if (element instanceof Interval) {
            Interval interval = (Interval)element;
            TimeBarRow row = this._model.getRowForInterval(interval);
            if (row != null && row.getIntervals() != null && row.getIntervals().contains(interval)) {
                Rectangle intervalRect = this.getIntervalBounds(row, (Interval)element);
                this._tbvi.repaint(intervalRect);
            }
        } else {
            throw new RuntimeException("Unknown object in elementRemovedFromSelection " + element.getClass().getName());
        }
        this._tbvi.fireSelectionChanged();
    }

    @Override
    public void modelDataChanged(TimeBarModel model) {
        this.checkAndAdjustMinMax();
        this.updateRowList();
        this._overlapStrategy.clearCachedData();
        this._tbvi.repaint();
    }

    @Override
    public void rowDataChanged(TimeBarModel model, TimeBarRow row) {
        this.checkAndAdjustMinMax();
        if (!this._drawOverlapping) {
            this._overlapStrategy.updateOICache(row);
        }
        if (this.isRowDisplayed(row)) {
            this._tbvi.repaint();
        }
    }

    @Override
    public void rowAdded(TimeBarModel model, TimeBarRow row) {
        this.checkAndAdjustMinMax();
        this.updateRowList();
        this._tbvi.repaint();
    }

    @Override
    public void rowRemoved(TimeBarModel model, TimeBarRow row) {
        this.checkAndAdjustMinMax();
        boolean isDisplayed = this.isRowDisplayed(row);
        this.updateRowList();
        if (isDisplayed) {
            this._tbvi.repaint();
        }
        if (this._selectionModel != null) {
            this._selectionModel.remSelectedRow(row);
        }
    }

    @Override
    public void elementAdded(TimeBarModel model, TimeBarRow row, Interval element) {
        this.checkAndAdjustMinMax();
        if (!this._drawOverlapping) {
            this._overlapStrategy.updateOICache(row);
        }
        if (this.isRowDisplayed(row)) {
            this._tbvi.repaint();
        }
    }

    @Override
    public void elementRemoved(TimeBarModel model, TimeBarRow row, Interval element) {
        this.checkAndAdjustMinMax();
        if (!this._drawOverlapping) {
            this._overlapStrategy.updateOICache(row);
        }
        if (this.isRowDisplayed(row)) {
            this._tbvi.repaint();
        }
        if (this._selectionModel != null) {
            this._selectionModel.remSelectedInterval(element);
        }
    }

    @Override
    public void elementChanged(TimeBarModel model, TimeBarRow row, Interval element) {
        this.checkAndAdjustMinMax();
        if (!this._drawOverlapping) {
            this._overlapStrategy.updateOICache(row);
        }
        if (this.isRowDisplayed(row)) {
            this._tbvi.repaint();
        }
    }

    @Override
    public void headerChanged(TimeBarModel model, TimeBarRow row, Object newHeader) {
        if (this.isRowDisplayed(row)) {
            this._tbvi.repaint();
        }
    }

    public int getFirstRow() {
        return this._firstRow;
    }

    public void setFirstRow(int firstRow) {
        this.setFirstRow(firstRow, 0);
    }

    public void setFirstRow(int firstRow, int pixOffset) {
        if (firstRow != this._firstRow || this._firstRowPixelOffset != pixOffset) {
            int oldVal = this._firstRow;
            int oldOffset = this._firstRowPixelOffset;
            if (this._tbvi != null) {
                int maxOptScroll;
                int diff = !this._timeBarViewState.getUseVariableRowHeights() ? firstRow * this._timeBarViewState.getDefaultRowHeight() + pixOffset - (oldVal * this._timeBarViewState.getDefaultRowHeight() + oldOffset) : this.getAbsPosForRow(firstRow) + pixOffset - (this.getAbsPosForRow(oldVal) + oldOffset);
                int n = maxOptScroll = this._orientation.equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL) ? this._diagramRect.height - this._diagramRect.height : this._diagramRect.width - this._diagramRect.width;
                if (!this._optimizeScrolling || Math.abs(diff) > maxOptScroll / 3) {
                    this._firstRow = firstRow;
                    this._firstRowPixelOffset = pixOffset;
                    this._tbvi.repaint();
                } else {
                    if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                        this._tbvi.doScrollVertical(diff);
                    } else {
                        this._tbvi.doScrollHorizontal(diff);
                    }
                    this._firstRow = firstRow;
                    this._firstRowPixelOffset = pixOffset;
                }
                if (this._tbvi != null) {
                    this._tbvi.firePropertyChange("FirstRow", oldVal, firstRow);
                    this._tbvi.firePropertyChange("FirstRowOffset", oldOffset, pixOffset);
                }
                this.updateRowScrollBar();
            } else {
                this._firstRow = firstRow;
                this._firstRowPixelOffset = pixOffset;
            }
        }
    }

    public int getFirstRowOffset() {
        return this._firstRowPixelOffset;
    }

    public void setFirstRowOffset(int offset) {
        this.setFirstRow(this.getFirstRow(), offset);
    }

    public int getTimeScalePosition() {
        return this._timeScalePosition;
    }

    public void setTimeScalePosition(int timeScalePosition) {
        this._timeScalePosition = timeScalePosition;
        if (this._tbvi != null) {
            this._tbvi.repaint();
        }
    }

    public int getYAxisWidth() {
        return this._yAxisWidth;
    }

    public void setYAxisWidth(int axisWidth) {
        this._yAxisWidth = axisWidth;
        if (this._tbvi != null) {
            this._tbvi.repaint();
        }
    }

    public int getXAxisHeight() {
        return this._xAxisHeight;
    }

    public void setHierarchyWidth(int width) {
        this._hierarchyWidth = width;
        if (this._tbvi != null) {
            this._tbvi.repaint();
        }
    }

    public int getHierarchyWidth() {
        return this._hierarchyWidth;
    }

    public void preparePaint(int cwidth, int cheight) {
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            this.preparePaintHorizontal(cwidth, cheight);
        } else {
            this.preparePaintVertical(cwidth, cheight);
        }
    }

    public void preparePaintHorizontal(int cwidth, int cheight) {
        int topy = this._timeScalePosition == 1 || this._timeScalePosition == 2 ? 0 : this._xAxisHeight;
        int height = this._timeScalePosition == 2 ? cheight : cheight - this._xAxisHeight;
        this._diagramRect = new Rectangle(this._hierarchyWidth + this._yAxisWidth, topy, cwidth - this._yAxisWidth - this._hierarchyWidth, height);
        this._yAxisRect = new Rectangle(this._hierarchyWidth, topy, this._yAxisWidth, height);
        this._hierarchyRect = new Rectangle(0, topy, this._hierarchyWidth, height);
        this._xAxisRect = this._timeScalePosition != 2 ? new Rectangle(this._diagramRect.x, this._timeScalePosition == 0 ? 0 : cheight - this._xAxisHeight, this._diagramRect.width, this._xAxisHeight) : new Rectangle(0, 0, 0, 0);
        this._endDate = this.dateForX(cwidth);
        this._titleRect = new Rectangle(0, this._xAxisRect.y, this._hierarchyRect.width + this._yAxisRect.width, this._xAxisRect.height);
        if (this._offsetLeft != 0 || this._offsetTop != 0) {
            this._diagramRect.x += this._offsetLeft;
            this._diagramRect.y += this._offsetTop;
            this._yAxisRect.x += this._offsetLeft;
            this._yAxisRect.y += this._offsetTop;
            this._xAxisRect.x += this._offsetLeft;
            this._xAxisRect.y += this._offsetTop;
            this._hierarchyRect.x += this._offsetLeft;
            this._hierarchyRect.y += this._offsetTop;
            this._titleRect.x += this._offsetLeft;
            this._titleRect.y += this._offsetTop;
        }
        if (this._autoScaleRows > 0) {
            int rowHeight = this._diagramRect.height / this._autoScaleRows;
            this.setRowHeight(rowHeight);
        }
    }

    public void preparePaintVertical(int cwidth, int cheight) {
        int leftX = this._timeScalePosition == 1 || this._timeScalePosition == 2 ? 0 : this._xAxisHeight;
        int width = this._timeScalePosition == 2 ? cwidth : cwidth - this._xAxisHeight;
        this._diagramRect = new Rectangle(leftX, this._hierarchyWidth + this._yAxisWidth, width, cheight - this._yAxisWidth - this._hierarchyWidth);
        this._yAxisRect = new Rectangle(leftX, this._hierarchyWidth, width, this._yAxisWidth);
        this._hierarchyRect = new Rectangle(leftX, 0, width, this._hierarchyWidth);
        if (this._timeScalePosition != 2) {
            int tsX = this._timeScalePosition == 0 ? 0 : cwidth - this._xAxisHeight;
            this._xAxisRect = new Rectangle(tsX, this._diagramRect.y, this._xAxisHeight, this._diagramRect.height);
        } else {
            this._xAxisRect = new Rectangle(0, 0, 0, 0);
        }
        this._endDate = this.dateForX(cheight);
        this._titleRect = new Rectangle(this._xAxisRect.x, 0, this._xAxisRect.width, this._hierarchyRect.height + this._yAxisRect.height);
        if (this._offsetLeft != 0 || this._offsetTop != 0) {
            this._diagramRect.x += this._offsetLeft;
            this._diagramRect.y += this._offsetTop;
            this._yAxisRect.x += this._offsetLeft;
            this._yAxisRect.y += this._offsetTop;
            this._xAxisRect.x += this._offsetLeft;
            this._xAxisRect.y += this._offsetTop;
            this._hierarchyRect.x += this._offsetLeft;
            this._hierarchyRect.y += this._offsetTop;
            this._titleRect.x += this._offsetLeft;
            this._titleRect.y += this._offsetTop;
        }
        if (this._autoScaleRows > 0) {
            int rowWidth = this._diagramRect.width / this._autoScaleRows;
            this.setRowHeight(rowWidth);
        }
    }

    public Rectangle getDiagramRect() {
        return this._diagramRect;
    }

    public Rectangle getXAxisRect() {
        return this._xAxisRect;
    }

    public Rectangle getYAxisRect() {
        return this._yAxisRect;
    }

    public Rectangle getHierarchyRect() {
        return this._hierarchyRect;
    }

    public Rectangle getTitleRect() {
        return this._titleRect;
    }

    public JaretDate getLastStartDate() {
        return this._lastStartDate;
    }

    public void setLastStartDate(JaretDate lastStartDate) {
        this._lastStartDate = lastStartDate;
    }

    private List<Interval> getIntervalsSortedAt(TimeBarRow row, int x) {
        List<Interval> intervals = this.getIntervalsAt(row, x);
        if (intervals.size() == 0) {
            return intervals;
        }
        Collections.sort(intervals, new Comparator<Interval>(){

            @Override
            public int compare(Interval i1, Interval i2) {
                return i1.getSeconds() - i2.getSeconds();
            }
        });
        return intervals;
    }

    private Interval intervalAt(TimeBarRow row, int x, int y) {
        Interval result = null;
        List<Interval> intervals = this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL ? this.getIntervalsSortedAt(row, x) : this.getIntervalsSortedAt(row, y);
        if (intervals.size() == 0) {
            return null;
        }
        for (Interval interval : intervals) {
            boolean overlapping;
            Rectangle intervalRect;
            if (!this._tbvi.timeBarContains(interval, intervalRect = this.getIntervalBounds(row, interval), x - intervalRect.x, y - intervalRect.y, overlapping = this._drawOverlapping ? false : this._overlapStrategy.getOverlapInfo((TimeBarRow)row, (Interval)interval).overlappingCount > 0)) continue;
            result = interval;
            break;
        }
        return result;
    }

    public void mousePressed(int x, int y, boolean isPopupTrigger, int modifierMask) {
        TimeBarMarker marker;
        if (this._diagramRect.contains(x, y)) {
            TimeBarRow row = this.rowForXY(x, y);
            Interval interval = this.intervalAt(row, x, y);
            if (interval != null && (this._intervalFilter == null || this._intervalFilter.isInResult(interval))) {
                this.setFocussedInterval(interval);
                if ((modifierMask & 0x80) != 0) {
                    if (!this._selectionModel.isSelected(interval)) {
                        this._selectionModel.addSelectedInterval(interval);
                    } else {
                        this._selectionModel.remSelectedInterval(interval);
                    }
                } else if (this._selectionModel.isEmpty()) {
                    this._selectionModel.setSelectedInterval(interval);
                }
            } else {
                if (!isPopupTrigger && (modifierMask & 0x80) == 0) {
                    this._selectionModel.clearSelection();
                }
                if (!isPopupTrigger && this._selectionModel.getMultipleSelectionAllowed() && this._rectSelectionEnabled && (row == null || this.getTouchedInterval(row, x, y) == null)) {
                    this._selectionRect = new Rectangle(x, y, 0, 0);
                }
            }
        } else if (this._lineDraggingAllowed && this.hierarchyLineHit(x, y)) {
            this._hierarchyLineDragging = true;
        } else if (this._lineDraggingAllowed && this.headerLineHit(x, y)) {
            this._headerLineDragging = true;
        } else if (this._rowHeightDraggingAllowed && this.rowLineHit(x, y)) {
            this._heightDraggedRow = this.getRowByBottomLine(x, y);
        } else if (this._yAxisRect.contains(x, y)) {
            TimeBarRow row = this.rowForXY(x, y);
            this.handleRowSelection(row, modifierMask);
        } else if (this._hierarchyRect.contains(x, y) && !isPopupTrigger) {
            TimeBarRow row = this.rowForXY(x, y);
            if (row instanceof TimeBarNode) {
                TimeBarNode node = (TimeBarNode)row;
                if (this._tbvi.isInToggleArea(node, x, y)) {
                    this._hierarchicalViewState.setExpanded(node, !this._hierarchicalViewState.isExpanded(node));
                } else if (this._tbvi.isInHierarchySelectionArea(node, x, y)) {
                    this.handleRowSelection(row, modifierMask);
                }
            }
        } else if (this._xAxisRect.contains(x, y) && (marker = this.getMarkerForXY(x, y)) != null && marker.isDraggable()) {
            this._tbvi.setCursor(13);
            this._draggedMarker = marker;
            this._markerDragStart = marker.getDate().copy();
        }
    }

    private void handleRowSelection(TimeBarRow row, int modifierMask) {
        if ((modifierMask & 0x80) != 0) {
            if (!this._selectionModel.isSelected(row)) {
                this._selectionModel.addSelectedRow(row);
            } else {
                this._selectionModel.remSelectedRow(row);
            }
        } else {
            this._selectionModel.setSelectedRow(row);
        }
    }

    public void mouseReleased(int x, int y, boolean isPopupTrigger, int modifierMask) {
        Interval interval;
        TimeBarRow row;
        if (this._headerLineDragging || this._hierarchyLineDragging || this._heightDraggedRow != null) {
            this._headerLineDragging = false;
            this._hierarchyLineDragging = false;
            this._heightDraggedRow = null;
            this._tbvi.setCursor(0);
            this._tbvi.repaint();
        }
        if (this._draggedMarker != null) {
            this._draggedMarker = null;
            this._tbvi.setCursor(0);
            this._tbvi.repaint();
        }
        if (this._selectionRect != null) {
            this._selectionRect = null;
            if (this._lastSelRect != null) {
                this._tbvi.repaint(this._lastSelRect.x, this._lastSelRect.y, this._lastSelRect.width + 1, this._lastSelRect.height + 1);
            }
        } else if ((modifierMask & 0x80) == 0 && (row = this.rowForXY(x, y)) != null && (interval = this.intervalAt(row, x, y)) != null) {
            this._selectionModel.setSelectedInterval(interval);
        }
        if (this._changingInterval != null) {
            this.fireIntervalChanged(this._intervalDraggedRow, this._changingInterval, this._originalInterval.getBegin(), this._originalInterval.getEnd());
            this._changingInterval = null;
            this._tbvi.setCursor(0);
        }
        if (isPopupTrigger) {
            row = this.rowForXY(x, y);
            this._ctxCoordinate = new Point(x, y);
            this._ctxRow = row;
            if (this._hierarchyRect.contains(x, y)) {
                this._tbvi.displayHierarchyContextMenu(row, x, y);
            } else if (this._yAxisRect.contains(x, y)) {
                this._tbvi.displayHeaderContextMenu(row, x, y);
            } else if (this._titleRect.contains(x, y)) {
                this._tbvi.displayTitleContextMenu(x, y);
            } else if (this._xAxisRect.contains(x, y)) {
                this._tbvi.displayTimeScaleContextMenu(x, y);
            } else if (this._diagramRect.contains(x, y)) {
                interval = this.intervalAt(row, x, y);
                if (interval != null && (this._intervalFilter == null || this._intervalFilter.isInResult(interval))) {
                    this._tbvi.displayIntervalContextMenu(interval, x, y);
                } else {
                    this._tbvi.displayBodyContextMenu(x, y);
                }
            }
        }
    }

    private void cancelDrag() {
        if (this._draggedMarker != null) {
            this._draggedMarker.setDate(this._markerDragStart);
            this._draggedMarker = null;
            this._tbvi.setCursor(0);
            this._tbvi.repaint();
        } else if (this._changingInterval != null && this._draggedInterval) {
            this._changingInterval.setBegin(this._originalInterval.getBegin());
            this._changingInterval.setEnd(this._originalInterval.getEnd());
            this.fireIntervalChangeCancelled(this._intervalDraggedRow, this._changingInterval);
            this._changingInterval = null;
            this._tbvi.setCursor(0);
        } else if (this._changingInterval != null && !this._draggedInterval) {
            this._changingInterval.setBegin(this._originalInterval.getBegin());
            this._changingInterval.setEnd(this._originalInterval.getEnd());
            this.fireIntervalChangeCancelled(this._intervalDraggedRow, this._changingInterval);
            this._changingInterval = null;
            this._tbvi.setCursor(0);
        }
    }

    public Point getCtxCoordinate() {
        return this._ctxCoordinate;
    }

    public TimeBarRow getCtxRow() {
        return this._ctxRow;
    }

    public void mouseDragged(int x, int y) {
        boolean horizontal;
        JaretDate xdate = this.dateForXY(x, y);
        boolean bl = horizontal = this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL;
        if (this._draggedMarker != null) {
            this._draggedMarker.setDate(xdate);
            if (this._autoscroll) {
                this.scrollDateToVisible(xdate);
            }
        } else if (this._changingInterval != null && this._draggedInterval) {
            double diffSeconds = -1.0 * (double)this._startIntervalDragDate.diffSeconds(xdate);
            diffSeconds = this.calcGridSnap(diffSeconds);
            JaretDate newBegin = this._originalInterval.getBegin().copy();
            newBegin.advanceSeconds(diffSeconds);
            JaretDate newEnd = this._originalInterval.getEnd().copy();
            newEnd.advanceSeconds(diffSeconds);
            boolean allowed = true;
            for (IntervalModificator modificator : this._intervalModificators) {
                allowed = allowed && (!modificator.isApplicable(this._intervalDraggedRow, this._changingInterval) || modificator.shiftAllowed(this._intervalDraggedRow, this._changingInterval, newBegin));
            }
            if (allowed) {
                this._changingInterval.setBegin(newBegin);
                this._changingInterval.setEnd(newEnd);
                if (this._autoscroll && this._lastDragDate != null) {
                    if (this._lastDragDate.diffSeconds(xdate) > 0) {
                        this.scrollDateToVisible(newBegin);
                    } else {
                        this.scrollDateToVisible(newEnd);
                    }
                }
                this.fireIntervalIntermediateChange(this._intervalDraggedRow, this._changingInterval, this._originalInterval.getBegin(), this._originalInterval.getEnd());
            }
        } else if (this._changingInterval != null && !this._draggedInterval) {
            double diffSeconds = -1.0 * (double)this._startIntervalDragDate.diffSeconds(xdate);
            diffSeconds = this.calcGridSnap(diffSeconds);
            if (this._draggedIntervalEdgeLeft) {
                JaretDate newBegin = this._originalInterval.getBegin().copy();
                newBegin.advanceSeconds(diffSeconds);
                boolean allowed = true;
                for (IntervalModificator modificator : this._intervalModificators) {
                    allowed = allowed && modificator.newBeginAllowed(this._intervalDraggedRow, this._changingInterval, newBegin);
                }
                if (allowed) {
                    this._changingInterval.setBegin(newBegin);
                    if (this._autoscroll) {
                        this.scrollDateToVisible(newBegin);
                    }
                }
            } else {
                JaretDate newEnd = this._originalInterval.getEnd().copy();
                newEnd.advanceSeconds(diffSeconds);
                boolean allowed = true;
                for (IntervalModificator modificator : this._intervalModificators) {
                    allowed = allowed && modificator.newEndAllowed(this._intervalDraggedRow, this._changingInterval, newEnd);
                }
                if (allowed) {
                    this._changingInterval.setEnd(newEnd);
                    if (this._autoscroll) {
                        this.scrollDateToVisible(newEnd);
                    }
                }
            }
            this.fireIntervalIntermediateChange(this._intervalDraggedRow, this._changingInterval, this._originalInterval.getBegin(), this._originalInterval.getEnd());
        } else if (this._selectionRect != null) {
            this._selectionRect.width = x - this._selectionRect.x;
            this._selectionRect.height = y - this._selectionRect.y;
            if (this._lastSelRect != null) {
                this.rectRepaint(this._lastSelRect);
            }
            Rectangle curSelRect = this.normalizeRectangle(this._selectionRect);
            this.selectIntervals(curSelRect);
            this.rectRepaint(curSelRect);
        } else if (this._hierarchyLineDragging) {
            int value;
            int n = value = horizontal ? x : y;
            if (value > 2) {
                this.setHierarchyWidth(value);
            }
        } else if (this._headerLineDragging) {
            int value = (horizontal ? x : y) - this._hierarchyWidth;
            if (value > 2) {
                this.setYAxisWidth(value);
            }
        } else if (this._heightDraggedRow != null) {
            int beginCoord;
            int value = (horizontal ? y : x) - (beginCoord = this.yForRow(this._heightDraggedRow));
            if (value > 10) {
                this._timeBarViewState.setRowHeight(this._heightDraggedRow, value);
            }
        } else {
            Interval interval;
            List<Interval> intervals;
            Interval interval2;
            TimeBarRow row = this.rowForXY(x, y);
            if (row != null && (interval2 = this.getTouchedInterval(row, x, y)) != null && this.isResizingAllowed(row, interval2)) {
                int diff;
                Rectangle rect = this.getIntervalBounds(row, interval2);
                int n = diff = horizontal ? Math.abs(x - rect.x) : Math.abs(y - rect.y);
                if (diff <= this._selectionDelta) {
                    this._draggedIntervalEdgeLeft = true;
                    this._tbvi.setCursor(horizontal ? 11 : 8);
                } else {
                    this._draggedIntervalEdgeLeft = false;
                    this._tbvi.setCursor(horizontal ? 10 : 9);
                }
                this._changingInterval = interval2;
                this._draggedInterval = false;
                this._originalInterval = new IntervalImpl();
                this._originalInterval.setBegin(interval2.getBegin());
                this._originalInterval.setEnd(interval2.getEnd());
                this._startIntervalDragDate = xdate;
                this._intervalDraggedRow = row;
                this.fireIntervalChangeStarted(this._intervalDraggedRow, this._changingInterval);
            }
            if (this._changingInterval == null && (intervals = this.getIntervalsAt(x, y)).size() == 1 && this.isShiftingAllowed(row, interval = intervals.get(0))) {
                this._changingInterval = interval;
                this._draggedInterval = true;
                this._originalInterval = new IntervalImpl();
                this._originalInterval.setBegin(interval.getBegin());
                this._originalInterval.setEnd(interval.getEnd());
                this._startIntervalDragDate = xdate;
                this._intervalDraggedRow = row;
                this._tbvi.setCursor(13);
                this.fireIntervalChangeStarted(this._intervalDraggedRow, this._changingInterval);
            }
        }
        this._lastDragDate = xdate;
    }

    private double calcGridSnap(double diffSeconds) {
        if (this._intervalModificators != null && this._intervalModificators.size() > 0) {
            double gridsnap = this._intervalModificators.get(0).getSecondGridSnap();
            if (gridsnap < 0.0) {
                return diffSeconds;
            }
            if (Math.abs(diffSeconds % gridsnap) > gridsnap / 2.0) {
                double off = diffSeconds < 0.0 ? -gridsnap : gridsnap;
                diffSeconds = diffSeconds - diffSeconds % gridsnap + off;
            } else {
                diffSeconds -= diffSeconds % gridsnap;
            }
            return diffSeconds;
        }
        return diffSeconds;
    }

    private boolean isShiftingAllowed(TimeBarRow row, Interval interval) {
        if (this._intervalModificators == null || this._intervalModificators.size() == 0) {
            return false;
        }
        boolean allowed = true;
        for (IntervalModificator modificator : this._intervalModificators) {
            allowed = allowed && (!modificator.isApplicable(row, interval) || modificator.isShiftingAllowed(row, interval));
        }
        return allowed;
    }

    private void rectRepaint(Rectangle rect) {
        this._tbvi.repaint(rect.x, rect.y, rect.width, 1);
        this._tbvi.repaint(rect.x, rect.y + rect.height, rect.width, 1);
        this._tbvi.repaint(rect.x, rect.y, 1, rect.height);
        this._tbvi.repaint(rect.x + rect.width, rect.y, 1, rect.height);
    }

    public void mouseMoved(int x, int y) {
        boolean horizontal;
        boolean bl = horizontal = this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL;
        if (this._xAxisRect != null && this._xAxisRect.contains(x, y)) {
            TimeBarMarker marker = this.getMarkerForXY(x, y);
            if (marker != null) {
                this._tbvi.setCursor(12);
            } else {
                this._tbvi.setCursor(0);
            }
        } else if (this._lineDraggingAllowed && (this.hierarchyLineHit(x, y) || this.headerLineHit(x, y))) {
            this._tbvi.setCursor(12);
        } else if (this._rowHeightDraggingAllowed && this.rowLineHit(x, y)) {
            this._tbvi.setCursor(12);
        } else if (this._diagramRect != null && this._diagramRect.contains(x, y)) {
            TimeBarRow row = this.rowForXY(x, y);
            if (row != null) {
                Interval interval = this.getTouchedInterval(row, x, y);
                if (interval != null && this.isResizingAllowed(row, interval)) {
                    long westDiff;
                    JaretDate d = this.dateForXY(x, y);
                    long eastDiff = Math.abs(d.diffMilliSeconds(interval.getBegin()));
                    if (eastDiff < (westDiff = Math.abs(d.diffMilliSeconds(interval.getEnd())))) {
                        this._tbvi.setCursor(horizontal ? 11 : 8);
                    } else {
                        this._tbvi.setCursor(horizontal ? 10 : 9);
                    }
                } else {
                    this._tbvi.setCursor(0);
                }
            }
        } else {
            this._tbvi.setCursor(0);
        }
    }

    private boolean hierarchyLineHit(int x, int y) {
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            return this._hierarchyWidth > 0 && Math.abs(this._hierarchyWidth - x) < this._selectionDelta;
        }
        return this._hierarchyWidth > 0 && Math.abs(this._hierarchyWidth - y) < this._selectionDelta;
    }

    public boolean rowLineHit(int x, int y) {
        if (this._yAxisRect.contains(x, y) || this._hierarchyRect.contains(x, y)) {
            int max;
            int coord;
            if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                coord = y;
                coord -= this._yAxisRect.y;
                max = this._yAxisRect.height;
            } else {
                coord = x;
                coord -= this._yAxisRect.x;
                max = this._yAxisRect.width;
            }
            TimeBarRow row = this.getRow(this._firstRow);
            int idx = this._firstRow;
            for (int endCoord = this._timeBarViewState.getRowHeight(row) - this._firstRowPixelOffset; endCoord < max && idx < this._rowList.size(); endCoord += this._timeBarViewState.getRowHeight(row)) {
                if (Math.abs(endCoord - coord) < this._selectionDelta) {
                    return true;
                }
                if (++idx > this._rowList.size() - 1) break;
                row = this.getRow(idx);
            }
        }
        return false;
    }

    private TimeBarRow getRowByBottomLine(int x, int y) {
        if (this._diagramRect.contains(x, y) || this._yAxisRect.contains(x, y) || this._hierarchyRect.contains(x, y)) {
            int max;
            int coord;
            if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                coord = y;
                coord -= this._diagramRect.y;
                max = this._diagramRect.height;
            } else {
                coord = x;
                coord -= this._diagramRect.x;
                max = this._diagramRect.width;
            }
            TimeBarRow row = this.getRow(this._firstRow);
            int idx = this._firstRow;
            for (int endCoord = this._timeBarViewState.getRowHeight(row) - this._firstRowPixelOffset; endCoord < max; endCoord += this._timeBarViewState.getRowHeight(row)) {
                if (Math.abs(endCoord - coord) < this._selectionDelta) {
                    return row;
                }
                row = this.getRow(++idx);
            }
        }
        return null;
    }

    private boolean headerLineHit(int x, int y) {
        if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            return this._yAxisWidth > 0 && Math.abs(this._hierarchyWidth + this._yAxisWidth - x) < this._selectionDelta;
        }
        return this._yAxisWidth > 0 && Math.abs(this._hierarchyWidth + this._yAxisWidth - y) < this._selectionDelta;
    }

    private boolean isResizingAllowed(TimeBarRow row, Interval interval) {
        if (this._intervalModificators == null || this._intervalModificators.size() == 0) {
            return false;
        }
        boolean result = true;
        if (this._intervalModificators != null) {
            for (IntervalModificator modificator : this._intervalModificators) {
                result = result && (!modificator.isApplicable(row, interval) || modificator.isSizingAllowed(row, interval));
            }
        }
        return result;
    }

    private Rectangle normalizeRectangle(Rectangle rect) {
        int x = Math.min(rect.x, rect.x + rect.width);
        int y = Math.min(rect.y, rect.y + rect.height);
        int width = Math.abs(rect.width);
        int height = Math.abs(rect.height);
        return new Rectangle(x, y, width, height);
    }

    private void selectIntervals(Rectangle curSelRect) {
        List<Interval> intervals = this.getIntervals(curSelRect);
        for (Interval interval : intervals) {
            if (this._selectionModel.getSelectedIntervals().contains(interval)) continue;
            this._selectionModel.addSelectedInterval(interval);
        }
        ArrayList<Interval> selection = new ArrayList<Interval>();
        selection.addAll(this._selectionModel.getSelectedIntervals());
        for (Interval interval : selection) {
            if (intervals.contains(interval)) continue;
            this._selectionModel.remSelectedInterval(interval);
        }
    }

    private List<Interval> getIntervals(Rectangle curSelRect) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        boolean horizontal = this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL;
        List<TimeBarRow> rows = horizontal ? this.getRows(curSelRect.y, curSelRect.y + curSelRect.height) : this.getRows(curSelRect.x, curSelRect.x + curSelRect.width);
        JaretDate begin = horizontal ? this.dateForCoord(curSelRect.x) : this.dateForCoord(curSelRect.y);
        JaretDate end = horizontal ? this.dateForCoord(curSelRect.x + curSelRect.width) : this.dateForCoord(curSelRect.y + curSelRect.height);
        for (TimeBarRow row : rows) {
            List<Interval> intervals = row.getIntervals(begin, end);
            for (Interval interval : intervals) {
                boolean overlapping = this._drawOverlapping ? false : this._overlapStrategy.getOverlapInfo((TimeBarRow)row, (Interval)interval).overlappingCount > 0;
                Rectangle intervalRect = this.getIntervalBounds(row, interval);
                Rectangle containingRect = this._tbvi.timeBarContainingRect(interval, intervalRect, overlapping);
                if (containingRect == null) {
                    containingRect = intervalRect;
                }
                if (!curSelRect.contains(containingRect)) continue;
                result.add(interval);
            }
        }
        return result;
    }

    private Interval getTouchedInterval(TimeBarRow row, int x, int y) {
        List<Interval> intervals = row.getIntervals(this.getStartDate(), this.getEndDate());
        for (Interval interval : intervals) {
            Rectangle intervalRect = this.getIntervalBounds(row, interval);
            if (this._orientation == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                if (y < intervalRect.y || y > intervalRect.y + intervalRect.height) continue;
                if (x - intervalRect.x <= this._selectionDelta && x - intervalRect.x >= 0) {
                    return interval;
                }
                if (intervalRect.x + intervalRect.width - x > this._selectionDelta || intervalRect.x + intervalRect.width - x < 0) continue;
                return interval;
            }
            if (x < intervalRect.x || x > intervalRect.x + intervalRect.width) continue;
            if (y - intervalRect.y <= this._selectionDelta && y - intervalRect.y >= 0) {
                return interval;
            }
            if (intervalRect.y + intervalRect.height - y > this._selectionDelta || intervalRect.y + intervalRect.height - y < 0) continue;
            return interval;
        }
        return null;
    }

    private List<TimeBarRow> getRows(int c1, int c2) {
        ArrayList<TimeBarRow> result = new ArrayList<TimeBarRow>();
        for (int r = this._firstRow; r <= this._firstRow + this.getRowsDisplayed() && r < this.getRowCount(); ++r) {
            int startC = this.yForRow(this.getRow(r));
            int endC = startC + this._timeBarViewState.getRowHeight(this.getRow(r));
            if (!(startC >= c1 && startC <= c2 || endC >= c1 && endC <= c2) && (c1 < startC || c1 > endC)) continue;
            result.add(this.getRow(r));
        }
        return result;
    }

    public boolean getDrawRowGrid() {
        return this._drawRowGrid;
    }

    public void setDrawRowGrid(boolean drawRowGrid) {
        this._drawRowGrid = drawRowGrid;
        if (this._tbvi != null) {
            this._tbvi.repaint();
        }
    }

    public void highlightRow(int y) {
        TimeBarRow row = this.rowForY(y);
        this.highlightRow(row);
    }

    public void highlightRow(TimeBarRow row) {
        if (row != this._highlightedRow) {
            TimeBarRow oldRow = this._highlightedRow;
            this._highlightedRow = row;
            this._tbvi.repaint(this.getRowBounds(this._highlightedRow));
            if (oldRow != null) {
                this._tbvi.repaint(this.getRowBounds(oldRow));
            }
        }
    }

    public void deHighlightRow() {
        if (this._highlightedRow != null) {
            TimeBarRow row = this._highlightedRow;
            this._highlightedRow = null;
            this._tbvi.repaint(this.getRowBounds(row));
        }
    }

    public TimeBarRow getHighlightedRow() {
        return this._highlightedRow;
    }

    public TimeBarMarker getDraggedMarker() {
        return this._draggedMarker;
    }

    public Rectangle getSelectionRect() {
        return this._selectionRect;
    }

    public void setLastSelRect(Rectangle rect) {
        this._lastSelRect = rect;
    }

    public Rectangle getLastSelRect() {
        return this._lastSelRect;
    }

    public String getToolTipText(int x, int y) {
        TimeBarMarker marker = this.getMarkerForXY(x, y);
        if (marker != null) {
            return marker.getDescription();
        }
        if (this._diagramRect.contains(x, y)) {
            TimeBarRow row = this.rowForXY(x, y);
            if (row != null) {
                String tooltip = null;
                List<Interval> intervals = this.getIntervalsAt(row, x, y);
                if (intervals.size() == 0) {
                    return tooltip;
                }
                for (Interval interval : intervals) {
                    boolean overlapping;
                    Rectangle intervalRect;
                    if (!this._tbvi.timeBarContains(interval, intervalRect = this.getIntervalBounds(row, interval), x - intervalRect.x, y - intervalRect.y, overlapping = this._drawOverlapping ? false : this._overlapStrategy.getOverlapInfo((TimeBarRow)row, (Interval)interval).overlappingCount > 0)) continue;
                    tooltip = this._tbvi.getIntervalToolTipText(interval, intervalRect, x - intervalRect.x, y - intervalRect.y);
                    break;
                }
                return tooltip;
            }
        } else {
            if (this._hierarchyRect.contains(x, y)) {
                TimeBarRow row = this.rowForXY(x, y);
                if (row instanceof TimeBarNode) {
                    return this._tbvi.getHierarchyToolTipText((TimeBarNode)row, x, y);
                }
                return null;
            }
            if (this._yAxisRect.contains(x, y)) {
                return this._tbvi.getHeaderToolTipText(this.rowForXY(x, y), x, y);
            }
            if (this._xAxisRect.contains(x, y)) {
                return this._tbvi.getTimeScaleToolTipText(x, y);
            }
        }
        return null;
    }

    public Rectangle getHeaderRect(TimeBarRow row) {
        if (!this.isRowDisplayed(row)) {
            return null;
        }
        if (this._orientation.equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL)) {
            int y = this.yForRow(row);
            Rectangle rect = new Rectangle(this._yAxisRect.x, y, this._yAxisWidth, this._timeBarViewState.getRowHeight(row));
            return rect;
        }
        int x = this.yForRow(row);
        Rectangle rect = new Rectangle(x, this._yAxisRect.y, this._timeBarViewState.getRowHeight(row), this._yAxisWidth);
        return rect;
    }

    public Rectangle getHierarchyRect(TimeBarRow row) {
        if (!this.isRowDisplayed(row)) {
            return null;
        }
        int y = this.yForRow(row);
        Rectangle rect = new Rectangle(this._hierarchyRect.x, y, this._hierarchyWidth, this._timeBarViewState.getRowHeight(row));
        return rect;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TimeBarViewerDelegate[");
        buf.append("Name:" + this._name + ",");
        buf.append("StartDate:" + this._startDate.toDisplayString() + ",");
        buf.append("MinDate:" + this._minDate.toDisplayString() + ",");
        buf.append("MaxDate:" + this._maxDate.toDisplayString() + ",");
        buf.append("]");
        return buf.toString();
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setXAxisHeight(int axisHeight) {
        if (axisHeight != this._xAxisHeight) {
            int oldVal = this._xAxisHeight;
            this._xAxisHeight = axisHeight;
            if (this._tbvi != null) {
                this._tbvi.repaint();
            }
            if (this._tbvi != null) {
                this._tbvi.firePropertyChange("XAxisHeight", oldVal, axisHeight);
            }
        }
    }

    public void setAutoscrollEnabled(boolean enableAutoscroll) {
        this._autoscroll = enableAutoscroll;
    }

    public boolean isAutoscrollEnabled() {
        return this._autoscroll;
    }

    public void scrollDateToVisible(JaretDate date) {
        JaretDate enddate = this.getStartDate().copy();
        date = date.copy();
        if (this._milliAccuracy) {
            enddate.advanceMillis(this.getMilliSecondsDisplayed());
            if (date.compareTo(this.getStartDate()) < 0) {
                this.setStartDate(date);
            } else if (date.compareTo(enddate) > 0) {
                date.advanceMillis(-this.getMilliSecondsDisplayed());
                this.setStartDate(date);
            }
        } else {
            enddate.advanceSeconds((double)this.getSecondsDisplayed());
            if (date.compareTo(this.getStartDate()) < 0) {
                this.setStartDate(date);
            } else if (date.compareTo(enddate) > 0) {
                date.advanceSeconds((double)(-this.getSecondsDisplayed()));
                this.setStartDate(date);
            }
        }
    }

    public void scrollRowToVisible(TimeBarRow row) {
        if (!this.isFiltered(row)) {
            int ridx = this._rowList.indexOf(row);
            if (ridx == -1) {
                return;
            }
            if (ridx < this._firstRow) {
                this.setFirstRow(ridx);
            } else if (ridx > this._firstRow + this.getRowsDisplayed()) {
                this.setFirstRow(ridx - this.getRowsDisplayed());
            }
        }
    }

    public void scrollIntervalToVisible(TimeBarRow row, Interval interval) {
        this.scrollRowToVisible(row);
        if (this._milliAccuracy) {
            if (interval.getBegin().compareTo(this._startDate) < 0) {
                this.scrollDateToVisible(interval.getBegin());
            } else if (interval.getEnd().diffMilliSeconds(interval.getBegin()) > this.getMilliSecondsDisplayed()) {
                this.setStartDate(interval.getBegin());
            } else {
                this.scrollDateToVisible(interval.getEnd());
            }
        } else if (interval.getBegin().compareTo(this._startDate) < 0) {
            this.scrollDateToVisible(interval.getBegin());
        } else if (interval.getEnd().diffSeconds(interval.getBegin()) > this.getSecondsDisplayed()) {
            this.setStartDate(interval.getBegin());
        } else {
            this.scrollDateToVisible(interval.getEnd());
        }
    }

    public void scrollIntervalToVisible(Interval interval) {
        TimeBarRow row = this._model.getRowForInterval(interval);
        if (row != null) {
            this.scrollIntervalToVisible(row, interval);
        }
    }

    public synchronized void addIntervalModificator(IntervalModificator intervalModificator) {
        if (this._intervalModificators == null) {
            this._intervalModificators = new Vector<IntervalModificator>();
        }
        this._intervalModificators.add(intervalModificator);
    }

    public void remIntervalModificator(IntervalModificator intervalModificator) {
        if (this._intervalModificators != null) {
            this._intervalModificators.remove(intervalModificator);
        }
    }

    public ITimeBarViewState getTimeBarViewState() {
        return this._timeBarViewState;
    }

    public HierarchicalViewState getHierarchicalViewState() {
        return this._hierarchicalViewState;
    }

    public void setHierarchicalViewState(HierarchicalViewState hvs) {
        this._hierarchicalViewState = hvs;
    }

    public void setTitle(String title) {
        this._title = title;
        if (this._tbvi != null) {
            this._tbvi.repaint();
        }
    }

    public String getTitle() {
        return this._title;
    }

    public boolean isDrawOverlapping() {
        return this._drawOverlapping;
    }

    public void setDrawOverlapping(boolean drawOverlapping) {
        this._drawOverlapping = drawOverlapping;
        if (this._tbvi != null) {
            this._tbvi.repaint();
        }
    }

    public int getMaxOverlapCount(TimeBarRow row) {
        if (this._drawOverlapping) {
            return 1;
        }
        return this._overlapStrategy.getMaxOverlapCount(row);
    }

    public List<Interval> filterIntervals(List<Interval> intervals) {
        if (this._intervalFilter == null) {
            return intervals;
        }
        ArrayList<Interval> result = new ArrayList<Interval>();
        for (Interval interval : intervals) {
            if (!this._intervalFilter.isInResult(interval)) continue;
            result.add(interval);
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this._rowFilter) || evt.getSource().equals(this._rowSorter)) {
            this.updateRowList();
            if (this._tbvi != null) {
                this._tbvi.repaint();
            }
        } else if (evt.getSource() instanceof TimeBarIntervalFilter && this._tbvi != null) {
            this._overlapStrategy.clearCachedData();
            this._tbvi.repaint();
        }
    }

    public Interval getFocussedInterval() {
        return this._focussedInterval;
    }

    public TimeBarRow getFocussedRow() {
        return this._focussedRow;
    }

    public boolean isFocussed(Interval interval) {
        if (this._focussedInterval == null) {
            return false;
        }
        return this._focussedInterval.equals(interval);
    }

    public void setFocussedInterval(Interval interval) {
        this.setFocussedInterval(null, interval);
    }

    public void setFocussedInterval(TimeBarRow row, Interval interval) {
        if (this._focussedInterval == null && interval == null) {
            return;
        }
        if (this._focussedInterval != null && this._focussedInterval.equals(interval)) {
            return;
        }
        if (interval != null && this.isFiltered(interval)) {
            return;
        }
        if (interval != null && row == null) {
            this._focussedRow = this._model.getRowForInterval(interval);
            if (this._focussedRow == null || this.isFiltered(this._focussedRow)) {
                return;
            }
        } else {
            this._focussedRow = row;
        }
        this._focussedInterval = interval;
        if (this._focussedInterval != null) {
            this.scrollIntervalToVisible(this._focussedRow, this._focussedInterval);
        }
        this._tbvi.repaint();
        this.fireFocussedIntervalChange(this._focussedRow, this._focussedInterval);
    }

    public void moveFocusRight() {
        int idx;
        if (this._focussedRow != null && this._focussedInterval != null && (idx = this._focussedRow.getIntervals().indexOf(this._focussedInterval)) + 1 < this._focussedRow.getIntervals().size()) {
            this.setFocussedInterval(this._focussedRow.getIntervals().get(idx + 1));
        }
    }

    public void moveFocusLeft() {
        int idx;
        if (this._focussedRow != null && this._focussedInterval != null && (idx = this._focussedRow.getIntervals().indexOf(this._focussedInterval)) - 1 >= 0) {
            this.setFocussedInterval(this._focussedRow.getIntervals().get(idx - 1));
        }
    }

    public void moveFocusUp() {
        int ridx;
        if (this._focussedRow != null && this._focussedInterval != null && (ridx = this._rowList.indexOf(this._focussedRow)) > 0) {
            TimeBarRow focussedRow = this._rowList.get(ridx - 1);
            List<Interval> intervals = focussedRow.getIntervals(this._focussedInterval.getBegin(), this._focussedInterval.getEnd());
            if (intervals != null && intervals.size() > 0) {
                this.setFocussedInterval(focussedRow, intervals.get(0));
            } else {
                Interval interval = this.getNearestInterval(focussedRow, this._focussedInterval);
                if (interval != null) {
                    this.setFocussedInterval(focussedRow, interval);
                }
            }
        }
    }

    public void moveFocusDown() {
        int ridx;
        if (this._focussedRow != null && this._focussedInterval != null && (ridx = this._rowList.indexOf(this._focussedRow)) + 1 < this._rowList.size()) {
            TimeBarRow focussedRow = this._rowList.get(ridx + 1);
            List<Interval> intervals = focussedRow.getIntervals(this._focussedInterval.getBegin(), this._focussedInterval.getEnd());
            if (intervals != null && intervals.size() > 0) {
                this.setFocussedInterval(focussedRow, intervals.get(0));
            } else {
                Interval interval = this.getNearestInterval(focussedRow, this._focussedInterval);
                if (interval != null) {
                    this.setFocussedInterval(focussedRow, interval);
                }
            }
        }
    }

    private Interval getNearestInterval(TimeBarRow row, Interval interval) {
        Interval result = null;
        long deltaSec = -1L;
        JaretDate d = new JaretDate(interval.getBegin());
        d.advanceSeconds((double)(interval.getSeconds() / 2));
        for (Interval i : row.getIntervals()) {
            int delta = Math.abs(i.getBegin().diffSeconds(d));
            if ((long)delta < deltaSec || deltaSec == -1L) {
                result = i;
                deltaSec = delta;
            }
            if ((long)(delta = Math.abs(i.getEnd().diffSeconds(d))) >= deltaSec && deltaSec != -1L) continue;
            result = i;
            deltaSec = delta;
        }
        return result;
    }

    public synchronized void addFocussedIntervalListener(FocussedIntervalListener listener) {
        if (this._focussedIntervalListeners == null) {
            this._focussedIntervalListeners = new Vector<FocussedIntervalListener>(2);
        }
        this._focussedIntervalListeners.add(listener);
    }

    public synchronized void remFocussedIntervalListener(FocussedIntervalListener listener) {
        if (this._focussedIntervalListeners != null) {
            this._focussedIntervalListeners.remove(listener);
        }
    }

    protected void fireFocussedIntervalChange(TimeBarRow newFocussedRow, Interval newFocussedInterval) {
        if (this._focussedIntervalListeners != null) {
            for (FocussedIntervalListener listener : this._focussedIntervalListeners) {
                listener.focussedIntervalChanged(this._tbvi, newFocussedRow, newFocussedInterval);
            }
        }
    }

    public void handleKeyPressed(int keyCode, int modifierMask) {
        boolean horizontal = this._orientation.equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL);
        if (modifierMask == 0) {
            switch (keyCode) {
                case 39: {
                    if (horizontal) {
                        this.moveFocusRight();
                        break;
                    }
                    this.moveFocusDown();
                    break;
                }
                case 37: {
                    if (horizontal) {
                        this.moveFocusLeft();
                        break;
                    }
                    this.moveFocusUp();
                    break;
                }
                case 38: {
                    if (horizontal) {
                        this.moveFocusUp();
                        break;
                    }
                    this.moveFocusLeft();
                    break;
                }
                case 40: {
                    if (horizontal) {
                        this.moveFocusDown();
                        break;
                    }
                    this.moveFocusRight();
                    break;
                }
                case 32: {
                    this.selectFocussedInterval(false);
                    break;
                }
                case 27: {
                    this.cancelDrag();
                    break;
                }
            }
        } else if ((modifierMask & 0x40) != 0) {
            switch (keyCode) {
                case 39: {
                    this.growRight(this._focussedRow, this._focussedInterval, this._keyboardChangeDelta);
                    break;
                }
                case 37: {
                    this.growLeft(this._focussedRow, this._focussedInterval, this._keyboardChangeDelta);
                    break;
                }
            }
        } else if ((modifierMask & 0x200) != 0) {
            switch (keyCode) {
                case 39: {
                    this.growLeft(this._focussedRow, this._focussedInterval, -this._keyboardChangeDelta);
                    break;
                }
                case 37: {
                    this.growRight(this._focussedRow, this._focussedInterval, -this._keyboardChangeDelta);
                    break;
                }
            }
        } else if ((modifierMask & 0x80) != 0) {
            switch (keyCode) {
                case 39: {
                    this.moveInterval(this._focussedRow, this._focussedInterval, this._keyboardChangeDelta);
                    break;
                }
                case 37: {
                    this.moveInterval(this._focussedRow, this._focussedInterval, -this._keyboardChangeDelta);
                    break;
                }
                case 32: {
                    this.selectFocussedInterval(true);
                    break;
                }
                case 27: {
                    this.cancelDrag();
                    break;
                }
            }
        }
    }

    private void selectFocussedInterval(boolean add) {
        if (this._focussedInterval != null) {
            if (!add) {
                this._selectionModel.setSelectedInterval(this._focussedInterval);
            } else if (!this._selectionModel.isSelected(this._focussedInterval)) {
                this._selectionModel.addSelectedInterval(this._focussedInterval);
            } else {
                this._selectionModel.remSelectedInterval(this._focussedInterval);
            }
        }
    }

    private void moveInterval(TimeBarRow row, Interval interval, int deltaSeconds) {
        if (interval == null) {
            return;
        }
        JaretDate newBegin = interval.getBegin().copy().advanceSeconds((double)deltaSeconds);
        boolean allowed = true;
        for (IntervalModificator modificator : this._intervalModificators) {
            allowed = allowed && (!modificator.isApplicable(this._intervalDraggedRow, this._changingInterval) || modificator.shiftAllowed(row, interval, newBegin));
        }
        if (allowed) {
            JaretDate oldBegin = interval.getBegin();
            JaretDate oldEnd = interval.getEnd();
            interval.setBegin(newBegin);
            interval.setEnd(interval.getEnd().advanceSeconds((double)deltaSeconds));
            this.fireIntervalChangeStarted(row, interval);
            this.fireIntervalChanged(row, interval, oldBegin, oldEnd);
        }
    }

    private void growLeft(TimeBarRow row, Interval interval, int deltaSeconds) {
        if (interval == null) {
            return;
        }
        JaretDate newBegin = interval.getBegin().copy().backSeconds((double)deltaSeconds);
        boolean allowed = true;
        for (IntervalModificator modificator : this._intervalModificators) {
            allowed = allowed && (!modificator.isApplicable(row, interval) || modificator.newBeginAllowed(row, interval, newBegin));
        }
        if (allowed) {
            JaretDate oldBegin = interval.getBegin();
            interval.setBegin(newBegin);
            this.fireIntervalChangeStarted(row, interval);
            this.fireIntervalChanged(row, interval, oldBegin, interval.getEnd());
        }
    }

    private void growRight(TimeBarRow row, Interval interval, int deltaSeconds) {
        if (interval == null) {
            return;
        }
        JaretDate newEnd = interval.getEnd().copy().advanceSeconds((double)deltaSeconds);
        boolean allowed = true;
        for (IntervalModificator modificator : this._intervalModificators) {
            allowed = allowed && (!modificator.isApplicable(row, interval) || modificator.newEndAllowed(row, interval, newEnd));
        }
        if (allowed) {
            JaretDate oldEnd = interval.getEnd();
            interval.setEnd(newEnd);
            this.fireIntervalChangeStarted(row, interval);
            this.fireIntervalChanged(row, interval, interval.getBegin(), oldEnd);
        }
    }

    public int getKeyboardChangeDelta() {
        return this._keyboardChangeDelta;
    }

    public void setKeyboardChangeDelta(int keyboardChangeDelta) {
        this._keyboardChangeDelta = keyboardChangeDelta;
    }

    public boolean hasVariableXScale() {
        return this._variableXScale;
    }

    public void setVariableXScale(boolean state) {
        if (state != this._variableXScale) {
            this._variableXScale = state;
            if (state) {
                this.setOptimizeScrolling(false);
                this._xScalePPSIntervalRow = new DefaultTimeBarNode(new DefaultRowHeader("PPSROW"));
                if (this._repaintingRowListener == null) {
                    this._repaintingRowListener = new TimeBarRowListener(){

                        public void elementAdded(TimeBarRow row, Interval element) {
                            TimeBarViewerDelegate.this._tbvi.repaint();
                        }

                        public void elementChanged(TimeBarRow row, Interval element) {
                            TimeBarViewerDelegate.this._tbvi.repaint();
                        }

                        public void elementRemoved(TimeBarRow row, Interval element) {
                            TimeBarViewerDelegate.this._tbvi.repaint();
                        }

                        public void headerChanged(TimeBarRow row, TimeBarRowHeader newHeader) {
                            TimeBarViewerDelegate.this._tbvi.repaint();
                        }

                        public void rowDataChanged(TimeBarRow row) {
                            TimeBarViewerDelegate.this._tbvi.repaint();
                        }
                    };
                }
                this._xScalePPSIntervalRow.addTimeBarRowListener(this._repaintingRowListener);
            } else {
                if (this._xScalePPSIntervalRow != null && this._repaintingRowListener != null) {
                    this._xScalePPSIntervalRow.remTimeBarRowListener(this._repaintingRowListener);
                }
                this._xScalePPSIntervalRow = null;
            }
            if (this._tbvi != null) {
                this._tbvi.repaint();
            }
            this.updateScrollBars();
        }
    }

    public TimeBarNode getPpsRow() {
        return this._xScalePPSIntervalRow;
    }

    public int getSelectionDelta() {
        return this._selectionDelta;
    }

    public void setSelectionDelta(int selectionDelta) {
        this._selectionDelta = selectionDelta;
    }

    public boolean isLineDraggingAllowed() {
        return this._lineDraggingAllowed;
    }

    public void setLineDraggingAllowed(boolean lineDraggingAllowed) {
        this._lineDraggingAllowed = lineDraggingAllowed;
    }

    public boolean isMilliAccuracy() {
        return this._milliAccuracy;
    }

    public void setMilliAccuracy(boolean milliAccuracy) {
        this._milliAccuracy = milliAccuracy;
    }

    public void setDrawingOffset(int marginLeft, int marginTop) {
        this._offsetLeft = marginLeft;
        this._offsetTop = marginTop;
    }

    public boolean getOptimizeScrolling() {
        return this._optimizeScrolling;
    }

    public void setOptimizeScrolling(boolean optimizeScrolling) {
        if (this._variableXScale && optimizeScrolling) {
            throw new RuntimeException("Optimized scrolling can not be used together with a variable xscale");
        }
        this._optimizeScrolling = optimizeScrolling;
    }

    public TimeBarViewerInterface.Orientation getOrientation() {
        return this._orientation;
    }

    public void setOrientation(TimeBarViewerInterface.Orientation orientation) {
        if (this._orientation != orientation) {
            this._orientation = orientation;
            this.updateScrollBars();
            if (this._tbvi != null) {
                this._tbvi.repaint();
            }
        }
    }

    public int getAutoScaleRows() {
        return this._autoScaleRows;
    }

    public void setAutoScaleRows(int rows) {
        if (this._autoScaleRows != rows) {
            this._autoScaleRows = rows;
            if (this._tbvi != null) {
                this._tbvi.repaint();
            }
        }
    }

    public void addTimeBarChangeListener(ITimeBarChangeListener listener) {
        if (!this._timeBarChangeListeners.contains(listener)) {
            this._timeBarChangeListeners.add(listener);
        }
    }

    public void removeTimeBarChangeListener(ITimeBarChangeListener listener) {
        this._timeBarChangeListeners.remove(listener);
    }

    protected void fireIntervalChangeStarted(TimeBarRow row, Interval interval) {
        for (ITimeBarChangeListener listener : this._timeBarChangeListeners) {
            listener.intervalChangeStarted(row, interval);
        }
    }

    protected void fireIntervalIntermediateChange(TimeBarRow row, Interval interval, JaretDate oldBegin, JaretDate oldEnd) {
        for (ITimeBarChangeListener listener : this._timeBarChangeListeners) {
            listener.intervalIntermediateChange(row, interval, oldBegin, oldEnd);
        }
    }

    protected void fireIntervalChanged(TimeBarRow row, Interval interval, JaretDate oldBegin, JaretDate oldEnd) {
        for (ITimeBarChangeListener listener : this._timeBarChangeListeners) {
            listener.intervalChanged(row, interval, oldBegin, oldEnd);
        }
    }

    protected void fireIntervalChangeCancelled(TimeBarRow row, Interval interval) {
        for (ITimeBarChangeListener listener : this._timeBarChangeListeners) {
            listener.intervalChangeCancelled(row, interval);
        }
    }

    public boolean isRowHeightDraggingAllowed() {
        return this._rowHeightDraggingAllowed;
    }

    public void setRowHeightDraggingAllowed(boolean rowHeightDraggingAllowed) {
        if (this._rowHeightDraggingAllowed != rowHeightDraggingAllowed) {
            this._rowHeightDraggingAllowed = rowHeightDraggingAllowed;
            if (this._tbvi != null) {
                this._tbvi.firePropertyChangeX("RowHeightDraggingAllowed", !rowHeightDraggingAllowed, rowHeightDraggingAllowed);
            }
        }
    }

    public boolean isInRowAxis(int x, int y) {
        return this._hierarchyRect.contains(x, y) || this._yAxisRect.contains(x, y);
    }

    public boolean isInDiagram(int x, int y) {
        return this._diagramRect.contains(x, y);
    }

    public boolean getStrictClipTimeCheck() {
        return this._strictClipTimeCheck;
    }

    public void setStrictClipTimeCheck(boolean strictClipTimeCheck) {
        this._strictClipTimeCheck = strictClipTimeCheck;
    }

    public int getScrollLookBackMinutes() {
        return this._scrollLookBackMinutes;
    }

    public void setScrollLookBackMinutes(int scrollLookBackMinutes) {
        this._scrollLookBackMinutes = scrollLookBackMinutes;
    }

    public int getScrollLookForwardMinutes() {
        return this._scrollLookForwardMinutes;
    }

    public void setScrollLookForwardMinutes(int scrollLookForwardMinutes) {
        this._scrollLookForwardMinutes = scrollLookForwardMinutes;
    }

    public IOverlapStrategy getOverlapStrategy() {
        return this._overlapStrategy;
    }

    public void setOverlapStrategy(IOverlapStrategy overlapStrategy) {
        if (overlapStrategy == null) {
            throw new IllegalArgumentException("Strategy may not be null");
        }
        IOverlapStrategy oldStrategy = this._overlapStrategy;
        this._overlapStrategy = overlapStrategy;
        oldStrategy.dispose();
    }
}

