/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars;

import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class TimeBarViewerSynchronizer
implements PropertyChangeListener {
    protected boolean _syncRowHeight = false;
    protected boolean _syncStartDate = true;
    protected boolean _syncTimeScale = true;
    protected List<TimeBarViewerInterface> _viewers;

    public TimeBarViewerSynchronizer(boolean syncRowHeight, boolean syncStartDate, boolean syncTimeScale) {
        this._syncRowHeight = syncRowHeight;
        this._syncStartDate = syncStartDate;
        this._syncTimeScale = syncTimeScale;
    }

    public void addViewer(TimeBarViewerInterface viewer) {
        if (this._viewers == null) {
            this._viewers = new ArrayList<TimeBarViewerInterface>();
        }
        this._viewers.add(viewer);
        viewer.addPropertyChangeListener(this);
    }

    public void remViewer(TimeBarViewerInterface viewer) {
        if (this._viewers != null) {
            this._viewers.remove(viewer);
            viewer.removePropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        TimeBarViewerInterface emitting = (TimeBarViewerInterface)evt.getSource();
        if (evt.getPropertyName().equals("PixelPerSecond") && this._syncTimeScale) {
            this.setPixPerSecond(emitting, emitting.getPixelPerSecond());
        } else if (evt.getPropertyName().equals("RowHeight") && this._syncRowHeight) {
            this.setRowHeight(emitting, emitting.getRowHeight());
        } else if (evt.getPropertyName().equals("StartDate") && this._syncStartDate) {
            this.setStartDate(emitting, emitting.getStartDate());
        } else if (evt.getPropertyName().equals("MinDate")) {
            this.setMinDate(emitting, emitting.getMinDate());
        } else if (evt.getPropertyName().equals("MaxDate")) {
            this.setMaxDate(emitting, emitting.getMaxDate());
        }
    }

    private void setPixPerSecond(TimeBarViewerInterface emitting, double pixPerSecond) {
        for (TimeBarViewerInterface viewer : this._viewers) {
            if (emitting.equals(viewer)) continue;
            viewer.removePropertyChangeListener(this);
            viewer.setPixelPerSecond(pixPerSecond);
            viewer.addPropertyChangeListener(this);
        }
    }

    private void setRowHeight(TimeBarViewerInterface emitting, int rowHeight) {
        for (TimeBarViewerInterface viewer : this._viewers) {
            if (emitting.equals(viewer)) continue;
            viewer.removePropertyChangeListener(this);
            viewer.setRowHeight(rowHeight);
            viewer.addPropertyChangeListener(this);
        }
    }

    private void setMinDate(TimeBarViewerInterface emitting, JaretDate minDate) {
        for (TimeBarViewerInterface viewer : this._viewers) {
            if (emitting.equals(viewer)) continue;
            viewer.removePropertyChangeListener(this);
            viewer.setMinDate(minDate.copy());
            viewer.addPropertyChangeListener(this);
        }
    }

    private void setMaxDate(TimeBarViewerInterface emitting, JaretDate maxDate) {
        for (TimeBarViewerInterface viewer : this._viewers) {
            if (emitting.equals(viewer)) continue;
            viewer.removePropertyChangeListener(this);
            viewer.setMaxDate(maxDate.copy());
            viewer.addPropertyChangeListener(this);
        }
    }

    private void setStartDate(TimeBarViewerInterface emitting, JaretDate startDate) {
        for (TimeBarViewerInterface viewer : this._viewers) {
            if (emitting.equals(viewer)) continue;
            viewer.removePropertyChangeListener(this);
            viewer.setStartDate(startDate.copy());
            viewer.addPropertyChangeListener(this);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TimeBarViewerSynchronizer:\n");
        for (TimeBarViewerInterface viewer : this._viewers) {
            buf.append(viewer.toString() + "\n");
        }
        return buf.toString();
    }
}

