/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.date.Interval;
import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.model.TimeBarModel;
import de.jaret.util.ui.timebars.model.TimeBarModelListener;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.model.TimeBarRowHeader;
import de.jaret.util.ui.timebars.model.TimeBarRowListener;
import java.util.List;
import java.util.Vector;

public abstract class AbstractTimeBarModel
implements TimeBarModel,
TimeBarRowListener {
    protected JaretDate _minDate;
    protected JaretDate _maxDate;
    protected List<TimeBarModelListener> _listenerList;

    public JaretDate getMinDate() {
        if (this._minDate == null) {
            return new JaretDate();
        }
        return this._minDate.copy();
    }

    public JaretDate getMaxDate() {
        if (this._maxDate == null) {
            return new JaretDate();
        }
        return this._maxDate.copy();
    }

    public TimeBarRow getRowForInterval(Interval interval) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getRow(i).getIntervals().contains(interval)) continue;
            return this.getRow(i);
        }
        return null;
    }

    public synchronized void addTimeBarModelListener(TimeBarModelListener tbml) {
        if (this._listenerList == null) {
            this._listenerList = new Vector<TimeBarModelListener>();
        }
        this._listenerList.add(tbml);
    }

    public void remTimeBarModelListener(TimeBarModelListener tbml) {
        if (this._listenerList != null) {
            this._listenerList.remove(tbml);
        }
    }

    protected void fireModelDataChanged() {
        if (this._listenerList != null) {
            for (TimeBarModelListener listener : this._listenerList) {
                listener.modelDataChanged(this);
            }
        }
    }

    protected void fireRowAdded(TimeBarRow row) {
        if (this._listenerList != null) {
            for (TimeBarModelListener listener : this._listenerList) {
                listener.rowAdded(this, row);
            }
        }
    }

    protected void fireRowRemoved(TimeBarRow row) {
        if (this._listenerList != null) {
            for (TimeBarModelListener listener : this._listenerList) {
                listener.rowRemoved(this, row);
            }
        }
    }

    protected void fireRowDataChanged(TimeBarRow row) {
        if (this._listenerList != null) {
            for (TimeBarModelListener listener : this._listenerList) {
                listener.rowDataChanged(this, row);
            }
        }
    }

    protected void fireHeaderChanged(TimeBarRow row, TimeBarRowHeader header) {
        if (this._listenerList != null) {
            for (TimeBarModelListener listener : this._listenerList) {
                listener.headerChanged(this, row, header);
            }
        }
    }

    protected void fireElementChanged(TimeBarRow row, Interval element) {
        if (this._listenerList != null) {
            for (TimeBarModelListener listener : this._listenerList) {
                listener.elementChanged(this, row, element);
            }
        }
    }

    protected void fireElementAdded(TimeBarRow row, Interval element) {
        if (this._listenerList != null) {
            for (TimeBarModelListener listener : this._listenerList) {
                listener.elementAdded(this, row, element);
            }
        }
    }

    protected void fireElementRemoved(TimeBarRow row, Interval element) {
        if (this._listenerList != null) {
            for (TimeBarModelListener listener : this._listenerList) {
                listener.elementRemoved(this, row, element);
            }
        }
    }

    public void elementAdded(TimeBarRow row, Interval element) {
        this.updateMinMax();
        this.fireElementAdded(row, element);
    }

    public void elementRemoved(TimeBarRow row, Interval element) {
        this.updateMinMax();
        this.fireElementRemoved(row, element);
    }

    public void elementChanged(TimeBarRow row, Interval element) {
        this.updateMinMax();
        this.fireElementChanged(row, element);
    }

    public void headerChanged(TimeBarRow row, TimeBarRowHeader newHeader) {
        this.fireHeaderChanged(row, newHeader);
    }

    public void rowDataChanged(TimeBarRow row) {
        this.updateMinMax();
        this.fireRowDataChanged(row);
    }

    protected void updateMinMax() {
        this._minDate = null;
        this._maxDate = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            TimeBarRow r = this.getRow(i);
            if (this._minDate == null && r.getMinDate() != null || r.getMinDate() != null && this._minDate.compareTo(r.getMinDate()) > 0) {
                this._minDate = r.getMinDate().copy();
            }
            if ((this._maxDate != null || r.getMaxDate() == null) && (r.getMaxDate() == null || this._maxDate.compareTo(r.getMaxDate()) >= 0)) continue;
            this._maxDate = r.getMaxDate().copy();
        }
    }
}

