/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.ui.timebars.model.AbstractTimeBarRowModel;
import de.jaret.util.ui.timebars.model.TimeBarNode;
import de.jaret.util.ui.timebars.model.TimeBarNodeListener;
import java.util.List;
import java.util.Vector;

public abstract class AbstractTimeBarNode
extends AbstractTimeBarRowModel
implements TimeBarNode {
    protected List<TimeBarNodeListener> _nodeListeners;

    public synchronized void addTimeBarNodeListener(TimeBarNodeListener tbnl) {
        if (this._nodeListeners == null) {
            this._nodeListeners = new Vector<TimeBarNodeListener>();
        }
        this._nodeListeners.add(tbnl);
        super.addTimeBarRowListener(tbnl);
    }

    public void removeTimeBarNodeListener(TimeBarNodeListener tbnl) {
        if (this._nodeListeners == null) {
            return;
        }
        this._nodeListeners.remove(tbnl);
        super.remTimeBarRowListener(tbnl);
    }

    protected void fireNodeAdded(TimeBarNode newNode) {
        if (this._nodeListeners != null) {
            for (TimeBarNodeListener listener : this._nodeListeners) {
                listener.nodeAdded(this, newNode);
            }
        }
    }

    protected void fireNodeRemoved(TimeBarNode removedNode) {
        if (this._nodeListeners != null) {
            for (TimeBarNodeListener listener : this._nodeListeners) {
                listener.nodeRemoved(this, removedNode);
            }
        }
    }
}

