/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.date.Interval;
import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.model.TimeBarRowHeader;
import de.jaret.util.ui.timebars.model.TimeBarRowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTimeBarRowModel
implements TimeBarRow,
PropertyChangeListener {
    protected TimeBarRowHeader _header;
    protected JaretDate _minDate;
    protected JaretDate _maxDate;
    protected List<TimeBarRowListener> _listenerList;

    public AbstractTimeBarRowModel() {
    }

    public AbstractTimeBarRowModel(TimeBarRowHeader header) {
        this.setRowHeader(header);
    }

    @Override
    public abstract List<Interval> getIntervals();

    @Override
    public List<Interval> getIntervals(JaretDate beginDate, JaretDate endDate) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        if (this.getIntervals() != null) {
            for (Interval interval : this.getIntervals()) {
                if (!(interval.getBegin().compareTo(beginDate) >= 0 && interval.getBegin().compareTo(endDate) <= 0 || interval.getEnd().compareTo(beginDate) >= 0 && interval.getEnd().compareTo(endDate) <= 0) && (interval.getBegin().compareTo(beginDate) > 0 || interval.getEnd().compareTo(endDate) < 0)) continue;
                result.add(interval);
            }
        }
        return result;
    }

    @Override
    public List<Interval> getIntervals(JaretDate date) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        for (Interval interval : this.getIntervals()) {
            if (!interval.contains(date)) continue;
            result.add(interval);
        }
        return result;
    }

    @Override
    public TimeBarRowHeader getRowHeader() {
        return this._header;
    }

    public void setRowHeader(TimeBarRowHeader header) {
        if (this._header != null) {
            this._header.removePropertyChangeListener(this);
        }
        this._header = header;
        if (this._header != null) {
            this._header.addPropertyChangeListener(this);
        }
        this.fireHeaderChanged();
    }

    @Override
    public synchronized void addTimeBarRowListener(TimeBarRowListener tbrl) {
        if (this._listenerList == null) {
            this._listenerList = new Vector<TimeBarRowListener>();
        }
        this._listenerList.add(tbrl);
    }

    @Override
    public void remTimeBarRowListener(TimeBarRowListener tbrl) {
        if (this._listenerList != null) {
            this._listenerList.remove(tbrl);
        }
    }

    protected void fireRowDataChanged() {
        if (this._listenerList != null) {
            for (TimeBarRowListener tbrl : this._listenerList) {
                tbrl.rowDataChanged(this);
            }
        }
    }

    protected void fireElementAdded(Interval element) {
        if (this._listenerList != null) {
            for (TimeBarRowListener tbrl : this._listenerList) {
                tbrl.elementAdded(this, element);
            }
        }
    }

    protected void fireElementRemoved(Interval element) {
        if (this._listenerList != null) {
            for (TimeBarRowListener tbrl : this._listenerList) {
                tbrl.elementRemoved(this, element);
            }
        }
    }

    protected void fireElementChanged(Interval element) {
        if (this._listenerList != null) {
            for (TimeBarRowListener tbrl : this._listenerList) {
                tbrl.elementChanged(this, element);
            }
        }
    }

    protected void fireHeaderChanged() {
        if (this._listenerList != null) {
            for (TimeBarRowListener tbrl : this._listenerList) {
                tbrl.headerChanged(this, this.getRowHeader());
            }
        }
    }

    @Override
    public JaretDate getMaxDate() {
        return this._maxDate;
    }

    @Override
    public JaretDate getMinDate() {
        return this._minDate;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Interval) {
            this.updateMinMax();
            this.fireElementChanged((Interval)evt.getSource());
        } else if (evt.getSource() == this._header) {
            this.fireHeaderChanged();
        } else {
            throw new RuntimeException("Unknown sender " + evt.getSource());
        }
    }

    protected void updateMinMax() {
        this._minDate = null;
        this._maxDate = null;
        for (Interval i : this.getIntervals()) {
            if (this._minDate == null || this._minDate.compareTo(i.getBegin()) > 0) {
                this._minDate = i.getBegin().copy();
            }
            if (this._maxDate != null && this._maxDate.compareTo(i.getEnd()) >= 0) continue;
            this._maxDate = i.getEnd().copy();
        }
        if (this._minDate == null) {
            this._minDate = new JaretDate();
        }
        if (this._maxDate == null) {
            this._maxDate = new JaretDate();
        }
    }
}

