/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.date.Interval;
import de.jaret.util.date.IntervalImpl;
import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.model.AbstractTimeBarRowModel;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.model.TimeBarRowHeader;
import de.jaret.util.ui.timebars.model.TimeBarRowListener;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddingTimeBarRowModel
extends AbstractTimeBarRowModel
implements TimeBarRowListener {
    protected List<Interval> _intervals = new ArrayList<Interval>();
    protected MergedInterval _mergedInterval;
    protected List<TimeBarRow> _rows = new ArrayList<TimeBarRow>();

    public AddingTimeBarRowModel(TimeBarRowHeader header) {
        super(header);
    }

    @Override
    public List<Interval> getIntervals() {
        return this._intervals;
    }

    public void addRow(TimeBarRow row) {
        this._rows.add(row);
        if (row.getMinDate() != null) {
            this.checkMergedInterval();
            if (this._mergedInterval.getBegin() == null || row.getMinDate().compareTo(this._mergedInterval.getBegin()) < 0) {
                this._mergedInterval.setBeginX(row.getMinDate().copy());
                this._minDate = this._mergedInterval.getBegin().copy();
            }
            if (this._mergedInterval.getEnd() == null || row.getMaxDate().compareTo(this._mergedInterval.getEnd()) > 0) {
                this._mergedInterval.setEndX(row.getMaxDate().copy());
                this._maxDate = this._mergedInterval.getEnd().copy();
            }
        }
        row.addTimeBarRowListener(this);
    }

    public void remRow(TimeBarRow row) {
        if (this._rows.remove(row)) {
            row.remTimeBarRowListener(this);
            this.checkBounds();
        }
    }

    protected void checkMergedInterval() {
        if (this._mergedInterval == null) {
            this._mergedInterval = new MergedInterval();
            this._intervals.add((Interval)this._mergedInterval);
        }
    }

    @Override
    public void rowDataChanged(TimeBarRow row) {
        this.checkBounds();
    }

    @Override
    public void elementAdded(TimeBarRow row, Interval element) {
        this.checkBounds();
    }

    @Override
    public void elementRemoved(TimeBarRow row, Interval element) {
        this.checkBounds();
    }

    @Override
    public void elementChanged(TimeBarRow row, Interval element) {
        this.checkBounds();
    }

    protected void checkBounds() {
        JaretDate min = null;
        JaretDate max = null;
        for (TimeBarRow row : this._rows) {
            if (row.getMinDate() != null && row.getIntervals().size() > 0 && (min == null || row.getMinDate().compareTo(min) < 0)) {
                min = row.getMinDate().copy();
            }
            if (row.getMaxDate() == null || row.getIntervals().size() <= 0 || max != null && row.getMaxDate().compareTo(max) <= 0) continue;
            max = row.getMaxDate().copy();
        }
        if (min == null) {
            if (this._mergedInterval != null) {
                this._intervals.remove((Object)this._mergedInterval);
                this.fireElementRemoved((Interval)this._mergedInterval);
                this._mergedInterval = null;
            }
        } else {
            this.checkMergedInterval();
            boolean changed = false;
            if (!(this._mergedInterval == null || this._mergedInterval.getBegin() != null && this._mergedInterval.getBegin().equals((Object)min))) {
                this._mergedInterval.setBeginX(min);
                this._minDate = this._mergedInterval.getBegin().copy();
                changed = true;
            }
            if (!(this._mergedInterval == null || this._mergedInterval.getEnd() != null && this._mergedInterval.getEnd().equals((Object)max))) {
                this._mergedInterval.setEndX(max);
                this._maxDate = this._mergedInterval.getEnd().copy();
                changed = true;
            }
            if (changed) {
                this.fireElementChanged((Interval)this._mergedInterval);
            }
        }
    }

    @Override
    public void headerChanged(TimeBarRow row, TimeBarRowHeader newHeader) {
    }

    public class MergedInterval
    extends IntervalImpl {
        public void setBeginX(JaretDate date) {
            super.setBegin(date);
        }

        public void setEndX(JaretDate date) {
            super.setEnd(date);
        }

        public void setBegin(JaretDate begin) {
        }

        public void setEnd(JaretDate end) {
        }
    }
}

