/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.ui.timebars.model.AbstractTimeBarModel;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import java.util.ArrayList;
import java.util.List;

public class DefaultTimeBarModel
extends AbstractTimeBarModel {
    protected List<TimeBarRow> _rows = new ArrayList<TimeBarRow>();

    public TimeBarRow getRow(int row) {
        return this._rows.get(row);
    }

    public int getRowCount() {
        return this._rows.size();
    }

    public void addRow(TimeBarRow row) {
        this.addRow(-1, row);
    }

    public void addRow(int index, TimeBarRow row) {
        if (index == -1) {
            this._rows.add(row);
        } else {
            this._rows.add(index, row);
        }
        if (this._minDate == null) {
            this._minDate = row.getMinDate();
            this._maxDate = row.getMaxDate();
        } else if (row.getMinDate() != null && row.getMaxDate() != null) {
            if (this._minDate.compareTo(row.getMinDate()) > 0) {
                this._minDate = row.getMinDate();
            } else if (this._maxDate.compareTo(row.getMaxDate()) < 0) {
                this._maxDate = row.getMaxDate();
            }
        }
        row.addTimeBarRowListener(this);
        this.fireRowAdded(row);
    }

    public void remRow(TimeBarRow row) {
        if (this._rows.contains(row)) {
            row.remTimeBarRowListener(this);
            this._rows.remove(row);
            this.updateMinMax();
            this.fireRowRemoved(row);
        }
    }

    public int getIndexForRow(TimeBarRow row) {
        return this._rows.indexOf(row);
    }
}

