/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.ui.timebars.model.DefaultRowHeader;
import de.jaret.util.ui.timebars.model.DefaultTimeBarRowModel;
import de.jaret.util.ui.timebars.model.TimeBarNode;
import de.jaret.util.ui.timebars.model.TimeBarNodeListener;
import de.jaret.util.ui.timebars.model.TimeBarRowHeader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTimeBarNode
extends DefaultTimeBarRowModel
implements TimeBarNode {
    List<TimeBarNode> _children = new ArrayList<TimeBarNode>();
    protected int _level = -1;
    List<TimeBarNodeListener> _nodeListeners;

    public DefaultTimeBarNode(TimeBarRowHeader header) {
        super(header);
    }

    public DefaultTimeBarNode() {
        this(new DefaultRowHeader(""));
    }

    @Override
    public List<TimeBarNode> getChildren() {
        return this._children;
    }

    @Override
    public void addNode(TimeBarNode node) {
        node.setLevel(this.getLevel() + 1);
        this._children.add(node);
        this.fireNodeAdded(node);
    }

    @Override
    public void remNode(TimeBarNode node) {
        if (this._children.remove(node)) {
            this.fireNodeRemoved(node);
        }
    }

    @Override
    public int getLevel() {
        return this._level;
    }

    @Override
    public void setLevel(int level) {
        this._level = level;
        if (this._children != null) {
            for (TimeBarNode node : this._children) {
                node.setLevel(level + 1);
            }
        }
    }

    @Override
    public void addTimeBarNodeListener(TimeBarNodeListener tbnl) {
        if (this._nodeListeners == null) {
            this._nodeListeners = new ArrayList<TimeBarNodeListener>();
        }
        this._nodeListeners.add(tbnl);
        super.addTimeBarRowListener(tbnl);
    }

    @Override
    public void removeTimeBarNodeListener(TimeBarNodeListener tbnl) {
        if (this._nodeListeners == null) {
            return;
        }
        this._nodeListeners.remove(tbnl);
        super.remTimeBarRowListener(tbnl);
    }

    protected void fireNodeAdded(TimeBarNode newNode) {
        if (this._nodeListeners != null) {
            for (TimeBarNodeListener listener : this._nodeListeners) {
                listener.nodeAdded(this, newNode);
            }
        }
    }

    protected void fireNodeRemoved(TimeBarNode removedNode) {
        if (this._nodeListeners != null) {
            for (TimeBarNodeListener listener : this._nodeListeners) {
                listener.nodeRemoved(this, removedNode);
            }
        }
    }
}

