/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.date.Interval;
import de.jaret.util.ui.timebars.model.AbstractTimeBarRowModel;
import de.jaret.util.ui.timebars.model.TimeBarRowHeader;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTimeBarRowModel
extends AbstractTimeBarRowModel {
    protected List<Interval> _intervals = new ArrayList<Interval>();

    public DefaultTimeBarRowModel() {
    }

    public DefaultTimeBarRowModel(TimeBarRowHeader header) {
        this.setRowHeader(header);
    }

    @Override
    public List<Interval> getIntervals() {
        return this._intervals;
    }

    public void addInterval(Interval interval) {
        this._intervals.add(interval);
        Collections.sort(this._intervals, new Comparator<Interval>(){

            @Override
            public int compare(Interval i1, Interval i2) {
                return i1.getBegin().compareTo(i2.getBegin());
            }
        });
        if (this._minDate == null || this._intervals.size() == 1) {
            this._minDate = interval.getBegin().copy();
            this._maxDate = interval.getEnd().copy();
        } else if (this._minDate.compareTo(interval.getBegin()) > 0) {
            this._minDate = interval.getBegin().copy();
        } else if (this._maxDate.compareTo(interval.getEnd()) < 0) {
            this._maxDate = interval.getEnd().copy();
        }
        interval.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireElementAdded(interval);
    }

    public void addIntervals(List<Interval> intervals) {
        this._intervals.addAll(intervals);
        Collections.sort(this._intervals, new Comparator<Interval>(){

            @Override
            public int compare(Interval i1, Interval i2) {
                return i1.getBegin().compareTo(i2.getBegin());
            }
        });
        this._minDate = this._intervals.get(0).getBegin().copy();
        this._maxDate = this._minDate.copy();
        for (Interval interval : this._intervals) {
            if (interval.getEnd().compareTo(this._maxDate) <= 0) continue;
            this._maxDate = interval.getEnd();
        }
        this._maxDate = this._maxDate.copy();
        this._maxDate = this._intervals.get(this._intervals.size() - 1).getEnd().copy();
        for (Interval interval : intervals) {
            interval.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.fireRowDataChanged();
    }

    public void remInterval(Interval interval) {
        if (this._intervals.contains(interval)) {
            this._intervals.remove(interval);
            this.updateMinMax();
            interval.removePropertyChangeListener((PropertyChangeListener)this);
            this.fireElementRemoved(interval);
        }
    }

    public void remIntervals(List<Interval> intervals) {
        boolean hasChanges = false;
        for (Interval interval : intervals) {
            if (!this._intervals.contains(interval)) continue;
            this._intervals.remove(interval);
            interval.removePropertyChangeListener((PropertyChangeListener)this);
            hasChanges = true;
        }
        if (hasChanges) {
            this.updateMinMax();
            this.fireRowDataChanged();
        }
    }

    public void clear() {
        for (Interval interval : this._intervals) {
            interval.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this._intervals.clear();
        this._minDate = null;
        this._maxDate = null;
        this.fireRowDataChanged();
    }
}

