/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.model.IRowHeightStrategy;
import de.jaret.util.ui.timebars.model.ITimeBarViewState;
import de.jaret.util.ui.timebars.model.ITimeBarViewStateListener;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DefaultTimeBarViewState
implements ITimeBarViewState {
    protected List<ITimeBarViewStateListener> _tbvsListeners = new Vector<ITimeBarViewStateListener>();
    protected Map<TimeBarRow, Integer> _heights = new HashMap<TimeBarRow, Integer>();
    protected boolean _useVariableRowHeights = false;
    protected int _defaultHeight;
    protected IRowHeightStrategy _rowHeightStrategy;
    protected TimeBarViewerDelegate _delegate;

    public DefaultTimeBarViewState(TimeBarViewerDelegate delegate) {
        this._delegate = delegate;
    }

    public int getRowHeight(TimeBarRow row) {
        if (!this._useVariableRowHeights) {
            return this._defaultHeight;
        }
        Integer h = this._heights.get(row);
        if (h == null || this._rowHeightStrategy != null && this._rowHeightStrategy.overrideDefault()) {
            if (this._rowHeightStrategy == null) {
                return this._defaultHeight;
            }
            return this._rowHeightStrategy.calculateRowHeight(this._delegate, this, row);
        }
        return h;
    }

    public void setRowHeight(TimeBarRow row, int height) {
        int curHeight = this.getRowHeight(row);
        if (curHeight != height) {
            this._heights.put(row, height);
            this.fireRowHeightChanged(row, height);
        }
    }

    public void setRowHeightStrategy(IRowHeightStrategy rowHeightStrategy) {
        this._rowHeightStrategy = rowHeightStrategy;
        this.fireViewStateChanged();
    }

    public IRowHeightStrategy getRowHeightStrategy() {
        return this._rowHeightStrategy;
    }

    public void fireRowHeightChanged(TimeBarRow row, int height) {
        for (ITimeBarViewStateListener listener : this._tbvsListeners) {
            listener.rowHeightChanged(row, height);
        }
    }

    public void fireViewStateChanged() {
        for (ITimeBarViewStateListener listener : this._tbvsListeners) {
            listener.viewStateChanged();
        }
    }

    public void removeTimeBarViewStateListener(ITimeBarViewStateListener listener) {
        this._tbvsListeners.remove(listener);
    }

    public void addTimeBarViewStateListener(ITimeBarViewStateListener listener) {
        this._tbvsListeners.add(listener);
    }

    public void setDefaultRowHeight(int height) {
        this._defaultHeight = height;
    }

    public int getDefaultRowHeight() {
        return this._defaultHeight;
    }

    public boolean getUseVariableRowHeights() {
        return this._useVariableRowHeights;
    }

    public void setUseVariableRowHeights(boolean useVariableRowHeights) {
        if (useVariableRowHeights != this._useVariableRowHeights) {
            this._useVariableRowHeights = useVariableRowHeights;
            this.fireViewStateChanged();
        }
    }
}

