/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.ui.timebars.model.HierarchicalViewState;
import de.jaret.util.ui.timebars.model.HierarchicalViewStateListener;
import de.jaret.util.ui.timebars.model.TimeBarNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HierarchicalViewStateImpl
implements HierarchicalViewState {
    protected List<HierarchicalViewStateListener> _listenerList;
    protected Map<TimeBarNode, Boolean> _stateMap = new HashMap<TimeBarNode, Boolean>();

    public boolean isExpanded(TimeBarNode node) {
        Boolean state = this._stateMap.get(node);
        if (state == null) {
            return false;
        }
        return state;
    }

    public void setExpanded(TimeBarNode node, boolean expanded) {
        Boolean oldState = this._stateMap.get(node);
        Boolean state = new Boolean(expanded);
        this._stateMap.put(node, state);
        if (expanded) {
            if (oldState == null || !oldState.booleanValue()) {
                this.fireNodeExpanded(node);
            }
        } else if (oldState != null && oldState.booleanValue()) {
            this.fireNodeFolded(node);
        }
    }

    public void setExpandedRecursive(TimeBarNode node, boolean expanded) {
        if (node.getChildren().size() > 0) {
            this.setExpanded(node, expanded);
            for (TimeBarNode child : node.getChildren()) {
                this.setExpandedRecursive(child, expanded);
            }
        }
    }

    public void addHierarchicalViewstateListener(HierarchicalViewStateListener hvsListener) {
        if (this._listenerList == null) {
            this._listenerList = new ArrayList<HierarchicalViewStateListener>();
        }
        this._listenerList.add(hvsListener);
    }

    public void remHierarchicalViewStateListener(HierarchicalViewStateListener hvsListener) {
        if (this._listenerList != null) {
            this._listenerList.remove(hvsListener);
        }
    }

    private void fireNodeExpanded(TimeBarNode node) {
        if (this._listenerList != null) {
            for (HierarchicalViewStateListener hvsl : this._listenerList) {
                hvsl.nodeExpanded(node);
            }
        }
    }

    private void fireNodeFolded(TimeBarNode node) {
        if (this._listenerList != null) {
            for (HierarchicalViewStateListener hvsl : this._listenerList) {
                hvsl.nodeFolded(node);
            }
        }
    }
}

