/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.ui.timebars.model.AbstractTimeBarModel;
import de.jaret.util.ui.timebars.model.HierarchicalTimeBarModel;
import de.jaret.util.ui.timebars.model.HierarchicalViewState;
import de.jaret.util.ui.timebars.model.HierarchicalViewStateListener;
import de.jaret.util.ui.timebars.model.TimeBarNode;
import de.jaret.util.ui.timebars.model.TimeBarNodeListener;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdHierarchicalTimeBarModel
extends AbstractTimeBarModel
implements HierarchicalViewStateListener,
TimeBarNodeListener {
    protected List<TimeBarNode> _rows;
    protected HierarchicalTimeBarModel _hModel;
    protected HierarchicalViewState _hvs;

    public StdHierarchicalTimeBarModel(HierarchicalTimeBarModel hModel, HierarchicalViewState hvs) {
        this._hModel = hModel;
        this._hvs = hvs;
        this._hvs.addHierarchicalViewstateListener(this);
        this.updateRowList();
        this.checkMinMax(this._hModel.getRootNode());
    }

    private void updateRowList() {
        this._rows = new ArrayList<TimeBarNode>();
        this.updateRowList(this._rows, 0, this._hModel.getRootNode(), true);
    }

    private void updateRowList(List<TimeBarNode> rows, int level, TimeBarNode node, boolean visible) {
        if (visible) {
            rows.add(node);
        }
        node.addTimeBarNodeListener(this);
        node.setLevel(level);
        if (this._minDate == null) {
            this._minDate = node.getMinDate();
            this._maxDate = node.getMaxDate();
        } else if (node.getMinDate() != null && node.getMaxDate() != null) {
            if (this._minDate.compareTo(node.getMinDate()) > 0) {
                this._minDate = node.getMinDate();
            }
            if (this._maxDate.compareTo(node.getMaxDate()) < 0) {
                this._maxDate = node.getMaxDate();
            }
        }
        if (node.getChildren() != null) {
            for (TimeBarNode n : node.getChildren()) {
                this.updateRowList(rows, level + 1, n, this._hvs.isExpanded(node) && visible);
            }
        }
        if (level > this._hModel.getDepth()) {
            this._hModel.setDepth(level);
        }
    }

    private void checkMinMax(TimeBarNode node) {
        if (this._minDate == null) {
            this._minDate = node.getMinDate();
            this._maxDate = node.getMaxDate();
        } else if (node.getMinDate() != null && node.getMaxDate() != null) {
            if (this._minDate.compareTo(node.getMinDate()) > 0) {
                this._minDate = node.getMinDate();
            }
            if (this._maxDate.compareTo(node.getMaxDate()) < 0) {
                this._maxDate = node.getMaxDate();
            }
        }
        if (node.getChildren() != null) {
            for (TimeBarNode child : node.getChildren()) {
                this.checkMinMax(child);
            }
        }
    }

    public boolean moreSiblings(TimeBarNode node, int level) {
        int idx = this._rows.indexOf(node);
        if (idx == -1) {
            return false;
        }
        if (node.getLevel() == level) {
            return this.getNextSibling(node) != null;
        }
        TimeBarNode n = node;
        for (int l = node.getLevel(); l > level + 1; --l) {
            n = this.getParent(n);
        }
        return this.getNextSibling(n) != null;
    }

    public TimeBarNode getNextSibling(TimeBarNode node) {
        TimeBarNode parent = this.getParent(node);
        if (parent == null) {
            return null;
        }
        int idx = parent.getChildren().indexOf(node);
        if (parent.getChildren().size() > idx + 1) {
            return parent.getChildren().get(idx + 1);
        }
        return null;
    }

    private TimeBarNode getParent(TimeBarNode node) {
        int idx = this._rows.indexOf(node);
        if (idx == -1) {
            return null;
        }
        for (int i = idx - 1; i >= 0; --i) {
            TimeBarNode n = this._rows.get(i);
            if (!n.getChildren().contains(node)) continue;
            return n;
        }
        return null;
    }

    boolean isVisible(TimeBarNode node) {
        return this.getIdxForNode(node) != -1;
    }

    int getIdxForNode(TimeBarNode node) {
        return this._rows.indexOf(node);
    }

    @Override
    public TimeBarRow getRow(int rowIdx) {
        return this._rows.get(rowIdx);
    }

    @Override
    public int getRowCount() {
        return this._rows.size();
    }

    @Override
    public void nodeAdded(TimeBarNode parent, TimeBarNode newChild) {
        this.checkMinMax(newChild);
        newChild.addTimeBarNodeListener(this);
        if (this._hvs.isExpanded(parent)) {
            HashMap<TimeBarNode, Integer> map = new HashMap<TimeBarNode, Integer>();
            this.posForNode(parent, map);
            int pos = (Integer)map.get(newChild);
            this._rows.add(pos, newChild);
            this.fireRowAdded(newChild);
            ArrayList<TimeBarNode> toAdd = new ArrayList<TimeBarNode>();
            this.enumerateChildren(newChild, toAdd);
            ++pos;
            for (TimeBarNode timeBarNode : toAdd) {
                this._rows.add(pos, timeBarNode);
                this.fireRowAdded(timeBarNode);
                ++pos;
            }
        }
    }

    private int posForNode(TimeBarNode node, Map<TimeBarNode, Integer> map) {
        int idx = this.getIdxForNode(node);
        int count = node.getChildren().size();
        int inserted = 0;
        for (int i = 0; i < count; ++i) {
            TimeBarNode n = node.getChildren().get(i);
            map.put(n, idx + 1 + inserted);
            ++inserted;
            if (!this._hvs.isExpanded(n) || n.getChildren().size() <= 0) continue;
            inserted += this.posForNode(n, map);
        }
        return inserted;
    }

    @Override
    public void nodeRemoved(TimeBarNode parent, TimeBarNode removedChild) {
        this.checkMinMax(this._hModel.getRootNode());
        removedChild.removeTimeBarNodeListener(this);
        if (this._hvs.isExpanded(parent)) {
            this._rows.remove(removedChild);
            this.fireRowRemoved(removedChild);
            ArrayList<TimeBarNode> toRemove = new ArrayList<TimeBarNode>();
            this.enumerateChildren(removedChild, toRemove);
            for (TimeBarNode timeBarNode : toRemove) {
                this._rows.remove(timeBarNode);
                this.fireRowRemoved(timeBarNode);
            }
        }
    }

    private void enumerateChildren(TimeBarNode node, List<TimeBarNode> children) {
        if (node.getChildren() != null && this._hvs.isExpanded(node)) {
            for (TimeBarNode timeBarNode : node.getChildren()) {
                children.add(timeBarNode);
                this.enumerateChildren(timeBarNode, children);
            }
        }
    }

    @Override
    public void nodeExpanded(TimeBarNode node) {
        this.nodeExpanded2(node);
        this.checkMinMax(node);
    }

    public int nodeExpanded2(TimeBarNode node) {
        int idx = this.getIdxForNode(node);
        int count = node.getChildren().size();
        int inserted = 0;
        for (int i = 0; i < count; ++i) {
            TimeBarNode n = node.getChildren().get(i);
            this._rows.add(idx + 1 + inserted, n);
            ++inserted;
            this.fireRowAdded(n);
            if (!this._hvs.isExpanded(n) || n.getChildren().size() <= 0) continue;
            inserted += this.nodeExpanded2(n);
        }
        return inserted;
    }

    @Override
    public void nodeFolded(TimeBarNode node) {
        int count = node.getChildren().size();
        for (int i = 0; i < count; ++i) {
            int idx2;
            TimeBarNode n = node.getChildren().get(i);
            if (this._hvs.isExpanded(n) && n.getChildren().size() > 0) {
                this.nodeFolded(n);
            }
            if ((idx2 = this.getIdxForNode(n)) != -1) {
                this._rows.remove(idx2);
            }
            this.fireRowRemoved(n);
        }
        this.checkMinMax(this._hModel.getRootNode());
    }
}

