/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.model;

import de.jaret.util.date.Interval;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.model.TimeBarSelectionListener;
import de.jaret.util.ui.timebars.model.TimeBarSelectionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBarSelectionModelImpl
implements TimeBarSelectionModel {
    protected List<TimeBarSelectionListener> _listenerList;
    protected List<Interval> _selectedIntervals = new ArrayList<Interval>();
    protected List<TimeBarRow> _selectedRows = new ArrayList<TimeBarRow>();
    protected boolean _rowSelectAllowed = true;
    protected boolean _intervalSelectAllow = true;
    protected boolean _multiAllowed = true;

    @Override
    public boolean isEmpty() {
        return this._selectedIntervals.size() == 0 && this._selectedRows.size() == 0;
    }

    @Override
    public boolean hasRowSelection() {
        return this._selectedRows.size() != 0;
    }

    @Override
    public boolean hasIntervalSelection() {
        return this._selectedIntervals.size() != 0;
    }

    @Override
    public List<TimeBarRow> getSelectedRows() {
        return this._selectedRows;
    }

    @Override
    public List<Interval> getSelectedIntervals() {
        return this._selectedIntervals;
    }

    @Override
    public void setRowSelectionAllowed(boolean allowed) {
        this._rowSelectAllowed = allowed;
    }

    @Override
    public void setIntervalSelectionAllowed(boolean allowed) {
        this._intervalSelectAllow = allowed;
    }

    @Override
    public void setMultipleSelectionAllowed(boolean allowed) {
        this._multiAllowed = allowed;
    }

    @Override
    public boolean getMultipleSelectionAllowed() {
        return this._multiAllowed;
    }

    @Override
    public void clearSelection() {
        if (!this.isEmpty()) {
            this._selectedIntervals.clear();
            this._selectedRows.clear();
            this.fireSelectionChanged();
        }
    }

    @Override
    public void setSelectedRow(TimeBarRow row) {
        if (this._rowSelectAllowed) {
            this._selectedRows.clear();
            this._selectedRows.add(row);
            this.fireSelectionChanged();
        }
    }

    @Override
    public void addSelectedRow(TimeBarRow row) {
        if (this._rowSelectAllowed) {
            if (!this._multiAllowed) {
                this._selectedRows.clear();
                this.fireSelectionChanged();
            }
            if (!this._selectedRows.contains(row)) {
                this._selectedRows.add(row);
                this.fireElementAdded(row);
            }
        }
    }

    @Override
    public void remSelectedRow(TimeBarRow row) {
        if (this.isSelected(row)) {
            this._selectedRows.remove(row);
            this.fireElementRemoved(row);
        }
    }

    @Override
    public boolean isSelected(TimeBarRow row) {
        return this._selectedRows.contains(row);
    }

    @Override
    public void setSelectedInterval(Interval interval) {
        if (this._intervalSelectAllow) {
            boolean hasSelection = this.hasIntervalSelection();
            this._selectedIntervals.clear();
            this._selectedIntervals.add(interval);
            if (hasSelection) {
                this.fireSelectionChanged();
            } else {
                this.fireElementAdded(interval);
            }
        }
    }

    @Override
    public void addSelectedInterval(Interval interval) {
        if (this._intervalSelectAllow) {
            if (!this._multiAllowed) {
                this._selectedIntervals.clear();
                this.fireSelectionChanged();
            }
            if (!this._selectedIntervals.contains(interval)) {
                this._selectedIntervals.add(interval);
                this.fireElementAdded(interval);
            }
        }
    }

    @Override
    public void remSelectedInterval(Interval interval) {
        if (this.isSelected(interval)) {
            this._selectedIntervals.remove(interval);
            this.fireElementRemoved(interval);
        }
    }

    @Override
    public void remSelectedIntervals(List<Interval> intervals) {
        this._selectedIntervals.removeAll(intervals);
        this.fireSelectionChanged();
    }

    @Override
    public boolean isSelected(Interval interval) {
        return this._selectedIntervals.contains(interval);
    }

    @Override
    public synchronized void addTimeBarSelectionListener(TimeBarSelectionListener tbsl) {
        if (this._listenerList == null) {
            this._listenerList = new Vector<TimeBarSelectionListener>();
        }
        this._listenerList.add(tbsl);
    }

    @Override
    public void remTimeBarSelectionListener(TimeBarSelectionListener tbsl) {
        if (this._listenerList != null) {
            this._listenerList.remove(tbsl);
        }
    }

    private void fireSelectionChanged() {
        if (this._listenerList != null) {
            for (TimeBarSelectionListener listener : this._listenerList) {
                listener.selectionChanged(this);
            }
        }
    }

    private void fireElementAdded(Object element) {
        if (this._listenerList != null) {
            for (TimeBarSelectionListener listener : this._listenerList) {
                listener.elementAddedToSelection(this, element);
            }
        }
    }

    private void fireElementRemoved(Object element) {
        if (this._listenerList != null) {
            for (TimeBarSelectionListener listener : this._listenerList) {
                listener.elementRemovedFromSelection(this, element);
            }
        }
    }
}

