/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.strategy;

import de.jaret.util.date.Interval;
import de.jaret.util.date.IntervalImpl;
import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.strategy.IOverlapStrategy;
import de.jaret.util.ui.timebars.strategy.OverlapInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOverlapStrategy
implements IOverlapStrategy {
    protected TimeBarViewerDelegate _delegate;
    protected Map<TimeBarRow, Map<Interval, OverlapInfo>> _oiRowCache = new HashMap<TimeBarRow, Map<Interval, OverlapInfo>>();

    public DefaultOverlapStrategy(TimeBarViewerDelegate delegate) {
        this._delegate = delegate;
    }

    @Override
    public OverlapInfo getOverlapInfo(TimeBarRow row, Interval interval) {
        Map<Interval, OverlapInfo> oiIntervalMap = this._oiRowCache.get(row);
        if (oiIntervalMap == null) {
            oiIntervalMap = this.updateOICache(row);
        }
        OverlapInfo oi = oiIntervalMap.get(interval);
        return oi;
    }

    @Override
    public int getMaxOverlapCount(TimeBarRow row) {
        Map<Interval, OverlapInfo> oiIntervalMap = this._oiRowCache.get(row);
        if (oiIntervalMap == null) {
            oiIntervalMap = this.updateOICache(row);
        }
        int max = 0;
        Collection<OverlapInfo> infos = oiIntervalMap.values();
        for (OverlapInfo overlapInfo : infos) {
            if (overlapInfo.maxOverlapping <= max) continue;
            max = overlapInfo.maxOverlapping;
        }
        return max + 1;
    }

    @Override
    public Map<Interval, OverlapInfo> updateOICache(TimeBarRow row) {
        OverlapInfo oi;
        List<Interval> intervals = this._delegate.filterIntervals(row.getIntervals());
        HashMap<Interval, OverlapInfo> result = new HashMap<Interval, OverlapInfo>();
        TreeMap<Long, Integer> mapEndTime = new TreeMap<Long, Integer>();
        for (int i = 0; i < intervals.size(); ++i) {
            Interval interval1 = intervals.get(i);
            mapEndTime.put(interval1.getBegin().getDate().getTime(), i);
            if (i >= intervals.size() - 1) continue;
            Interval interval2 = intervals.get(i);
            assert (0 >= interval1.getBegin().compareTo(interval2.getBegin()));
        }
        ArrayList<OverlapInfo> oList = new ArrayList<OverlapInfo>();
        for (int i = 0; i < intervals.size(); ++i) {
            int startIdx;
            Interval interval = intervals.get(i);
            oi = new OverlapInfo();
            oi.interval = interval;
            result.put(interval, oi);
            oList.add(oi);
            Map.Entry first = mapEndTime.floorEntry(interval.getBegin().getDate().getTime() - 1L);
            for (int x = startIdx = null == first ? 0 : (Integer)first.getValue(); x < intervals.size(); ++x) {
                if (i == x) continue;
                Interval cmp = intervals.get(x);
                if (0 < cmp.getBegin().compareTo(interval.getEnd())) break;
                if (!IntervalImpl.intersectNonIncluding((Interval)interval, (Interval)cmp)) continue;
                oi.overlapping.add(cmp);
            }
            int max = 0;
            int cur = 0;
            for (Interval check : oi.overlapping) {
                if (!check.contains(interval.getBegin())) continue;
                ++cur;
            }
            if (cur > max) {
                max = cur;
            }
            cur = 0;
            for (Interval check : oi.overlapping) {
                if (!check.contains(interval.getEnd())) continue;
                ++cur;
            }
            if (cur > max) {
                max = cur;
            }
            for (Interval check : oi.overlapping) {
                if (!interval.contains(check.getBegin())) continue;
                cur = 1;
                for (Interval check2 : oi.overlapping) {
                    if (check.equals(check2) || !IntervalImpl.containsNonIncluding((Interval)check2, (JaretDate)check.getBegin())) continue;
                    ++cur;
                }
                if (cur <= max) continue;
                max = cur;
            }
            for (Interval check : oi.overlapping) {
                if (!interval.contains(check.getEnd())) continue;
                cur = 1;
                for (Interval check2 : oi.overlapping) {
                    if (check.equals(check2) || !IntervalImpl.containsNonIncluding((Interval)check2, (JaretDate)check.getEnd())) continue;
                    ++cur;
                }
                if (cur <= max) continue;
                max = cur;
            }
            oi.maxOverlapping = max;
            oi.overlappingCount = max;
        }
        Collections.sort(oList, new Comparator<OverlapInfo>(){

            @Override
            public int compare(OverlapInfo arg0, OverlapInfo arg1) {
                return arg1.overlappingCount - arg0.overlappingCount;
            }
        });
        boolean change = true;
        while (change) {
            change = false;
            for (int i = 0; i < oList.size(); ++i) {
                oi = (OverlapInfo)oList.get(i);
                int max = this.getMaxOverlapping(oi, result);
                if (max == oi.maxOverlapping) continue;
                oi.maxOverlapping = max;
                change = true;
            }
        }
        block11: for (int i = 0; i < oList.size(); ++i) {
            oi = (OverlapInfo)oList.get(i);
            int[] positions = new int[oi.maxOverlapping + 1];
            for (int p = 0; p < oi.maxOverlapping + 1; ++p) {
                positions[p] = -1;
            }
            for (Interval interval : oi.overlapping) {
                OverlapInfo o = (OverlapInfo)result.get(interval);
                if (o.pos == -1) continue;
                positions[o.pos] = o.pos;
            }
            if (oi.pos != -1) continue;
            for (int p = 0; p < oi.maxOverlapping + 1; ++p) {
                if (positions[p] != -1) continue;
                oi.pos = p;
                positions[p] = p;
                continue block11;
            }
        }
        this._oiRowCache.put(row, result);
        return result;
    }

    private int getMaxOverlapping(OverlapInfo oi, Map<Interval, OverlapInfo> map) {
        int max = oi.overlappingCount;
        for (Interval interval : oi.overlapping) {
            OverlapInfo o = map.get(interval);
            if (o.maxOverlapping <= max) continue;
            max = o.maxOverlapping;
        }
        return max;
    }

    @Override
    public void clearCachedData() {
        this._oiRowCache.clear();
    }

    @Override
    public void dispose() {
        this._delegate = null;
        this._oiRowCache = null;
    }

    private void dump(Map<Interval, OverlapInfo> map) {
        for (Interval i : map.keySet()) {
            OverlapInfo oi = map.get(i);
            this.dump(oi);
        }
        System.out.println();
    }

    private void dump(OverlapInfo oi) {
        System.out.println("oi " + oi.interval + " pos " + oi.pos + " max " + oi.maxOverlapping);
        for (Interval interval : oi.overlapping) {
            System.out.println(" --> " + interval);
        }
    }
}

