/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swing;

import de.jaret.util.date.Interval;
import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.TimeBarIntervalFilter;
import de.jaret.util.ui.timebars.TimeBarMarker;
import de.jaret.util.ui.timebars.TimeBarRowFilter;
import de.jaret.util.ui.timebars.TimeBarRowSorter;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.mod.IntervalModificator;
import de.jaret.util.ui.timebars.model.FocussedIntervalListener;
import de.jaret.util.ui.timebars.model.HierarchicalTimeBarModel;
import de.jaret.util.ui.timebars.model.HierarchicalViewState;
import de.jaret.util.ui.timebars.model.ITimeBarChangeListener;
import de.jaret.util.ui.timebars.model.ITimeBarViewState;
import de.jaret.util.ui.timebars.model.TimeBarModel;
import de.jaret.util.ui.timebars.model.TimeBarNode;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.model.TimeBarRowHeader;
import de.jaret.util.ui.timebars.model.TimeBarSelectionModel;
import de.jaret.util.ui.timebars.strategy.IOverlapStrategy;
import de.jaret.util.ui.timebars.strategy.OverlapInfo;
import de.jaret.util.ui.timebars.swing.dnd.IntervalListTransferable;
import de.jaret.util.ui.timebars.swing.dnd.RowIntervalTuple;
import de.jaret.util.ui.timebars.swing.renderer.DefaultGridRenderer;
import de.jaret.util.ui.timebars.swing.renderer.DefaultHeaderRenderer;
import de.jaret.util.ui.timebars.swing.renderer.DefaultTimeBarRenderer;
import de.jaret.util.ui.timebars.swing.renderer.DefaultTimeScaleRenderer;
import de.jaret.util.ui.timebars.swing.renderer.GridRenderer;
import de.jaret.util.ui.timebars.swing.renderer.HeaderRenderer;
import de.jaret.util.ui.timebars.swing.renderer.HierarchyRenderer;
import de.jaret.util.ui.timebars.swing.renderer.TimeBarGapRenderer;
import de.jaret.util.ui.timebars.swing.renderer.TimeBarRenderer;
import de.jaret.util.ui.timebars.swing.renderer.TimeScaleRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBarViewer
extends JPanel
implements TimeBarViewerInterface,
ChangeListener,
ComponentListener {
    private static final boolean SHOWPAINTTIME = false;
    public static final Color HIGHLIGHT_COLOR = Color.RED;
    private static final int PREFHEIGHT = 300;
    private static final int PREFWIDTH = 500;
    protected TimeBarViewerDelegate _delegate;
    protected TimeScaleRenderer _timeScaleRenderer = new DefaultTimeScaleRenderer();
    protected JComponent _timeScaleRendererComponent;
    protected GridRenderer _gridRenderer = new DefaultGridRenderer();
    protected JComponent _gridRendererComponent;
    protected TimeBarGapRenderer _gapRenderer = null;
    protected HeaderRenderer _headerRenderer;
    protected HierarchyRenderer _hierarchyRenderer;
    protected JScrollBar _xScrollBar;
    protected JScrollBar _yScrollBar;
    public Diagram _diagram;
    protected Map<Class<? extends Interval>, TimeBarRenderer> _rendererMap = new HashMap<Class<? extends Interval>, TimeBarRenderer>();
    protected Map _registeredPopupMenues;
    protected JPopupMenu _headerPopup;

    public TimeBarViewer(TimeBarModel model, boolean suppressXScroll, boolean suppressYScroll) {
        this._delegate = new TimeBarViewerDelegate(this);
        this.putClientProperty("delegate", this._delegate);
        this.setLayout(new BorderLayout());
        this._xScrollBar = new JScrollBar(0);
        BoundedRangeModel brModelX = this._xScrollBar.getModel();
        brModelX.addChangeListener(this);
        this._xScrollBar.setUnitIncrement(1);
        if (!suppressXScroll) {
            this.add((Component)this._xScrollBar, "South");
        }
        this._yScrollBar = new JScrollBar(1);
        BoundedRangeModel brModelY = this._yScrollBar.getModel();
        brModelY.addChangeListener(this);
        this._yScrollBar.setUnitIncrement(1);
        if (!suppressYScroll) {
            this.add((Component)this._yScrollBar, "East");
        }
        this._diagram = new Diagram();
        this._diagram._timeBarViewer = this;
        this.add((Component)this._diagram, "Center");
        this.addComponentListener(this);
        if (model != null) {
            this._delegate.setModel(model);
        }
        this.setHeaderRenderer(new DefaultHeaderRenderer());
        this.registerTimeBarRenderer(Interval.class, new DefaultTimeBarRenderer());
    }

    public TimeBarViewer(TimeBarModel model) {
        this(model, false, false);
    }

    public TimeBarViewer() {
        this((TimeBarModel)null);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this._diagram.addMouseListener(l);
    }

    @Override
    public void setModel(TimeBarModel model) {
        this._delegate.setModel(model);
    }

    @Override
    public TimeBarModel getModel() {
        return this._delegate.getModel();
    }

    public void setRowFilter(TimeBarRowFilter rowFilter) {
        this._delegate.setRowFilter(rowFilter);
    }

    public TimeBarRowFilter getRowFilter() {
        return this._delegate.getRowFilter();
    }

    public void setRowSorter(TimeBarRowSorter rowSorter) {
        this._delegate.setRowSorter(rowSorter);
    }

    public TimeBarRowSorter getRowSorter() {
        return this._delegate.getRowSorter();
    }

    public void setIntervalFilter(TimeBarIntervalFilter intervalFilter) {
        this._delegate.setIntervalFilter(intervalFilter);
    }

    public void setTimeBarRenderer(TimeBarRenderer renderer) {
        this.registerTimeBarRenderer(Interval.class, renderer);
    }

    public TimeBarRenderer getTimeBarRenderer() {
        return this._rendererMap.get(Interval.class);
    }

    public void registerTimeBarRenderer(Class<? extends Interval> intervalClass, TimeBarRenderer renderer) {
        this._rendererMap.put(intervalClass, renderer);
        this.repaint();
    }

    public Map<Class<? extends Interval>, TimeBarRenderer> getRendererMapping() {
        return this._rendererMap;
    }

    protected TimeBarRenderer getRenderer(Class<? extends Interval> clazz) {
        Class<?>[] interfaces;
        TimeBarRenderer result = null;
        result = this._rendererMap.get(clazz);
        if (result != null) {
            return result;
        }
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            result = this._rendererMap.get(c);
            if (result == null) continue;
            return result;
        }
        for (Class<? extends Interval> sc = clazz.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            Class<?>[] scinterfaces;
            result = this._rendererMap.get(sc);
            if (result != null) {
                return result;
            }
            for (Class<?> c : scinterfaces = sc.getInterfaces()) {
                result = this._rendererMap.get(c);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public void setHeaderRenderer(HeaderRenderer renderer) {
        this._headerRenderer = renderer;
        if (this._headerRenderer != null) {
            this._delegate.setYAxisWidth(renderer.getWidth());
        } else {
            this._delegate.setYAxisWidth(0);
        }
        this._diagram.safeRepaint();
    }

    public void setHierarchyRenderer(HierarchyRenderer renderer) {
        this._hierarchyRenderer = renderer;
        if (this._hierarchyRenderer != null) {
            this._delegate.setHierarchyWidth(renderer.getWidth());
        } else {
            this._delegate.setHierarchyWidth(0);
        }
        this._diagram.safeRepaint();
    }

    @Override
    public void setPixelPerSecond(double pixelPerSecond) {
        this._delegate.setPixelPerSecond(pixelPerSecond);
    }

    @Override
    public double getPixelPerSecond() {
        return this._delegate.getPixelPerSecond();
    }

    @Override
    public void setRowHeight(int rowHeight) {
        this._delegate.setRowHeight(rowHeight);
    }

    @Override
    public int getRowHeight() {
        return this._delegate.getTimeBarViewState().getDefaultRowHeight();
    }

    @Override
    public void updateXScrollBar(int max, int pos, int secondsDisplayed) {
        BoundedRangeModel brModel = this._xScrollBar.getModel();
        if (brModel != null) {
            brModel.setMinimum(0);
            brModel.setMaximum(max);
            brModel.setExtent(secondsDisplayed);
            brModel.removeChangeListener(this);
            brModel.setValue(pos);
            brModel.addChangeListener(this);
            this._xScrollBar.setBlockIncrement(secondsDisplayed / 10);
        }
    }

    @Override
    public void updateYScrollBar(int max, int pos, int rowsDisplayed) {
        BoundedRangeModel brModel = this._yScrollBar.getModel();
        brModel.setMinimum(0);
        brModel.setMaximum(max);
        brModel.setExtent(rowsDisplayed);
        brModel.removeChangeListener(this);
        brModel.setValue(pos);
        brModel.addChangeListener(this);
        this._yScrollBar.setBlockIncrement(rowsDisplayed / 10 + 1);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this._xScrollBar.getModel()) {
            BoundedRangeModel brModel = this._xScrollBar.getModel();
            int value = brModel.getValue();
            this._delegate.handleHorizontalScroll(value, true);
        } else if (e.getSource() == this._yScrollBar.getModel()) {
            BoundedRangeModel brModel = this._yScrollBar.getModel();
            int value = brModel.getValue();
            this._delegate.handleVerticalScroll(value, true);
        } else {
            throw new RuntimeException("Unknown sender");
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this._delegate.updateScrollBars();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected JComponent getIntervalComponent(TimeBarRow row, Interval interval) {
        int y = this._delegate.yForRow(row);
        int x = this._delegate.xForDate(interval.getBegin());
        int width = this._delegate.xForDate(interval.getEnd()) - x;
        Rectangle intervalRect = new Rectangle(x, y, width, this._delegate.getTimeBarViewState().getRowHeight(row));
        return this.getIntervalComponent(interval, intervalRect);
    }

    protected JComponent getIntervalComponent(Interval interval, Rectangle intervalRect) {
        TimeBarRenderer renderer = this.getRenderer(interval.getClass());
        if (renderer == null) {
            throw new RuntimeException("no suitable renderer registered");
        }
        boolean overlapping = false;
        OverlapInfo oi = null;
        if (this._delegate.isDrawOverlapping()) {
            TimeBarRow row = this._delegate.getModel().getRowForInterval(interval);
            oi = this._delegate.getOverlapStrategy().getOverlapInfo(row, interval);
            boolean bl = overlapping = oi.maxOverlapping > 0;
            if (oi != null) {
                int y;
                int height = this._delegate.getTimeBarViewState().getRowHeight(row) / (oi.maxOverlapping + 1);
                intervalRect.y = y = intervalRect.y + oi.pos * height;
                intervalRect.height = height;
            }
        }
        JComponent component = renderer.getTimeBarRendererComponent(this, interval, false, overlapping);
        component.setBounds(intervalRect);
        return component;
    }

    public TimeScaleRenderer getTimeScaleRenderer() {
        return this._timeScaleRenderer;
    }

    public void setTimeScaleRenderer(TimeScaleRenderer timeScaleRenderer) {
        this._timeScaleRenderer = timeScaleRenderer;
        if (this._timeScaleRenderer != null && this._timeScaleRenderer.getHeight() != -1) {
            this._delegate.setXAxisHeight(this._timeScaleRenderer.getHeight());
        }
    }

    public GridRenderer getGridRenderer() {
        return this._gridRenderer;
    }

    public void setGridRenderer(GridRenderer gridRenderer) {
        this._gridRenderer = gridRenderer;
        this._diagram.safeRepaint();
    }

    public TimeBarGapRenderer getGapRenderer() {
        return this._gapRenderer;
    }

    public void setGapRenderer(TimeBarGapRenderer gapRenderer) {
        this._gapRenderer = gapRenderer;
        this._diagram.safeRepaint();
    }

    public JPopupMenu getHeaderPopup() {
        return this._headerPopup;
    }

    public void setHeaderPopup(JPopupMenu headerPopup) {
        this._headerPopup = headerPopup;
    }

    public void registerPopupMenu(Class clazz, JPopupMenu popup) {
        if (this._registeredPopupMenues == null) {
            this._registeredPopupMenues = new HashMap();
        }
        this._registeredPopupMenues.put(clazz, popup);
    }

    public JPopupMenu getPopupMenu(Class clazz) {
        if (this._registeredPopupMenues == null) {
            return null;
        }
        JPopupMenu popup = (JPopupMenu)this._registeredPopupMenues.get(clazz);
        return popup;
    }

    @Override
    public void firePropertyChangeX(String propName, Object oldVal, Object newVal) {
        this.firePropertyChange(propName, oldVal, newVal);
    }

    @Override
    public boolean timeBarContains(Interval interval, Rectangle intervalRect, int x, int y, boolean overlapping) {
        JComponent component = this.getIntervalComponent(interval, intervalRect);
        return component.contains(x, y);
    }

    @Override
    public Rectangle timeBarContainingRect(Interval interval, Rectangle intervalRect, boolean overlapping) {
        JComponent component = this.getIntervalComponent(interval, intervalRect);
        Rectangle containingRect = (Rectangle)component.getClientProperty("contRect");
        return containingRect;
    }

    @Override
    public void setCursor(int cursorType) {
        this.setCursor(Cursor.getPredefinedCursor(cursorType));
    }

    @Override
    public String getIntervalToolTipText(Interval interval, Rectangle intervalRect, int x, int y) {
        JComponent component = this.getIntervalComponent(interval, intervalRect);
        String tooltip = component.getToolTipText(new MouseEvent(this, 0, 0L, 0, x, y, 0, false));
        return tooltip;
    }

    @Override
    public JaretDate getStartDate() {
        return this._delegate.getStartDate();
    }

    @Override
    public void setStartDate(JaretDate startDate) {
        this._delegate.setStartDate(startDate);
    }

    @Override
    public JaretDate getMinDate() {
        return this._delegate.getMinDate();
    }

    @Override
    public void setMinDate(JaretDate minDate) {
        this._delegate.setMinDate(minDate);
    }

    @Override
    public JaretDate getMaxDate() {
        return this._delegate.getMaxDate();
    }

    @Override
    public void setMaxDate(JaretDate maxDate) {
        this._delegate.setMaxDate(maxDate);
    }

    @Override
    public TimeBarSelectionModel getSelectionModel() {
        return this._delegate.getSelectionModel();
    }

    @Override
    public void setSelectionModel(TimeBarSelectionModel selectionModel) {
        this._delegate.setSelectionModel(selectionModel);
    }

    @Override
    public int getFirstRowDisplayed() {
        return this._delegate.getFirstRow();
    }

    @Override
    public void setFirstRowDisplayed(int rowIdx) {
        this._delegate.setFirstRow(rowIdx);
    }

    @Override
    public void setFirstRow(int firstRow, int pixOffset) {
        this._delegate.setFirstRow(firstRow, pixOffset);
    }

    public JaretDate getEndDate() {
        return this._delegate.getEndDate();
    }

    @Override
    public int getFirstRowOffset() {
        return this._delegate.getFirstRowOffset();
    }

    @Override
    public void setFirstRowOffset(int offset) {
        this._delegate.setFirstRowOffset(offset);
    }

    public void setTimeScalePosition(int timeScalePosition) {
        this._delegate.setTimeScalePosition(timeScalePosition);
    }

    @Override
    public void setAdjustMinMaxDatesByModel(boolean adjust) {
        this._delegate.setAdjustMinMaxDatesByModel(adjust);
    }

    @Override
    public boolean getAdjustMinMaxDatesByModel() {
        return this._delegate.getAdjustMinMaxDatesByModel();
    }

    public TimeBarRow rowForY(int y) {
        return this._delegate.rowForY(y);
    }

    @Override
    public JaretDate dateForX(int x) {
        return this._delegate.dateForCoord(x);
    }

    @Override
    public JaretDate dateForXY(int x, int y) {
        return this._delegate.dateForCoord(x, y);
    }

    @Override
    public int xForDate(JaretDate date) {
        return this._delegate.xForDate(date);
    }

    public void highlightRow(int y) {
        this._delegate.highlightRow(y);
    }

    public void highlightRow(TimeBarRow timeBarRow) {
        this._delegate.highlightRow(timeBarRow);
    }

    public void deHighlightRow() {
        this._delegate.deHighlightRow();
    }

    @Override
    public void setDrawRowGrid(boolean drawRowGrid) {
        this._delegate.setDrawRowGrid(drawRowGrid);
    }

    @Override
    public boolean getDrawRowGrid() {
        return this._delegate.getDrawRowGrid();
    }

    @Override
    public void setYAxisWidth(int width) {
        this._delegate.setYAxisWidth(width);
    }

    @Override
    public int getYAxisWidth() {
        return this._delegate.getYAxisWidth();
    }

    @Override
    public void setHierarchyWidth(int width) {
        this._delegate.setHierarchyWidth(width);
    }

    @Override
    public int getHierarchyWidth() {
        return this._delegate.getHierarchyWidth();
    }

    @Override
    public void addIntervalModificator(IntervalModificator intervalModificator) {
        this._delegate.addIntervalModificator(intervalModificator);
    }

    @Override
    public void remIntervalModificator(IntervalModificator intervalModificator) {
        this._delegate.remIntervalModificator(intervalModificator);
    }

    @Override
    public void setAutoscrollEnabled(boolean enableAutoscroll) {
        this._delegate.setAutoscrollEnabled(enableAutoscroll);
    }

    @Override
    public boolean isAutoscrollEnabled() {
        return this._delegate.isAutoscrollEnabled();
    }

    @Override
    public String getTimeScaleToolTipText(int x, int y) {
        if (this._timeScaleRendererComponent != null) {
            return this._timeScaleRendererComponent.getToolTipText(new MouseEvent(this, 0, 0L, 0, x - this._delegate.getDiagramRect().x, y - this._delegate.getXAxisRect().y, 0, false));
        }
        return null;
    }

    @Override
    public String getHeaderToolTipText(TimeBarRow row, int x, int y) {
        if (this._headerRenderer != null && row != null) {
            JComponent component = this._headerRenderer.getHeaderRendererComponent(this, row.getRowHeader(), false);
            component.setBounds(this._delegate.getHeaderRect(row));
            return component.getToolTipText(new MouseEvent(this, 0, 0L, 0, x - this._delegate.getYAxisRect().x, y - this._delegate.getYAxisRect().y, 0, false));
        }
        return null;
    }

    @Override
    public String getHierarchyToolTipText(TimeBarNode node, int x, int y) {
        if (this._hierarchyRenderer != null && node != null) {
            JComponent component = this._hierarchyRenderer.getHierarchyRendererComponent(this, node, false, false, false, 0, 1);
            component.setBounds(this._delegate.getHierarchyRect(node));
            return component.getToolTipText(new MouseEvent(this, 0, 0L, 0, x - this._delegate.getHierarchyRect().x, y - this._delegate.getHierarchyRect().y, 0, false));
        }
        return null;
    }

    @Override
    public HierarchicalViewState getHierarchicalViewState() {
        return this._delegate.getHierarchicalViewState();
    }

    @Override
    public void setHierarchicalViewState(HierarchicalViewState hierarchicalViewState) {
        this._delegate.setHierarchicalViewState(hierarchicalViewState);
    }

    @Override
    public void setModel(HierarchicalTimeBarModel hModel) {
        this._delegate.setModel(hModel);
    }

    @Override
    public HierarchicalTimeBarModel getHierarchicalModel() {
        return this._delegate.getHierarchicalModel();
    }

    @Override
    public int getMarkerWidth() {
        return 4;
    }

    @Override
    public void setTitle(String title) {
        this._delegate.setTitle(title);
    }

    @Override
    public String getTitle() {
        return this._delegate.getTitle();
    }

    @Override
    public void displayBodyContextMenu(int x, int y) {
    }

    @Override
    public void displayTimeScaleContextMenu(int x, int y) {
    }

    @Override
    public void displayIntervalContextMenu(Interval interval, int x, int y) {
    }

    @Override
    public void displayHeaderContextMenu(TimeBarRow row, int x, int y) {
    }

    @Override
    public void displayHierarchyContextMenu(TimeBarRow row, int x, int y) {
    }

    @Override
    public void displayTitleContextMenu(int x, int y) {
    }

    @Override
    public boolean isInToggleArea(TimeBarNode node, int x, int y) {
        return true;
    }

    @Override
    public boolean isInHierarchySelectionArea(TimeBarNode node, int x, int y) {
        return false;
    }

    public void setDrawOverlapping(boolean drawOverlapping) {
        this._delegate.setDrawOverlapping(drawOverlapping);
    }

    public boolean getDrawOverlapping() {
        return this._delegate.isDrawOverlapping();
    }

    @Override
    public void addMarker(TimeBarMarker marker) {
        this._delegate.addMarker(marker);
    }

    @Override
    public void remMarker(TimeBarMarker marker) {
        this._delegate.remMarker(marker);
    }

    @Override
    public List<TimeBarMarker> getMarkers() {
        return this._delegate.getMarkers();
    }

    @Override
    public void addMarkers(List<TimeBarMarker> markers) {
        this._delegate.addMarkers(markers);
    }

    @Override
    public int getSelectionDelta() {
        return this._delegate.getSelectionDelta();
    }

    @Override
    public void setSelectionDelta(int selectionDelta) {
        this._delegate.setSelectionDelta(selectionDelta);
    }

    @Override
    public boolean isLineDraggingAllowed() {
        return this._delegate.isLineDraggingAllowed();
    }

    @Override
    public void setLineDraggingAllowed(boolean lineDraggingAllowed) {
        this._delegate.setLineDraggingAllowed(lineDraggingAllowed);
    }

    @Override
    public int getYForRow(TimeBarRow row) {
        return this._delegate.yForRow(row);
    }

    @Override
    public TimeBarRow getRowForY(int y) {
        return this._delegate.rowForY(y);
    }

    @Override
    public TimeBarRow getRowForXY(int x, int y) {
        return this._delegate.rowForXY(x, y);
    }

    @Override
    public boolean isMilliAccuracy() {
        return this._delegate.isMilliAccuracy();
    }

    @Override
    public void setMilliAccuracy(boolean milliAccuracy) {
        this._delegate.setMilliAccuracy(milliAccuracy);
    }

    @Override
    public TimeBarNode getPpsRow() {
        return this._delegate.getPpsRow();
    }

    @Override
    public boolean hasVariableXScale() {
        return this._delegate.hasVariableXScale();
    }

    @Override
    public void setVariableXScale(boolean state) {
        this._delegate.setVariableXScale(state);
    }

    @Override
    public void doScrollHorizontal(int diff) {
        Graphics g = this._diagram.getGraphics();
        if (g == null) {
            return;
        }
        if (this._delegate.getDiagramRect() == null) {
            return;
        }
        Rectangle d = new Rectangle(this._delegate.getDiagramRect());
        if (this._delegate.getOrientation().equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL)) {
            if (this._delegate.getTimeScalePosition() != 2) {
                if (this._delegate.getTimeScalePosition() == 0) {
                    d.y = this._delegate.getXAxisRect().y;
                }
                d.height += this._delegate.getXAxisRect().height;
            }
        } else {
            d.y = 0;
            d.height = d.height + this._delegate.getHierarchyWidth() + this._delegate.getYAxisWidth();
        }
        if (diff > 0) {
            g.copyArea(d.x + diff, d.y, d.width - diff, d.height, -diff, 0);
            this._diagram.repaint(d.x + d.width - diff, d.y, diff, d.height);
        } else {
            diff = -diff;
            g.copyArea(d.x, d.y, d.width - diff, d.height, diff, 0);
            this._diagram.repaint(d.x, d.y, diff, d.height);
        }
        g.dispose();
    }

    @Override
    public void doScrollVertical(int diff) {
        Graphics g = this._diagram.getGraphics();
        if (g == null) {
            return;
        }
        if (this._delegate.getDiagramRect() == null) {
            return;
        }
        Rectangle d = new Rectangle(this._delegate.getDiagramRect());
        if (this._delegate.getOrientation().equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL)) {
            d.x = d.x - this._delegate.getHierarchyWidth() - this._delegate.getYAxisWidth();
            d.width = d.width + this._delegate.getHierarchyWidth() + this._delegate.getYAxisWidth();
        } else {
            d.x -= this._delegate.getXAxisHeight();
            d.width += this._delegate.getXAxisHeight();
        }
        if (diff > 0) {
            g.copyArea(d.x, d.y + diff, d.width, d.height - diff, 0, -diff);
            this._diagram.repaint(d.x, d.y + d.height - diff, d.width, diff);
        } else {
            diff = -diff;
            g.copyArea(d.x, d.y, d.width, d.height - diff, 0, diff);
            this._diagram.repaint(d.x, d.y, d.width, diff);
        }
        g.dispose();
    }

    @Override
    public boolean getOptimizeScrolling() {
        return this._delegate.getOptimizeScrolling();
    }

    @Override
    public void setOptimizeScrolling(boolean optimizeScrolling) {
        this._delegate.setOptimizeScrolling(optimizeScrolling);
    }

    @Override
    public TimeBarViewerInterface.Orientation getOrientation() {
        return this._delegate.getOrientation();
    }

    @Override
    public void setOrientation(TimeBarViewerInterface.Orientation orientation) {
        this._delegate.setOrientation(orientation);
    }

    @Override
    public int getAutoScaleRows() {
        return this._delegate.getAutoScaleRows();
    }

    @Override
    public void setAutoScaleRows(int rows) {
        this._delegate.setAutoScaleRows(rows);
    }

    @Override
    public int getXAxisHeight() {
        return this._delegate.getXAxisHeight();
    }

    @Override
    public void setXAxisHeight(int height) {
        this._delegate.setXAxisHeight(height);
    }

    @Override
    public void fireSelectionChanged() {
    }

    @Override
    public void addTimeBarChangeListener(ITimeBarChangeListener listener) {
        this._delegate.addTimeBarChangeListener(listener);
    }

    @Override
    public void removeTimeBarChangeListener(ITimeBarChangeListener listener) {
        this._delegate.removeTimeBarChangeListener(listener);
    }

    @Override
    public void addFocussedIntervalListener(FocussedIntervalListener listener) {
        this._delegate.addFocussedIntervalListener(listener);
    }

    @Override
    public void remFocussedIntervalListener(FocussedIntervalListener listener) {
        this._delegate.remFocussedIntervalListener(listener);
    }

    @Override
    public ITimeBarViewState getTimeBarViewState() {
        return this._delegate.getTimeBarViewState();
    }

    @Override
    public boolean isRowHeightDragginAllowed() {
        return this._delegate.isRowHeightDraggingAllowed();
    }

    @Override
    public void setRowHeightDraggingAllowed(boolean rowHeightDraggingAllowed) {
        this._delegate.setRowHeightDraggingAllowed(rowHeightDraggingAllowed);
    }

    @Override
    public boolean rowLineHit(int x, int y) {
        return this._delegate.rowLineHit(x, y);
    }

    @Override
    public boolean isInRowAxis(int x, int y) {
        return this._delegate.isInRowAxis(x, y);
    }

    @Override
    public boolean isInDiagram(int x, int y) {
        return this._delegate.isInDiagram(x, y);
    }

    @Override
    public boolean getStrictClipTimeCheck() {
        return this._delegate.getStrictClipTimeCheck();
    }

    @Override
    public void setStrictClipTimeCheck(boolean strictClipTimeCheck) {
        this._delegate.setStrictClipTimeCheck(strictClipTimeCheck);
    }

    @Override
    public int getSecondsDisplayed() {
        return this._delegate.getSecondsDisplayed();
    }

    @Override
    public IOverlapStrategy getOverlapStrategy() {
        return this._delegate.getOverlapStrategy();
    }

    @Override
    public void setOverlapStrategy(IOverlapStrategy overlapStrategy) {
        this._delegate.setOverlapStrategy(overlapStrategy);
    }

    @Override
    public int getScrollLookBackMinutes() {
        return this._delegate.getScrollLookBackMinutes();
    }

    @Override
    public void setScrollLookBackMinutes(int scrollLookBackMinutes) {
        this._delegate.setScrollLookBackMinutes(scrollLookBackMinutes);
    }

    @Override
    public void setScrollLookForwardMinutes(int scrollLookForwardMinutes) {
        this._delegate.setScrollLookForwardMinutes(scrollLookForwardMinutes);
    }

    @Override
    public int getScrollLookForwardMinutes() {
        return this._delegate.getScrollLookForwardMinutes();
    }

    @Override
    public String getName() {
        return this._delegate.getName();
    }

    @Override
    public void setName(String name) {
        this._delegate.setName(name);
    }

    class TimeBarDropTargetListener
    extends DropTargetAdapter {
        TimeBarDropTargetListener() {
        }

        public void dragOver(DropTargetDragEvent e) {
            if (e.isDataFlavorSupported(IntervalListTransferable.intervalListFlavor)) {
                TimeBarViewer.this._delegate.highlightRow(e.getLocation().y);
                e.acceptDrag(3);
            }
        }

        public void dragExit(DropTargetEvent dte) {
            TimeBarViewer.this._delegate.deHighlightRow();
        }

        public void drop(DropTargetDropEvent e) {
            System.out.println("Drop!");
            TimeBarViewer.this._delegate.deHighlightRow();
            try {
                Transferable tr = e.getTransferable();
                DataFlavor[] flavors = tr.getTransferDataFlavors();
                for (int i = 0; i < flavors.length; ++i) {
                    if (!flavors[i].equals(IntervalListTransferable.intervalListFlavor)) continue;
                    e.rejectDrop();
                    e.acceptDrop(e.getDropAction());
                    e.dropComplete(true);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            e.rejectDrop();
        }
    }

    class TimeBarDragSourceListener
    extends DragSourceAdapter {
        TimeBarDragSourceListener() {
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (dsde.getDropSuccess()) {
                TimeBarViewer.this._diagram.repaint();
            }
        }
    }

    class TimeBarViewerDragGestureListener
    implements DragGestureListener {
        TimeBarViewerDragGestureListener() {
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            Component c = e.getComponent();
            TimeBarViewer tbv = ((Diagram)c)._timeBarViewer;
            TimeBarSelectionModel selModel = TimeBarViewer.this._delegate.getSelectionModel();
            if (selModel.hasIntervalSelection()) {
                List<Interval> l = selModel.getSelectedIntervals();
                List rowIntervalTuples = this.buildRowIntervalTuples(l);
                IntervalListTransferable ilt = new IntervalListTransferable(rowIntervalTuples);
                e.startDrag(null, ilt);
            }
        }

        private List buildRowIntervalTuples(List l) {
            ArrayList<RowIntervalTuple> rowIntervalTuples = new ArrayList<RowIntervalTuple>();
            ArrayList list = new ArrayList(l);
            RowIntervalTuple tuple = new RowIntervalTuple(null, list);
            rowIntervalTuples.add(tuple);
            return rowIntervalTuples;
        }
    }

    private class Diagram
    extends JComponent
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        TimeBarViewer _timeBarViewer;
        protected boolean _enableDragAndDrop = false;

        public Diagram() {
            this.setBackground(Color.WHITE);
            this.setToolTipText("");
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            if (this._enableDragAndDrop) {
                TimeBarViewerDragGestureListener dgl = new TimeBarViewerDragGestureListener();
                DragSource dragSource = DragSource.getDefaultDragSource();
                dragSource.addDragSourceListener(new TimeBarDragSourceListener());
                DragGestureRecognizer dgr = dragSource.createDefaultDragGestureRecognizer(this, 3, dgl);
            }
        }

        public String getToolTipText(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            return TimeBarViewer.this._delegate.getToolTipText(x, y);
        }

        public void safeRepaint() {
            Runnable doRepaint = new Runnable(){

                public void run() {
                    Diagram.this.repaint();
                }
            };
            SwingUtilities.invokeLater(doRepaint);
        }

        public void paintComponent(Graphics g) {
            long time = System.currentTimeMillis();
            long nanoTime = System.nanoTime();
            TimeBarViewer.this._delegate.preparePaint(this.getWidth(), this.getHeight());
            g.setColor(Color.WHITE);
            g.fillRect(g.getClipBounds().x, g.getClipBounds().y, g.getClipBounds().width, g.getClipBounds().height);
            g.setColor(Color.BLACK);
            this.drawGrid(g);
            if (TimeBarViewer.this._delegate.getTimeScalePosition() != 2) {
                this.drawXAxis(g);
            }
            this.drawRows(g);
            this.drawMarkers(g);
            this.drawSelectionRect(g);
        }

        private void drawSelectionRect(Graphics g) {
            if (TimeBarViewer.this._delegate.getSelectionRect() != null) {
                TimeBarViewer.this._delegate.setLastSelRect(this.normalizeRectangle(TimeBarViewer.this._delegate.getSelectionRect()));
                g.setColor(Color.GRAY);
                Rectangle lastSelRect = TimeBarViewer.this._delegate.getLastSelRect();
                g.drawRect(lastSelRect.x, lastSelRect.y, lastSelRect.width, lastSelRect.height);
            }
        }

        private Rectangle normalizeRectangle(Rectangle rect) {
            int x = Math.min(rect.x, rect.x + rect.width);
            int y = Math.min(rect.y, rect.y + rect.height);
            int width = Math.abs(rect.width);
            int height = Math.abs(rect.height);
            return new Rectangle(x, y, width, height);
        }

        private void drawMarkers(Graphics g) {
            if (TimeBarViewer.this._delegate.getMarkers() != null) {
                for (TimeBarMarker marker : TimeBarViewer.this._delegate.getMarkers()) {
                    if (!TimeBarViewer.this._delegate.isDisplayed(marker.getDate())) continue;
                    this.drawMarker(g, marker);
                }
            }
        }

        private void drawMarker(Graphics g, TimeBarMarker marker) {
            Color oldCol = g.getColor();
            if (TimeBarViewer.this._delegate.getDraggedMarker() == marker) {
                g.setColor(Color.BLUE);
            } else {
                g.setColor(Color.RED);
            }
            int x = TimeBarViewer.this._delegate.xForDate(marker.getDate());
            g.drawLine(x, 0, x, this.getHeight());
            g.setColor(oldCol);
        }

        private void drawXAxis(Graphics g) {
            TimeBarViewer.this._timeScaleRendererComponent = TimeBarViewer.this._timeScaleRenderer.getRendererComponent(this._timeBarViewer, TimeBarViewer.this._delegate.getTimeScalePosition() == 0);
            TimeBarViewer.this._timeScaleRendererComponent.setBounds(TimeBarViewer.this._delegate.getXAxisRect());
            Graphics gg = g.create(TimeBarViewer.this._delegate.getXAxisRect().x, TimeBarViewer.this._delegate.getXAxisRect().y, TimeBarViewer.this._delegate.getXAxisRect().width, TimeBarViewer.this._delegate.getXAxisRect().height);
            TimeBarViewer.this._timeScaleRendererComponent.paint(gg);
            gg.dispose();
        }

        private void drawGrid(Graphics g) {
            if (TimeBarViewer.this._gridRenderer != null) {
                TimeBarViewer.this._gridRendererComponent = TimeBarViewer.this._gridRenderer.getRendererComponent(this._timeBarViewer);
                TimeBarViewer.this._gridRendererComponent.setBounds(TimeBarViewer.this._delegate.getDiagramRect());
                Graphics gg = g.create(TimeBarViewer.this._delegate.getDiagramRect().x, TimeBarViewer.this._delegate.getDiagramRect().y, TimeBarViewer.this._delegate.getDiagramRect().width, TimeBarViewer.this._delegate.getDiagramRect().height);
                TimeBarViewer.this._gridRendererComponent.paint(gg);
                gg.dispose();
            }
        }

        private void drawRows(Graphics g) {
            if (TimeBarViewer.this._delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                this.drawRowsHorizontal(g);
            } else {
                this.drawRowsVertical(g);
            }
        }

        private void drawRowsHorizontal(Graphics g) {
            g.setColor(Color.BLACK);
            Rectangle clipSave = g.getClipBounds();
            g.setClip(0, TimeBarViewer.this._delegate.getDiagramRect().y, this.getWidth(), TimeBarViewer.this._delegate.getDiagramRect().height);
            g.drawLine(TimeBarViewer.this._delegate.getDiagramRect().x - 1, 0, TimeBarViewer.this._delegate.getDiagramRect().x - 1, this.getHeight());
            g.drawLine(TimeBarViewer.this._delegate.getHierarchyRect().x + TimeBarViewer.this._delegate.getHierarchyWidth() - 1, 0, TimeBarViewer.this._delegate.getHierarchyRect().x + TimeBarViewer.this._delegate.getHierarchyWidth() - 1, this.getHeight());
            int upperYBound = TimeBarViewer.this._delegate.getDiagramRect().y;
            int lowerYBound = upperYBound + TimeBarViewer.this._delegate.getDiagramRect().height;
            if (g.getClipBounds() != null) {
                upperYBound = g.getClipBounds().y;
                lowerYBound = upperYBound + g.getClipBounds().height;
            }
            for (int r = TimeBarViewer.this._delegate.getFirstRow(); r <= TimeBarViewer.this._delegate.getFirstRow() + TimeBarViewer.this._delegate.getRowsDisplayed() && r < TimeBarViewer.this._delegate.getRowCount(); ++r) {
                TimeBarRow row = TimeBarViewer.this._delegate.getRow(r);
                int rowHeight = TimeBarViewer.this._delegate.getTimeBarViewState().getRowHeight(row);
                int y = TimeBarViewer.this._delegate.yForRow(row);
                if (!(y >= upperYBound && y <= lowerYBound || y + rowHeight >= upperYBound && y + rowHeight <= lowerYBound) && (upperYBound <= y || upperYBound >= y + rowHeight)) continue;
                this.drawRow(g, y, rowHeight, TimeBarViewer.this._delegate.getRow(r), TimeBarViewer.this._delegate.getSelectionModel().isSelected(TimeBarViewer.this._delegate.getRow(r)));
                if (TimeBarViewer.this._gapRenderer == null) continue;
                this.drawRowGaps(g, y, rowHeight, TimeBarViewer.this._delegate.getRow(r), TimeBarViewer.this._delegate.getSelectionModel().isSelected(TimeBarViewer.this._delegate.getRow(r)));
            }
            g.setClip(clipSave);
        }

        private void drawRowsVertical(Graphics g) {
            g.setColor(Color.BLACK);
            Rectangle clipSave = g.getClipBounds();
            g.setClip(0, TimeBarViewer.this._delegate.getDiagramRect().y, this.getWidth(), TimeBarViewer.this._delegate.getDiagramRect().height);
            g.drawLine(0, TimeBarViewer.this._delegate.getDiagramRect().y - 1, this.getWidth(), TimeBarViewer.this._delegate.getDiagramRect().y - 1);
            g.drawLine(0, TimeBarViewer.this._delegate.getHierarchyRect().y + TimeBarViewer.this._delegate.getHierarchyWidth() - 1, this.getWidth(), TimeBarViewer.this._delegate.getHierarchyRect().y + TimeBarViewer.this._delegate.getHierarchyWidth() - 1);
            int leftXBound = TimeBarViewer.this._delegate.getDiagramRect().x;
            int rightXBound = leftXBound + TimeBarViewer.this._delegate.getDiagramRect().width;
            if (g.getClipBounds() != null) {
                leftXBound = g.getClipBounds().x;
                rightXBound = leftXBound + g.getClipBounds().width;
            }
            for (int r = TimeBarViewer.this._delegate.getFirstRow(); r <= TimeBarViewer.this._delegate.getFirstRow() + TimeBarViewer.this._delegate.getRowsDisplayed() && r < TimeBarViewer.this._delegate.getRowCount(); ++r) {
                TimeBarRow row = TimeBarViewer.this._delegate.getRow(r);
                int rowWidth = TimeBarViewer.this._delegate.getTimeBarViewState().getRowHeight(row);
                int x = TimeBarViewer.this._delegate.yForRow(row);
                if (!(x >= leftXBound && x <= rightXBound || x + rowWidth >= leftXBound && x + rowWidth <= rightXBound) && (leftXBound <= x || leftXBound >= x + rowWidth)) continue;
                this.drawRowVertical(g, x, rowWidth, TimeBarViewer.this._delegate.getRow(r), TimeBarViewer.this._delegate.getSelectionModel().isSelected(TimeBarViewer.this._delegate.getRow(r)));
                if (TimeBarViewer.this._gapRenderer == null) continue;
                this.drawRowGapsVertical(g, x, rowWidth, TimeBarViewer.this._delegate.getRow(r), TimeBarViewer.this._delegate.getSelectionModel().isSelected(TimeBarViewer.this._delegate.getRow(r)));
            }
            g.setClip(clipSave);
        }

        private void drawRow(Graphics g, int y, int height, TimeBarRow row, boolean selected) {
            this.drawRowHeader(g, y, height, row.getRowHeader(), selected);
            this.drawHierarchy(g, y, height, row, selected);
            Rectangle diagramRect = TimeBarViewer.this._delegate.getDiagramRect();
            if (TimeBarViewer.this._delegate.getDrawRowGrid()) {
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(diagramRect.x, y + height - 1, diagramRect.x + diagramRect.width, y + height - 1);
            }
            if (selected || TimeBarViewer.this._delegate.getHighlightedRow() == row) {
                if (TimeBarViewer.this._delegate.getHighlightedRow() == row) {
                    g.setColor(HIGHLIGHT_COLOR);
                } else {
                    g.setColor(Color.BLUE);
                }
                int markerHeight = height;
                if (y + markerHeight > diagramRect.y + diagramRect.height) {
                    markerHeight -= y + markerHeight - (diagramRect.y + diagramRect.height);
                }
                g.fillRect(diagramRect.x, y, this.getWidth() - TimeBarViewer.this._delegate.getYAxisWidth() - TimeBarViewer.this._delegate.getHierarchyWidth(), markerHeight);
                g.setColor(Color.BLACK);
            }
            JaretDate start = TimeBarViewer.this._delegate.getStartDate();
            JaretDate end = TimeBarViewer.this._delegate.getEndDate();
            if (g.getClipBounds() != null) {
                start = TimeBarViewer.this._delegate.dateForCoord(g.getClipBounds().x);
                end = TimeBarViewer.this._delegate.dateForCoord(g.getClipBounds().x + g.getClipBounds().width);
            }
            List<Interval> intervals = row.getIntervals(start, end);
            for (Interval i : intervals) {
                if (TimeBarViewer.this._delegate.getIntervalFilter() != null && !TimeBarViewer.this._delegate.getIntervalFilter().isInResult(i)) continue;
                if (TimeBarViewer.this._delegate.isDrawOverlapping()) {
                    this.drawInterval(g, y, height, i, TimeBarViewer.this._delegate.getSelectionModel().isSelected(i), null, row);
                    continue;
                }
                this.drawInterval(g, y, height, i, TimeBarViewer.this._delegate.getSelectionModel().isSelected(i), TimeBarViewer.this._delegate.getOverlapStrategy().getOverlapInfo(row, i), row);
            }
        }

        private void drawRowVertical(Graphics g, int x, int width, TimeBarRow row, boolean selected) {
            this.drawRowHeaderVertical(g, x, width, row.getRowHeader(), selected);
            this.drawHierarchyVertical(g, x, width, row, selected);
            Rectangle diagramRect = TimeBarViewer.this._delegate.getDiagramRect();
            if (TimeBarViewer.this._delegate.getDrawRowGrid()) {
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(x + width - 1, diagramRect.y, x + width - 1, diagramRect.y + diagramRect.height);
            }
            if (selected || TimeBarViewer.this._delegate.getHighlightedRow() == row) {
                if (TimeBarViewer.this._delegate.getHighlightedRow() == row) {
                    g.setColor(HIGHLIGHT_COLOR);
                } else {
                    g.setColor(Color.BLUE);
                }
                int markerWidth = width;
                if (x + markerWidth > diagramRect.x + diagramRect.width) {
                    markerWidth -= x + markerWidth - (diagramRect.x + diagramRect.width);
                }
                g.fillRect(x, diagramRect.y, markerWidth, this.getHeight() - TimeBarViewer.this._delegate.getYAxisWidth() - TimeBarViewer.this._delegate.getHierarchyWidth());
                g.setColor(Color.BLACK);
            }
            JaretDate start = TimeBarViewer.this._delegate.getStartDate();
            JaretDate end = TimeBarViewer.this._delegate.getEndDate();
            if (g.getClipBounds() != null) {
                start = TimeBarViewer.this._delegate.dateForCoord(g.getClipBounds().y);
                end = TimeBarViewer.this._delegate.dateForCoord(g.getClipBounds().y + g.getClipBounds().height);
            }
            List<Interval> intervals = row.getIntervals(start, end);
            for (Interval i : intervals) {
                if (TimeBarViewer.this._delegate.getIntervalFilter() != null && !TimeBarViewer.this._delegate.getIntervalFilter().isInResult(i)) continue;
                if (TimeBarViewer.this._delegate.isDrawOverlapping()) {
                    this.drawIntervalVertical(g, x, width, i, TimeBarViewer.this._delegate.getSelectionModel().isSelected(i), null, row);
                    continue;
                }
                this.drawIntervalVertical(g, x, width, i, TimeBarViewer.this._delegate.getSelectionModel().isSelected(i), TimeBarViewer.this._delegate.getOverlapStrategy().getOverlapInfo(row, i), row);
            }
        }

        private void drawRowGaps(Graphics g, int y, int height, TimeBarRow row, boolean selected) {
            JaretDate start = TimeBarViewer.this._delegate.getStartDate();
            JaretDate end = TimeBarViewer.this._delegate.getEndDate();
            if (g.getClipBounds() != null) {
                start = TimeBarViewer.this._delegate.dateForCoord(g.getClipBounds().x);
                end = TimeBarViewer.this._delegate.dateForCoord(g.getClipBounds().x + g.getClipBounds().width);
            }
            ArrayList<Interval> intervals = new ArrayList<Interval>();
            Interval firstInterval = null;
            for (Interval interval : row.getIntervals()) {
                if (TimeBarViewer.this._delegate.getIntervalFilter() != null && !TimeBarViewer.this._delegate.getIntervalFilter().isInResult(interval)) continue;
                if (interval.getEnd().compareTo(start) < 0) {
                    if (firstInterval != null && start.diffSeconds(interval.getEnd()) >= start.diffSeconds(firstInterval.getEnd())) continue;
                    firstInterval = interval;
                    continue;
                }
                if (interval.contains(start)) {
                    firstInterval = interval;
                    continue;
                }
                if (firstInterval != null) {
                    intervals.add(firstInterval);
                    firstInterval = null;
                }
                if (interval.contains(end)) {
                    intervals.add(interval);
                    break;
                }
                if (interval.getBegin().compareTo(end) > 0) {
                    intervals.add(interval);
                    break;
                }
                intervals.add(interval);
            }
            Interval lastInterval = null;
            for (Interval i : intervals) {
                if (lastInterval != null) {
                    this.drawGap(g, row, y, height, lastInterval, i);
                }
                lastInterval = i;
            }
        }

        private void drawRowGapsVertical(Graphics g, int x, int width, TimeBarRow row, boolean selected) {
            JaretDate start = TimeBarViewer.this._delegate.getStartDate();
            JaretDate end = TimeBarViewer.this._delegate.getEndDate();
            if (g.getClipBounds() != null) {
                start = TimeBarViewer.this._delegate.dateForCoord(g.getClipBounds().y);
                end = TimeBarViewer.this._delegate.dateForCoord(g.getClipBounds().y + g.getClipBounds().height);
            }
            ArrayList<Interval> intervals = new ArrayList<Interval>();
            Interval firstInterval = null;
            for (Interval interval : row.getIntervals()) {
                if (TimeBarViewer.this._delegate.getIntervalFilter() != null && !TimeBarViewer.this._delegate.getIntervalFilter().isInResult(interval)) continue;
                if (interval.getEnd().compareTo(start) < 0) {
                    if (firstInterval != null && start.diffSeconds(interval.getEnd()) >= start.diffSeconds(firstInterval.getEnd())) continue;
                    firstInterval = interval;
                    continue;
                }
                if (interval.contains(start)) {
                    firstInterval = interval;
                    continue;
                }
                if (firstInterval != null) {
                    intervals.add(firstInterval);
                    firstInterval = null;
                }
                if (interval.contains(end)) {
                    intervals.add(interval);
                    break;
                }
                if (interval.getBegin().compareTo(end) > 0) {
                    intervals.add(interval);
                    break;
                }
                intervals.add(interval);
            }
            Interval lastInterval = null;
            for (Interval i : intervals) {
                if (lastInterval != null) {
                    this.drawGapVertical(g, row, x, width, lastInterval, i);
                }
                lastInterval = i;
            }
        }

        private void drawInterval(Graphics g, int y, int height, Interval i, boolean selected, OverlapInfo oiInfo, TimeBarRow row) {
            boolean overlapping;
            TimeBarRenderer renderer = TimeBarViewer.this.getRenderer(i.getClass());
            if (renderer == null) {
                throw new RuntimeException("no suitable renderer registered");
            }
            boolean bl = overlapping = oiInfo != null && oiInfo.maxOverlapping > 0;
            if (oiInfo != null) {
                height = TimeBarViewer.this._delegate.getTimeBarViewState().getRowHeight(row) / (oiInfo.maxOverlapping + 1);
                y += oiInfo.pos * height;
            }
            JComponent component = renderer.getTimeBarRendererComponent(this._timeBarViewer, i, selected, overlapping);
            int x = TimeBarViewer.this._delegate.xForDate(i.getBegin());
            int width = TimeBarViewer.this._delegate.xForDate(i.getEnd()) - x;
            component.setBounds(x, y, width, height);
            Graphics gg = g.create(x, y, width, height);
            Rectangle diagramRect = TimeBarViewer.this._delegate.getDiagramRect();
            if (y + height > diagramRect.y + diagramRect.height) {
                height -= y + height - (diagramRect.y + diagramRect.height);
            }
            int upperClipBound = 0;
            if (y < diagramRect.y) {
                upperClipBound = diagramRect.y - y;
            }
            if (x + width > diagramRect.x + diagramRect.width) {
                width -= x + width - (diagramRect.x + diagramRect.width);
            }
            gg.setClip(x < diagramRect.x ? diagramRect.x - x : 0, upperClipBound, width, height);
            ((Component)component).paint(gg);
            gg.dispose();
        }

        private void drawIntervalVertical(Graphics g, int x, int width, Interval i, boolean selected, OverlapInfo oiInfo, TimeBarRow row) {
            boolean overlapping;
            TimeBarRenderer renderer = TimeBarViewer.this.getRenderer(i.getClass());
            if (renderer == null) {
                throw new RuntimeException("no suitable renderer registered");
            }
            boolean bl = overlapping = oiInfo != null && oiInfo.maxOverlapping > 0;
            if (oiInfo != null) {
                width = TimeBarViewer.this._delegate.getTimeBarViewState().getRowHeight(row) / (oiInfo.maxOverlapping + 1);
                x += oiInfo.pos * width;
            }
            JComponent component = renderer.getTimeBarRendererComponent(this._timeBarViewer, i, selected, overlapping);
            int y = TimeBarViewer.this._delegate.xForDate(i.getBegin());
            int height = TimeBarViewer.this._delegate.xForDate(i.getEnd()) - y;
            component.setBounds(x, y, width, height);
            Graphics gg = g.create(x, y, width, height);
            Rectangle diagramRect = TimeBarViewer.this._delegate.getDiagramRect();
            if (x + width > diagramRect.x + diagramRect.width) {
                width -= x + width - (diagramRect.x + diagramRect.width);
            }
            int upperClipBound = 0;
            if (x < diagramRect.x) {
                upperClipBound = diagramRect.x - x;
            }
            if (y + height > diagramRect.y + diagramRect.height) {
                height -= y + height - (diagramRect.y + diagramRect.height);
            }
            gg.setClip(upperClipBound, y < diagramRect.y ? diagramRect.y - y : 0, width, height);
            ((Component)component).paint(gg);
            gg.dispose();
        }

        private void drawGap(Graphics g, TimeBarRow row, int y, int height, Interval i1, Interval i2) {
            JComponent component = TimeBarViewer.this._gapRenderer.getTimeBarGapRendererComponent(this._timeBarViewer, row, i1, i2);
            int x = TimeBarViewer.this._delegate.xForDate(i1.getEnd());
            int width = TimeBarViewer.this._delegate.xForDate(i2.getBegin()) - x;
            if (TimeBarViewer.this._gapRenderer.getMinimumWidth() > 0 && width < TimeBarViewer.this._gapRenderer.getMinimumWidth()) {
                int diff = TimeBarViewer.this._gapRenderer.getMinimumWidth() - width;
                width += diff;
                x -= diff / 2;
            }
            component.setBounds(x, y, width, height);
            Graphics gg = g.create(x, y, width, height);
            Rectangle diagramRect = TimeBarViewer.this._delegate.getDiagramRect();
            if (y + height > diagramRect.y + diagramRect.height) {
                height -= y + height - (diagramRect.y + diagramRect.height);
            }
            int upperClipBound = 0;
            if (y < diagramRect.y) {
                upperClipBound = diagramRect.y - y;
            }
            gg.setClip(x < diagramRect.x ? diagramRect.x - x : 0, upperClipBound, width, height);
            ((Component)component).paint(gg);
            gg.dispose();
        }

        private void drawGapVertical(Graphics g, TimeBarRow row, int x, int width, Interval i1, Interval i2) {
            JComponent component = TimeBarViewer.this._gapRenderer.getTimeBarGapRendererComponent(this._timeBarViewer, row, i1, i2);
            int y = TimeBarViewer.this._delegate.xForDate(i1.getEnd());
            int height = TimeBarViewer.this._delegate.xForDate(i2.getBegin()) - y;
            if (TimeBarViewer.this._gapRenderer.getMinimumWidth() > 0 && height < TimeBarViewer.this._gapRenderer.getMinimumWidth()) {
                int diff = TimeBarViewer.this._gapRenderer.getMinimumWidth() - height;
                height += diff;
                y -= diff / 2;
            }
            component.setBounds(x, y, width, height);
            Graphics gg = g.create(x, y, width, height);
            Rectangle diagramRect = TimeBarViewer.this._delegate.getDiagramRect();
            if (x + width > diagramRect.x + diagramRect.width) {
                width -= x + width - (diagramRect.x + diagramRect.width);
            }
            int upperClipBound = 0;
            if (x < diagramRect.x) {
                upperClipBound = diagramRect.x - x;
            }
            gg.setClip(upperClipBound, y < diagramRect.y ? diagramRect.y - y : 0, width, height);
            ((Component)component).paint(gg);
            gg.dispose();
        }

        private void drawRowHeader(Graphics g, int y, int height, TimeBarRowHeader header, boolean selected) {
            if (TimeBarViewer.this._headerRenderer != null && TimeBarViewer.this._delegate.getYAxisWidth() > 0) {
                Graphics gg;
                JComponent component = TimeBarViewer.this._headerRenderer.getHeaderRendererComponent(this._timeBarViewer, header, selected);
                int x = TimeBarViewer.this._delegate.getYAxisRect().x;
                int width = TimeBarViewer.this._delegate.getYAxisWidth() - 1;
                Rectangle diagramRect = TimeBarViewer.this._delegate.getDiagramRect();
                int prefHeight = component.getPreferredSize().height;
                if (prefHeight < height) {
                    int hCor = (height - prefHeight) / 2;
                    gg = g.create(x, y + hCor, width, prefHeight);
                    component.setBounds(x, y + hCor, width, prefHeight);
                    int upperClipBound = 0;
                    if (y + hCor < diagramRect.y) {
                        upperClipBound = diagramRect.y - y - hCor;
                    }
                    if (y + hCor + height > diagramRect.y + diagramRect.height) {
                        prefHeight -= y + hCor + prefHeight - (diagramRect.y + diagramRect.height);
                    }
                    gg.setClip(0, upperClipBound, width, prefHeight);
                } else {
                    gg = g.create(x, y, width, height);
                    component.setBounds(x, y, width, height);
                    int upperClipBound = 0;
                    if (y < diagramRect.y) {
                        upperClipBound = diagramRect.y - y;
                    }
                    if (y + height > diagramRect.y + diagramRect.height) {
                        height -= y + height - (diagramRect.y + diagramRect.height);
                    }
                    gg.setClip(x < diagramRect.x ? diagramRect.x - x : 0, upperClipBound, width, height);
                }
                component.paint(gg);
                gg.dispose();
            }
        }

        private void drawRowHeaderVertical(Graphics g, int x, int width, TimeBarRowHeader header, boolean selected) {
            if (TimeBarViewer.this._headerRenderer != null && TimeBarViewer.this._delegate.getYAxisWidth() > 0) {
                Graphics gg;
                JComponent component = TimeBarViewer.this._headerRenderer.getHeaderRendererComponent(this._timeBarViewer, header, selected);
                int y = TimeBarViewer.this._delegate.getYAxisRect().y;
                int height = TimeBarViewer.this._delegate.getYAxisWidth() - 1;
                Rectangle diagramRect = TimeBarViewer.this._delegate.getDiagramRect();
                int prefWidth = component.getPreferredSize().width;
                if (prefWidth < width) {
                    int wCor = (width - prefWidth) / 2;
                    gg = g.create(x + wCor, y, prefWidth, height);
                    component.setBounds(x + wCor, y, prefWidth, height);
                    int upperClipBound = 0;
                    if (x + wCor < diagramRect.x) {
                        upperClipBound = diagramRect.x - x - wCor;
                    }
                    if (x + wCor + width > diagramRect.x + diagramRect.width) {
                        prefWidth -= x + wCor + prefWidth - (diagramRect.x + diagramRect.width);
                    }
                    gg.setClip(upperClipBound, 0, prefWidth, height);
                } else {
                    gg = g.create(x, y, width, height);
                    component.setBounds(x, y, width, height);
                    int upperClipBound = 0;
                    if (x < diagramRect.x) {
                        upperClipBound = diagramRect.x - x;
                    }
                    if (x + width > diagramRect.x + diagramRect.width) {
                        width -= x + width - (diagramRect.x + diagramRect.width);
                    }
                    gg.setClip(upperClipBound, y < diagramRect.y ? diagramRect.y - y : 0, width, height);
                }
                component.paint(gg);
                gg.dispose();
            }
        }

        private void drawHierarchy(Graphics g, int y, int height, TimeBarRow row, boolean selected) {
            if (TimeBarViewer.this._hierarchyRenderer != null && TimeBarViewer.this._delegate.getHierarchyWidth() > 0) {
                int level = 0;
                int depth = 0;
                boolean expanded = false;
                boolean leaf = true;
                if (row instanceof TimeBarNode) {
                    TimeBarNode node = (TimeBarNode)row;
                    if (TimeBarViewer.this._delegate.getHierarchicalViewState().isExpanded(node)) {
                        expanded = true;
                    }
                    leaf = node.getChildren().size() == 0;
                    level = node.getLevel();
                    depth = TimeBarViewer.this._delegate.getHierarchicalModel().getDepth();
                }
                int x = TimeBarViewer.this._delegate.getHierarchyRect().x;
                int width = TimeBarViewer.this._delegate.getHierarchyWidth() - 1;
                JComponent component = TimeBarViewer.this._hierarchyRenderer.getHierarchyRendererComponent(this._timeBarViewer, row, selected, expanded, leaf, level, depth);
                Rectangle diagramRect = TimeBarViewer.this._delegate.getDiagramRect();
                Graphics gg = g.create(x, y, width, height);
                component.setBounds(x, y, width, height);
                if (y + height > diagramRect.y + diagramRect.height) {
                    height -= y + height - (diagramRect.y + diagramRect.height);
                }
                int upperClipBound = 0;
                if (y < diagramRect.y) {
                    upperClipBound = diagramRect.y - y;
                }
                gg.setClip(x, upperClipBound, width, height);
                component.paint(gg);
                gg.dispose();
            }
        }

        private void drawHierarchyVertical(Graphics g, int x, int width, TimeBarRow row, boolean selected) {
            if (TimeBarViewer.this._hierarchyRenderer != null && TimeBarViewer.this._delegate.getHierarchyWidth() > 0) {
                int level = 0;
                int depth = 0;
                boolean expanded = false;
                boolean leaf = true;
                if (row instanceof TimeBarNode) {
                    TimeBarNode node = (TimeBarNode)row;
                    if (TimeBarViewer.this._delegate.getHierarchicalViewState().isExpanded(node)) {
                        expanded = true;
                    }
                    leaf = node.getChildren().size() == 0;
                    level = node.getLevel();
                    depth = TimeBarViewer.this._delegate.getHierarchicalModel().getDepth();
                }
                int y = TimeBarViewer.this._delegate.getHierarchyRect().y;
                int height = TimeBarViewer.this._delegate.getHierarchyWidth() - 1;
                JComponent component = TimeBarViewer.this._hierarchyRenderer.getHierarchyRendererComponent(this._timeBarViewer, row, selected, expanded, leaf, level, depth);
                Rectangle diagramRect = TimeBarViewer.this._delegate.getDiagramRect();
                Graphics gg = g.create(x, y, width, height);
                component.setBounds(x, y, width, height);
                if (x + width > diagramRect.x + diagramRect.width) {
                    width -= x + width - (diagramRect.x + diagramRect.width);
                }
                int upperClipBound = 0;
                if (x < diagramRect.x) {
                    upperClipBound = diagramRect.x - x;
                }
                gg.setClip(upperClipBound, y, width, height);
                component.paint(gg);
                gg.dispose();
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(500, 300);
        }

        public void displayHeaderPopup(MouseEvent e) {
            if (e.isPopupTrigger() && TimeBarViewer.this._headerPopup != null) {
                TimeBarViewer.this._headerPopup.show(this._timeBarViewer, e.getX(), e.getY());
            }
        }

        public void displayElementPopup(MouseEvent e, Interval interval) {
            JPopupMenu popup;
            if (e.isPopupTrigger() && (popup = interval == null ? TimeBarViewer.this.getPopupMenu(Void.TYPE) : TimeBarViewer.this.getPopupMenu(interval.getClass())) != null) {
                popup.show(this._timeBarViewer, e.getX(), e.getY());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            TimeBarViewer.this._delegate.mousePressed(e.getX(), e.getY(), e.isPopupTrigger(), e.getModifiersEx());
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            TimeBarViewer.this._delegate.mouseReleased(e.getX(), e.getY(), e.isPopupTrigger(), e.getModifiersEx());
        }

        public void mouseDragged(MouseEvent e) {
            TimeBarViewer.this._delegate.mouseDragged(e.getX(), e.getY());
        }

        public void mouseMoved(MouseEvent e) {
            TimeBarViewer.this._delegate.mouseMoved(e.getX(), e.getY());
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollType() == 0) {
                int val = e.getUnitsToScroll();
                if (TimeBarViewer.this._delegate.getXAxisRect() != null && e.getY() > TimeBarViewer.this._delegate.getXAxisRect().y && e.getY() < TimeBarViewer.this._delegate.getXAxisRect().y + TimeBarViewer.this._delegate.getXAxisRect().height) {
                    TimeBarViewer.this._xScrollBar.setValue(TimeBarViewer.this._xScrollBar.getValue() + val * TimeBarViewer.this._xScrollBar.getModel().getExtent() / 5);
                } else {
                    TimeBarViewer.this._yScrollBar.getModel().setValue(TimeBarViewer.this._yScrollBar.getModel().getValue() + val);
                }
            }
        }
    }
}

