/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swing.renderer;

import de.jaret.util.date.Interval;
import de.jaret.util.misc.FormatHelper;
import de.jaret.util.swing.GraphicsHelper;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.swing.TimeBarViewer;
import de.jaret.util.ui.timebars.swing.renderer.TimeBarGapRenderer;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;

public class DefaultGapRenderer
implements TimeBarGapRenderer {
    protected GapRenderer _component = new GapRenderer();

    public JComponent getTimeBarGapRendererComponent(TimeBarViewer tbv, TimeBarRow row, Interval interval1, Interval interval2) {
        boolean horizontal = tbv.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL;
        this._component.setUp(horizontal, interval1, interval2);
        return this._component;
    }

    public int getMinimumWidth() {
        return -1;
    }

    class GapRenderer
    extends JComponent {
        private Interval _i1;
        private Interval _i2;
        private boolean _horizontal;

        GapRenderer() {
        }

        public void setUp(boolean horizontal, Interval interval1, Interval interval2) {
            this._horizontal = horizontal;
            this._i1 = interval1;
            this._i2 = interval2;
        }

        protected void paintComponent(Graphics g) {
            if (this._i1 != null && this._i2 != null) {
                int diffminutes = (int)this._i2.getBegin().diffMinutes(this._i1.getEnd());
                String timeString = FormatHelper.NFInt2Digits().format(diffminutes / 60) + ":" + FormatHelper.NFInt2Digits().format(diffminutes % 60);
                int twidth = GraphicsHelper.getStringDrawingWidth((Graphics)g, (String)timeString);
                int theight = GraphicsHelper.getStringDrawingHeight((Graphics)g, (String)timeString);
                g.setColor(Color.DARK_GRAY);
                if (this._horizontal) {
                    if (this.getWidth() > twidth + 3 && this.getHeight() / 2 >= theight) {
                        GraphicsHelper.drawStringCentered((Graphics)g, (String)timeString, (int)(this.getWidth() / 2), (int)(this.getHeight() / 2 - 2));
                    }
                    if (this.getWidth() > 15) {
                        GraphicsHelper.drawArrowLine((Graphics)g, (int)2, (int)(this.getHeight() / 2), (int)(this.getWidth() - 3), (int)(this.getHeight() / 2), (int)4, (boolean)true, (boolean)true);
                    }
                } else {
                    if (this.getHeight() > theight + 3 && this.getWidth() >= twidth) {
                        GraphicsHelper.drawStringCenteredPoint((Graphics)g, (String)timeString, (int)(this.getWidth() / 2), (int)(this.getHeight() / 2));
                    }
                    if (this.getWidth() > 15) {
                        GraphicsHelper.drawArrowLineVertical((Graphics)g, (int)(this.getWidth() / 2), (int)2, (int)(this.getWidth() / 2), (int)(this.getHeight() - 3), (int)3, (int)4, (boolean)true, (boolean)true);
                    }
                }
            }
        }
    }
}

