/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swing.renderer;

import de.jaret.util.date.DateUtils;
import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.TickScaler;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.swing.TimeBarViewer;
import de.jaret.util.ui.timebars.swing.renderer.GridRenderer;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;

public class DefaultGridRenderer
implements GridRenderer {
    private static final Color MAJORGRIDCOLOR = new Color(200, 200, 200);
    private static final Color MINORGRIDCOLOR = new Color(230, 230, 230);
    protected MyGridRenderer _component = new MyGridRenderer();

    public JComponent getRendererComponent(TimeBarViewer tbv) {
        this._component.setTimeBarViewer(tbv);
        return this._component;
    }

    class MyGridRenderer
    extends JComponent {
        private TimeBarViewer _tbv;

        MyGridRenderer() {
        }

        public void setTimeBarViewer(TimeBarViewer tbv) {
            this._tbv = tbv;
        }

        private int xForDate(JaretDate date) {
            long seconds = date.diffSeconds(this._tbv.getStartDate());
            int x = (int)((double)seconds * this._tbv.getPixelPerSecond());
            return x;
        }

        private JaretDate dateForX(int x) {
            int diffSec = (int)((double)x / this._tbv.getPixelPerSecond());
            JaretDate date = new JaretDate(this._tbv.getStartDate());
            date.advanceSeconds((double)diffSec);
            return date;
        }

        public void paintComponent(Graphics g) {
            int adv;
            int coord;
            boolean horizontal = this._tbv.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL;
            JaretDate date = this._tbv.getStartDate().copy();
            int idx = TickScaler.getTickIdx(this._tbv.getPixelPerSecond());
            int majTick = TickScaler.getMajorTickMinutes(idx);
            int minTick = TickScaler.getMinorTickMinutes(idx);
            TickScaler.Range range = TickScaler.getRange(idx);
            date.setMinutes(0);
            date.setHours(0);
            date.setSeconds(0);
            if (range == TickScaler.Range.WEEK) {
                while (date.getDayOfWeek() != DateUtils.getFirstDayOfWeek()) {
                    date.backDays(1.0);
                }
            } else if (range == TickScaler.Range.MONTH) {
                date.setDay(1);
            }
            JaretDate save = date.copy();
            date.backMinutes((double)majTick);
            int max = horizontal ? this.getWidth() : this.getHeight();
            g.setColor(MINORGRIDCOLOR);
            while (this.xForDate(date) < max) {
                coord = this.xForDate(date);
                if (horizontal) {
                    g.drawLine(coord, 0, coord, this.getHeight());
                } else {
                    g.drawLine(0, coord, this.getWidth(), coord);
                }
                if (range == TickScaler.Range.MONTH) {
                    adv = Math.round(minTick / 40320);
                    if (adv == 0) {
                        adv = 1;
                    }
                    date.advanceMonths(adv);
                    continue;
                }
                date.advanceMinutes((double)minTick);
            }
            date = save.copy();
            g.setColor(MAJORGRIDCOLOR);
            while (this.xForDate(date) < max) {
                coord = this.xForDate(date);
                if (horizontal) {
                    g.drawLine(coord, 0, coord, this.getHeight());
                } else {
                    g.drawLine(0, coord, this.getWidth(), coord);
                }
                if (range == TickScaler.Range.MONTH) {
                    adv = Math.round(majTick / 40320);
                    if (adv == 0) {
                        adv = 1;
                    }
                    date.advanceMonths(adv);
                    continue;
                }
                date.advanceMinutes((double)majTick);
            }
        }
    }
}

