/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swing.renderer;

import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.swing.TimeBarViewer;
import de.jaret.util.ui.timebars.swing.renderer.HierarchyRenderer;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;

public class DefaultHierarchyRenderer
implements HierarchyRenderer {
    private static final int SIZE = 12;
    private MyHierarchyRenderer _renderer = new MyHierarchyRenderer();

    public JComponent getHierarchyRendererComponent(TimeBarViewer tbv, TimeBarRow row, boolean selected, boolean expanded, boolean leaf, int level, int depth) {
        this._renderer.configure(tbv, row, selected, expanded, leaf, level, depth);
        this._renderer.setToolTipText("Hierarchy");
        return this._renderer;
    }

    public int getWidth() {
        return 16;
    }

    class MyHierarchyRenderer
    extends JComponent {
        TimeBarViewer _tbv;
        TimeBarRow _row;
        boolean _selected;
        boolean _expanded;
        boolean _leaf;
        int _level;
        int _depth;

        MyHierarchyRenderer() {
        }

        public void configure(TimeBarViewer tbv, TimeBarRow row, boolean selected, boolean expanded, boolean leaf, int level, int depth) {
            this._tbv = tbv;
            this._row = row;
            this._expanded = expanded;
            this._leaf = leaf;
            this._level = level;
            this._depth = depth;
        }

        public void paintComponent(Graphics gc) {
            int offx = (this.getWidth() - 12) / (this._depth + 1);
            int x = offx * this._level + 6;
            int y = (this.getHeight() - 12) / 2;
            if (this._leaf) {
                this.drawLeaf(gc, 12, x, y);
            } else if (this._expanded) {
                this.drawMinus(gc, 12, x, y);
            } else {
                this.drawPlus(gc, 12, x, y);
            }
            boolean drawConnections = false;
            if (drawConnections) {
                for (int i = 0; i <= this._level - 1; ++i) {
                    x = offx * i + 12;
                    gc.drawLine(x, 0, x, this.getHeight());
                }
                x = offx * this._level + 12;
                gc.drawLine(x, 0, x, (this.getHeight() - 12) / 2);
                gc.drawLine(x, (this.getHeight() - 12) / 2 + 12, x, y + this.getHeight());
                if (this._level > 0) {
                    x = offx * (this._level - 1) + 12;
                    int xx = offx * this._level + 12;
                    y = (this.getHeight() - 12) / 2 + 6;
                    gc.drawLine(x, y, xx - 6, y);
                }
            }
        }

        protected void drawPlus(Graphics gc, int size, int x, int y) {
            gc.drawLine(x + 3, y + size / 2, x + size - 3, y + size / 2);
            gc.drawLine(x + size / 2, y + 3, x + size / 2, y + size - 3);
            gc.drawRect(x, y, size, size);
        }

        protected void drawMinus(Graphics gc, int size, int x, int y) {
            gc.drawLine(x + 3, y + size / 2, x + size - 3, y + size / 2);
            gc.drawRect(x, y, size, size);
        }

        protected void drawLeaf(Graphics gc, int size, int x, int y) {
            Color bg = gc.getColor();
            gc.setColor(Color.BLACK);
            gc.fillOval(x + size / 2, y + size / 2, size / 2, size / 2);
            gc.setColor(bg);
        }
    }
}

