/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swing.renderer;

import de.jaret.util.date.Interval;
import de.jaret.util.ui.timebars.swing.TimeBarViewer;
import de.jaret.util.ui.timebars.swing.renderer.TimeBarRenderer;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTimeBarRenderer
implements TimeBarRenderer {
    protected JButton _component = new JButton();
    protected Map<Class<? extends Interval>, TimeBarRenderer> _rendererMap;

    public void registerTimeBarRenderer(Class<? extends Interval> intervalClass, TimeBarRenderer renderer) {
        if (this._rendererMap == null) {
            this._rendererMap = new HashMap<Class<? extends Interval>, TimeBarRenderer>();
        }
        this._rendererMap.put(intervalClass, renderer);
    }

    private TimeBarRenderer getRenderer(Class<? extends Interval> clazz) {
        Class<?>[] interfaces;
        TimeBarRenderer result = null;
        result = this._rendererMap.get(clazz);
        if (result != null) {
            return result;
        }
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            result = this._rendererMap.get(c);
            if (result == null) continue;
            return result;
        }
        for (Class<? extends Interval> sc = clazz.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            Class<?>[] scinterfaces;
            result = this._rendererMap.get(sc);
            if (result != null) {
                return result;
            }
            for (Class<?> c : scinterfaces = sc.getInterfaces()) {
                result = this._rendererMap.get(c);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    @Override
    public JComponent getTimeBarRendererComponent(TimeBarViewer tbv, Interval value, boolean isSelected, boolean overlapping) {
        TimeBarRenderer renderer = null;
        if (this._rendererMap != null) {
            renderer = this.getRenderer(value.getClass());
        }
        if (renderer == null) {
            return this.defaultGetTimeBarRendererComponent(tbv, value, isSelected, overlapping);
        }
        return renderer.getTimeBarRendererComponent(tbv, value, isSelected, overlapping);
    }

    public JComponent defaultGetTimeBarRendererComponent(TimeBarViewer tbv, Interval value, boolean isSelected, boolean overlapping) {
        this._component.setText(value.toString());
        this._component.setToolTipText(value.toString());
        if (isSelected) {
            this._component.setBackground(Color.BLUE);
        } else {
            this._component.setBackground(Color.LIGHT_GRAY);
        }
        return this._component;
    }
}

