/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swing.renderer;

import de.jaret.util.date.DateUtils;
import de.jaret.util.date.JaretDate;
import de.jaret.util.swing.GraphicsHelper;
import de.jaret.util.ui.timebars.TickScaler;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.swing.TimeBarViewer;
import de.jaret.util.ui.timebars.swing.renderer.TimeScaleRenderer;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class DefaultTimeScaleRenderer
implements TimeScaleRenderer {
    protected MyTimeScaleRenderer _renderer = new MyTimeScaleRenderer();

    public JComponent getRendererComponent(TimeBarViewer tbv, boolean top) {
        this._renderer.setTimeBarViewer(tbv);
        this._renderer.setTop(top);
        return this._renderer;
    }

    public int getHeight() {
        return 50;
    }

    class MyTimeScaleRenderer
    extends JComponent {
        private TimeBarViewer _tbv;
        boolean _top;

        MyTimeScaleRenderer() {
        }

        public void setTimeBarViewer(TimeBarViewer tbv) {
            this._tbv = tbv;
        }

        public void setTop(boolean top) {
            this._top = top;
        }

        private int xForDate(JaretDate date) {
            int x = this._tbv.xForDate(date);
            return x -= this._tbv.getHierarchyWidth() + this._tbv.getYAxisWidth();
        }

        private JaretDate dateForX(int x) {
            return this._tbv.dateForX(x + this._tbv.getHierarchyWidth() + this._tbv.getYAxisWidth());
        }

        public void paintComponent(Graphics g) {
            if (this._tbv.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                this.paintHorizontal(g);
            } else {
                this.paintVertical(g);
            }
        }

        public void paintHorizontal(Graphics g) {
            int adv;
            int x;
            int dayOff;
            int majorLabelOff;
            int majorOff;
            int minorOff;
            int basey;
            JaretDate date = this._tbv.getStartDate().copy();
            int idx = TickScaler.getTickIdx(this._tbv.getPixelPerSecond());
            int majTick = TickScaler.getMajorTickMinutes(idx);
            int minTick = TickScaler.getMinorTickMinutes(idx);
            TickScaler.Range range = TickScaler.getRange(idx);
            date.setMinutes(0);
            date.setHours(0);
            date.setSeconds(0);
            if (range == TickScaler.Range.WEEK) {
                while (date.getDayOfWeek() != DateUtils.getFirstDayOfWeek()) {
                    date.backDays(1.0);
                }
            } else if (range == TickScaler.Range.MONTH) {
                date.setDay(1);
            }
            JaretDate save = date.copy();
            if (!this._top) {
                basey = 0;
                minorOff = 5;
                majorOff = 10;
                majorLabelOff = 22;
                dayOff = 34;
            } else {
                basey = this.getHeight() - 1;
                minorOff = -5;
                majorOff = -10;
                majorLabelOff = -10;
                dayOff = -22;
            }
            int oy = basey;
            g.drawLine(0, oy, this.getWidth(), oy);
            while (this.xForDate(date) < this.getWidth()) {
                x = this.xForDate(date);
                g.drawLine(x, oy, x, oy + minorOff);
                if (range == TickScaler.Range.MONTH) {
                    adv = Math.round(minTick / 40320);
                    if (adv == 0) {
                        adv = 1;
                    }
                    date.advanceMonths(adv);
                    continue;
                }
                date.advanceMinutes((double)minTick);
            }
            date = save.copy();
            while (this.xForDate(date) < this.getWidth()) {
                x = this.xForDate(date);
                g.drawLine(x, oy, x, oy + majorOff);
                if (range == TickScaler.Range.MONTH) {
                    adv = Math.round(majTick / 40320);
                    if (adv == 0) {
                        adv = 1;
                    }
                    date.advanceMonths(adv);
                    continue;
                }
                date.advanceMinutes((double)majTick);
            }
            date = save.copy();
            int lastDay = date.getDay();
            int width = this.getWidth();
            while (this.xForDate(date) < width + 100) {
                int x2 = this.xForDate(date);
                if (date.getMinutes() % (majTick * 2) == 0) {
                    String str = null;
                    if (range == TickScaler.Range.HOUR) {
                        str = date.toDisplayStringTime();
                    } else if (range == TickScaler.Range.DAY) {
                        str = date.getShortDayOfWeekString();
                    } else if (range == TickScaler.Range.WEEK) {
                        str = "KW" + date.getWeekOfYear();
                    } else if (range == TickScaler.Range.MONTH) {
                        str = Integer.toString(date.getYear());
                    }
                    if (x2 > GraphicsHelper.getStringDrawingWidth((Graphics)g, (String)str) / 2) {
                        GraphicsHelper.drawStringCentered((Graphics)g, (String)str, (int)x2, (int)(oy + majorLabelOff));
                    }
                    if (range == TickScaler.Range.HOUR) {
                        str = date.getDay() != lastDay ? date.getDay() + ". (" + date.getDayOfWeekString() + ")" : "";
                        lastDay = date.getDay();
                    } else if (range == TickScaler.Range.DAY || range == TickScaler.Range.WEEK) {
                        str = date.getDay() + ".";
                    } else if (range == TickScaler.Range.MONTH) {
                        str = date.getMonthString();
                    }
                    GraphicsHelper.drawStringCentered((Graphics)g, (String)str, (int)x2, (int)(oy + dayOff));
                }
                if (range == TickScaler.Range.MONTH) {
                    int adv2 = Math.round(majTick / 40320);
                    if (adv2 == 0) {
                        adv2 = 1;
                    }
                    date.advanceMonths(adv2);
                    continue;
                }
                date.advanceMinutes((double)majTick);
            }
        }

        public void paintVertical(Graphics g) {
            int adv;
            int y;
            int majorOff;
            int minorOff;
            int basex;
            JaretDate date = this._tbv.getStartDate().copy();
            int idx = TickScaler.getTickIdx(this._tbv.getPixelPerSecond());
            int majTick = TickScaler.getMajorTickMinutes(idx);
            int minTick = TickScaler.getMinorTickMinutes(idx);
            TickScaler.Range range = TickScaler.getRange(idx);
            date.setMinutes(0);
            date.setHours(0);
            date.setSeconds(0);
            if (range == TickScaler.Range.WEEK) {
                while (date.getDayOfWeek() != DateUtils.getFirstDayOfWeek()) {
                    date.backDays(1.0);
                }
            } else if (range == TickScaler.Range.MONTH) {
                date.setDay(1);
            }
            JaretDate save = date.copy();
            if (!this._top) {
                basex = 0;
                minorOff = 5;
                majorOff = 10;
            } else {
                basex = this.getWidth() - 1;
                minorOff = -5;
                majorOff = -10;
            }
            int ox = basex;
            if (this._top) {
                g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
            } else {
                g.drawLine(0, 0, 0, this.getHeight());
            }
            while (this.xForDate(date) < this.getHeight()) {
                y = this.xForDate(date);
                g.drawLine(ox, y, ox + minorOff, y);
                if (range == TickScaler.Range.MONTH) {
                    adv = Math.round(minTick / 40320);
                    if (adv == 0) {
                        adv = 1;
                    }
                    date.advanceMonths(adv);
                    continue;
                }
                date.advanceMinutes((double)minTick);
            }
            date = save.copy();
            while (this.xForDate(date) < this.getHeight()) {
                y = this.xForDate(date);
                g.drawLine(ox, y, ox + majorOff, y);
                if (range == TickScaler.Range.MONTH) {
                    adv = Math.round(majTick / 40320);
                    if (adv == 0) {
                        adv = 1;
                    }
                    date.advanceMonths(adv);
                    continue;
                }
                date.advanceMinutes((double)majTick);
            }
            date = save.copy();
            int height = this.getHeight();
            while (this.xForDate(date) < height + 50) {
                int y2 = this.xForDate(date);
                if (date.getMinutes() % (majTick * 2) == 0) {
                    String str = null;
                    if (range == TickScaler.Range.HOUR) {
                        str = date.toDisplayStringTime();
                    } else if (range == TickScaler.Range.DAY) {
                        str = date.getShortDayOfWeekString();
                    } else if (range == TickScaler.Range.WEEK) {
                        str = "KW" + date.getWeekOfYear();
                    } else if (range == TickScaler.Range.MONTH) {
                        str = Integer.toString(date.getYear());
                    }
                    if (y2 > GraphicsHelper.getStringDrawingWidth((Graphics)g, (String)str) / 2) {
                        if (this._top) {
                            GraphicsHelper.drawStringRightAlignedVCenter((Graphics)g, (String)str, (int)(ox + majorOff - 1), (int)y2);
                        } else {
                            GraphicsHelper.drawStringLeftAlignedVCenter((Graphics)g, (String)str, (int)(ox + majorOff + 1), (int)y2);
                        }
                    }
                }
                if (range == TickScaler.Range.MONTH) {
                    int adv2 = Math.round(majTick / 40320);
                    if (adv2 == 0) {
                        adv2 = 1;
                    }
                    date.advanceMonths(adv2);
                    continue;
                }
                date.advanceMinutes((double)majTick);
            }
        }

        public String getToolTipText(MouseEvent event) {
            if (this._tbv.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                JaretDate date = this.dateForX(event.getX());
                return date.toDisplayString();
            }
            JaretDate date = this.dateForX(event.getY());
            return date.toDisplayString();
        }
    }
}

