/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt;

import de.jaret.util.date.Interval;
import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.TimeBarMarker;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.model.TimeBarNode;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.model.TimeBarRowHeader;
import de.jaret.util.ui.timebars.strategy.OverlapInfo;
import de.jaret.util.ui.timebars.swt.TimeBarPrinter;
import de.jaret.util.ui.timebars.swt.TimeBarViewer;
import de.jaret.util.ui.timebars.swt.renderer.GridRenderer;
import de.jaret.util.ui.timebars.swt.renderer.HeaderRenderer;
import de.jaret.util.ui.timebars.swt.renderer.HierarchyRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarGapRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarMarkerRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarRenderer2;
import de.jaret.util.ui.timebars.swt.renderer.TimeScaleRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TitleRenderer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class RenderDelegate {
    public static void drawRowSimple(TimeBarViewerDelegate delegate, TimeBarPrinter tbPrinter, HeaderRenderer headerRenderer, HierarchyRenderer hierarchyRenderer, boolean printing, GC gc, TimeBarRow row, int y, boolean selected) {
        if (row.getRowHeader() != null) {
            RenderDelegate.drawRowHeaderHorizontal(delegate, headerRenderer, printing, gc, y, row.getRowHeader(), selected, row);
        }
        if (hierarchyRenderer != null && delegate.getHierarchyWidth() > 0) {
            RenderDelegate.drawHierarchy(delegate, hierarchyRenderer, printing, gc, y, row, selected);
        }
        int rowHeight = delegate.getTimeBarViewState().getRowHeight(row);
        org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
        gc.setClipping(TimeBarViewer.convertRect(delegate.getDiagramRect()));
        if (delegate.getDrawRowGrid()) {
            Color fg = gc.getForeground();
            int ly = y + rowHeight - 1;
            if (delegate.getDiagramRect().y + delegate.getDiagramRect().height > ly) {
                gc.drawLine(delegate.getDiagramRect().x, ly, delegate.getDiagramRect().x + delegate.getDiagramRect().width, ly);
            }
            gc.setForeground(fg);
        }
        JaretDate start = delegate.getStartDate();
        JaretDate end = delegate.getEndDate();
        if (gc.isClipped()) {
            start = delegate.dateForCoord(gc.getClipping().x);
            end = delegate.dateForCoord(gc.getClipping().x + gc.getClipping().width);
        }
        List<Interval> intervals = row.getIntervals(start, end);
        for (Interval i : intervals) {
            if (delegate.getIntervalFilter() != null && !delegate.getIntervalFilter().isInResult(i)) continue;
            TimeBarRenderer renderer = tbPrinter.getRenderer(i.getClass());
            if (delegate.isDrawOverlapping()) {
                RenderDelegate.drawIntervalHorizontal(delegate, renderer, printing, gc, y, i, null, row);
                continue;
            }
            RenderDelegate.drawIntervalHorizontal(delegate, renderer, printing, gc, y, i, delegate.getOverlapStrategy().getOverlapInfo(row, i), row);
        }
        gc.setClipping(clipSave);
    }

    public static void drawRowGaps(TimeBarViewerDelegate delegate, TimeBarGapRenderer renderer, boolean printing, GC gc, int x, int y, TimeBarRow row, boolean selected) {
        JaretDate start = delegate.getStartDate();
        JaretDate end = delegate.getEndDate();
        if (gc.isClipped()) {
            start = delegate.dateForXY(gc.getClipping().x, gc.getClipping().y);
            end = delegate.dateForXY(gc.getClipping().x + gc.getClipping().width, gc.getClipping().y + gc.getClipping().height);
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        Interval firstInterval = null;
        for (Interval interval : row.getIntervals()) {
            if (delegate.getIntervalFilter() != null && !delegate.getIntervalFilter().isInResult(interval)) continue;
            if (interval.getEnd().compareTo(start) < 0) {
                if (firstInterval != null && start.diffMilliSeconds(interval.getEnd()) >= start.diffMilliSeconds(firstInterval.getEnd())) continue;
                firstInterval = interval;
                continue;
            }
            if (interval.contains(start)) {
                firstInterval = interval;
                continue;
            }
            if (firstInterval != null) {
                intervals.add(firstInterval);
                firstInterval = null;
            }
            if (interval.contains(end)) {
                intervals.add(interval);
                break;
            }
            if (interval.getBegin().compareTo(end) > 0) {
                intervals.add(interval);
                break;
            }
            intervals.add(interval);
        }
        Interval lastInterval = null;
        for (Interval i : intervals) {
            if (lastInterval != null) {
                RenderDelegate.drawGap(delegate, renderer, false, gc, row, x, y, lastInterval, i);
            }
            lastInterval = i;
        }
    }

    public static void drawIntervalHorizontal(TimeBarViewerDelegate delegate, TimeBarRenderer renderer, boolean printing, GC gc, int y, Interval interval, OverlapInfo oi, TimeBarRow row) {
        if (renderer != null) {
            int rowHeight = delegate.getTimeBarViewState().getRowHeight(row);
            int maxOverlapping = 1;
            int oiPos = 0;
            if (oi != null) {
                maxOverlapping = oi.maxOverlapping + 1;
                oiPos = oi.pos;
            }
            int height = rowHeight / maxOverlapping;
            int x = delegate.xForDate(interval.getBegin());
            int x2 = delegate.xForDate(interval.getEnd());
            int width = x2 - x;
            org.eclipse.swt.graphics.Rectangle intervalArea = new org.eclipse.swt.graphics.Rectangle(x, y += oiPos * height, width, height);
            boolean selected = delegate.getSelectionModel().isSelected(interval);
            boolean overlapping = oi != null ? oi.overlappingCount > 0 : false;
            org.eclipse.swt.graphics.Rectangle drawingArea = new org.eclipse.swt.graphics.Rectangle(intervalArea.x, intervalArea.y, intervalArea.width, intervalArea.height);
            if (renderer instanceof TimeBarRenderer2) {
                drawingArea = ((TimeBarRenderer2)((Object)renderer)).getPreferredDrawingBounds(intervalArea, delegate, interval, selected, printing, overlapping);
            }
            if (!gc.getClipping().intersects(drawingArea)) {
                return;
            }
            if (drawingArea.y + drawingArea.height > delegate.getDiagramRect().y + delegate.getDiagramRect().height) {
                height -= drawingArea.y + drawingArea.height - (delegate.getDiagramRect().y + delegate.getDiagramRect().height);
            }
            org.eclipse.swt.graphics.Rectangle clip = new org.eclipse.swt.graphics.Rectangle(drawingArea.x < delegate.getDiagramRect().x ? delegate.getDiagramRect().x : drawingArea.x, drawingArea.y, drawingArea.width, height);
            org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
            gc.setClipping(clip.intersection(clipSave));
            renderer.draw(gc, intervalArea, delegate, interval, selected, printing, overlapping);
            gc.setClipping(clipSave);
        }
    }

    public static void drawIntervalVertical(TimeBarViewerDelegate delegate, TimeBarRenderer renderer, boolean printing, GC gc, int x, Interval interval, OverlapInfo oi, TimeBarRow row) {
        if (renderer != null) {
            int rowHeight = delegate.getTimeBarViewState().getRowHeight(row);
            int maxOverlapping = 1;
            int oiPos = 0;
            if (oi != null) {
                maxOverlapping = oi.maxOverlapping + 1;
                oiPos = oi.pos;
            }
            int width = rowHeight / maxOverlapping;
            int y = delegate.xForDate(interval.getBegin());
            int y2 = delegate.xForDate(interval.getEnd());
            int height = y2 - y;
            org.eclipse.swt.graphics.Rectangle intervalArea = new org.eclipse.swt.graphics.Rectangle(x += oiPos * width, y, width, height);
            boolean selected = delegate.getSelectionModel().isSelected(interval);
            boolean overlapping = oi != null ? oi.overlappingCount > 0 : false;
            org.eclipse.swt.graphics.Rectangle drawingArea = new org.eclipse.swt.graphics.Rectangle(intervalArea.x, intervalArea.y, intervalArea.width, intervalArea.height);
            if (renderer instanceof TimeBarRenderer2) {
                drawingArea = ((TimeBarRenderer2)((Object)renderer)).getPreferredDrawingBounds(intervalArea, delegate, interval, selected, printing, overlapping);
            }
            if (!gc.getClipping().intersects(drawingArea)) {
                return;
            }
            if (drawingArea.x + drawingArea.width > delegate.getDiagramRect().x + delegate.getDiagramRect().width) {
                width -= drawingArea.x + drawingArea.width - (delegate.getDiagramRect().x + delegate.getDiagramRect().width);
            }
            org.eclipse.swt.graphics.Rectangle clip = new org.eclipse.swt.graphics.Rectangle(drawingArea.x, drawingArea.y < delegate.getDiagramRect().y ? delegate.getDiagramRect().y : drawingArea.y, width, drawingArea.height);
            org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
            gc.setClipping(clip.intersection(clipSave));
            renderer.draw(gc, intervalArea, delegate, interval, delegate.getSelectionModel().isSelected(interval), printing, oi.overlappingCount > 0);
            gc.setClipping(clipSave);
        }
    }

    public static void drawRowHeaderHorizontal(TimeBarViewerDelegate delegate, HeaderRenderer renderer, boolean printing, GC gc, int y, TimeBarRowHeader header, boolean selected, TimeBarRow row) {
        if (renderer != null && delegate.getYAxisWidth() > 0) {
            int x = delegate.getYAxisRect().x;
            int width = delegate.getYAxisWidth() - 1;
            int rowHeight = delegate.getTimeBarViewState().getRowHeight(row);
            org.eclipse.swt.graphics.Rectangle drawingArea = new org.eclipse.swt.graphics.Rectangle(x, y, width, rowHeight);
            int clipheight = rowHeight;
            if (y + rowHeight > delegate.getDiagramRect().y + delegate.getDiagramRect().height) {
                clipheight -= y + clipheight - (delegate.getDiagramRect().y + delegate.getDiagramRect().height);
            }
            org.eclipse.swt.graphics.Rectangle clip = new org.eclipse.swt.graphics.Rectangle(x, y, width, clipheight);
            org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
            gc.setClipping(clip.intersection(clipSave));
            renderer.draw(gc, drawingArea, delegate, header, selected, printing);
            gc.setClipping(clipSave);
        }
    }

    public static void drawRowHeaderVertical(TimeBarViewerDelegate delegate, HeaderRenderer renderer, boolean printing, GC gc, int x, TimeBarRowHeader header, boolean selected, TimeBarRow row) {
        if (renderer != null && delegate.getYAxisWidth() > 0) {
            int y = delegate.getYAxisRect().y;
            int height = delegate.getYAxisWidth() - 1;
            int rowWidth = delegate.getTimeBarViewState().getRowHeight(row);
            org.eclipse.swt.graphics.Rectangle drawingArea = new org.eclipse.swt.graphics.Rectangle(x, y, rowWidth, height);
            int clipwidth = rowWidth;
            if (x + rowWidth > delegate.getDiagramRect().x + delegate.getDiagramRect().width) {
                clipwidth -= x + clipwidth - (delegate.getDiagramRect().x + delegate.getDiagramRect().width);
            }
            org.eclipse.swt.graphics.Rectangle clip = new org.eclipse.swt.graphics.Rectangle(x, y, clipwidth, height);
            org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
            gc.setClipping(clip.intersection(clipSave));
            renderer.draw(gc, drawingArea, delegate, header, selected, printing);
            gc.setClipping(clipSave);
        }
    }

    public static void drawHierarchy(TimeBarViewerDelegate delegate, HierarchyRenderer renderer, boolean printing, GC gc, int y, TimeBarRow row, boolean selected) {
        if (renderer != null) {
            int rowHeight = delegate.getTimeBarViewState().getRowHeight(row);
            int level = 0;
            int depth = 0;
            boolean expanded = false;
            boolean leaf = true;
            if (row instanceof TimeBarNode) {
                TimeBarNode node = (TimeBarNode)row;
                if (delegate.getHierarchicalViewState().isExpanded(node)) {
                    expanded = true;
                }
                leaf = node.getChildren().size() == 0;
                level = node.getLevel();
                depth = delegate.getHierarchicalModel().getDepth();
            }
            int x = delegate.getHierarchyRect().x;
            int width = delegate.getHierarchyWidth() - 1;
            org.eclipse.swt.graphics.Rectangle drawingArea = new org.eclipse.swt.graphics.Rectangle(x, y, width, rowHeight);
            int clipheight = rowHeight;
            if (y + rowHeight > delegate.getDiagramRect().y + delegate.getDiagramRect().height) {
                clipheight -= y + clipheight - (delegate.getDiagramRect().y + delegate.getDiagramRect().height);
            }
            org.eclipse.swt.graphics.Rectangle clip = new org.eclipse.swt.graphics.Rectangle(x, y, width, clipheight);
            org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
            gc.setClipping(clip.intersection(clipSave));
            renderer.draw(gc, drawingArea, delegate, row, selected, expanded, leaf, level, depth, printing);
            gc.setClipping(clipSave);
        }
    }

    public static void drawHierarchyVertical(TimeBarViewerDelegate delegate, HierarchyRenderer renderer, boolean printing, GC gc, int x, TimeBarRow row, boolean selected) {
        if (renderer != null) {
            int level = 0;
            int depth = 0;
            boolean expanded = false;
            boolean leaf = true;
            if (row instanceof TimeBarNode) {
                TimeBarNode node = (TimeBarNode)row;
                if (delegate.getHierarchicalViewState().isExpanded(node)) {
                    expanded = true;
                }
                leaf = node.getChildren().size() == 0;
                level = node.getLevel();
                depth = delegate.getHierarchicalModel().getDepth();
            }
            int y = delegate.getHierarchyRect().y;
            int height = delegate.getHierarchyWidth() - 1;
            int rowWidth = delegate.getTimeBarViewState().getRowHeight(row);
            org.eclipse.swt.graphics.Rectangle drawingArea = new org.eclipse.swt.graphics.Rectangle(x, y, rowWidth, height);
            int clipwidth = rowWidth;
            if (x + rowWidth > delegate.getDiagramRect().x + delegate.getDiagramRect().width) {
                clipwidth -= x + clipwidth - (delegate.getDiagramRect().x + delegate.getDiagramRect().width);
            }
            org.eclipse.swt.graphics.Rectangle clip = new org.eclipse.swt.graphics.Rectangle(x, y, clipwidth, height);
            org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
            gc.setClipping(clip.intersection(clipSave));
            renderer.draw(gc, drawingArea, delegate, row, selected, expanded, leaf, level, depth, printing);
            gc.setClipping(clipSave);
        }
    }

    public static void drawXAxis(TimeBarViewerDelegate delegate, TimeScaleRenderer renderer, boolean printing, GC gc) {
        if (renderer != null && delegate.getTimeScalePosition() != 2) {
            org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
            gc.setClipping(RenderDelegate.convertRect(delegate.getXAxisRect()).intersection(clipSave));
            renderer.draw(gc, RenderDelegate.convertRect(delegate.getXAxisRect()), delegate, delegate.getTimeScalePosition() == 0, printing);
            gc.setClipping(clipSave);
        }
    }

    public static void drawGrid(TimeBarViewerDelegate delegate, GridRenderer gridRenderer, boolean printing, GC gc) {
        if (gridRenderer != null) {
            org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
            gc.setClipping(RenderDelegate.convertRect(delegate.getDiagramRect()).intersection(clipSave));
            gridRenderer.draw(gc, delegate, RenderDelegate.convertRect(delegate.getDiagramRect()), printing);
            gc.setClipping(clipSave);
        }
    }

    public static void drawTitle(TimeBarViewerDelegate delegate, TitleRenderer titleRenderer, boolean printing, GC gc) {
        if (titleRenderer != null && delegate.getTimeScalePosition() != 2) {
            org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
            gc.setClipping(RenderDelegate.convertRect(delegate.getTitleRect()).intersection(clipSave));
            titleRenderer.draw(gc, RenderDelegate.convertRect(delegate.getTitleRect()), delegate, delegate.getTitle(), printing);
            gc.setClipping(clipSave);
        }
    }

    public static void drawMarkers(TimeBarViewerDelegate delegate, TimeBarMarkerRenderer renderer, boolean printing, GC gc) {
        if (delegate.getMarkers() != null) {
            for (TimeBarMarker marker : delegate.getMarkers()) {
                if (!delegate.isDisplayed(marker.getDate())) continue;
                RenderDelegate.drawMarker(delegate, renderer, printing, gc, marker);
            }
        }
    }

    public static void drawMarker(TimeBarViewerDelegate delegate, TimeBarMarkerRenderer renderer, boolean printing, GC gc, TimeBarMarker marker) {
        if (renderer != null) {
            boolean isDragged = false;
            if (delegate.getDraggedMarker() == marker) {
                isDragged = true;
            }
            renderer.draw(gc, delegate, marker, isDragged, printing);
        }
    }

    public static void drawGap(TimeBarViewerDelegate delegate, TimeBarGapRenderer renderer, boolean printing, GC gc, TimeBarRow row, int xx, int y, Interval i1, Interval i2) {
        if (renderer != null) {
            if (delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                int x = delegate.xForDate(i1.getEnd());
                int width = delegate.xForDate(i2.getBegin()) - x;
                int height = delegate.getTimeBarViewState().getRowHeight(row);
                org.eclipse.swt.graphics.Rectangle drawingArea = new org.eclipse.swt.graphics.Rectangle(x, y, width, height);
                if (y + height > delegate.getDiagramRect().y + delegate.getDiagramRect().height) {
                    height -= y + height - (delegate.getDiagramRect().y + delegate.getDiagramRect().height);
                }
                org.eclipse.swt.graphics.Rectangle clip = new org.eclipse.swt.graphics.Rectangle(x < delegate.getDiagramRect().x ? delegate.getDiagramRect().x : x, y, width, height);
                org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
                gc.setClipping(clip.intersection(clipSave));
                renderer.draw(gc, delegate, row, i1, i2, drawingArea, printing);
                gc.setClipping(clipSave);
            } else {
                int yy = delegate.xForDate(i1.getEnd());
                int height = delegate.xForDate(i2.getBegin()) - yy;
                int width = delegate.getTimeBarViewState().getRowHeight(row);
                org.eclipse.swt.graphics.Rectangle drawingArea = new org.eclipse.swt.graphics.Rectangle(xx, yy, width, height);
                if (xx + width > delegate.getDiagramRect().x + delegate.getDiagramRect().width) {
                    width -= xx + width - (delegate.getDiagramRect().x + delegate.getDiagramRect().width);
                }
                org.eclipse.swt.graphics.Rectangle clip = new org.eclipse.swt.graphics.Rectangle(xx, yy < delegate.getDiagramRect().y ? delegate.getDiagramRect().y : yy, width, height);
                org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
                gc.setClipping(clip.intersection(clipSave));
                renderer.draw(gc, delegate, row, i1, i2, drawingArea, printing);
                gc.setClipping(clipSave);
            }
        }
    }

    private static org.eclipse.swt.graphics.Rectangle convertRect(Rectangle rect) {
        return new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
    }
}

