/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt;

import de.jaret.util.date.Interval;
import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.ViewConfiguration;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.swt.RenderDelegate;
import de.jaret.util.ui.timebars.swt.TimeBarViewer;
import de.jaret.util.ui.timebars.swt.renderer.GlobalAssistantRenderer;
import de.jaret.util.ui.timebars.swt.renderer.GridRenderer;
import de.jaret.util.ui.timebars.swt.renderer.HeaderRenderer;
import de.jaret.util.ui.timebars.swt.renderer.HierarchyRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarGapRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarMarkerRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeScaleRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TitleRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.Printer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBarPrinter {
    private static final double DEFAULT_MARGIN = 1.0;
    private static final double DEFAULT_FOOTER_HEIGHT = 0.5;
    private static final double SCREEN_DPI_X = 96.0;
    private static final double SCREEN_DPI_Y = 96.0;
    private static final double INCH_IN_CM = 2.54;
    private static final String PRINTERFONTNAME = "Sans";
    private static final int PRINTERFONTSIZE = 6;
    protected Printer _printer;
    protected double _scaleX;
    protected double _scaleY;
    protected TimeScaleRenderer _timeScaleRenderer;
    protected HeaderRenderer _headerRenderer;
    protected TimeBarRenderer _renderer;
    protected HierarchyRenderer _hierarchyRenderer;
    protected GridRenderer _gridRenderer;
    protected TimeBarGapRenderer _gapRenderer;
    protected TimeBarMarkerRenderer _markerRenderer;
    protected TitleRenderer _titleRenderer;
    protected GlobalAssistantRenderer _globalAssistantRenderer;
    protected Map<Class<? extends Interval>, TimeBarRenderer> _printerRendererMap = new HashMap<Class<? extends Interval>, TimeBarRenderer>();
    protected TimeBarViewerDelegate _delegate = new TimeBarViewerDelegate(null);
    protected double _footerHeight = 0.5;
    protected double _marginTop = 1.0;
    protected double _marginBottom = 1.0;
    protected double _marginLeft = 1.0;
    protected double _marginRight = 1.0;

    public TimeBarPrinter(Printer printer) {
        this._printer = printer;
        Point dpi = this._printer.getDPI();
        this._scaleX = (double)dpi.x / 96.0;
        this._scaleY = (double)dpi.y / 96.0;
    }

    public int scaleX(int in) {
        return (int)Math.round(this._scaleX * (double)in);
    }

    public double getScaleX() {
        return this._scaleX;
    }

    public int scaleY(int in) {
        return (int)Math.round(this._scaleY * (double)in);
    }

    public double getScaleY() {
        return this._scaleY;
    }

    protected int pixelForCmX(double cm) {
        Point dpi = this._printer.getDPI();
        double inch = cm / 2.54;
        return (int)((double)dpi.x * inch);
    }

    protected int pixelForCmY(double cm) {
        Point dpi = this._printer.getDPI();
        double inch = cm / 2.54;
        return (int)((double)dpi.y * inch);
    }

    public Printer getPrinter() {
        return this._printer;
    }

    public TimeBarViewerDelegate getDelegate() {
        return this._delegate;
    }

    public void init(TimeBarViewer tbv) {
        this._delegate.setOptimizeScrolling(false);
        if (tbv.getTimeScaleRenderer() != null) {
            this._timeScaleRenderer = tbv.getTimeScaleRenderer().createPrintRenderer(this._printer);
        }
        if (tbv.getHeaderRenderer() != null) {
            this._headerRenderer = tbv.getHeaderRenderer().createPrintRenderer(this._printer);
        }
        if (tbv.getGridRenderer() != null) {
            this._gridRenderer = tbv.getGridRenderer().createPrintRenderer(this._printer);
        }
        if (tbv.getHierarchyRenderer() != null) {
            this._hierarchyRenderer = tbv.getHierarchyRenderer().createPrintRenderer(this._printer);
        }
        if (tbv.getGapRenderer() != null) {
            this._gapRenderer = tbv.getGapRenderer().createPrintRenderer(this._printer);
        }
        if (tbv.getMarkerRenderer() != null) {
            this._markerRenderer = tbv.getMarkerRenderer().createPrintRenderer(this._printer);
        }
        if (tbv.getTitleRenderer() != null) {
            this._titleRenderer = tbv.getTitleRenderer().createPrintRenderer(this._printer);
        }
        if (tbv.getGlobalAssistantRenderer() != null) {
            this._globalAssistantRenderer = tbv.getGlobalAssistantRenderer().createPrintRenderer(this._printer);
        }
        Map<Class<? extends Interval>, TimeBarRenderer> rendererMap = tbv.getRendererMapping();
        for (Class<? extends Interval> clazz : rendererMap.keySet()) {
            TimeBarRenderer displayRenderer = rendererMap.get(clazz);
            TimeBarRenderer printRenderer = displayRenderer.createPrintrenderer(this._printer);
            this._printerRendererMap.put(clazz, printRenderer);
        }
        boolean horizontal = tbv.getOrientation().equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL);
        this._delegate.setOrientation(tbv.getOrientation());
        this._delegate.addMarkers(tbv.getMarkers());
        this._delegate.setModel(tbv.getHierarchicalModel());
        this._delegate.setHierarchicalViewState(tbv.getHierarchicalViewState());
        this._delegate.setModel(tbv.getModel());
        this._delegate.setXAxisHeight(this.scaleY(tbv.getXAxisHeight()));
        if (this._timeScaleRenderer.getHeight() > 0) {
            this._delegate.setXAxisHeight(this._timeScaleRenderer.getHeight());
        }
        this._delegate.setTimeScalePosition(tbv.getTimeScalePosition());
        this._delegate.setYAxisWidth(this.scaleX(tbv.getYAxisWidth()));
        this._delegate.setHierarchyWidth(this.scaleX(tbv.getHierarchyWidth()));
        this._delegate.setRowHeight(this.scaleY(tbv.getRowHeight()));
        if (tbv.getTimeBarViewState().getUseVariableRowHeights()) {
            this._delegate.getTimeBarViewState().setUseVariableRowHeights(true);
            for (int i = 0; i < tbv.getModel().getRowCount(); ++i) {
                TimeBarRow row = tbv.getModel().getRow(i);
                int height = tbv.getTimeBarViewState().getRowHeight(row);
                height = horizontal ? this.scaleY(height) : this.scaleX(height);
                this._delegate.getTimeBarViewState().setRowHeight(row, height);
            }
            this._delegate.getTimeBarViewState().setRowHeightStrategy(tbv.getTimeBarViewState().getRowHeightStrategy());
        }
        this._delegate.setDrawRowGrid(tbv.getDrawRowGrid());
        this._delegate.setRowSorter(tbv.getRowSorter());
        this._delegate.setRowFilter(tbv.getRowFilter());
        this._delegate.setIntervalFilter(tbv.getIntervalFilter());
        this._delegate.setDrawOverlapping(tbv.getDrawOverlapping());
        this._delegate.setTitle(tbv.getTitle());
    }

    protected TimeBarRenderer getRenderer(Class<? extends Interval> clazz) {
        Class<?>[] interfaces;
        TimeBarRenderer result = null;
        result = this._printerRendererMap.get(clazz);
        if (result != null) {
            return result;
        }
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            result = this._printerRendererMap.get(c);
            if (result == null) continue;
            return result;
        }
        for (Class<? extends Interval> sc = clazz.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            Class<?>[] scinterfaces;
            result = this._printerRendererMap.get(sc);
            if (result != null) {
                return result;
            }
            for (Class<?> c : scinterfaces = sc.getInterfaces()) {
                result = this._printerRendererMap.get(c);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public void print(ViewConfiguration vc) {
        int pagesX;
        int marginTop = this.pixelForCmY(this._marginTop);
        int marginBottom = this.pixelForCmY(this._marginBottom);
        int marginLeft = this.pixelForCmX(this._marginLeft);
        int marginRight = this.pixelForCmX(this._marginRight);
        int footerHeight = this.pixelForCmX(this._footerHeight);
        int width = this._printer.getClientArea().width - marginLeft - marginRight;
        int height = this._printer.getClientArea().height - marginTop - marginBottom - footerHeight;
        this._printer.startJob(vc.getName() != null ? vc.getName() : "timebars_print");
        GC gc = new GC((Drawable)this._printer);
        Font oldfont = gc.getFont();
        FontData fontdata = new FontData(PRINTERFONTNAME, 6, 0);
        Font printerFont = new Font((Device)this._printer, fontdata);
        gc.setFont(printerFont);
        int secTotal = vc.getEndDate() != null ? vc.getEndDate().diffSeconds(vc.getStartDate()) : this._delegate.getModel().getMaxDate().diffSeconds(vc.getStartDate());
        int totalyaxiswidth = this._delegate.getHierarchyWidth() + this._delegate.getYAxisWidth();
        this._delegate.setDrawingOffset(marginLeft, marginTop);
        this._delegate.preparePaint(width, height);
        double pps = (double)this._delegate.getDiagramRect().width / (double)vc.getSecondsPerPage();
        this._delegate.setPixelPerSecond(pps);
        long totalPixelWidth = (long)((double)secTotal * pps);
        if (vc.getRepeatYAxis()) {
            pagesX = secTotal / vc.getSecondsPerPage();
            if (secTotal % vc.getSecondsPerPage() > 0) {
                ++pagesX;
            }
        } else if (secTotal <= vc.getSecondsPerPage()) {
            pagesX = 1;
        } else {
            long remain = totalPixelWidth;
            pagesX = 0;
            ++pagesX;
            pagesX = (int)((long)pagesX + (remain -= (long)this._delegate.getDiagramRect().width) / (long)(this._delegate.getDiagramRect().width + totalyaxiswidth));
            if (remain % (long)(this._delegate.getDiagramRect().width + totalyaxiswidth) > 0L) {
                ++pagesX;
            }
        }
        ArrayList<Integer> firstRows = new ArrayList<Integer>();
        ArrayList<Integer> firstRowOffsets = new ArrayList<Integer>();
        int y = 0;
        int pageIdx = 0;
        int rowIdx = 0;
        while (rowIdx < this._delegate.getRowCount()) {
            rowIdx = this._delegate.getRowIdxForAbsoluteOffset(y);
            firstRows.add(rowIdx);
            firstRowOffsets.add(this._delegate.getRowPixOffsetForAbsoluteOffset(rowIdx, y));
            y = vc.getRepeatScale() || pageIdx == 0 ? (y += this._delegate.getDiagramRect().height) : (y += this._delegate.getDiagramRect().height + this._delegate.getXAxisHeight());
            ++pageIdx;
            try {
                rowIdx = this._delegate.getRowIdxForAbsoluteOffset(y);
            }
            catch (Exception e) {
                rowIdx = -1;
            }
            if (rowIdx < this._delegate.getRowCount() && rowIdx != -1) continue;
        }
        int pagesY = pageIdx;
        int xaxisheigth = this._delegate.getXAxisHeight();
        int yaxisWidth = this._delegate.getYAxisWidth();
        int hierarchyWidth = this._delegate.getHierarchyWidth();
        JaretDate pageStart = vc.getStartDate().copy();
        for (int px = 0; px < pagesX; ++px) {
            this._delegate.setStartDate(pageStart);
            for (int py = 0; py < pagesY; ++py) {
                String footerText = vc.getFootLine() != null ? vc.getFootLine() : "";
                footerText = footerText + "(" + (px + 1) + "/" + pagesX + "," + (py + 1) + "/" + pagesY + ")";
                this._printer.startPage();
                if (vc.getRepeatScale() || py == 0 && this._delegate.getTimeScalePosition() == 0 || py == pagesY - 1 && this._delegate.getTimeScalePosition() == 1) {
                    this._delegate.setXAxisHeight(xaxisheigth);
                } else {
                    this._delegate.setXAxisHeight(0);
                }
                if (vc.getRepeatYAxis() || px == 0) {
                    this._delegate.setHierarchyWidth(hierarchyWidth);
                    this._delegate.setYAxisWidth(yaxisWidth);
                } else {
                    this._delegate.setHierarchyWidth(0);
                    this._delegate.setYAxisWidth(0);
                }
                this._delegate.preparePaint(width, height);
                this.print(gc, footerText, (Integer)firstRows.get(py), (Integer)firstRowOffsets.get(py), this._delegate.getDiagramRect().height, footerHeight);
                this._printer.endPage();
            }
            pageStart = this._delegate.getEndDate().copy();
        }
        this._printer.endJob();
        gc.setFont(oldfont);
        printerFont.dispose();
        gc.dispose();
    }

    private void print(GC gc, String footer, int firstRow, int firstRowOffset, int diagramHeight, int footerHeight) {
        this._delegate.setFirstRow(firstRow, firstRowOffset);
        RenderDelegate.drawGrid(this._delegate, this._gridRenderer, true, gc);
        if (this._globalAssistantRenderer != null) {
            this._globalAssistantRenderer.doRenderingBeforeIntervals(this._delegate, gc, true);
        }
        RenderDelegate.drawXAxis(this._delegate, this._timeScaleRenderer, true, gc);
        this.drawRows(gc);
        RenderDelegate.drawMarkers(this._delegate, this._markerRenderer, true, gc);
        if (this._delegate.getTitleRect().width > 0 && this._delegate.getTitleRect().height > 0) {
            RenderDelegate.drawTitle(this._delegate, this._titleRenderer, true, gc);
        }
        if (footer != null) {
            this.drawFooter(gc, footer, this._delegate.getDiagramRect().y + this._delegate.getDiagramRect().height, footerHeight);
        }
        if (this._globalAssistantRenderer != null) {
            this._globalAssistantRenderer.doRenderingLast(this._delegate, gc, true);
        }
        Color bg = gc.getBackground();
        gc.fillRectangle(this._delegate.getDiagramRect().x + this._delegate.getDiagramRect().width, this._delegate.getDiagramRect().y, this.pixelForCmX(this._marginLeft), this._delegate.getDiagramRect().height);
        gc.setBackground(bg);
    }

    private void drawFooter(GC gc, String footer, int footerStartY, int footerHeight) {
        Point extent = gc.textExtent(footer);
        int y = footerStartY + (footerHeight - extent.y) / 2;
        gc.drawString(footer, this._delegate.getHierarchyRect().x, y);
    }

    private void drawRows(GC gc) {
        TimeBarRow row;
        int y;
        int firstRow = this._delegate.getFirstRow();
        int startY = Math.min(this._delegate.getXAxisRect().y, this._delegate.getDiagramRect().y);
        int endY = Math.max(this._delegate.getXAxisRect().y + this._delegate.getXAxisRect().height, this._delegate.getDiagramRect().y + this._delegate.getDiagramRect().height);
        if (this._delegate.getYAxisWidth() > 0) {
            gc.drawLine(this._delegate.getDiagramRect().x - 1, startY, this._delegate.getDiagramRect().x - 1, endY);
        }
        if (this._delegate.getHierarchyWidth() > 0) {
            gc.drawLine(this._delegate.getHierarchyRect().x + this._delegate.getHierarchyRect().width - 1, startY, this._delegate.getHierarchyRect().x + this._delegate.getHierarchyRect().width - 1, endY);
        }
        int upperYBound = 0;
        int lowerYBound = this._printer.getClientArea().height;
        if (gc.isClipped()) {
            upperYBound = gc.getClipping().y;
            lowerYBound = upperYBound + gc.getClipping().height;
        }
        for (int r = firstRow; r <= firstRow + this._delegate.getRowsDisplayed() + 1 && r < this._delegate.getRowCount() && (y = this._delegate.yForRow(row = this._delegate.getRow(r))) != -1; ++r) {
            int rowHeight = this._delegate.getTimeBarViewState().getRowHeight(row);
            if (!(y >= upperYBound && y <= lowerYBound || y + rowHeight >= upperYBound && y + rowHeight <= lowerYBound) && (upperYBound <= y || upperYBound >= y + rowHeight)) continue;
            RenderDelegate.drawRowSimple(this._delegate, this, this._headerRenderer, this._hierarchyRenderer, true, gc, this._delegate.getRow(r), y, false);
            if (this._gapRenderer == null) continue;
            RenderDelegate.drawRowGaps(this._delegate, this._gapRenderer, true, gc, 0, y, this._delegate.getRow(r), false);
        }
    }

    public void dispose() {
        this._delegate.dispose();
        if (this._headerRenderer != null) {
            this._headerRenderer.dispose();
        }
        if (this._timeScaleRenderer != null) {
            this._timeScaleRenderer.dispose();
        }
        if (this._renderer != null) {
            this._renderer.dispose();
        }
        if (this._hierarchyRenderer != null) {
            this._hierarchyRenderer.dispose();
        }
        if (this._gridRenderer != null) {
            this._gridRenderer.dispose();
        }
        if (this._markerRenderer != null) {
            this._markerRenderer.dispose();
        }
        if (this._titleRenderer != null) {
            this._titleRenderer.dispose();
        }
        if (this._gapRenderer != null) {
            this._gapRenderer.dispose();
        }
        if (this._globalAssistantRenderer != null) {
            this._globalAssistantRenderer.dispose();
        }
        for (TimeBarRenderer renderer : this._printerRendererMap.values()) {
            renderer.dispose();
        }
    }

    public double getFooterHeight() {
        return this._footerHeight;
    }

    public void setFooterHeight(double footerHeight) {
        this._footerHeight = footerHeight;
    }

    public double getMarginTop() {
        return this._marginTop;
    }

    public void setMarginTop(double marginTop) {
        this._marginTop = marginTop;
    }

    public double getMarginBottom() {
        return this._marginBottom;
    }

    public void setMarginBottom(double marginBottom) {
        this._marginBottom = marginBottom;
    }

    public double getMarginLeft() {
        return this._marginLeft;
    }

    public void setMarginLeft(double marginLeft) {
        this._marginLeft = marginLeft;
    }

    public double getMarginRight() {
        return this._marginRight;
    }

    public void setMarginRight(double marginRight) {
        this._marginRight = marginRight;
    }
}

