/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt;

import de.jaret.util.date.Interval;
import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.TimeBarIntervalFilter;
import de.jaret.util.ui.timebars.TimeBarMarker;
import de.jaret.util.ui.timebars.TimeBarRowFilter;
import de.jaret.util.ui.timebars.TimeBarRowSorter;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.mod.IntervalModificator;
import de.jaret.util.ui.timebars.model.FocussedIntervalListener;
import de.jaret.util.ui.timebars.model.HierarchicalTimeBarModel;
import de.jaret.util.ui.timebars.model.HierarchicalViewState;
import de.jaret.util.ui.timebars.model.ITimeBarChangeListener;
import de.jaret.util.ui.timebars.model.ITimeBarViewState;
import de.jaret.util.ui.timebars.model.TimeBarModel;
import de.jaret.util.ui.timebars.model.TimeBarNode;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.model.TimeBarSelectionModel;
import de.jaret.util.ui.timebars.model.TimeBarSelectionModelImpl;
import de.jaret.util.ui.timebars.strategy.IOverlapStrategy;
import de.jaret.util.ui.timebars.swt.RenderDelegate;
import de.jaret.util.ui.timebars.swt.RowContextMenuHandler;
import de.jaret.util.ui.timebars.swt.renderer.DefaultGridRenderer;
import de.jaret.util.ui.timebars.swt.renderer.DefaultHeaderRenderer;
import de.jaret.util.ui.timebars.swt.renderer.DefaultRenderer;
import de.jaret.util.ui.timebars.swt.renderer.DefaultTimeBarMarkerRenderer;
import de.jaret.util.ui.timebars.swt.renderer.DefaultTimeScaleRenderer;
import de.jaret.util.ui.timebars.swt.renderer.DefaultTitleRenderer;
import de.jaret.util.ui.timebars.swt.renderer.GlobalAssistantRenderer;
import de.jaret.util.ui.timebars.swt.renderer.GridRenderer;
import de.jaret.util.ui.timebars.swt.renderer.HeaderRenderer;
import de.jaret.util.ui.timebars.swt.renderer.HierarchyRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarGapRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarMarkerRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeScaleRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TitleRenderer;
import de.jaret.util.ui.timebars.swt.util.actions.JaretTimeBarsActionFactory;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBarViewer
extends Canvas
implements TimeBarViewerInterface,
ISelectionProvider {
    private static final boolean SHOWPAINTTIME = false;
    public static final Color ROWGRID_COLOR = Display.getCurrent().getSystemColor(15);
    public static final Color HIGHLIGHT_COLOR = new Color((Device)Display.getCurrent(), 255, 200, 200);
    public static final int DEFAULT_ALPHA = 70;
    public static final Color ROWSELECT_COLOR = Display.getCurrent().getSystemColor(9);
    protected static final int INCREMENTDIVISOR_X = 10;
    protected static final int INCREMENTDIVISOR_Y = 10;
    protected static final Color LINECOLOR = Display.getCurrent().getSystemColor(2);
    protected Color _rowGridColor = ROWGRID_COLOR;
    protected Color _highlightColor = HIGHLIGHT_COLOR;
    protected int _highlightAlpha = 70;
    protected Color _rowSelectColor = ROWSELECT_COLOR;
    protected int _ghostAlpha = 70;
    private static final int POPUP_BUTTON = 3;
    private static final double MOUSEWHEEL_FACTOR = 2.5;
    protected TimeBarViewerDelegate _delegate;
    protected TimeScaleRenderer _timeScaleRenderer = new DefaultTimeScaleRenderer();
    protected Map<Class<? extends Interval>, TimeBarRenderer> _rendererMap = new HashMap<Class<? extends Interval>, TimeBarRenderer>();
    protected HierarchyRenderer _hierarchyRenderer;
    protected GridRenderer _gridRenderer = new DefaultGridRenderer();
    protected GlobalAssistantRenderer _globalRenderer;
    protected TimeBarGapRenderer _gapRenderer = null;
    protected HeaderRenderer _headerRenderer = new DefaultHeaderRenderer();
    protected TimeBarMarkerRenderer _markerRenderer = new DefaultTimeBarMarkerRenderer();
    protected TitleRenderer _titleRenderer = new DefaultTitleRenderer();
    protected JaretTimeBarsActionFactory _actionFactory;
    protected Menu _bodyContextMenu;
    protected Menu _intervalContextMenu;
    protected Menu _scaleContextMenu;
    protected Menu _titleContextMenu;
    protected RowContextMenuHandler _hierarchyCtxHandler;
    protected RowContextMenuHandler _headerCtxHandler;
    protected PropertyChangeSupport _propertyChangeSupport;
    protected List<ISelectionChangedListener> _selectionChangeListeners;
    protected List<Interval> _ghostIntervals;
    protected List<Integer> _ghostIntervalYCoordinates;
    protected Point _ghostOrigin;
    protected List<TimeBarRow> _ghostRows;
    protected List<Integer> _ghostRowYCoordinates;

    public TimeBarViewer(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x20000000);
        ScrollBar horizontalBar;
        this._delegate = new TimeBarViewerDelegate(this);
        this.setData("delegate", this._delegate);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                TimeBarViewer.this.onPaint(event);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent me) {
            }

            public void mouseDown(MouseEvent me) {
                TimeBarViewer.this.forceFocus();
                TimeBarViewer.this._delegate.mousePressed(me.x, me.y, me.button == 3, TimeBarViewer.this.convertModifierMaskToSwing(me.stateMask));
            }

            public void mouseUp(MouseEvent me) {
                TimeBarViewer.this._delegate.mouseReleased(me.x, me.y, me.button == 3, TimeBarViewer.this.convertModifierMaskToSwing(me.stateMask));
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent me) {
                if ((me.stateMask & 0x80000) != 0) {
                    TimeBarViewer.this._delegate.mouseDragged(me.x, me.y);
                } else {
                    TimeBarViewer.this._delegate.mouseMoved(me.x, me.y);
                }
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent arg0) {
            }

            public void mouseExit(MouseEvent arg0) {
            }

            public void mouseHover(MouseEvent me) {
                TimeBarViewer.this.setToolTipText(TimeBarViewer.this._delegate.getToolTipText(me.x, me.y));
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                TimeBarViewer.this._delegate.handleKeyPressed(TimeBarViewer.this.convertKeyCodeToSwing(e.keyCode), TimeBarViewer.this.convertModifierMaskToSwing(e.stateMask));
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TimeBarViewer.this.onDispose();
            }
        });
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null) {
            verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TimeBarViewer.this.handleVerticalScroll(event);
                }
            });
        }
        if ((horizontalBar = this.getHorizontalBar()) != null) {
            horizontalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TimeBarViewer.this.handleHorizontalScroll(event);
                }
            });
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 11: {
                        TimeBarViewer.this._delegate.updateScrollBars();
                        break;
                    }
                }
            }
        };
        this.addListener(11, listener);
        this.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if ((event.stateMask & 0x40000) != 0) {
                    int c = event.count;
                    double factor = (double)Math.abs(c) / 2.5;
                    if (c > 0) {
                        TimeBarViewer.this._delegate.setPixelPerSecond(TimeBarViewer.this._delegate.getPixelPerSecond() * factor);
                    } else {
                        TimeBarViewer.this._delegate.setPixelPerSecond(TimeBarViewer.this._delegate.getPixelPerSecond() / factor);
                    }
                }
            }
        });
        this.registerTimeBarRenderer(Interval.class, new DefaultRenderer());
        this.setBackground(Display.getCurrent().getSystemColor(1));
    }

    public void onDispose() {
        super.dispose();
        this._delegate.dispose();
        HIGHLIGHT_COLOR.dispose();
        if (this._hierarchyRenderer != null) {
            this._hierarchyRenderer.dispose();
        }
        if (this._headerRenderer != null) {
            this._headerRenderer.dispose();
        }
        if (this._timeScaleRenderer != null) {
            this._timeScaleRenderer.dispose();
        }
        if (this._gridRenderer != null) {
            this._gridRenderer.dispose();
        }
        if (this._gapRenderer != null) {
            this._gapRenderer.dispose();
        }
        this.disposeTimeBarRenderers();
        if (this._markerRenderer != null) {
            this._markerRenderer.dispose();
        }
        if (this._titleRenderer != null) {
            this._titleRenderer.dispose();
        }
        if (this._globalRenderer != null) {
            this._globalRenderer.dispose();
        }
    }

    private void disposeTimeBarRenderers() {
        for (TimeBarRenderer tbr : this._rendererMap.values()) {
            tbr.dispose();
        }
    }

    @Override
    public int getWidth() {
        return this.getClientArea().width;
    }

    @Override
    public int getHeight() {
        return this.getClientArea().height;
    }

    @Override
    public void repaint() {
        this.redraw();
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        this.redraw(x, y, width, height, false);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private int convertModifierMaskToSwing(int stateMask) {
        int mask = 0;
        if ((stateMask & 0x40000) != 0) {
            mask |= 0x80;
        }
        if ((stateMask & 0x20000) != 0) {
            mask |= 0x40;
        }
        if ((stateMask & 0x10000) != 0) {
            mask |= 0x200;
        }
        return mask;
    }

    private int convertKeyCodeToSwing(int keyCode) {
        int result = keyCode;
        switch (keyCode) {
            case 0x1000003: {
                result = 37;
                break;
            }
            case 0x1000004: {
                result = 39;
                break;
            }
            case 0x1000001: {
                result = 38;
                break;
            }
            case 0x1000002: {
                result = 40;
                break;
            }
            case 32: {
                result = 32;
                break;
            }
            case 27: {
                result = 27;
                break;
            }
            default: {
                result = keyCode;
            }
        }
        return result;
    }

    private void handleHorizontalScroll(SelectionEvent event) {
        int value = this.getHorizontalBar().getSelection();
        this._delegate.handleHorizontalScroll(value, true);
    }

    private void handleVerticalScroll(SelectionEvent event) {
        int value = this.getVerticalBar().getSelection();
        this._delegate.handleVerticalScroll(value, true);
    }

    @Override
    public void updateXScrollBar(int max, int pos, int secondsDisplayed) {
        ScrollBar scroll = this.getHorizontalBar();
        if (scroll != null) {
            scroll.setMinimum(0);
            scroll.setMaximum(max);
            scroll.setThumb(secondsDisplayed);
            scroll.setIncrement(secondsDisplayed / 10);
            scroll.setPageIncrement(secondsDisplayed);
            scroll.setSelection(pos);
        }
    }

    @Override
    public void updateYScrollBar(int max, int pos, int rowsDisplayed) {
        ScrollBar scroll = this.getVerticalBar();
        if (scroll != null) {
            scroll.setMinimum(0);
            scroll.setMaximum(max);
            scroll.setThumb(rowsDisplayed);
            scroll.setIncrement(rowsDisplayed / 10);
            scroll.setPageIncrement(rowsDisplayed);
            scroll.setSelection(pos);
        }
    }

    @Override
    public int xForDate(JaretDate date) {
        return this._delegate.xForDate(date);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint != -1 || hHint != -1) {
            return new Point(wHint != -1 ? wHint : 100, hHint != -1 ? hHint : 100);
        }
        Point e = new Point((int)((double)this._delegate.getTotalSeconds() * this._delegate.getPixelPerSecond()), this._delegate.getRowCount() * this._delegate.getTimeBarViewState().getDefaultRowHeight());
        return e;
    }

    @Override
    public void setModel(TimeBarModel model) {
        this._delegate.setModel(model);
    }

    @Override
    public void setModel(HierarchicalTimeBarModel hModel) {
        this._delegate.setModel(hModel);
    }

    @Override
    public TimeBarModel getModel() {
        return this._delegate.getModel();
    }

    @Override
    public HierarchicalTimeBarModel getHierarchicalModel() {
        return this._delegate.getHierarchicalModel();
    }

    @Override
    public HierarchicalViewState getHierarchicalViewState() {
        return this._delegate.getHierarchicalViewState();
    }

    @Override
    public void setHierarchicalViewState(HierarchicalViewState hierarchicalViewState) {
        this._delegate.setHierarchicalViewState(hierarchicalViewState);
    }

    public void setTimeBarRenderer(TimeBarRenderer renderer) {
        this.registerTimeBarRenderer(Interval.class, renderer);
    }

    public TimeBarRenderer getTimeBarRenderer() {
        return this._rendererMap.get(Interval.class);
    }

    public void registerTimeBarRenderer(Class<? extends Interval> intervalClass, TimeBarRenderer renderer) {
        this._rendererMap.put(intervalClass, renderer);
        this.repaint();
    }

    public Map<Class<? extends Interval>, TimeBarRenderer> getRendererMapping() {
        return this._rendererMap;
    }

    protected TimeBarRenderer getRenderer(Class<? extends Interval> clazz) {
        Class<?>[] interfaces;
        TimeBarRenderer result = null;
        result = this._rendererMap.get(clazz);
        if (result != null) {
            return result;
        }
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            result = this._rendererMap.get(c);
            if (result == null) continue;
            return result;
        }
        for (Class<? extends Interval> sc = clazz.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            Class<?>[] scinterfaces;
            result = this._rendererMap.get(sc);
            if (result != null) {
                return result;
            }
            for (Class<?> c : scinterfaces = sc.getInterfaces()) {
                result = this._rendererMap.get(c);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    @Override
    public void firePropertyChange(String string, double oldValue, double newValue) {
        this.firePropertyChangeX(string, new Double(oldValue), new Double(newValue));
    }

    @Override
    public void firePropertyChangeX(String propName, Object oldVal, Object newVal) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(propName, oldVal, newVal);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    synchronized void onPaint(PaintEvent event) {
        GC gc = event.gc;
        this._delegate.preparePaint(this.getWidth(), this.getHeight());
        this._delegate.updateScrollBars();
        long time = System.currentTimeMillis();
        long ntime = System.nanoTime();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(gc.getClipping());
        try {
            RenderDelegate.drawXAxis(this._delegate, this._timeScaleRenderer, false, gc);
            RenderDelegate.drawGrid(this._delegate, this._gridRenderer, false, gc);
            if (this._globalRenderer != null) {
                this._globalRenderer.doRenderingBeforeIntervals(this._delegate, gc, false);
            }
            this.drawRows(gc);
            RenderDelegate.drawMarkers(this._delegate, this._markerRenderer, false, gc);
            this.drawSelectionRect(gc);
            RenderDelegate.drawTitle(this._delegate, this._titleRenderer, false, gc);
            if (this._globalRenderer != null) {
                this._globalRenderer.doRenderingLast(this._delegate, gc, false);
            }
            this.drawGhosts(gc);
            time = System.currentTimeMillis() - time;
            ntime = System.nanoTime() - ntime;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void drawRows(GC gc) {
        boolean horizontal = true;
        if (this._delegate.getOrientation() == TimeBarViewerInterface.Orientation.VERTICAL) {
            horizontal = false;
        }
        Color fg = gc.getForeground();
        gc.setForeground(LINECOLOR);
        if (horizontal) {
            gc.drawLine(this._delegate.getYAxisWidth() + this._delegate.getHierarchyWidth() - 1, 0, this._delegate.getYAxisWidth() + this._delegate.getHierarchyWidth() - 1, this.getClientArea().height);
            gc.drawLine(this._delegate.getHierarchyWidth() - 1, 0, this._delegate.getHierarchyWidth() - 1, this.getClientArea().height);
        } else {
            gc.drawLine(0, this._delegate.getYAxisWidth() + this._delegate.getHierarchyWidth() - 1, this.getClientArea().width, this._delegate.getYAxisWidth() + this._delegate.getHierarchyWidth() - 1);
            gc.drawLine(0, this._delegate.getHierarchyWidth() - 1, this.getClientArea().width, this._delegate.getHierarchyWidth() - 1);
        }
        gc.setForeground(fg);
        if (horizontal) {
            this.drawRowsHorizontal(gc);
        } else {
            this.drawRowsVertical(gc);
        }
    }

    private void drawRowsHorizontal(GC gc) {
        TimeBarRow row;
        int y;
        int firstRow = this._delegate.getFirstRow();
        org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
        org.eclipse.swt.graphics.Rectangle nc = new org.eclipse.swt.graphics.Rectangle(0, this._delegate.getDiagramRect().y, this.getWidth(), this._delegate.getDiagramRect().height);
        gc.setClipping(gc.getClipping().intersection(nc));
        int upperYBound = this._delegate.getDiagramRect().y;
        int lowerYBound = upperYBound + this._delegate.getDiagramRect().height;
        if (gc.isClipped()) {
            upperYBound = gc.getClipping().y;
            lowerYBound = upperYBound + gc.getClipping().height;
        }
        for (int r = firstRow; r <= firstRow + this._delegate.getRowsDisplayed() + 1 && r < this._delegate.getRowCount() && (y = this._delegate.yForRow(row = this._delegate.getRow(r))) != -1; ++r) {
            int rowHeight = this._delegate.getTimeBarViewState().getRowHeight(row);
            if (!(y >= upperYBound && y <= lowerYBound || y + rowHeight >= upperYBound && y + rowHeight <= lowerYBound) && (upperYBound <= y || upperYBound >= y + rowHeight)) continue;
            this.drawRowHorizontal(gc, this._delegate.getRow(r), y, this._delegate.getSelectionModel().isSelected(this._delegate.getRow(r)));
            if (this._gapRenderer == null) continue;
            RenderDelegate.drawRowGaps(this._delegate, this._gapRenderer, false, gc, 0, y, this._delegate.getRow(r), this._delegate.getSelectionModel().isSelected(this._delegate.getRow(r)));
        }
        gc.setClipping(clipSave);
    }

    private void drawRowsVertical(GC gc) {
        TimeBarRow row;
        int x;
        int firstRow = this._delegate.getFirstRow();
        org.eclipse.swt.graphics.Rectangle clipSave = gc.getClipping();
        org.eclipse.swt.graphics.Rectangle nc = new org.eclipse.swt.graphics.Rectangle(this._delegate.getDiagramRect().x, 0, this._delegate.getDiagramRect().width, this.getHeight());
        gc.setClipping(gc.getClipping().intersection(nc));
        int upperXBound = this._delegate.getDiagramRect().x;
        int lowerXBound = upperXBound + this._delegate.getDiagramRect().width;
        if (gc.isClipped()) {
            upperXBound = gc.getClipping().x;
            lowerXBound = upperXBound + gc.getClipping().width;
        }
        for (int r = firstRow; r <= firstRow + this._delegate.getRowsDisplayed() + 1 && r < this._delegate.getRowCount() && (x = this._delegate.yForRow(row = this._delegate.getRow(r))) != -1; ++r) {
            int rowHeight = this._delegate.getTimeBarViewState().getRowHeight(row);
            if (!(x >= upperXBound && x <= lowerXBound || x + rowHeight >= upperXBound && x + rowHeight <= lowerXBound) && (upperXBound <= x || upperXBound >= x + rowHeight)) continue;
            this.drawRowVertical(gc, this._delegate.getRow(r), x, this._delegate.getSelectionModel().isSelected(this._delegate.getRow(r)));
            if (this._gapRenderer == null) continue;
            RenderDelegate.drawRowGaps(this._delegate, this._gapRenderer, false, gc, x, 0, this._delegate.getRow(r), this._delegate.getSelectionModel().isSelected(this._delegate.getRow(r)));
        }
        gc.setClipping(clipSave);
    }

    private void drawSelectionRect(GC gc) {
        if (this._delegate.getSelectionRect() != null) {
            Color fg = gc.getForeground();
            this._delegate.setLastSelRect(this.normalizeRectangle(this._delegate.getSelectionRect()));
            gc.setForeground(Display.getCurrent().getSystemColor(12));
            Rectangle selRect = this._delegate.getLastSelRect();
            gc.drawRectangle(selRect.x, selRect.y, selRect.width, selRect.height);
            gc.setForeground(fg);
        }
    }

    private Rectangle normalizeRectangle(Rectangle rect) {
        int x = Math.min(rect.x, rect.x + rect.width);
        int y = Math.min(rect.y, rect.y + rect.height);
        int width = Math.abs(rect.width);
        int height = Math.abs(rect.height);
        return new Rectangle(x, y, width, height);
    }

    public static org.eclipse.swt.graphics.Rectangle convertRect(Rectangle rect) {
        if (rect == null) {
            return null;
        }
        return new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    private Rectangle convertRect(org.eclipse.swt.graphics.Rectangle rect) {
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    private void drawRowHorizontal(GC gc, TimeBarRow row, int y, boolean selected) {
        JaretDate end;
        JaretDate start;
        int rowHeight = this._delegate.getTimeBarViewState().getRowHeight(row);
        if (row.getRowHeader() != null) {
            RenderDelegate.drawRowHeaderHorizontal(this._delegate, this._headerRenderer, false, gc, y, row.getRowHeader(), selected, row);
        }
        if (this._hierarchyRenderer != null && this._delegate.getHierarchyWidth() > 0) {
            RenderDelegate.drawHierarchy(this._delegate, this._hierarchyRenderer, false, gc, y, row, selected);
        }
        if (this._delegate.getDrawRowGrid()) {
            Color fg = gc.getForeground();
            gc.setForeground(this._rowGridColor);
            gc.drawLine(this._delegate.getDiagramRect().x, y + rowHeight - 1, this._delegate.getDiagramRect().x + this._delegate.getDiagramRect().width, y + rowHeight - 1);
            gc.setForeground(fg);
        }
        if (selected || this._delegate.getHighlightedRow() == row) {
            Color bg = gc.getBackground();
            boolean highlight = false;
            if (this._delegate.getHighlightedRow() == row) {
                highlight = true;
                gc.setBackground(this._highlightColor);
            } else {
                gc.setBackground(this._rowSelectColor);
            }
            int markerHeight = rowHeight;
            if (y + markerHeight > this._delegate.getDiagramRect().y + this._delegate.getDiagramRect().height) {
                markerHeight -= y + markerHeight - (this._delegate.getDiagramRect().y + this._delegate.getDiagramRect().height);
            }
            int alpha = gc.getAlpha();
            if (highlight && (this._ghostIntervals != null || this._ghostRows != null) && !SWT.getPlatform().equals("gtk")) {
                gc.setAlpha(this._highlightAlpha);
            }
            gc.fillRectangle(this._delegate.getDiagramRect().x, y, this.getWidth() - this._delegate.getDiagramRect().x, markerHeight);
            gc.setAlpha(alpha);
            gc.setBackground(bg);
        }
        if (this._delegate.getStrictClipTimeCheck()) {
            start = this._delegate.getStartDate();
            end = this._delegate.getEndDate();
        } else {
            start = this._delegate.getStartDate().copy().backMinutes((double)this._delegate.getScrollLookBackMinutes());
            end = this._delegate.getEndDate().copy().advanceMinutes((double)this._delegate.getScrollLookForwardMinutes());
        }
        if (gc.isClipped() && this._delegate.getStrictClipTimeCheck()) {
            start = this._delegate.dateForCoord(gc.getClipping().x);
            end = this._delegate.dateForCoord(gc.getClipping().x + gc.getClipping().width);
        }
        List<Interval> intervalsUnfiltered = row.getIntervals(start, end);
        List<Object> intervals = new ArrayList();
        if (this._delegate.getIntervalFilter() != null) {
            for (Interval interval : intervalsUnfiltered) {
                if (!this._delegate.getIntervalFilter().isInResult(interval)) continue;
                intervals.add(interval);
            }
        } else {
            intervals = intervalsUnfiltered;
        }
        for (Interval interval : intervals) {
            TimeBarRenderer renderer = this.getRenderer(interval.getClass());
            if (renderer == null) {
                throw new RuntimeException("No suitable renderer for " + interval.getClass());
            }
            if (this._delegate.isDrawOverlapping()) {
                RenderDelegate.drawIntervalHorizontal(this._delegate, renderer, false, gc, y, interval, null, row);
                continue;
            }
            RenderDelegate.drawIntervalHorizontal(this._delegate, renderer, false, gc, y, interval, this._delegate.getOverlapStrategy().getOverlapInfo(row, interval), row);
        }
    }

    private void drawRowVertical(GC gc, TimeBarRow row, int x, boolean selected) {
        JaretDate end;
        JaretDate start;
        int rowHeight = this._delegate.getTimeBarViewState().getRowHeight(row);
        if (row.getRowHeader() != null) {
            RenderDelegate.drawRowHeaderVertical(this._delegate, this._headerRenderer, false, gc, x, row.getRowHeader(), selected, row);
        }
        if (this._hierarchyRenderer != null && this._delegate.getHierarchyWidth() > 0) {
            RenderDelegate.drawHierarchyVertical(this._delegate, this._hierarchyRenderer, false, gc, x, row, selected);
        }
        if (this._delegate.getDrawRowGrid()) {
            Color fg = gc.getForeground();
            gc.setForeground(this._rowGridColor);
            gc.drawLine(x + rowHeight - 1, this._delegate.getDiagramRect().y, x + rowHeight - 1, this._delegate.getDiagramRect().y + this._delegate.getDiagramRect().height);
            gc.setForeground(fg);
        }
        if (selected || this._delegate.getHighlightedRow() == row) {
            Color bg = gc.getBackground();
            boolean highlight = false;
            if (this._delegate.getHighlightedRow() == row) {
                highlight = true;
                gc.setBackground(this._highlightColor);
            } else {
                gc.setBackground(this._rowSelectColor);
            }
            int markerWidth = rowHeight;
            if (x + markerWidth > this._delegate.getDiagramRect().x + this._delegate.getDiagramRect().width) {
                markerWidth -= x + markerWidth - (this._delegate.getDiagramRect().x + this._delegate.getDiagramRect().width);
            }
            int alpha = gc.getAlpha();
            if (highlight && (this._ghostIntervals != null || this._ghostRows != null) && !SWT.getPlatform().equals("gtk")) {
                gc.setAlpha(this._highlightAlpha);
            }
            gc.fillRectangle(x, this._delegate.getDiagramRect().y, markerWidth, this.getHeight() - this._delegate.getDiagramRect().y);
            gc.setAlpha(alpha);
            gc.setBackground(bg);
        }
        if (this._delegate.getStrictClipTimeCheck()) {
            start = this._delegate.getStartDate();
            end = this._delegate.getEndDate();
        } else {
            start = this._delegate.getStartDate().copy().backMinutes((double)this._delegate.getScrollLookBackMinutes());
            end = this._delegate.getEndDate().copy().advanceMinutes((double)this._delegate.getScrollLookForwardMinutes());
        }
        if (gc.isClipped() && this._delegate.getStrictClipTimeCheck()) {
            start = this._delegate.dateForCoord(gc.getClipping().y);
            end = this._delegate.dateForCoord(gc.getClipping().y + gc.getClipping().height);
        }
        List<Interval> intervalsUnfiltered = row.getIntervals(start, end);
        List<Object> intervals = new ArrayList();
        if (this._delegate.getIntervalFilter() != null) {
            for (Interval interval : intervalsUnfiltered) {
                if (!this._delegate.getIntervalFilter().isInResult(interval)) continue;
                intervals.add(interval);
            }
        } else {
            intervals = intervalsUnfiltered;
        }
        for (Interval interval : intervals) {
            TimeBarRenderer renderer = this.getRenderer(interval.getClass());
            if (renderer == null) {
                throw new RuntimeException("no suitable renderer for class " + interval.getClass());
            }
            if (this._delegate.isDrawOverlapping()) {
                RenderDelegate.drawIntervalVertical(this._delegate, renderer, false, gc, x, interval, null, row);
                continue;
            }
            RenderDelegate.drawIntervalVertical(this._delegate, renderer, false, gc, x, interval, this._delegate.getOverlapStrategy().getOverlapInfo(row, interval), row);
        }
    }

    public GridRenderer getGridRenderer() {
        return this._gridRenderer;
    }

    public void setGridRenderer(GridRenderer gridRenderer) {
        this._gridRenderer = gridRenderer;
        this.repaint();
    }

    public void setGlobalAssistantRenderer(GlobalAssistantRenderer gar) {
        this._globalRenderer = gar;
    }

    public GlobalAssistantRenderer getGlobalAssistantRenderer() {
        return this._globalRenderer;
    }

    public TimeBarGapRenderer getGapRenderer() {
        return this._gapRenderer;
    }

    public void setGapRenderer(TimeBarGapRenderer gapRenderer) {
        this._gapRenderer = gapRenderer;
        this.repaint();
    }

    public TimeScaleRenderer getTimeScaleRenderer() {
        return this._timeScaleRenderer;
    }

    public void setTimeScaleRenderer(TimeScaleRenderer timeScaleRenderer) {
        this._timeScaleRenderer = timeScaleRenderer;
        if (this._timeScaleRenderer != null && this._timeScaleRenderer.getHeight() != -1) {
            this._delegate.setXAxisHeight(this._timeScaleRenderer.getHeight());
        }
        this.repaint();
    }

    public void setMarkerRenderer(TimeBarMarkerRenderer markerRenderer) {
        this._markerRenderer = markerRenderer;
        this.repaint();
    }

    public TimeBarMarkerRenderer getMarkerRenderer() {
        return this._markerRenderer;
    }

    @Override
    public int getMarkerWidth() {
        if (this._markerRenderer != null) {
            return this._markerRenderer.getWidth();
        }
        return 0;
    }

    public void setHierarchyRenderer(HierarchyRenderer hierarchyRenderer) {
        this._hierarchyRenderer = hierarchyRenderer;
        if (this._hierarchyRenderer != null && this._hierarchyRenderer.getPreferredWidth() != -1) {
            this._delegate.setHierarchyWidth(this._hierarchyRenderer.getPreferredWidth());
        }
    }

    public HierarchyRenderer getHierarchyRenderer() {
        return this._hierarchyRenderer;
    }

    public HeaderRenderer getHeaderRenderer() {
        return this._headerRenderer;
    }

    public void setHeaderRenderer(HeaderRenderer headerRenderer) {
        this._headerRenderer = headerRenderer;
        this.repaint();
    }

    public TitleRenderer getTitleRenderer() {
        return this._titleRenderer;
    }

    public void setTitleRenderer(TitleRenderer titleRenderer) {
        this._titleRenderer = titleRenderer;
        this.repaint();
    }

    @Override
    public boolean timeBarContains(Interval interval, Rectangle intervalRect, int x, int y, boolean overlapping) {
        TimeBarRenderer renderer = this.getRenderer(interval.getClass());
        if (renderer == null) {
            throw new RuntimeException("no suitable renderer");
        }
        return renderer.contains(interval, TimeBarViewer.convertRect(intervalRect), x, y, overlapping);
    }

    @Override
    public Rectangle timeBarContainingRect(Interval interval, Rectangle intervalRect, boolean overlapping) {
        TimeBarRenderer renderer = this.getRenderer(interval.getClass());
        if (renderer == null) {
            throw new RuntimeException("no suitable renderer");
        }
        return this.convertRect(renderer.getContainingRectangle(interval, TimeBarViewer.convertRect(intervalRect), overlapping));
    }

    @Override
    public void setCursor(int cursorType) {
        cursorType = this.convertCursorType(cursorType);
        this.setCursor(Display.getCurrent().getSystemCursor(cursorType));
    }

    private int convertCursorType(int cursorType) {
        int result = 0;
        switch (cursorType) {
            case 12: {
                result = 21;
                break;
            }
            case 13: {
                result = 5;
                break;
            }
            case 11: {
                result = 12;
                break;
            }
            case 10: {
                result = 13;
                break;
            }
            case 8: {
                result = 10;
                break;
            }
            case 9: {
                result = 11;
                break;
            }
        }
        return result;
    }

    @Override
    public String getIntervalToolTipText(Interval interval, Rectangle intervalRect, int x, int y) {
        TimeBarRenderer renderer = this.getRenderer(interval.getClass());
        if (renderer == null) {
            throw new RuntimeException("no suitable renderer");
        }
        return renderer.getToolTipText(interval, TimeBarViewer.convertRect(intervalRect), x, y, false);
    }

    @Override
    public double getPixelPerSecond() {
        return this._delegate.getPixelPerSecond();
    }

    @Override
    public void setPixelPerSecond(double pixPerSecond) {
        this._delegate.setPixelPerSecond(pixPerSecond);
    }

    @Override
    public int getRowHeight() {
        return this._delegate.getTimeBarViewState().getDefaultRowHeight();
    }

    @Override
    public void setRowHeight(int rowHeight) {
        this._delegate.setRowHeight(rowHeight);
    }

    @Override
    public int getXAxisHeight() {
        return this._delegate.getXAxisHeight();
    }

    @Override
    public void setXAxisHeight(int height) {
        this._delegate.setXAxisHeight(height);
    }

    @Override
    public JaretDate getStartDate() {
        return this._delegate.getStartDate();
    }

    @Override
    public void setStartDate(JaretDate startDate) {
        this._delegate.setStartDate(startDate);
    }

    @Override
    public JaretDate getMinDate() {
        return this._delegate.getMinDate();
    }

    @Override
    public void setMinDate(JaretDate minDate) {
        this._delegate.setMinDate(minDate);
    }

    @Override
    public JaretDate getMaxDate() {
        return this._delegate.getMaxDate();
    }

    @Override
    public void setMaxDate(JaretDate maxDate) {
        this._delegate.setMaxDate(maxDate);
    }

    @Override
    public TimeBarSelectionModel getSelectionModel() {
        return this._delegate.getSelectionModel();
    }

    @Override
    public void setSelectionModel(TimeBarSelectionModel selectionModel) {
        this._delegate.setSelectionModel(selectionModel);
    }

    @Override
    public int getFirstRowDisplayed() {
        return this._delegate.getFirstRow();
    }

    @Override
    public void setFirstRowDisplayed(int rowIdx) {
        this._delegate.setFirstRow(rowIdx);
    }

    @Override
    public int getFirstRowOffset() {
        return this._delegate.getFirstRowOffset();
    }

    @Override
    public void setFirstRowOffset(int offset) {
        this._delegate.setFirstRowOffset(offset);
    }

    @Override
    public void setFirstRow(int firstRow, int pixOffset) {
        this._delegate.setFirstRow(firstRow, pixOffset);
    }

    public JaretDate getEndDate() {
        return this._delegate.getEndDate();
    }

    public void setTimeScalePosition(int timeScalePosition) {
        this._delegate.setTimeScalePosition(timeScalePosition);
    }

    public int getTimeScalePosition() {
        return this._delegate.getTimeScalePosition();
    }

    @Override
    public void setAdjustMinMaxDatesByModel(boolean adjust) {
        this._delegate.setAdjustMinMaxDatesByModel(adjust);
    }

    @Override
    public boolean getAdjustMinMaxDatesByModel() {
        return this._delegate.getAdjustMinMaxDatesByModel();
    }

    public TimeBarRow rowForY(int y) {
        return this._delegate.rowForY(y);
    }

    @Override
    public JaretDate dateForX(int x) {
        return this._delegate.dateForCoord(x);
    }

    @Override
    public JaretDate dateForXY(int x, int y) {
        return this._delegate.dateForXY(x, y);
    }

    public void highlightRow(int y) {
        this._delegate.highlightRow(y);
    }

    public void highlightRow(TimeBarRow timeBarRow) {
        this._delegate.highlightRow(timeBarRow);
    }

    public void deHighlightRow() {
        this._delegate.deHighlightRow();
    }

    @Override
    public void setDrawRowGrid(boolean drawRowGrid) {
        this._delegate.setDrawRowGrid(drawRowGrid);
    }

    @Override
    public boolean getDrawRowGrid() {
        return this._delegate.getDrawRowGrid();
    }

    public void setRowFilter(TimeBarRowFilter rowFilter) {
        this._delegate.setRowFilter(rowFilter);
    }

    public TimeBarRowFilter getRowFilter() {
        return this._delegate.getRowFilter();
    }

    public void setIntervalFilter(TimeBarIntervalFilter intervalFilter) {
        this._delegate.setIntervalFilter(intervalFilter);
    }

    public TimeBarIntervalFilter getIntervalFilter() {
        return this._delegate.getIntervalFilter();
    }

    public void setRowSorter(TimeBarRowSorter rowSorter) {
        this._delegate.setRowSorter(rowSorter);
    }

    public TimeBarRowSorter getRowSorter() {
        return this._delegate.getRowSorter();
    }

    @Override
    public void addMarker(TimeBarMarker marker) {
        this._delegate.addMarker(marker);
    }

    @Override
    public void remMarker(TimeBarMarker marker) {
        this._delegate.remMarker(marker);
    }

    @Override
    public List<TimeBarMarker> getMarkers() {
        return this._delegate.getMarkers();
    }

    @Override
    public void addMarkers(List<TimeBarMarker> markers) {
        this._delegate.addMarkers(markers);
    }

    @Override
    public void setYAxisWidth(int width) {
        this._delegate.setYAxisWidth(width);
    }

    @Override
    public int getYAxisWidth() {
        return this._delegate.getYAxisWidth();
    }

    @Override
    public void setHierarchyWidth(int width) {
        this._delegate.setHierarchyWidth(width);
    }

    @Override
    public int getHierarchyWidth() {
        return this._delegate.getHierarchyWidth();
    }

    @Override
    public void setAutoscrollEnabled(boolean enableAutoscroll) {
        this._delegate.setAutoscrollEnabled(enableAutoscroll);
    }

    @Override
    public boolean isAutoscrollEnabled() {
        return this._delegate.isAutoscrollEnabled();
    }

    @Override
    public void addIntervalModificator(IntervalModificator intervalModificator) {
        this._delegate.addIntervalModificator(intervalModificator);
    }

    @Override
    public void remIntervalModificator(IntervalModificator intervalModificator) {
        this._delegate.remIntervalModificator(intervalModificator);
    }

    @Override
    public String getTimeScaleToolTipText(int x, int y) {
        if (this._timeScaleRenderer != null) {
            String tooltip = this._timeScaleRenderer.getToolTipText(this, TimeBarViewer.convertRect(this._delegate.getXAxisRect()), x, y);
            return tooltip;
        }
        return null;
    }

    @Override
    public String getHeaderToolTipText(TimeBarRow row, int x, int y) {
        if (this._headerRenderer != null) {
            return this._headerRenderer.getToolTipText(row, TimeBarViewer.convertRect(this._delegate.getYAxisRect()), x, y);
        }
        return null;
    }

    @Override
    public String getHierarchyToolTipText(TimeBarNode node, int x, int y) {
        if (this._hierarchyRenderer != null) {
            return this._hierarchyRenderer.getToolTipText(node, TimeBarViewer.convertRect(this._delegate.getHierarchyRect()), x, y);
        }
        return null;
    }

    @Override
    public boolean isInToggleArea(TimeBarNode node, int xx, int yy) {
        int x = this._delegate.getHierarchyRect().x;
        int width = this._delegate.getHierarchyWidth() - 1;
        int rowHeight = this._delegate.getTimeBarViewState().getRowHeight(node);
        int y = this._delegate.yForRow(node);
        org.eclipse.swt.graphics.Rectangle drawingArea = new org.eclipse.swt.graphics.Rectangle(x, y, width, rowHeight);
        return this._hierarchyRenderer.isInToggleArea(this, node, drawingArea, xx, yy);
    }

    @Override
    public boolean isInHierarchySelectionArea(TimeBarNode node, int xx, int yy) {
        int x = this._delegate.getHierarchyRect().x;
        int width = this._delegate.getHierarchyWidth() - 1;
        int rowHeight = this._delegate.getTimeBarViewState().getRowHeight(node);
        int y = this._delegate.yForRow(node);
        org.eclipse.swt.graphics.Rectangle drawingArea = new org.eclipse.swt.graphics.Rectangle(x, y, width, rowHeight);
        return this._hierarchyRenderer.isInHierarchySelectionArea(this, node, drawingArea, xx, yy);
    }

    @Override
    public void setTitle(String title) {
        this._delegate.setTitle(title);
    }

    @Override
    public String getTitle() {
        return this._delegate.getTitle();
    }

    private void dispContextMenu(Menu contextMenu, int x, int y) {
        Shell shell = Display.getCurrent().getActiveShell();
        Point coords = Display.getCurrent().map((Control)this, (Control)shell, x, y);
        contextMenu.setLocation(coords.x + shell.getLocation().x, coords.y + shell.getLocation().y);
        contextMenu.setVisible(true);
    }

    @Override
    public void displayBodyContextMenu(int x, int y) {
        if (this._bodyContextMenu != null) {
            this.dispContextMenu(this._bodyContextMenu, x, y);
        }
    }

    @Override
    public void displayTimeScaleContextMenu(int x, int y) {
        if (this._scaleContextMenu != null) {
            this.dispContextMenu(this._scaleContextMenu, x, y);
        }
    }

    @Override
    public void displayIntervalContextMenu(Interval interval, int x, int y) {
        if (this._intervalContextMenu != null) {
            this.dispContextMenu(this._intervalContextMenu, x, y);
        }
    }

    @Override
    public void displayHeaderContextMenu(TimeBarRow row, int x, int y) {
        Menu ctxMenu;
        if (this._headerCtxHandler != null && (ctxMenu = this._headerCtxHandler.getContextMenu(this, row)) != null) {
            this.dispContextMenu(ctxMenu, x, y);
        }
    }

    @Override
    public void displayHierarchyContextMenu(TimeBarRow row, int x, int y) {
        Menu ctxMenu;
        if (this._hierarchyCtxHandler != null && (ctxMenu = this._hierarchyCtxHandler.getContextMenu(this, row)) != null) {
            this.dispContextMenu(ctxMenu, x, y);
        }
    }

    @Override
    public void displayTitleContextMenu(int x, int y) {
        if (this._titleContextMenu != null) {
            this.dispContextMenu(this._titleContextMenu, x, y);
        }
    }

    public Menu getBodyContextMenu() {
        return this._bodyContextMenu;
    }

    public void setBodyContextMenu(Menu bodyContextMenu) {
        this._bodyContextMenu = bodyContextMenu;
    }

    public Menu getIntervalContextMenu() {
        return this._intervalContextMenu;
    }

    public void setIntervalContextMenu(Menu intervalContextMenu) {
        this._intervalContextMenu = intervalContextMenu;
    }

    public Menu getScaleContextMenu() {
        return this._scaleContextMenu;
    }

    public void setScaleContextMenu(Menu scaleContextMenu) {
        this._scaleContextMenu = scaleContextMenu;
    }

    public Menu getTitleContextMenu() {
        return this._titleContextMenu;
    }

    public void setTitleContextMenu(Menu titleContextMenu) {
        this._titleContextMenu = titleContextMenu;
    }

    public RowContextMenuHandler getHeaderCtxHandler() {
        return this._headerCtxHandler;
    }

    public void setHeaderCtxHandler(RowContextMenuHandler headerCtxHandler) {
        this._headerCtxHandler = headerCtxHandler;
    }

    public RowContextMenuHandler getHierarchyCtxHandler() {
        return this._hierarchyCtxHandler;
    }

    public void setHierarchyCtxHandler(RowContextMenuHandler hierarchyCtxHandler) {
        this._hierarchyCtxHandler = hierarchyCtxHandler;
    }

    public int getKeyboardChangeDelta() {
        return this._delegate.getKeyboardChangeDelta();
    }

    public void setKeyboardChangeDelta(int keyboardChangeDelta) {
        this._delegate.setKeyboardChangeDelta(keyboardChangeDelta);
    }

    public void setFocussedInterval(Interval interval) {
        this._delegate.setFocussedInterval(interval);
    }

    public void setFocussedInterval(TimeBarRow row, Interval interval) {
        this._delegate.setFocussedInterval(row, interval);
    }

    public Interval getFocussedInterval() {
        return this._delegate.getFocussedInterval();
    }

    public TimeBarRow getFocussedRow() {
        return this._delegate.getFocussedRow();
    }

    public boolean isFocussed(Interval interval) {
        return this._delegate.isFocussed(interval);
    }

    public void scrollDateToVisible(JaretDate date) {
        this._delegate.scrollDateToVisible(date);
    }

    public void scrollRowToVisible(TimeBarRow row) {
        this._delegate.scrollRowToVisible(row);
    }

    public void scrollIntervalToVisible(TimeBarRow row, Interval interval) {
        this._delegate.scrollIntervalToVisible(row, interval);
    }

    public void scrollIntervalToVisible(Interval interval) {
        this._delegate.scrollIntervalToVisible(interval);
    }

    public synchronized void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this._selectionChangeListeners == null) {
            this._selectionChangeListeners = new Vector<ISelectionChangedListener>();
        }
        this._selectionChangeListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this._selectionChangeListeners != null) {
            this._selectionChangeListeners.remove(listener);
        }
    }

    public ISelection getSelection() {
        return this.getStrucuredSelection();
    }

    public void setSelection(ISelection selection) {
        this.setStructuredSelection(selection);
    }

    private ISelection getStrucuredSelection() {
        TimeBarSelectionModel tmSelection = this.getSelectionModel();
        if (tmSelection != null && !tmSelection.isEmpty()) {
            ArrayList<TimeBarRow> list = new ArrayList<TimeBarRow>();
            list.addAll(tmSelection.getSelectedRows());
            list.addAll(tmSelection.getSelectedIntervals());
            StructuredSelection selection = new StructuredSelection(list);
            return selection;
        }
        return new StructuredSelection();
    }

    private void setStructuredSelection(ISelection selection) {
        TimeBarSelectionModelImpl tmSelection = new TimeBarSelectionModelImpl();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            for (Object o : structured.toList()) {
                if (o instanceof Interval) {
                    tmSelection.addSelectedInterval((Interval)o);
                    continue;
                }
                if (o instanceof TimeBarRow) {
                    tmSelection.addSelectedRow((TimeBarRow)o);
                    continue;
                }
                throw new IllegalArgumentException("Type " + o.getClass().getName() + " not supported for selection");
            }
        }
        this.setSelectionModel(tmSelection);
    }

    @Override
    public void fireSelectionChanged() {
        SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, this.getStrucuredSelection());
        this.fireSelectionChanged(evt);
    }

    private void fireSelectionChanged(SelectionChangedEvent event) {
        if (this._selectionChangeListeners != null) {
            for (ISelectionChangedListener listener : this._selectionChangeListeners) {
                listener.selectionChanged(event);
            }
        }
    }

    public JaretTimeBarsActionFactory getActionFactory() {
        if (this._actionFactory == null) {
            this._actionFactory = new JaretTimeBarsActionFactory(this, this._delegate);
        }
        return this._actionFactory;
    }

    public void setDrawOverlapping(boolean drawOverlapping) {
        this._delegate.setDrawOverlapping(drawOverlapping);
    }

    public boolean getDrawOverlapping() {
        return this._delegate.isDrawOverlapping();
    }

    public List<Interval> getIntervalsAt(int x, int y) {
        return this._delegate.getIntervalsAt(x, y);
    }

    public Color getRowGridColor() {
        return this._rowGridColor;
    }

    public void setRowGridColor(Color rowGridColor) {
        this._rowGridColor = rowGridColor;
    }

    public Color getHighlightColor() {
        return this._highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this._highlightColor = highlightColor;
    }

    public Color getRowSelectColor() {
        return this._rowSelectColor;
    }

    public void setRowSelectColor(Color rowSelectColor) {
        this._rowSelectColor = rowSelectColor;
    }

    public int getHighlightAlpha() {
        return this._highlightAlpha;
    }

    public void setHighlightAlpha(int highlightAlpha) {
        this._highlightAlpha = highlightAlpha;
    }

    public int getGhostAlpha() {
        return this._ghostAlpha;
    }

    public void setGhostAlpha(int ghostAlpha) {
        this._ghostAlpha = ghostAlpha;
    }

    @Override
    public int getSelectionDelta() {
        return this._delegate.getSelectionDelta();
    }

    @Override
    public void setSelectionDelta(int selectionDelta) {
        this._delegate.setSelectionDelta(selectionDelta);
    }

    @Override
    public boolean isLineDraggingAllowed() {
        return this._delegate.isLineDraggingAllowed();
    }

    @Override
    public void setLineDraggingAllowed(boolean lineDraggingAllowed) {
        this._delegate.setLineDraggingAllowed(lineDraggingAllowed);
    }

    @Override
    public int getYForRow(TimeBarRow row) {
        return this._delegate.yForRow(row);
    }

    @Override
    public TimeBarRow getRowForY(int y) {
        return this._delegate.rowForY(y);
    }

    @Override
    public TimeBarRow getRowForXY(int x, int y) {
        return this._delegate.rowForXY(x, y);
    }

    public void setGhostIntervals(List<Interval> intervals, List<Integer> yCoordinates) {
        this._ghostIntervals = intervals;
        this._ghostIntervalYCoordinates = yCoordinates;
        this.redraw();
    }

    public void setGhostInterval(Interval interval, int y) {
        if (interval == null) {
            this.setGhostIntervals(null, null);
        } else {
            ArrayList<Interval> l = new ArrayList<Interval>(1);
            ArrayList<Integer> l2 = new ArrayList<Integer>(1);
            l.add(interval);
            l2.add(y);
            this.setGhostIntervals(l, l2);
        }
    }

    public void setGhostRows(List<TimeBarRow> rows, List<Integer> yCoordinates) {
        this._ghostRows = rows;
        this._ghostRowYCoordinates = yCoordinates;
        this.redraw();
    }

    public void setGhostRow(TimeBarRow row, int y) {
        if (row == null) {
            this.setGhostRows(null, null);
        } else {
            ArrayList<TimeBarRow> l = new ArrayList<TimeBarRow>(1);
            ArrayList<Integer> l2 = new ArrayList<Integer>(1);
            l.add(row);
            l2.add(y);
            this.setGhostRows(l, l2);
        }
    }

    public void setGhostOrigin(int x, int y) {
        this._ghostOrigin = new Point(x, y);
        if (this._ghostIntervals != null || this._ghostRows != null) {
            this.redraw();
        }
    }

    private void drawGhosts(GC gc) {
        this.drawGhostIntervals(gc);
        this.drawGhostRows(gc);
    }

    private void drawGhostIntervals(GC gc) {
        if (this._ghostOrigin != null && this._ghostIntervals != null) {
            for (int i = 0; i < this._ghostIntervals.size(); ++i) {
                Interval interval = this._ghostIntervals.get(i);
                int yoff = this._ghostIntervalYCoordinates.get(i);
                org.eclipse.swt.graphics.Rectangle drawingArea = TimeBarViewer.convertRect(this._delegate.getIntervalBounds(-1, interval));
                if (this._delegate.getOrientation().equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL)) {
                    drawingArea.y = this._ghostOrigin.y + yoff;
                    drawingArea.height = this._delegate.getTimeBarViewState().getDefaultRowHeight();
                } else {
                    drawingArea.x = this._ghostOrigin.x + yoff;
                    drawingArea.width = this._delegate.getTimeBarViewState().getDefaultRowHeight();
                }
                int alpha = gc.getAlpha();
                gc.setAlpha(this._ghostAlpha);
                TimeBarRenderer renderer = this.getRenderer(interval.getClass());
                if (renderer == null) {
                    throw new RuntimeException("no suitable renderer");
                }
                renderer.draw(gc, drawingArea, this._delegate, interval, false, false, false);
                gc.setAlpha(alpha);
            }
        }
    }

    private void drawGhostRows(GC gc) {
        if (this._ghostOrigin != null && this._ghostRows != null) {
            int alpha = gc.getAlpha();
            gc.setAlpha(this._ghostAlpha);
            for (int i = 0; i < this._ghostRows.size(); ++i) {
                TimeBarRow row = this._ghostRows.get(i);
                int yoff = this._ghostRowYCoordinates.get(i);
                if (this._delegate.getOrientation().equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL)) {
                    int y = this._ghostOrigin.y + yoff;
                    this.drawRowHorizontal(gc, row, y, false);
                    continue;
                }
                int x = this._ghostOrigin.x + yoff;
                this.drawRowVertical(gc, row, x, false);
            }
            gc.setAlpha(alpha);
        }
    }

    @Override
    public boolean isMilliAccuracy() {
        return this._delegate.isMilliAccuracy();
    }

    @Override
    public void setMilliAccuracy(boolean milliAccuracy) {
        this._delegate.setMilliAccuracy(milliAccuracy);
    }

    @Override
    public TimeBarNode getPpsRow() {
        return this._delegate.getPpsRow();
    }

    @Override
    public boolean hasVariableXScale() {
        return this._delegate.hasVariableXScale();
    }

    @Override
    public void setVariableXScale(boolean state) {
        this._delegate.setVariableXScale(state);
    }

    @Override
    public void doScrollHorizontal(int diff) {
        Rectangle d = new Rectangle(this._delegate.getDiagramRect());
        if (this._delegate.getOrientation().equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL)) {
            if (this._delegate.getTimeScalePosition() != 2) {
                if (this._delegate.getTimeScalePosition() == 0) {
                    d.y = this._delegate.getXAxisRect().y;
                }
                d.height += this._delegate.getXAxisRect().height;
            }
        } else {
            d.y = 0;
            d.height = d.height + this._delegate.getHierarchyWidth() + this._delegate.getYAxisWidth();
        }
        if (diff > 0) {
            this.scroll(d.x, d.y, d.x + diff, d.y, d.width - diff, d.height, false);
        } else {
            diff = -diff;
            this.scroll(d.x + diff, d.y, d.x, d.y, d.width - diff, d.height, false);
        }
    }

    @Override
    public void doScrollVertical(int diff) {
        Rectangle d = new Rectangle(this._delegate.getDiagramRect());
        if (this._delegate.getOrientation().equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL)) {
            d.x = d.x - this._delegate.getHierarchyWidth() - this._delegate.getYAxisWidth();
            d.width = d.width + this._delegate.getHierarchyWidth() + this._delegate.getYAxisWidth();
        } else {
            d.x -= this._delegate.getXAxisHeight();
            d.width += this._delegate.getXAxisHeight();
        }
        if (diff > 0) {
            this.scroll(d.x, d.y, d.x, d.y + diff, d.width, d.height - diff, false);
        } else {
            diff = -diff;
            this.scroll(d.x, d.y + diff, d.x, d.y, d.width, d.height - diff, false);
        }
    }

    @Override
    public boolean getOptimizeScrolling() {
        return this._delegate.getOptimizeScrolling();
    }

    @Override
    public void setOptimizeScrolling(boolean optimizeScrolling) {
        this._delegate.setOptimizeScrolling(optimizeScrolling);
    }

    @Override
    public TimeBarViewerInterface.Orientation getOrientation() {
        return this._delegate.getOrientation();
    }

    @Override
    public void setOrientation(TimeBarViewerInterface.Orientation orientation) {
        this._delegate.setOrientation(orientation);
    }

    @Override
    public int getAutoScaleRows() {
        return this._delegate.getAutoScaleRows();
    }

    @Override
    public void setAutoScaleRows(int rows) {
        this._delegate.setAutoScaleRows(rows);
    }

    public org.eclipse.swt.graphics.Rectangle getIntervalBounds(Interval interval) {
        return TimeBarViewer.convertRect(this._delegate.getIntervalBounds(interval));
    }

    @Override
    public void addTimeBarChangeListener(ITimeBarChangeListener listener) {
        this._delegate.addTimeBarChangeListener(listener);
    }

    @Override
    public void removeTimeBarChangeListener(ITimeBarChangeListener listener) {
        this._delegate.removeTimeBarChangeListener(listener);
    }

    @Override
    public void addFocussedIntervalListener(FocussedIntervalListener listener) {
        this._delegate.addFocussedIntervalListener(listener);
    }

    @Override
    public void remFocussedIntervalListener(FocussedIntervalListener listener) {
        this._delegate.remFocussedIntervalListener(listener);
    }

    @Override
    public ITimeBarViewState getTimeBarViewState() {
        return this._delegate.getTimeBarViewState();
    }

    @Override
    public boolean isRowHeightDragginAllowed() {
        return this._delegate.isRowHeightDraggingAllowed();
    }

    @Override
    public void setRowHeightDraggingAllowed(boolean rowHeightDraggingAllowed) {
        this._delegate.setRowHeightDraggingAllowed(rowHeightDraggingAllowed);
    }

    @Override
    public boolean rowLineHit(int x, int y) {
        return this._delegate.rowLineHit(x, y);
    }

    @Override
    public boolean isInRowAxis(int x, int y) {
        return this._delegate.isInRowAxis(x, y);
    }

    @Override
    public boolean isInDiagram(int x, int y) {
        return this._delegate.isInDiagram(x, y);
    }

    @Override
    public boolean getStrictClipTimeCheck() {
        return this._delegate.getStrictClipTimeCheck();
    }

    @Override
    public void setStrictClipTimeCheck(boolean strictClipTimeCheck) {
        this._delegate.setStrictClipTimeCheck(strictClipTimeCheck);
    }

    @Override
    public int getSecondsDisplayed() {
        return this._delegate.getSecondsDisplayed();
    }

    @Override
    public IOverlapStrategy getOverlapStrategy() {
        return this._delegate.getOverlapStrategy();
    }

    @Override
    public void setOverlapStrategy(IOverlapStrategy overlapStrategy) {
        this._delegate.setOverlapStrategy(overlapStrategy);
    }

    @Override
    public int getScrollLookBackMinutes() {
        return this._delegate.getScrollLookBackMinutes();
    }

    @Override
    public void setScrollLookBackMinutes(int scrollLookBackMinutes) {
        this._delegate.setScrollLookBackMinutes(scrollLookBackMinutes);
    }

    @Override
    public void setScrollLookForwardMinutes(int scrollLookForwardMinutes) {
        this._delegate.setScrollLookForwardMinutes(scrollLookForwardMinutes);
    }

    @Override
    public int getScrollLookForwardMinutes() {
        return this._delegate.getScrollLookForwardMinutes();
    }

    @Override
    public String getName() {
        return this._delegate.getName();
    }

    @Override
    public void setName(String name) {
        this._delegate.setName(name);
    }
}

