/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.renderer;

import de.jaret.util.date.Interval;
import de.jaret.util.date.JaretDate;
import de.jaret.util.date.holidayenumerator.HolidayEnumerator;
import de.jaret.util.date.iterator.DateIterator;
import de.jaret.util.date.iterator.DayIterator;
import de.jaret.util.date.iterator.HourIterator;
import de.jaret.util.date.iterator.MinuteIterator;
import de.jaret.util.date.iterator.MonthIterator;
import de.jaret.util.date.iterator.WeekIterator;
import de.jaret.util.date.iterator.YearIterator;
import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.model.PPSInterval;
import de.jaret.util.ui.timebars.swt.TimeBarViewer;
import de.jaret.util.ui.timebars.swt.renderer.RendererBase;
import de.jaret.util.ui.timebars.swt.renderer.TimeScaleRenderer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;

public class BoxTimeScaleRenderer
extends RendererBase
implements TimeScaleRenderer {
    private static final int DEFAULT_NUMBER_OF_STRIPS = 3;
    protected static final int BOXHEIGHT = 20;
    protected static final int ADDITIONALGAP = 7;
    protected static final int GAP = 3;
    protected static final int PRINTINGLINEWIDTH = 3;
    protected int _textHeight = -1;
    protected int _numberOfStrips = 3;
    private double _lastPPS = -1.0;
    protected HolidayEnumerator _holidayEnumerator;
    protected List<DateIterator> _iterators;
    protected List<DateIterator.Format> _formats;
    protected List<Boolean> _enable;

    public BoxTimeScaleRenderer(Printer printer) {
        super(printer);
        this.initIterators();
    }

    private void initIterators() {
        this._iterators = new ArrayList<DateIterator>();
        this._formats = new ArrayList<DateIterator.Format>();
        this._enable = new ArrayList<Boolean>();
        this._iterators.add((DateIterator)new MinuteIterator(30));
        this._formats.add(DateIterator.Format.LONG);
        this._enable.add(true);
        this._iterators.add((DateIterator)new HourIterator(3));
        this._formats.add(DateIterator.Format.LONG);
        this._enable.add(true);
        this._iterators.add((DateIterator)new HourIterator(12));
        this._formats.add(DateIterator.Format.LONG);
        this._enable.add(true);
        this._iterators.add((DateIterator)new DayIterator());
        this._formats.add(DateIterator.Format.LONG);
        this._enable.add(true);
        this._iterators.add((DateIterator)new WeekIterator());
        this._formats.add(DateIterator.Format.LONG);
        this._enable.add(true);
        this._iterators.add((DateIterator)new MonthIterator());
        this._formats.add(DateIterator.Format.LONG);
        this._enable.add(true);
        this._iterators.add((DateIterator)new YearIterator());
        this._formats.add(DateIterator.Format.LONG);
        this._enable.add(true);
    }

    public BoxTimeScaleRenderer() {
        super(null);
        this.initIterators();
    }

    public void setHolidayEnumerator(HolidayEnumerator he) {
        this._holidayEnumerator = he;
    }

    public void draw(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, boolean top, boolean printing) {
        if (this._lastPPS != delegate.getPixelPerSecond()) {
            this.checkStrips(gc, delegate, delegate.getStartDate());
            this._lastPPS = delegate.getPixelPerSecond();
        }
        if (this._textHeight == -1) {
            Point p = gc.textExtent("Q");
            this._textHeight = p.y;
        }
        int lineWidth = gc.getLineWidth();
        if (printing) {
            gc.setLineWidth(3);
        }
        if (!delegate.hasVariableXScale()) {
            this.drawStrips(gc, drawingArea, delegate, top, printing, delegate.getStartDate().copy(), delegate.getStartDate().copy().advanceSeconds((double)delegate.getSecondsDisplayed()));
        } else {
            JaretDate startDate = delegate.getStartDate().copy();
            JaretDate endDate = delegate.getStartDate().copy().advanceSeconds((double)delegate.getSecondsDisplayed());
            List<Interval> ppsIntervals = delegate.getPpsRow().getIntervals(startDate, endDate);
            if (ppsIntervals.size() == 0) {
                this.drawStrips(gc, drawingArea, delegate, top, printing, delegate.getStartDate().copy(), delegate.getStartDate().copy().advanceSeconds((double)delegate.getSecondsDisplayed()));
            } else {
                JaretDate d = startDate.copy();
                while (d.compareTo(endDate) < 0) {
                    PPSInterval nextInterval;
                    this.checkStrips(gc, delegate, d);
                    PPSInterval ppsInterval = delegate.getPPSInterval(d);
                    JaretDate e = ppsInterval != null ? ppsInterval.getEnd() : ((nextInterval = delegate.nextPPSInterval(d)) != null ? nextInterval.getBegin() : endDate);
                    this.drawStrips(gc, drawingArea, delegate, top, printing, d, e);
                    d = e;
                }
                this._lastPPS = -1.0;
            }
        }
        gc.setLineWidth(lineWidth);
    }

    private void drawStrips(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, boolean top, boolean printing, JaretDate startDate, JaretDate endDate) {
        boolean horizontal = delegate.getOrientation().equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL);
        Rectangle clipSave = gc.getClipping();
        if (horizontal) {
            int sx = delegate.xForDate(startDate);
            Rectangle destRect = new Rectangle(sx, drawingArea.y, delegate.xForDate(endDate) - sx, drawingArea.height);
            gc.setClipping(destRect.intersection(clipSave));
            int ox = drawingArea.x;
            int basey = top ? drawingArea.y + drawingArea.height : drawingArea.y + this.scaleY(20);
            int drawn = 0;
            for (int i = 0; i < this._iterators.size() && drawn < this._numberOfStrips; ++i) {
                DateIterator it = this._iterators.get(i);
                if (!this._enable.get(i).booleanValue()) continue;
                ++drawn;
                it.reInitialize(startDate, endDate.copy().advanceSeconds((double)it.getApproxStepSeconds()));
                while (it.hasNextDate()) {
                    String label = it.getLabel(this._formats.get(i));
                    JaretDate d = it.getNextDate();
                    int x = delegate.xForDate(d);
                    gc.drawLine(x, basey, x, basey - this.scaleY(20));
                    int yy = (this.scaleY(20) - this._textHeight) / 2;
                    gc.drawString(label, x + this.scaleX(3), basey - yy - this._textHeight);
                }
                if (top) {
                    gc.drawLine(ox, basey - this.scaleY(20), ox + drawingArea.width, basey - this.scaleY(20));
                } else {
                    gc.drawLine(ox, basey, ox + drawingArea.width, basey);
                }
                basey += top ? -this.scaleY(20) : this.scaleY(20);
            }
        } else {
            int sy = delegate.xForDate(startDate);
            Rectangle destRect = new Rectangle(drawingArea.x, sy, drawingArea.width, delegate.xForDate(endDate) - sy);
            gc.setClipping(destRect.intersection(clipSave));
            int oy = drawingArea.y;
            int basex = top ? drawingArea.x + drawingArea.width : drawingArea.x + this.scaleX(20);
            int drawn = 0;
            for (int i = 0; i < this._iterators.size() && drawn < this._numberOfStrips; ++i) {
                DateIterator it = this._iterators.get(i);
                if (!this._enable.get(i).booleanValue()) continue;
                ++drawn;
                it.reInitialize(startDate, endDate.copy().advanceSeconds((double)it.getApproxStepSeconds()));
                while (it.hasNextDate()) {
                    String label = it.getLabel(this._formats.get(i));
                    JaretDate d = it.getNextDate();
                    int y = delegate.xForDate(d);
                    gc.drawLine(basex, y, basex - this.scaleX(20), y);
                    int xx = (this.scaleX(20) - this._textHeight) / 2;
                    SwtGraphicsHelper.drawStringVertical((GC)gc, (String)label, (int)(basex - xx - this._textHeight), (int)(y + this.scaleY(3)));
                }
                if (top) {
                    gc.drawLine(basex - this.scaleX(20), oy, basex - this.scaleX(20), oy + drawingArea.height);
                } else {
                    gc.drawLine(basex, oy, basex, oy + drawingArea.height);
                }
                basex += top ? -this.scaleX(20) : this.scaleX(20);
            }
        }
        gc.setClipping(clipSave);
    }

    private void checkStrips(GC gc, TimeBarViewerDelegate delegate, JaretDate startDate) {
        for (int i = 0; i < this._iterators.size(); ++i) {
            DateIterator it = this._iterators.get(i);
            it.reInitialize(startDate, null);
            if (it.previewNextDate() != null) {
                JaretDate current = it.getNextDate();
                JaretDate next = it.getNextDate();
                int width = delegate.xForDate(next) - delegate.xForDate(current);
                String label = it.getLabel(DateIterator.Format.LONG);
                Point p = gc.textExtent(label);
                if (width > p.x + 3 + 7) {
                    this._enable.set(i, true);
                    this._formats.set(i, DateIterator.Format.LONG);
                    continue;
                }
                label = it.getLabel(DateIterator.Format.MEDIUM);
                p = gc.textExtent(label);
                if (width > p.x + 3 + 7) {
                    this._enable.set(i, true);
                    this._formats.set(i, DateIterator.Format.MEDIUM);
                    continue;
                }
                label = it.getLabel(DateIterator.Format.SHORT);
                p = gc.textExtent(label);
                if (width > p.x + 3 + 7) {
                    this._enable.set(i, true);
                    this._formats.set(i, DateIterator.Format.SHORT);
                    continue;
                }
                this._enable.set(i, false);
                continue;
            }
            this._enable.set(i, false);
        }
    }

    public String getToolTipText(TimeBarViewer tbv, Rectangle drawingArea, int x, int y) {
        String str = null;
        JaretDate date = tbv.dateForX(x);
        str = date.toDisplayString();
        if (this._holidayEnumerator != null && (this._holidayEnumerator.isHoliday(date.getDate()) || this._holidayEnumerator.isSpecialDay(date.getDate()))) {
            str = str + "\n" + this._holidayEnumerator.getDayName(date.getDate());
        }
        return str;
    }

    public int getHeight() {
        if (this._printer == null) {
            return this._numberOfStrips * 20;
        }
        return this.scaleY(this._numberOfStrips * 20);
    }

    public void dispose() {
    }

    public TimeScaleRenderer createPrintRenderer(Printer printer) {
        return new BoxTimeScaleRenderer(printer);
    }

    public int getNumberOfStrips() {
        return this._numberOfStrips;
    }

    public void setNumberOfStrips(int numberOfStrips) {
        this._numberOfStrips = numberOfStrips;
    }
}

