/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.renderer;

import de.jaret.util.date.Interval;
import de.jaret.util.misc.FormatHelper;
import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.swt.renderer.RendererBase;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarGapRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class DefaultGapRenderer
extends RendererBase
implements TimeBarGapRenderer {
    private static final int PRINTING_LINEWIDTH = 3;
    private static final Color DEFAULT_COLOR = Display.getCurrent().getSystemColor(16);

    public DefaultGapRenderer(Printer printer) {
        super(printer);
    }

    public DefaultGapRenderer() {
        super(null);
    }

    public void draw(GC gc, TimeBarViewerDelegate delegate, TimeBarRow row, Interval i1, Interval i2, Rectangle drawingArea, boolean printing) {
        int ox = drawingArea.x;
        int oy = drawingArea.y;
        int width = drawingArea.width;
        int height = drawingArea.height;
        boolean horizontal = delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL;
        Color fg = gc.getForeground();
        int diffminutes = (int)i2.getBegin().diffMinutes(i1.getEnd());
        String timeString = FormatHelper.NFInt2Digits().format(diffminutes / 60) + ":" + FormatHelper.NFInt2Digits().format(diffminutes % 60);
        int twidth = SwtGraphicsHelper.getStringDrawingWidth((GC)gc, (String)timeString);
        int theight = SwtGraphicsHelper.getStringDrawingHeight((GC)gc, (String)timeString);
        gc.setForeground(DEFAULT_COLOR);
        if (horizontal) {
            if (width > twidth + 3 && height / 2 >= theight) {
                SwtGraphicsHelper.drawStringCentered((GC)gc, (String)timeString, (int)(ox + width / 2), (int)(oy + height / 2 - 2));
            }
        } else if (height > theight + 3 && width / 2 >= twidth) {
            SwtGraphicsHelper.drawStringCenteredAroundPoint((GC)gc, (String)timeString, (int)(ox + width / 2), (int)(oy + height / 2));
        }
        if (printing) {
            gc.setLineWidth(3);
        }
        if (horizontal) {
            if (width > 15) {
                SwtGraphicsHelper.drawArrowLine((GC)gc, (int)(ox + 2), (int)(oy + height / 2), (int)(ox + width - 3), (int)(oy + height / 2), (int)this.scaleX(4), (int)this.scaleY(3), (boolean)true, (boolean)true);
            }
        } else if (height > 15) {
            SwtGraphicsHelper.drawArrowLineVertical((GC)gc, (int)(ox + width / 2), (int)(oy + 2), (int)(ox + width / 2), (int)(oy + height - 3), (int)this.scaleX(3), (int)this.scaleY(4), (boolean)true, (boolean)true);
        }
        gc.setLineWidth(1);
        gc.setForeground(fg);
    }

    public void dispose() {
    }

    public TimeBarGapRenderer createPrintRenderer(Printer printer) {
        DefaultGapRenderer renderer = new DefaultGapRenderer(printer);
        return renderer;
    }
}

