/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.renderer;

import de.jaret.util.date.DateUtils;
import de.jaret.util.date.JaretDate;
import de.jaret.util.date.holidayenumerator.HolidayEnumerator;
import de.jaret.util.ui.timebars.TickScaler;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.swt.renderer.GridRenderer;
import de.jaret.util.ui.timebars.swt.renderer.RendererBase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class DefaultGridRenderer
extends RendererBase
implements GridRenderer {
    private static final RGB MAJORGRID_COLOR = new RGB(200, 200, 200);
    private static final RGB MINORGRID_COLOR = new RGB(230, 230, 230);
    private static final RGB SATURDAY_COLOR = new RGB(255, 230, 230);
    private static final RGB SUNDAY_COLOR = new RGB(255, 200, 200);
    private static final RGB SPECIALDAY_COLOR = new RGB(255, 255, 207);
    private static final int PRINTING_LINEWIDTH = 3;
    private Color _colorMajorGrid;
    private Color _colorMinorGrid;
    private Color _colorSaturday;
    private Color _colorSunday;
    private Color _colorSpecialDay;
    private HolidayEnumerator _holidayEnumerator;
    private boolean _markWeekends = true;
    private boolean _markSpecialdays = true;
    private boolean _markHolidays = true;
    private double _upperPPSMarkLimit = 0.01;

    public DefaultGridRenderer(Printer printer) {
        super(printer);
        this._colorMajorGrid = new Color((Device)printer, MAJORGRID_COLOR);
        this._colorMinorGrid = new Color((Device)printer, MINORGRID_COLOR);
        this._colorSaturday = new Color((Device)printer, SATURDAY_COLOR);
        this._colorSunday = new Color((Device)printer, SUNDAY_COLOR);
        this._colorSpecialDay = new Color((Device)printer, SPECIALDAY_COLOR);
    }

    public DefaultGridRenderer() {
        super(null);
        this._colorMajorGrid = new Color((Device)Display.getCurrent(), MAJORGRID_COLOR);
        this._colorMinorGrid = new Color((Device)Display.getCurrent(), MINORGRID_COLOR);
        this._colorSaturday = new Color((Device)Display.getCurrent(), SATURDAY_COLOR);
        this._colorSunday = new Color((Device)Display.getCurrent(), SUNDAY_COLOR);
        this._colorSpecialDay = new Color((Device)Display.getCurrent(), SPECIALDAY_COLOR);
    }

    public void setHolidayEnumerator(HolidayEnumerator he) {
        this._holidayEnumerator = he;
    }

    public void setMarkWeekends(boolean mark) {
        this._markWeekends = mark;
    }

    public void setMarkSpecialDays(boolean mark) {
        this._markSpecialdays = mark;
    }

    public void setMarkHolidays(boolean mark) {
        this._markHolidays = mark;
    }

    public void setUpperPPSMarkLimit(double limit) {
        this._upperPPSMarkLimit = limit;
    }

    public void draw(GC gc, TimeBarViewerDelegate delegate, Rectangle drawingArea, boolean printing) {
        int adv;
        int max;
        int idx;
        int ox = drawingArea.x;
        int oy = drawingArea.y;
        int width = drawingArea.width;
        int height = drawingArea.height;
        Color fg = gc.getForeground();
        if (!printing) {
            idx = TickScaler.getTickIdx(delegate.getPixelPerSecond() / this.getScaleX());
        } else {
            idx = TickScaler.getTickIdx(delegate.getPixelPerSecond() / this.getScaleX());
            this._upperPPSMarkLimit *= this.getScaleX();
        }
        int majTick = TickScaler.getMajorTickMinutes(idx);
        int minTick = TickScaler.getMinorTickMinutes(idx);
        TickScaler.Range range = TickScaler.getRange(idx);
        JaretDate date = delegate.getStartDate().copy();
        date.setMinutes(0);
        date.setHours(0);
        date.setSeconds(0);
        if (range == TickScaler.Range.WEEK) {
            while (date.getDayOfWeek() != DateUtils.getFirstDayOfWeek()) {
                date.backDays(1.0);
            }
        } else if (range == TickScaler.Range.MONTH) {
            date.setDay(1);
        }
        JaretDate save = date.copy();
        boolean horizontal = delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL;
        int n = max = horizontal ? ox + width : oy + height;
        if (this._markHolidays || this._markSpecialdays || this._markWeekends) {
            Color bg = gc.getBackground();
            if (range == TickScaler.Range.DAY || range == TickScaler.Range.WEEK || range == TickScaler.Range.HOUR && delegate.getPixelPerSecond() < this._upperPPSMarkLimit) {
                int daywidth = (int)(delegate.getPixelPerSecond() * 24.0 * 60.0 * 60.0);
                while (delegate.xForDate(date) < max) {
                    int x = delegate.xForDate(date);
                    Color mark = null;
                    if (this._holidayEnumerator != null) {
                        if (this._markHolidays && this._holidayEnumerator.isHoliday(date.getDate())) {
                            mark = this._colorSunday;
                        } else if (this._markSpecialdays && this._holidayEnumerator.isSpecialDay(date.getDate())) {
                            mark = this._colorSpecialDay;
                        }
                    }
                    if (mark == null && this._markWeekends) {
                        if (date.getDayOfWeek() == 7) {
                            mark = this._colorSaturday;
                        } else if (date.getDayOfWeek() == 1) {
                            mark = this._colorSunday;
                        }
                    }
                    if (mark != null) {
                        gc.setBackground(mark);
                        if (delegate.hasVariableXScale()) {
                            int x2 = delegate.xForDate(date.copy().advanceDays(1));
                            daywidth = x2 - x;
                        }
                        if (horizontal) {
                            gc.fillRectangle(x, oy, daywidth, height);
                        } else {
                            gc.fillRectangle(ox, x, width, daywidth);
                        }
                    }
                    date.advanceDays(1);
                }
            }
            gc.setBackground(bg);
        }
        date = save.copy();
        if (printing) {
            gc.setLineWidth(3);
        }
        gc.setForeground(this._colorMinorGrid);
        while (delegate.xForDate(date) < max) {
            int x = delegate.xForDate(date);
            if (horizontal) {
                gc.drawLine(x, oy, x, oy + height);
            } else {
                gc.drawLine(ox, x, ox + width, x);
            }
            if (range == TickScaler.Range.MONTH) {
                adv = Math.round(minTick / 40320);
                if (adv == 0) {
                    adv = 1;
                }
                date.advanceMonths(adv);
                continue;
            }
            date.advanceMinutes((double)minTick);
        }
        date = save.copy();
        gc.setForeground(this._colorMajorGrid);
        while (delegate.xForDate(date) < ox + width) {
            int x = delegate.xForDate(date);
            if (horizontal) {
                gc.drawLine(x, oy, x, oy + height);
            } else {
                gc.drawLine(ox, x, ox + width, x);
            }
            if (range == TickScaler.Range.MONTH) {
                adv = Math.round(majTick / 40320);
                if (adv == 0) {
                    adv = 1;
                }
                date.advanceMonths(adv);
                continue;
            }
            date.advanceMinutes((double)majTick);
        }
        gc.setLineWidth(1);
        gc.setForeground(fg);
    }

    public void dispose() {
        this._colorMajorGrid.dispose();
        this._colorMinorGrid.dispose();
        this._colorSaturday.dispose();
        this._colorSpecialDay.dispose();
        this._colorSunday.dispose();
    }

    public GridRenderer createPrintRenderer(Printer printer) {
        DefaultGridRenderer renderer = new DefaultGridRenderer(printer);
        renderer.setHolidayEnumerator(this._holidayEnumerator);
        renderer.setMarkHolidays(this._markHolidays);
        renderer.setMarkSpecialDays(this._markSpecialdays);
        renderer.setMarkWeekends(this._markWeekends);
        return renderer;
    }
}

