/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.renderer;

import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.model.TimeBarRowHeader;
import de.jaret.util.ui.timebars.swt.renderer.HeaderRenderer;
import de.jaret.util.ui.timebars.swt.renderer.RendererBase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class DefaultHeaderRenderer
extends RendererBase
implements HeaderRenderer {
    private static final int PRINTING_LINEWIDTH = 3;

    public DefaultHeaderRenderer(Printer printer) {
        super(printer);
    }

    public DefaultHeaderRenderer() {
        super(null);
    }

    public void draw(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, TimeBarRowHeader header, boolean selected, boolean printing) {
        if (printing) {
            this.print(gc, drawingArea, delegate, header);
        } else {
            String str = header.toString();
            Color bg = gc.getBackground();
            Color fg = gc.getForeground();
            if (selected) {
                gc.setBackground(Display.getCurrent().getSystemColor(9));
                gc.setForeground(Display.getCurrent().getSystemColor(1));
            }
            gc.fillRectangle(drawingArea);
            SwtGraphicsHelper.drawStringCenteredVCenter((GC)gc, (String)str, (int)drawingArea.x, (int)(drawingArea.x + drawingArea.width), (int)(drawingArea.y + drawingArea.height / 2));
            gc.setBackground(bg);
            gc.setForeground(fg);
            if (delegate.getDrawRowGrid()) {
                if (delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL) {
                    gc.drawLine(drawingArea.x, drawingArea.y + drawingArea.height - 1, drawingArea.x + drawingArea.width, drawingArea.y + drawingArea.height - 1);
                } else {
                    gc.drawLine(drawingArea.x + drawingArea.width - 1, drawingArea.y, drawingArea.x + drawingArea.width - 1, drawingArea.y + drawingArea.height - 1);
                }
            }
        }
    }

    public String getToolTipText(TimeBarRow row, Rectangle drawingArea, int x, int y) {
        if (row == null) {
            return null;
        }
        return row.getRowHeader().getLabel();
    }

    public boolean contains(Rectangle drawingArea, int x, int y) {
        return true;
    }

    public void dispose() {
    }

    public void print(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, TimeBarRowHeader header) {
        String str = header.toString();
        SwtGraphicsHelper.drawStringCenteredVCenter((GC)gc, (String)str, (int)drawingArea.x, (int)(drawingArea.x + drawingArea.width), (int)(drawingArea.y + drawingArea.height / 2));
        if (delegate.getDrawRowGrid()) {
            gc.setLineWidth(3);
            gc.drawLine(drawingArea.x, drawingArea.y + drawingArea.height - 3, drawingArea.x + drawingArea.width, drawingArea.y + drawingArea.height - 3);
            gc.setLineWidth(1);
        }
    }

    public HeaderRenderer createPrintRenderer(Printer printer) {
        return new DefaultHeaderRenderer(printer);
    }
}

