/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.renderer;

import de.jaret.util.ui.ResourceImageDescriptor;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.model.StdHierarchicalTimeBarModel;
import de.jaret.util.ui.timebars.model.TimeBarNode;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.swt.TimeBarViewer;
import de.jaret.util.ui.timebars.swt.renderer.HierarchyRenderer;
import de.jaret.util.ui.timebars.swt.renderer.RendererBase;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHierarchyRenderer
extends RendererBase
implements HierarchyRenderer {
    protected static final int DEFAULT_SIZE = 12;
    protected static final int SYMBOLINSETS = 3;
    protected static final int DEFAULT_LEVEL_WIDTH = 16;
    protected static final int LABELGAP = 4;
    protected static final int PRINTINGLINEWIDTH = 3;
    protected int _size = 12;
    protected int _signInsets = 3;
    protected boolean _drawTreeLines = true;
    protected int _levelWidth = 16;
    protected boolean _fixedLevelWidth = false;
    protected boolean _drawIcons = false;
    protected boolean _drawLabels = false;
    protected Map<Class<? extends TimeBarRow>, ILabelProvider> _labelProviderMap = new HashMap<Class<? extends TimeBarRow>, ILabelProvider>();
    protected static final String PLUS = "plus";
    protected static final String MINUS = "minus";
    protected static final String LEAF = "leaf";
    private ImageRegistry _imageRegistry;
    protected String _plusRscName;
    protected String _minusRscName;
    protected String _leafRscName;

    public DefaultHierarchyRenderer(Printer printer) {
        super(printer);
        this._size = this.scaleX(12);
        this._signInsets = this.scaleX(this._signInsets);
        this._levelWidth = this.scaleX(this._levelWidth);
    }

    public DefaultHierarchyRenderer() {
        super(null);
    }

    @Override
    public void draw(GC gc, Rectangle drawingArea, TimeBarViewerDelegate tbv, TimeBarRow row, boolean selected, boolean expanded, boolean leaf, int level, int depth, boolean printing) {
        int offx = !this._fixedLevelWidth && depth > 0 ? (drawingArea.width - this._size) / (depth + 1) : this.scaleX(this._levelWidth);
        int x = drawingArea.x + offx * level + this._size / 2;
        int y = drawingArea.y + (drawingArea.height - this._size) / 2;
        if (leaf && !this._drawIcons) {
            this.drawLeafSymbol(gc, this._size, x, y);
        } else if (expanded && !leaf) {
            this.drawExpanded(gc, this._size, x, y);
        } else if (!leaf) {
            this.drawCollapsed(gc, this._size, x, y);
        }
        x += this._size + 4;
        ILabelProvider labelProvider = this.getLabelProvider(row.getClass());
        if (labelProvider != null && (this._drawIcons || this._drawLabels)) {
            String label;
            Image img;
            int labelx = x;
            if (this._drawIcons && (img = labelProvider.getImage((Object)row)) != null) {
                if (!printing) {
                    gc.drawImage(img, x, y);
                    labelx += img.getBounds().width;
                } else {
                    gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x, y, this.scaleX(img.getBounds().width), this.scaleY(img.getBounds().height));
                    labelx += this.scaleX(img.getBounds().width);
                }
            }
            if (this._drawLabels && (label = labelProvider.getText((Object)row)) != null) {
                if (!printing && selected) {
                    Color bg = gc.getBackground();
                    gc.setBackground(Display.getCurrent().getSystemColor(9));
                    gc.drawString(label, labelx, y);
                    gc.setBackground(bg);
                } else {
                    gc.drawString(label, labelx, y);
                }
            }
        }
        if (this._drawTreeLines) {
            TimeBarNode node = (TimeBarNode)row;
            if (printing) {
                gc.setLineWidth(3);
            }
            gc.setLineStyle(3);
            int midy = drawingArea.y + (drawingArea.height - this._size) / 2 + this._size / 2;
            int icoy = drawingArea.y + (drawingArea.height - this._size) / 2 + this._size;
            int icox = drawingArea.x + offx * level + this._size - this._size / 2;
            int midx = drawingArea.x + offx * level + this._size;
            int beginx = drawingArea.x + offx * (level - 1) + this._size;
            gc.drawLine(beginx, midy, icox, midy);
            gc.drawLine(beginx, drawingArea.y, beginx, midy);
            if (!leaf && expanded) {
                gc.drawLine(midx, icoy, midx, drawingArea.y + drawingArea.height);
            }
            if (tbv.getModel() instanceof StdHierarchicalTimeBarModel) {
                StdHierarchicalTimeBarModel model = (StdHierarchicalTimeBarModel)tbv.getModel();
                for (int i = 0; i < level; ++i) {
                    if (!model.moreSiblings(node, i)) continue;
                    x = drawingArea.x + offx * i + this._size;
                    gc.drawLine(x, drawingArea.y, x, drawingArea.y + drawingArea.height);
                }
            }
            gc.setLineStyle(1);
            gc.setLineWidth(1);
        }
    }

    protected void drawCollapsed(GC gc, int size, int x, int y) {
        if (this._plusRscName != null) {
            ImageRegistry registry = this.getImageRegistry();
            Image img = registry.get(PLUS);
            if (img != null) {
                gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x, y, size, size);
            }
        } else {
            this.drawPlus(gc, size, x, y);
        }
    }

    protected void drawExpanded(GC gc, int size, int x, int y) {
        if (this._minusRscName != null) {
            ImageRegistry registry = this.getImageRegistry();
            Image img = registry.get(MINUS);
            if (img != null) {
                gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x, y, size, size);
            }
        } else {
            this.drawMinus(gc, size, x, y);
        }
    }

    protected void drawLeafSymbol(GC gc, int size, int x, int y) {
        if (this._leafRscName != null) {
            ImageRegistry registry = this.getImageRegistry();
            Image img = registry.get(LEAF);
            if (img != null) {
                gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x, y, size, size);
            }
        } else {
            this.drawLeaf(gc, size, x, y);
        }
    }

    protected void drawPlus(GC gc, int size, int x, int y) {
        gc.drawLine(x + this._signInsets, y + size / 2, x + size - this._signInsets, y + size / 2);
        gc.drawLine(x + size / 2, y + this._signInsets, x + size / 2, y + size - this._signInsets);
        gc.drawRectangle(x, y, size, size);
    }

    protected void drawMinus(GC gc, int size, int x, int y) {
        gc.drawLine(x + this._signInsets, y + size / 2, x + size - this._signInsets, y + size / 2);
        gc.drawRectangle(x, y, size, size);
    }

    protected void drawLeaf(GC gc, int size, int x, int y) {
        Color bg = gc.getBackground();
        gc.setBackground(Display.getCurrent().getSystemColor(2));
        gc.fillOval(x + size / 2, y + size / 2, size / 2, size / 2);
        gc.setBackground(bg);
    }

    @Override
    public String getToolTipText(TimeBarNode node, Rectangle drawingArea, int x, int y) {
        if (node != null) {
            return node.getRowHeader().getLabel();
        }
        return null;
    }

    @Override
    public boolean isInToggleArea(TimeBarViewerInterface tbv, TimeBarNode node, Rectangle drawingArea, int xx, int yy) {
        int depth = tbv.getHierarchicalModel().getDepth();
        int offx = !this._fixedLevelWidth && depth > 0 ? (drawingArea.width - this._size) / (depth + 1) : this.scaleX(this._levelWidth);
        int level = node.getLevel();
        int x = drawingArea.x + offx * level + this._size / 2;
        int y = drawingArea.y + (drawingArea.height - this._size) / 2;
        return x <= xx && xx <= x + this._size && y <= yy && yy <= y + this._size;
    }

    @Override
    public boolean isInHierarchySelectionArea(TimeBarViewer tbv, TimeBarNode node, Rectangle drawingArea, int xx, int yy) {
        int depth = tbv.getHierarchicalModel().getDepth();
        int offx = !this._fixedLevelWidth && depth > 0 ? (drawingArea.width - this._size) / (depth + 1) : this.scaleX(this._levelWidth);
        int level = node.getLevel();
        int x = drawingArea.x + offx * level + this._size / 2;
        int y = drawingArea.y + (drawingArea.height - this._size) / 2;
        x += this._size + 4;
        ILabelProvider labelProvider = this.getLabelProvider(node.getClass());
        if (labelProvider != null && (this._drawIcons || this._drawLabels)) {
            String label;
            Image img;
            int labelx = x;
            Rectangle selRect = new Rectangle(x, y, 0, 0);
            if (this._drawIcons && (img = labelProvider.getImage((Object)node)) != null) {
                labelx += img.getBounds().width;
                selRect.width += img.getBounds().width;
                selRect.height += img.getBounds().height;
            }
            if (this._drawLabels && (label = labelProvider.getText((Object)node)) != null) {
                selRect.width += drawingArea.width - selRect.x;
                selRect.height = Math.max(selRect.height, 16);
            }
            return selRect.contains(xx, yy);
        }
        return false;
    }

    @Override
    public int getPreferredWidth() {
        return this.scaleX(this._size + 4);
    }

    @Override
    public void dispose() {
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
        }
    }

    public boolean getFixedLevelWidth() {
        return this._fixedLevelWidth;
    }

    public void setFixedLevelWidth(boolean fixedLevelWidth) {
        this._fixedLevelWidth = fixedLevelWidth;
    }

    public ILabelProvider getLabelProvider() {
        return this.getLabelProvider(TimeBarRow.class);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.registerLabelProvider(TimeBarRow.class, labelProvider);
    }

    public void registerLabelProvider(Class<? extends TimeBarRow> clazz, ILabelProvider labelProvider) {
        this._labelProviderMap.put(clazz, labelProvider);
    }

    protected void setLabelProviderMap(Map<Class<? extends TimeBarRow>, ILabelProvider> map) {
        this._labelProviderMap = map;
    }

    protected ILabelProvider getLabelProvider(Class<? extends TimeBarRow> clazz) {
        Class<?>[] interfaces;
        ILabelProvider result = null;
        result = this._labelProviderMap.get(clazz);
        if (result != null) {
            return result;
        }
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            result = this._labelProviderMap.get(c);
            if (result == null) continue;
            return result;
        }
        for (Class<? extends TimeBarRow> sc = clazz.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            Class<?>[] scinterfaces;
            result = this._labelProviderMap.get(sc);
            if (result != null) {
                return result;
            }
            for (Class<?> c : scinterfaces = sc.getInterfaces()) {
                result = this._labelProviderMap.get(c);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public int getLevelWidth() {
        return this._levelWidth;
    }

    public void setLevelWidth(int levelWidth) {
        this._levelWidth = levelWidth;
    }

    public boolean getDrawIcons() {
        return this._drawIcons;
    }

    public void setDrawIcons(boolean drawIcons) {
        this._drawIcons = drawIcons;
    }

    public boolean getDrawLabels() {
        return this._drawLabels;
    }

    public void setDrawLabels(boolean drawLabels) {
        this._drawLabels = drawLabels;
    }

    @Override
    public HierarchyRenderer createPrintRenderer(Printer printer) {
        DefaultHierarchyRenderer r = new DefaultHierarchyRenderer(printer);
        r.setDrawIcons(this._drawIcons);
        r.setDrawLabels(this._drawLabels);
        r.setFixedLevelWidth(this._fixedLevelWidth);
        r.setLevelWidth(this._levelWidth);
        r.setLabelProviderMap(this._labelProviderMap);
        r.setRscNames(this._plusRscName, this._minusRscName, this._leafRscName);
        return r;
    }

    public void setRscNames(String plusRscPath, String minusRscPath, String leafRscPath) {
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
            this._imageRegistry = null;
        }
        this._plusRscName = plusRscPath;
        this._minusRscName = minusRscPath;
        this._leafRscName = leafRscPath;
    }

    public void setImageDescriptors(ImageDescriptor plus, ImageDescriptor minus, ImageDescriptor leaf) {
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
        }
        this._imageRegistry = new ImageRegistry();
        this._imageRegistry.put(PLUS, plus);
        this._imageRegistry.put(MINUS, minus);
        this._imageRegistry.put(LEAF, leaf);
        this._plusRscName = "plusRscPath";
        this._minusRscName = "minusRscPath";
        this._leafRscName = "leafRscPath";
    }

    private ImageRegistry getImageRegistry() {
        if (this._imageRegistry == null) {
            this._imageRegistry = new ImageRegistry();
            ResourceImageDescriptor imgDesc = new ResourceImageDescriptor(this._plusRscName, this.getClass());
            this._imageRegistry.put(PLUS, imgDesc.createImage());
            imgDesc = new ResourceImageDescriptor(this._minusRscName, this.getClass());
            this._imageRegistry.put(MINUS, imgDesc.createImage());
            imgDesc = new ResourceImageDescriptor(this._leafRscName, this.getClass());
            this._imageRegistry.put(LEAF, imgDesc.createImage());
        }
        return this._imageRegistry;
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int size) {
        this._size = size;
    }

    public boolean getDrawTreeLines() {
        return this._drawTreeLines;
    }

    public void setDrawTreeLines(boolean drawTreeLines) {
        this._drawTreeLines = drawTreeLines;
    }
}

