/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.renderer;

import de.jaret.util.date.Interval;
import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.swt.renderer.AbstractTimeBarRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarRenderer2;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRenderer
extends AbstractTimeBarRenderer
implements TimeBarRenderer,
TimeBarRenderer2 {
    protected static final double BORDERFACTOR = 0.2;
    protected TimeBarViewerDelegate _delegate;
    protected Map<Class<? extends Interval>, TimeBarRenderer> _rendererMap;

    public DefaultRenderer(Printer printer) {
        super(printer);
    }

    public DefaultRenderer() {
        super(null);
    }

    public void registerTimeBarRenderer(Class<? extends Interval> intervalClass, TimeBarRenderer renderer) {
        if (this._rendererMap == null) {
            this._rendererMap = new HashMap<Class<? extends Interval>, TimeBarRenderer>();
        }
        this._rendererMap.put(intervalClass, renderer);
    }

    private TimeBarRenderer getRenderer(Class<? extends Interval> clazz) {
        Class<?>[] interfaces;
        TimeBarRenderer result = null;
        result = this._rendererMap.get(clazz);
        if (result != null) {
            return result;
        }
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            result = this._rendererMap.get(c);
            if (result == null) continue;
            return result;
        }
        for (Class<? extends Interval> sc = clazz.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            Class<?>[] scinterfaces;
            result = this._rendererMap.get(sc);
            if (result != null) {
                return result;
            }
            for (Class<?> c : scinterfaces = sc.getInterfaces()) {
                result = this._rendererMap.get(c);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    @Override
    public void draw(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, Interval interval, boolean selected, boolean printing, boolean overlap) {
        TimeBarRenderer renderer = null;
        this._delegate = delegate;
        if (this._rendererMap != null) {
            renderer = this.getRenderer(interval.getClass());
        }
        if (renderer == null) {
            if (!printing) {
                this.defaultDraw(gc, drawingArea, delegate, interval, selected, printing, overlap);
            } else {
                this.print(gc, drawingArea, delegate, interval, overlap);
            }
        } else {
            renderer.draw(gc, drawingArea, delegate, interval, selected, printing, overlap);
        }
    }

    @Override
    public String getToolTipText(Interval interval, Rectangle drawingArea, int x, int y, boolean overlapping) {
        TimeBarRenderer renderer = null;
        if (this._rendererMap != null) {
            renderer = this._rendererMap.get(interval.getClass());
        }
        if (renderer == null) {
            return this.getToolTipText(this._delegate, interval, drawingArea, x, y, overlapping);
        }
        return renderer.getToolTipText(interval, drawingArea, x, y, overlapping);
    }

    @Override
    public boolean contains(Interval interval, Rectangle drawingArea, int x, int y, boolean overlapping) {
        TimeBarRenderer renderer = null;
        if (this._rendererMap != null) {
            renderer = this._rendererMap.get(interval.getClass());
        }
        if (renderer == null) {
            return this.contains(this._delegate, interval, drawingArea, x, y, overlapping);
        }
        return renderer.contains(interval, drawingArea, x, y, overlapping);
    }

    @Override
    public Rectangle getContainingRectangle(Interval interval, Rectangle drawingArea, boolean overlapping) {
        TimeBarRenderer renderer = null;
        if (this._rendererMap != null) {
            renderer = this._rendererMap.get(interval.getClass());
        }
        if (renderer == null) {
            return this.getContainingRectangle(this._delegate, interval, drawingArea, overlapping);
        }
        return renderer.getContainingRectangle(interval, drawingArea, overlapping);
    }

    @Override
    public TimeBarRenderer createPrintrenderer(Printer printer) {
        DefaultRenderer renderer = new DefaultRenderer(printer);
        if (this._rendererMap != null) {
            for (Class<? extends Interval> clazz : this._rendererMap.keySet()) {
                TimeBarRenderer r = this._rendererMap.get(clazz);
                renderer.registerTimeBarRenderer(clazz, r.createPrintrenderer(printer));
            }
        }
        return renderer;
    }

    @Override
    public void dispose() {
        if (this._rendererMap != null) {
            for (Class<? extends Interval> clazz : this._rendererMap.keySet()) {
                TimeBarRenderer r = this._rendererMap.get(clazz);
                r.dispose();
            }
        }
    }

    private void defaultDraw(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, Interval interval, boolean selected, boolean printing, boolean overlap) {
        this.drawFocus(gc, drawingArea, delegate, interval, selected, printing, overlap);
        boolean horizontal = delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL;
        Rectangle iRect = this.getIRect(horizontal, drawingArea, overlap);
        Color bg = gc.getBackground();
        String str = interval.toString();
        if (!selected) {
            gc.setBackground(Display.getCurrent().getSystemColor(15));
        } else {
            gc.setBackground(Display.getCurrent().getSystemColor(9));
        }
        gc.fillRectangle(iRect);
        gc.drawRectangle(iRect);
        SwtGraphicsHelper.drawStringCentered((GC)gc, (String)str, (Rectangle)iRect);
        gc.setBackground(bg);
    }

    @Override
    public String getToolTipText(TimeBarViewerDelegate delegate, Interval interval, Rectangle drawingArea, int x, int y, boolean overlapping) {
        if (this.contains(delegate, interval, drawingArea, x, y, overlapping)) {
            return interval.toString();
        }
        return null;
    }

    @Override
    public boolean contains(TimeBarViewerDelegate delegate, Interval interval, Rectangle drawingArea, int x, int y, boolean overlapping) {
        boolean horizontal = true;
        if (null != delegate) {
            horizontal = delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL;
        }
        Rectangle iRect = this.getIRect(horizontal, drawingArea, overlapping);
        return iRect.contains(drawingArea.x + x, drawingArea.y + y);
    }

    @Override
    public Rectangle getContainingRectangle(TimeBarViewerDelegate delegate, Interval interval, Rectangle drawingArea, boolean overlapping) {
        boolean horizontal = delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL;
        Rectangle iRect = this.getIRect(horizontal, drawingArea, overlapping);
        return iRect;
    }

    private void print(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, Interval interval, boolean overlap) {
        boolean horizontal = delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL;
        Rectangle iRect = this.getIRect(horizontal, drawingArea, overlap);
        Color bg = gc.getBackground();
        gc.setLineWidth(2);
        gc.setBackground(this._printer.getSystemColor(15));
        gc.fillRectangle(iRect);
        gc.drawRectangle(iRect);
        String str = interval.toString();
        gc.setLineWidth(1);
        SwtGraphicsHelper.drawStringCentered((GC)gc, (String)str, (Rectangle)iRect);
        gc.setBackground(bg);
    }

    protected Rectangle getIRect(boolean horizontal, Rectangle drawingArea, boolean overlap) {
        if (horizontal) {
            int borderHeight = (int)((double)drawingArea.height * 0.2 / 2.0);
            int height = drawingArea.height - (overlap ? 0 : 2 * borderHeight);
            int y = drawingArea.y + (overlap ? 0 : borderHeight);
            return new Rectangle(drawingArea.x, y, drawingArea.width - 1, height - 1);
        }
        int borderWidth = (int)((double)drawingArea.width * 0.2 / 2.0);
        int width = drawingArea.width - (overlap ? 0 : 2 * borderWidth);
        int x = drawingArea.x + (overlap ? 0 : borderWidth);
        return new Rectangle(x, drawingArea.y, width - 1, drawingArea.height - 1);
    }
}

