/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.renderer;

import de.jaret.util.ui.timebars.TimeBarMarker;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.swt.renderer.RendererBase;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarMarkerRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class DefaultTimeBarMarkerRenderer
extends RendererBase
implements TimeBarMarkerRenderer {
    private static final Color MARKER_ACTIVE_COLOR = Display.getCurrent().getSystemColor(9);
    private static final Color MARKER_COLOR = Display.getCurrent().getSystemColor(3);
    private static final int PRINTING_LINEWIDTH = 3;

    public DefaultTimeBarMarkerRenderer(Printer printer) {
        super(printer);
    }

    public DefaultTimeBarMarkerRenderer() {
        super(null);
    }

    public void draw(GC gc, TimeBarViewerDelegate tbv, TimeBarMarker marker, boolean isDragged, boolean printing) {
        boolean horizontal = tbv.getOrientation().equals((Object)TimeBarViewerInterface.Orientation.HORIZONTAL);
        Color oldCol = gc.getForeground();
        if (!printing) {
            if (isDragged) {
                gc.setForeground(MARKER_ACTIVE_COLOR);
            } else {
                gc.setForeground(MARKER_COLOR);
            }
        } else {
            gc.setForeground(this._printer.getSystemColor(12));
            gc.setLineWidth(3);
        }
        if (horizontal) {
            int startY = Math.min(tbv.getXAxisRect().y, tbv.getDiagramRect().y);
            int x = tbv.xForDate(marker.getDate());
            int height = tbv.getXAxisRect().height + tbv.getDiagramRect().height;
            gc.drawLine(x, startY, x, startY + height);
        } else {
            int startX = Math.min(tbv.getXAxisRect().x, tbv.getDiagramRect().x);
            int y = tbv.xForDate(marker.getDate());
            int width = tbv.getXAxisRect().width + tbv.getDiagramRect().width;
            gc.drawLine(startX, y, startX + width, y);
        }
        gc.setLineWidth(1);
        gc.setForeground(oldCol);
    }

    public void dispose() {
    }

    public int getWidth() {
        return this.scaleX(4);
    }

    public TimeBarMarkerRenderer createPrintRenderer(Printer printer) {
        return new DefaultTimeBarMarkerRenderer(printer);
    }
}

