/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.renderer;

import de.jaret.util.date.DateUtils;
import de.jaret.util.date.JaretDate;
import de.jaret.util.date.holidayenumerator.HolidayEnumerator;
import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.timebars.TickScaler;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.TimeBarViewerInterface;
import de.jaret.util.ui.timebars.swt.TimeBarViewer;
import de.jaret.util.ui.timebars.swt.renderer.RendererBase;
import de.jaret.util.ui.timebars.swt.renderer.TimeScaleRenderer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;

public class DefaultTimeScaleRenderer
extends RendererBase
implements TimeScaleRenderer {
    protected static final int PREFERREDHEIGHT = 50;
    private static final long APPROXSECONDSINMONTH = 40320L;
    protected static final int MINORLENGTH = 5;
    protected static final int MAJORLENGTH = 10;
    private TickScaler.Range _lastRange = TickScaler.Range.DAY;
    protected HolidayEnumerator _holidayEnumerator;

    public DefaultTimeScaleRenderer(Printer printer) {
        super(printer);
    }

    public DefaultTimeScaleRenderer() {
        super(null);
    }

    public void setHolidayEnumerator(HolidayEnumerator he) {
        this._holidayEnumerator = he;
    }

    public void draw(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, boolean top, boolean printing) {
        if (delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL) {
            this.drawHorizontal(gc, drawingArea, delegate, top, printing);
        } else {
            this.drawVertical(gc, drawingArea, delegate, top, printing);
        }
    }

    public void drawHorizontal(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, boolean top, boolean printing) {
        int adv;
        int x;
        TickScaler.Range range;
        int dayOff;
        int majorLabelOff;
        int majorOff;
        int minorOff;
        int basey;
        int ox = drawingArea.x;
        if (!top) {
            basey = drawingArea.y;
            minorOff = this.scaleY(5);
            majorOff = this.scaleY(10);
            majorLabelOff = this.scaleY(22);
            dayOff = this.scaleY(34);
        } else {
            basey = drawingArea.y + drawingArea.height - 1;
            minorOff = this.scaleY(-5);
            majorOff = this.scaleY(-10);
            majorLabelOff = this.scaleY(-10);
            dayOff = this.scaleY(-22);
        }
        int oy = basey;
        int width = drawingArea.width;
        JaretDate date = delegate.getStartDate().copy();
        int idx = !printing ? TickScaler.getTickIdx(delegate.getPixelPerSecond() / this.getScaleX()) : TickScaler.getTickIdx(delegate.getPixelPerSecond() / this.getScaleX());
        int majTick = TickScaler.getMajorTickMinutes(idx);
        int minTick = TickScaler.getMinorTickMinutes(idx);
        this._lastRange = range = TickScaler.getRange(idx);
        date.setMinutes(0);
        date.setHours(0);
        date.setSeconds(0);
        if (range == TickScaler.Range.WEEK) {
            while (date.getDayOfWeek() != DateUtils.getFirstDayOfWeek()) {
                date.backDays(1.0);
            }
        } else if (range == TickScaler.Range.MONTH) {
            date.setDay(1);
        }
        JaretDate save = date.copy();
        if (printing) {
            gc.setLineWidth(1);
        }
        gc.drawLine(ox, oy, ox + width, oy);
        while (delegate.xForDate(date) < ox + width) {
            x = delegate.xForDate(date);
            gc.drawLine(x, oy, x, oy + minorOff);
            if (range == TickScaler.Range.MONTH) {
                adv = Math.round((long)minTick / 40320L);
                if (adv == 0) {
                    adv = 1;
                }
                date.advanceMonths(adv);
                continue;
            }
            date.advanceMinutes((double)minTick);
        }
        date = save.copy();
        while (delegate.xForDate(date) < ox + width) {
            x = delegate.xForDate(date);
            gc.drawLine(x, oy, x, oy + majorOff);
            if (range == TickScaler.Range.MONTH) {
                adv = Math.round((long)majTick / 40320L);
                if (adv == 0) {
                    adv = 1;
                }
                date.advanceMonths(adv);
                continue;
            }
            date.advanceMinutes((double)majTick);
        }
        gc.setLineWidth(1);
        date = save.copy();
        int lastDay = date.getDay();
        boolean second = true;
        int count = 0;
        boolean third = true;
        while (delegate.xForDate(date) < drawingArea.x + drawingArea.width) {
            int x2 = delegate.xForDate(date);
            if (date.getMinutes() % (majTick * 2) == 0) {
                String str = null;
                if (range == TickScaler.Range.HOUR) {
                    str = date.toDisplayStringTime();
                } else if (range == TickScaler.Range.DAY) {
                    str = date.getShortDayOfWeekString();
                } else if (range == TickScaler.Range.WEEK) {
                    str = "KW" + date.getWeekOfYear();
                } else if (range == TickScaler.Range.MONTH) {
                    str = Integer.toString(date.getYear());
                }
                if (x2 > SwtGraphicsHelper.getStringDrawingWidth((GC)gc, (String)str) / 2) {
                    SwtGraphicsHelper.drawStringCentered((GC)gc, (String)str, (int)x2, (int)(oy + majorLabelOff));
                }
                if (range == TickScaler.Range.HOUR) {
                    str = date.getDay() != lastDay ? date.getDay() + ". (" + date.getDayOfWeekString() + ")" : "";
                    lastDay = date.getDay();
                } else if (range == TickScaler.Range.DAY || range == TickScaler.Range.WEEK) {
                    str = date.getDay() + "." + (third ? date.getShortMonthString() : "");
                } else if (range == TickScaler.Range.MONTH) {
                    str = date.getMonthString();
                }
                second = !second;
                third = count++ % 3 == 0;
                SwtGraphicsHelper.drawStringCentered((GC)gc, (String)str, (int)x2, (int)(oy + dayOff));
            }
            if (range == TickScaler.Range.MONTH) {
                int adv2 = Math.round((long)majTick / 40320L);
                if (adv2 == 0) {
                    adv2 = 1;
                }
                date.advanceMonths(adv2);
                continue;
            }
            date.advanceMinutes((double)majTick);
        }
    }

    private void drawVertical(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, boolean top, boolean printing) {
        int adv;
        int y;
        TickScaler.Range range;
        int dayOff;
        int majorLabelOff;
        int majorOff;
        int minorOff;
        int basex;
        int oy = drawingArea.y;
        if (!top) {
            basex = drawingArea.x;
            minorOff = this.scaleX(5);
            majorOff = this.scaleX(10);
            majorLabelOff = this.scaleX(22);
            dayOff = this.scaleX(34);
        } else {
            basex = drawingArea.x + drawingArea.width - 1;
            minorOff = this.scaleX(-5);
            majorOff = this.scaleX(-10);
            majorLabelOff = this.scaleX(-10);
            dayOff = this.scaleX(-22);
        }
        int ox = basex;
        int height = drawingArea.height;
        JaretDate date = delegate.getStartDate().copy();
        int idx = TickScaler.getTickIdx(delegate.getPixelPerSecond() / this.getScaleY());
        int majTick = TickScaler.getMajorTickMinutes(idx);
        int minTick = TickScaler.getMinorTickMinutes(idx);
        this._lastRange = range = TickScaler.getRange(idx);
        date.setMinutes(0);
        date.setHours(0);
        date.setSeconds(0);
        if (range == TickScaler.Range.WEEK) {
            while (date.getDayOfWeek() != DateUtils.getFirstDayOfWeek()) {
                date.backDays(1.0);
            }
        } else if (range == TickScaler.Range.MONTH) {
            date.setDay(1);
        }
        JaretDate save = date.copy();
        if (printing) {
            gc.setLineWidth(1);
        }
        gc.drawLine(ox, oy, ox, oy + height);
        while (delegate.xForDate(date) < oy + height) {
            y = delegate.xForDate(date);
            gc.drawLine(ox, y, ox + minorOff, y);
            if (range == TickScaler.Range.MONTH) {
                adv = Math.round((long)minTick / 40320L);
                if (adv == 0) {
                    adv = 1;
                }
                date.advanceMonths(adv);
                continue;
            }
            date.advanceMinutes((double)minTick);
        }
        date = save.copy();
        while (delegate.xForDate(date) < oy + height) {
            y = delegate.xForDate(date);
            gc.drawLine(ox, y, ox + majorOff, y);
            if (range == TickScaler.Range.MONTH) {
                adv = Math.round((long)majTick / 40320L);
                if (adv == 0) {
                    adv = 1;
                }
                date.advanceMonths(adv);
                continue;
            }
            date.advanceMinutes((double)majTick);
        }
        gc.setLineWidth(1);
        date = save.copy();
        while (delegate.xForDate(date) < drawingArea.y + drawingArea.height + 50) {
            y = delegate.xForDate(date);
            if (date.getMinutes() % (majTick * 2) == 0) {
                String str = null;
                if (range == TickScaler.Range.HOUR) {
                    str = date.toDisplayStringTime();
                } else if (range == TickScaler.Range.DAY) {
                    str = date.getShortDayOfWeekString();
                } else if (range == TickScaler.Range.WEEK) {
                    str = "KW" + date.getWeekOfYear();
                } else if (range == TickScaler.Range.MONTH) {
                    str = Integer.toString(date.getYear());
                }
                if (top) {
                    SwtGraphicsHelper.drawStringRightAlignedVCenter((GC)gc, (String)str, (int)(drawingArea.x + drawingArea.width + majorOff), (int)y);
                } else {
                    SwtGraphicsHelper.drawStringLeftAlignedVCenter((GC)gc, (String)str, (int)(drawingArea.x + majorOff), (int)y);
                }
            }
            if (range == TickScaler.Range.MONTH) {
                int adv2 = Math.round((long)majTick / 40320L);
                if (adv2 == 0) {
                    adv2 = 1;
                }
                date.advanceMonths(adv2);
                continue;
            }
            date.advanceMinutes((double)majTick);
        }
    }

    public String getToolTipText(TimeBarViewer tbv, Rectangle drawingArea, int x, int y) {
        TimeBarViewerDelegate delegate = (TimeBarViewerDelegate)tbv.getData("delegate");
        JaretDate date = null;
        date = delegate.getOrientation() == TimeBarViewerInterface.Orientation.HORIZONTAL ? tbv.dateForX(x) : tbv.dateForX(y);
        String str = this.getToolTipTextForDate(date, this._lastRange);
        if (this._holidayEnumerator != null && (this._holidayEnumerator.isHoliday(date.getDate()) || this._holidayEnumerator.isSpecialDay(date.getDate()))) {
            str = str + "\n" + this._holidayEnumerator.getDayName(date.getDate());
        }
        return str;
    }

    protected String getToolTipTextForDate(JaretDate date, TickScaler.Range range) {
        String str = range == TickScaler.Range.HOUR ? date.toDisplayString() : date.toDisplayStringDate();
        return str;
    }

    public int getHeight() {
        if (this._printer == null) {
            return 50;
        }
        return this.scaleY(50);
    }

    public void dispose() {
    }

    public TimeScaleRenderer createPrintRenderer(Printer printer) {
        DefaultTimeScaleRenderer dtsr = new DefaultTimeScaleRenderer(printer);
        dtsr.setHolidayEnumerator(this._holidayEnumerator);
        return dtsr;
    }
}

