/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.renderer;

import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.ResourceImageDescriptor;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.swt.renderer.RendererBase;
import de.jaret.util.ui.timebars.swt.renderer.TitleRenderer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class DefaultTitleRenderer
extends RendererBase
implements TitleRenderer {
    private static final int FONTSIZE = 14;
    protected static final String BACKGROUND = "background";
    private ImageRegistry _imageRegistry;
    protected String _backgroundRscName;
    protected Font _titleFont;

    public DefaultTitleRenderer(Printer printer) {
        super(printer);
        FontData fontdata = new FontData("Arial", 14, 1);
        this._titleFont = new Font((Device)printer, fontdata);
    }

    public DefaultTitleRenderer() {
        super(null);
        FontData fontdata = new FontData("Arial", 14, 1);
        this._titleFont = new Font((Device)Display.getCurrent(), fontdata);
    }

    public void draw(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, String title, boolean printing) {
        Image img = null;
        ImageRegistry registry = this.getImageRegistry();
        if (registry != null && (img = this.getImageRegistry().get(BACKGROUND)) != null && drawingArea.width > 0 && drawingArea.height > 0) {
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, drawingArea.x, drawingArea.y, drawingArea.width - 1, drawingArea.height - 1);
        }
        if (title != null) {
            Font oldfont = gc.getFont();
            gc.setFont(this._titleFont);
            if (img == null) {
                gc.fillRectangle(drawingArea.x, drawingArea.y, drawingArea.width - 1, drawingArea.height - 1);
            }
            SwtGraphicsHelper.drawStringCentered((GC)gc, (String)title, (Rectangle)drawingArea);
            gc.setFont(oldfont);
        }
        if (delegate.getTimeScalePosition() == 0) {
            gc.drawLine(drawingArea.x, drawingArea.y + drawingArea.height - 1, drawingArea.x + drawingArea.width, drawingArea.y + drawingArea.height - 1);
        } else if (delegate.getTimeScalePosition() == 1) {
            gc.drawLine(drawingArea.x, drawingArea.y, drawingArea.x + drawingArea.width, drawingArea.y);
        }
    }

    public TitleRenderer createPrintRenderer(Printer printer) {
        DefaultTitleRenderer renderer = new DefaultTitleRenderer(printer);
        renderer.setBackgroundRscName(this.getBackgroundRscName());
        return renderer;
    }

    public void dispose() {
        this._titleFont.dispose();
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
            this._imageRegistry = null;
        }
    }

    public String getBackgroundRscName() {
        return this._backgroundRscName;
    }

    public void setBackgroundRscName(String backgroundRscName) {
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
        }
        this._backgroundRscName = backgroundRscName;
    }

    public void setBackgroundImageDescriptor(ImageDescriptor descriptor) {
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
        }
        this._imageRegistry = new ImageRegistry();
        this._imageRegistry.put(BACKGROUND, descriptor);
    }

    private ImageRegistry getImageRegistry() {
        if (this._imageRegistry == null && this._backgroundRscName != null) {
            this._imageRegistry = new ImageRegistry();
            ResourceImageDescriptor imgDesc = new ResourceImageDescriptor(this._backgroundRscName, this.getClass());
            this._imageRegistry.put(BACKGROUND, imgDesc.createImage());
        }
        return this._imageRegistry;
    }
}

