/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.renderer;

import de.jaret.util.date.Interval;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;

public class RendererBase {
    private static final double ASSUMED_DISPLAY_DPI = 96.0;
    protected Printer _printer;
    protected double _scaleX = 1.0;
    protected double _scaleY = 1.0;

    public RendererBase(Printer printer) {
        this._printer = printer;
        if (this._printer != null) {
            Point dpi = this._printer.getDPI();
            this._scaleX = (double)dpi.x / 96.0;
            this._scaleY = (double)dpi.y / 96.0;
        }
    }

    public int scaleX(int in) {
        return (int)Math.round(this._scaleX * (double)in);
    }

    public double getScaleX() {
        return this._scaleX;
    }

    public int scaleY(int in) {
        return (int)Math.round(this._scaleY * (double)in);
    }

    public double getScaleY() {
        return this._scaleY;
    }

    public Printer getPrinter() {
        return this._printer;
    }

    public void drawFocus(GC gc, Rectangle drawingArea, TimeBarViewerDelegate delegate, Interval interval, boolean selected, boolean printing, boolean overlap) {
        if (printing) {
            return;
        }
        if (delegate.isFocussed(interval)) {
            gc.drawFocus(drawingArea.x, drawingArea.y, drawingArea.width, drawingArea.height);
        }
    }
}

