/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.util;

import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.swt.TimeBarViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;

public class TimeScaleDragSupport
implements MouseMoveListener {
    private int _lastX = -1;
    private int _lastY = -1;
    private TimeBarViewer _tbv;
    private boolean _includeDiagram = false;

    public TimeScaleDragSupport(TimeBarViewer tbv, boolean includeDiagram) {
        this._tbv = tbv;
        this._includeDiagram = includeDiagram;
        this._tbv.addMouseMoveListener(this);
    }

    public TimeScaleDragSupport(TimeBarViewer tbv) {
        this(tbv, false);
    }

    public void mouseMove(MouseEvent me) {
        TimeBarViewerDelegate delegate = (TimeBarViewerDelegate)this._tbv.getData("delegate");
        if ((me.stateMask & 0x80000) != 0 && (delegate.getXAxisRect().contains(me.x, me.y) || this._includeDiagram && delegate.getDiagramRect().contains(me.x, me.y))) {
            if (this._lastX != -1) {
                int seconds = this._tbv.dateForXY(me.x, me.y).diffSeconds(this._tbv.dateForXY(this._lastX, this._lastY));
                this._tbv.setStartDate(this._tbv.getStartDate().copy().advanceSeconds((double)(-seconds)));
            }
            this._lastX = me.x;
            this._lastY = me.y;
        } else {
            this._lastX = -1;
        }
    }
}

