/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.timebars.swt.util.actions;

import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.swt.TimeBarViewer;
import de.jaret.util.ui.timebars.swt.util.actions.CenterScaleAction;
import de.jaret.util.ui.timebars.swt.util.actions.CollapseAllAction;
import de.jaret.util.ui.timebars.swt.util.actions.CollapseNodeAction;
import de.jaret.util.ui.timebars.swt.util.actions.ExpandAllAction;
import de.jaret.util.ui.timebars.swt.util.actions.ExpandNodeAction;
import de.jaret.util.ui.timebars.swt.util.actions.ScaleMonthAction;
import de.jaret.util.ui.timebars.swt.util.actions.ScaleWeekAction;
import de.jaret.util.ui.timebars.swt.util.actions.ScaleYearAction;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;

public class JaretTimeBarsActionFactory {
    public static final String ACTION_SCALETOWEEK = ScaleWeekAction.class.getCanonicalName();
    public static final String ACTION_SCALETOMONTH = ScaleMonthAction.class.getCanonicalName();
    public static final String ACTION_SCALETOYEAR = ScaleYearAction.class.getCanonicalName();
    public static final String ACTION_CENTERSCALE = CenterScaleAction.class.getCanonicalName();
    public static final String ACTION_EXPANDALL = ExpandAllAction.class.getCanonicalName();
    public static final String ACTION_COLLAPSEALL = CollapseAllAction.class.getCanonicalName();
    public static final String ACTION_EXPANDNODE = ExpandNodeAction.class.getCanonicalName();
    public static final String ACTION_COLLAPSENODE = CollapseNodeAction.class.getCanonicalName();
    private final TimeBarViewer _viewer;
    private final TimeBarViewerDelegate _delegate;
    private Map<String, Action> _actionMap;

    public JaretTimeBarsActionFactory(TimeBarViewer viewer, TimeBarViewerDelegate delegate) {
        this._viewer = viewer;
        this._delegate = delegate;
    }

    public Action createStdAction(String name) {
        Action result;
        if (this._actionMap == null) {
            this._actionMap = new HashMap<String, Action>();
        }
        if ((result = this._actionMap.get(name)) != null) {
            return result;
        }
        if (name.equals(ACTION_SCALETOWEEK)) {
            result = new ScaleWeekAction(this._viewer, this._delegate);
        } else if (name.equals(ACTION_SCALETOMONTH)) {
            result = new ScaleMonthAction(this._viewer, this._delegate);
        } else if (name.equals(ACTION_SCALETOYEAR)) {
            result = new ScaleYearAction(this._viewer, this._delegate);
        } else if (name.equals(ACTION_CENTERSCALE)) {
            result = new CenterScaleAction(this._viewer, this._delegate);
        } else if (name.equals(ACTION_COLLAPSEALL)) {
            result = new CollapseAllAction(this._viewer, this._delegate);
        } else if (name.equals(ACTION_EXPANDALL)) {
            result = new ExpandAllAction(this._viewer, this._delegate);
        } else if (name.equals(ACTION_COLLAPSENODE)) {
            result = new CollapseNodeAction(this._viewer, this._delegate);
        } else if (name.equals(ACTION_EXPANDNODE)) {
            result = new ExpandNodeAction(this._viewer, this._delegate);
        }
        if (result != null) {
            this._actionMap.put(name, result);
        }
        return result;
    }
}

