/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.Common;
import de.mud.jta.Help;
import de.mud.jta.Plugin;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.AppletRequest;
import de.mud.jta.event.FocusStatusListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.ReturnFocusRequest;
import de.mud.jta.event.SocketRequest;
import de.mud.jta.event.SoundListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintJob;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;

public class Applet
extends JApplet {
    private static final int debug = 0;
    private String frameTitle = null;
    private RootPaneContainer appletFrame;
    private Properties options = new Properties();
    private Common pluginLoader;
    private String host;
    private String port;
    private boolean disconnect = true;
    private boolean connect = false;
    private boolean disconnectCloseWindow = true;
    private Plugin focussedPlugin;
    private Clipboard clipboard;
    private boolean online = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.pluginLoader == null) {
            try {
                this.options.load(Applet.class.getResourceAsStream("/de/mud/jta/default.conf"));
            }
            catch (Exception e) {
                try {
                    URL url = new URL(this.getCodeBase() + "default.conf");
                    this.options.load(url.openStream());
                }
                catch (Exception e1) {
                    System.err.println("jta: cannot load default.conf");
                    System.err.println("jta: try extracting it from the jar file");
                    System.err.println("jta: expected file here: " + this.getCodeBase() + "default.conf");
                }
            }
            String value = this.getParameter("config");
            if (value != null) {
                Properties appletParams = new Properties();
                URL url = null;
                try {
                    url = new URL(value);
                }
                catch (Exception e) {
                    try {
                        url = new URL(this.getCodeBase() + value);
                    }
                    catch (Exception ce) {
                        System.err.println("jta: could not find config file: " + ce);
                    }
                }
                if (url != null) {
                    try {
                        appletParams.load(Applet.class.getResourceAsStream("/de/mud/jta/" + value));
                        Enumeration<Object> ape = appletParams.keys();
                        while (ape.hasMoreElements()) {
                            String key = (String)ape.nextElement();
                            this.options.put(key, appletParams.getProperty(key));
                        }
                    }
                    catch (Exception e) {
                        try {
                            appletParams.load(url.openStream());
                            Enumeration<Object> ape = appletParams.keys();
                            while (ape.hasMoreElements()) {
                                String key = (String)ape.nextElement();
                                this.options.put(key, appletParams.getProperty(key));
                            }
                        }
                        catch (Exception e2) {
                            System.err.println("jta: could not load config file: " + e2);
                        }
                    }
                }
            }
            this.parameterOverride(this.options);
            this.pluginLoader = new Common(this.options);
            this.host = this.options.getProperty("Socket.host");
            if (this.host == null) {
                this.host = this.getCodeBase().getHost();
            }
            this.port = this.options.getProperty("Socket.port");
            if (this.port == null) {
                this.port = "23";
            }
            if (new Boolean(this.options.getProperty("Applet.connect")).booleanValue()) {
                this.connect = true;
            }
            if (!new Boolean(this.options.getProperty("Applet.disconnect")).booleanValue()) {
                this.disconnect = false;
            }
            if (!new Boolean(this.options.getProperty("Applet.disconnect.closeWindow")).booleanValue()) {
                this.disconnectCloseWindow = false;
            }
            this.frameTitle = this.options.getProperty("Applet.detach.title");
            this.appletFrame = new Boolean(this.options.getProperty("Applet.detach")).booleanValue() ? (this.frameTitle == null ? new JFrame("jta: " + this.host + (this.port.equals("23") ? "" : " " + this.port)) : new JFrame(this.frameTitle)) : this;
            this.appletFrame.getContentPane().setLayout(new BorderLayout());
            Map componentList = this.pluginLoader.getComponents();
            for (String name : componentList.keySet()) {
                Component c = (Component)componentList.get(name);
                value = this.options.getProperty("layout." + name);
                if (value != null) {
                    this.appletFrame.getContentPane().add(value, c);
                    continue;
                }
                System.err.println("jta: no layout property set for '" + name + "'");
                System.err.println("jta: ignoring '" + name + "'");
            }
            this.pluginLoader.registerPluginListener(new SoundListener(){

                public void playSound(URL audioClip) {
                    Applet.this.getAudioClip(audioClip).play();
                }
            });
            this.pluginLoader.broadcast(new AppletRequest(this));
            if (this.appletFrame != this) {
                final String startText = this.options.getProperty("Applet.detach.startText");
                final String stopText = this.options.getProperty("Applet.detach.stopText");
                final Button close = new Button();
                Vector privileges = Common.split(this.options.getProperty("Applet.Netscape.privilege"), ',');
                Class<?> privilegeManager = null;
                Method enable = null;
                try {
                    privilegeManager = Class.forName("netscape.security.PrivilegeManager");
                    enable = privilegeManager.getMethod("enablePrivilege", String.class);
                }
                catch (Exception e) {
                    System.err.println("Applet: This is not Netscape ...");
                }
                if (privilegeManager != null && enable != null && privileges != null) {
                    for (int i = 0; i < privileges.size(); ++i) {
                        try {
                            enable.invoke(privilegeManager, privileges.elementAt(i));
                            System.out.println("Applet: access for '" + privileges.elementAt(i) + "' allowed");
                            continue;
                        }
                        catch (Exception e) {
                            System.err.println("Applet: access for '" + privileges.elementAt(i) + "' denied");
                        }
                    }
                }
                try {
                    this.clipboard = this.appletFrame.getContentPane().getToolkit().getSystemClipboard();
                    System.err.println("Applet: acquired system clipboard: " + this.clipboard);
                }
                catch (Exception e) {
                    System.err.println("Applet: system clipboard access denied: " + (e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e));
                }
                finally {
                    if (this.clipboard == null) {
                        System.err.println("Applet: copy & paste only within the JTA");
                        this.clipboard = new Clipboard("de.mud.jta.Main");
                    }
                }
                if (new Boolean(this.options.getProperty("Applet.detach.immediately")).booleanValue()) {
                    if (new Boolean(this.options.getProperty("Applet.detach.fullscreen")).booleanValue()) {
                        ((JFrame)this.appletFrame).setSize(this.appletFrame.getContentPane().getToolkit().getScreenSize());
                    } else {
                        ((JFrame)this.appletFrame).pack();
                    }
                    ((JFrame)this.appletFrame).show();
                    this.pluginLoader.broadcast(new SocketRequest(this.host, Integer.parseInt(this.port)));
                    this.pluginLoader.broadcast(new ReturnFocusRequest());
                    close.setLabel(startText != null ? stopText : "Disconnect");
                } else {
                    close.setLabel(startText != null ? startText : "Connect");
                }
                close.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (((JFrame)Applet.this.appletFrame).isVisible()) {
                            Applet.this.pluginLoader.broadcast(new SocketRequest());
                            ((JFrame)Applet.this.appletFrame).setVisible(false);
                            close.setLabel(startText != null ? startText : "Connect");
                        } else {
                            if (Applet.this.frameTitle == null) {
                                ((JFrame)Applet.this.appletFrame).setTitle("jta: " + Applet.this.host + (Applet.this.port.equals("23") ? "" : " " + Applet.this.port));
                            }
                            if (new Boolean(Applet.this.options.getProperty("Applet.detach.fullscreen")).booleanValue()) {
                                ((JFrame)Applet.this.appletFrame).setSize(Applet.this.appletFrame.getContentPane().getToolkit().getScreenSize());
                            } else {
                                ((JFrame)Applet.this.appletFrame).pack();
                            }
                            ((JFrame)Applet.this.appletFrame).show();
                            if (Applet.this.port == null || Applet.this.port.length() <= 0) {
                                Applet.this.port = "23";
                            }
                            Applet.this.getAppletContext().showStatus("Trying " + Applet.this.host + " " + Applet.this.port + " ...");
                            Applet.this.pluginLoader.broadcast(new SocketRequest(Applet.this.host, Integer.parseInt(Applet.this.port)));
                            Applet.this.pluginLoader.broadcast(new ReturnFocusRequest());
                            close.setLabel(stopText != null ? stopText : "Disconnect");
                        }
                    }
                });
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().add("Center", close);
                MenuBar mb = new MenuBar();
                Menu file = new Menu("File");
                file.setShortcut(new MenuShortcut(70, true));
                MenuItem tmp = new MenuItem("Connect");
                file.add(tmp);
                tmp.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Applet.this.pluginLoader.broadcast(new SocketRequest(Applet.this.host, Integer.parseInt(Applet.this.port)));
                    }
                });
                tmp = new MenuItem("Disconnect");
                file.add(tmp);
                tmp.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Applet.this.pluginLoader.broadcast(new SocketRequest());
                    }
                });
                file.add(new MenuItem("-"));
                tmp = new MenuItem("Print");
                file.add(tmp);
                tmp.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (Applet.this.pluginLoader.getComponents().get("Terminal") != null) {
                            PrintJob printJob = Applet.this.appletFrame.getContentPane().getToolkit().getPrintJob((JFrame)Applet.this.appletFrame, "JTA Terminal", null);
                            ((Component)Applet.this.pluginLoader.getComponents().get("Terminal")).print(printJob.getGraphics());
                            printJob.end();
                        }
                    }
                });
                file.add(new MenuItem("-"));
                tmp = new MenuItem("Exit");
                file.add(tmp);
                tmp.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        ((JFrame)Applet.this.appletFrame).setVisible(false);
                        Applet.this.pluginLoader.broadcast(new SocketRequest());
                        close.setLabel(startText != null ? startText : "Connect");
                    }
                });
                mb.add(file);
                Menu edit = new Menu("Edit");
                edit.setShortcut(new MenuShortcut(69, true));
                tmp = new MenuItem("Copy");
                edit.add(tmp);
                tmp.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (Applet.this.focussedPlugin instanceof VisualTransferPlugin) {
                            ((VisualTransferPlugin)((Object)Applet.this.focussedPlugin)).copy(Applet.this.clipboard);
                        }
                    }
                });
                tmp = new MenuItem("Paste");
                edit.add(tmp);
                tmp.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (Applet.this.focussedPlugin instanceof VisualTransferPlugin) {
                            ((VisualTransferPlugin)((Object)Applet.this.focussedPlugin)).paste(Applet.this.clipboard);
                        }
                    }
                });
                mb.add(edit);
                Map menuList = this.pluginLoader.getMenus();
                for (String name : menuList.keySet()) {
                    Object o = menuList.get(name);
                    if (!(o instanceof Menu)) continue;
                    mb.add((Menu)o);
                }
                Menu help = new Menu("Help");
                help.setShortcut(new MenuShortcut(156, true));
                tmp = new MenuItem("General");
                help.add(tmp);
                tmp.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Help.show(Applet.this.appletFrame.getContentPane(), Applet.this.options.getProperty("Help.url"));
                    }
                });
                mb.setHelpMenu(help);
                if (new Boolean(this.options.getProperty("Applet.detach.menuBar")).booleanValue()) {
                    ((JFrame)this.appletFrame).setMenuBar(mb);
                }
                try {
                    ((JFrame)this.appletFrame).addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent evt) {
                            Applet.this.pluginLoader.broadcast(new SocketRequest());
                            ((JFrame)Applet.this.appletFrame).setVisible(false);
                            close.setLabel(startText != null ? startText : "Connect");
                        }
                    });
                }
                catch (Exception e) {
                    System.err.println("Applet: could not set up Window event listener");
                    System.err.println("Applet: you will not be able to close it");
                }
                this.pluginLoader.registerPluginListener(new OnlineStatusListener(){

                    public void online() {
                        Applet.this.online = true;
                        if (!((JFrame)Applet.this.appletFrame).isVisible()) {
                            ((JFrame)Applet.this.appletFrame).setVisible(true);
                        }
                    }

                    public void offline() {
                        Applet.this.online = false;
                        if (Applet.this.disconnectCloseWindow) {
                            ((JFrame)Applet.this.appletFrame).setVisible(false);
                            close.setLabel(startText != null ? startText : "Connect");
                        }
                    }
                });
                this.pluginLoader.registerPluginListener(new FocusStatusListener(){

                    public void pluginGainedFocus(Plugin plugin) {
                        Applet.this.focussedPlugin = plugin;
                    }

                    public void pluginLostFocus(Plugin plugin) {
                    }
                });
            } else {
                this.pluginLoader.registerPluginListener(new OnlineStatusListener(){

                    public void online() {
                        Applet.this.online = true;
                    }

                    public void offline() {
                        Applet.this.online = false;
                    }
                });
            }
        }
    }

    public void start() {
        if (!this.online && (this.appletFrame == this || this.connect)) {
            this.getAppletContext().showStatus("Trying " + this.host + " " + this.port + " ...");
            this.pluginLoader.broadcast(new SocketRequest(this.host, Integer.parseInt(this.port)));
            this.pluginLoader.broadcast(new ReturnFocusRequest());
        }
    }

    public void stop() {
        if (this.online && this.disconnect) {
            this.pluginLoader.broadcast(new SocketRequest());
        }
    }

    private void parameterOverride(Properties options) {
        Enumeration<Object> e = options.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getParameter(key);
            if (value == null) continue;
            System.out.println("Applet: overriding value of " + key + " with " + value);
            options.put(key, value);
        }
    }
}

