/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.Common;
import de.mud.jta.Help;
import de.mud.jta.Plugin;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.FocusStatusListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.ReturnFocusRequest;
import de.mud.jta.event.SocketRequest;
import java.awt.PrintJob;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class Main {
    private static final int debug = 0;
    private static final boolean personalJava = false;
    private static Plugin focussedPlugin;
    private static Clipboard clipboard;
    private static String host;
    private static String port;

    public static void main(String[] args) {
        String cfg;
        final Properties options = new Properties();
        try {
            options.load(Main.class.getResourceAsStream("/de/mud/jta/default.conf"));
        }
        catch (IOException e) {
            System.err.println("jta: cannot load default.conf");
        }
        String error = Main.parseOptions(options, args);
        if (error != null) {
            System.err.println(error);
            System.err.println("usage: de.mud.jta.Main [-plugins pluginlist] [-addplugin plugin] [-config url_or_file] [-term id] [host [port]]");
            System.exit(0);
        }
        if ((cfg = options.getProperty("Main.config")) != null) {
            try {
                options.load(new URL(cfg).openStream());
            }
            catch (IOException e) {
                try {
                    options.load(new FileInputStream(cfg));
                }
                catch (Exception fe) {
                    System.err.println("jta: cannot load " + cfg);
                }
            }
        }
        host = options.getProperty("Socket.host");
        port = options.getProperty("Socket.port");
        final JFrame frame = new JFrame("jta: " + host + (port.equals("23") ? "" : " " + port));
        try {
            clipboard = frame.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            System.err.println("jta: system clipboard access denied");
            System.err.println("jta: copy & paste only within the JTA");
            clipboard = new Clipboard("de.mud.jta.Main");
        }
        final Common setup = new Common(options);
        if (port == null || port.length() == 0) {
            port = setup.getPlugins().containsKey("SSH") ? "22" : "23";
        }
        setup.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                frame.setTitle("jta: " + host + (port.equals("23") ? "" : " " + port));
            }

            public void offline() {
                frame.setTitle("jta: offline");
            }
        });
        setup.registerPluginListener(new FocusStatusListener(){

            public void pluginGainedFocus(Plugin plugin) {
                focussedPlugin = plugin;
            }

            public void pluginLostFocus(Plugin plugin) {
            }
        });
        Map componentList = setup.getComponents();
        for (String name : componentList.keySet()) {
            JComponent c = (JComponent)componentList.get(name);
            if (options.getProperty("layout." + name) == null) {
                System.err.println("jta: no layout property set for '" + name + "'");
                frame.add("South", c);
                continue;
            }
            frame.getContentPane().add(options.getProperty("layout." + name), c);
        }
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                setup.broadcast(new SocketRequest());
                frame.setVisible(false);
                frame.dispose();
                System.exit(0);
            }
        });
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setMnemonic(70);
        JMenuItem tmp = new JMenuItem("Connect");
        file.add(tmp);
        tmp.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String destination = JOptionPane.showInputDialog(frame, new JLabel("Enter your destination host (host[:port])"), "Connect", 3);
                if (destination != null) {
                    int sep = 0;
                    sep = destination.indexOf(32);
                    if (sep > 0 || (sep = destination.indexOf(58)) > 0) {
                        host = destination.substring(0, sep);
                        port = destination.substring(sep + 1);
                    } else {
                        host = destination;
                    }
                    setup.broadcast(new SocketRequest());
                    setup.broadcast(new SocketRequest(host, Integer.parseInt(port)));
                }
            }
        });
        tmp = new JMenuItem("Disconnect");
        file.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                setup.broadcast(new SocketRequest());
            }
        });
        file.addSeparator();
        if (setup.getComponents().get("Terminal") != null) {
            tmp = new JMenuItem("Print");
            file.add(tmp);
            tmp.setAccelerator(KeyStroke.getKeyStroke(80, 2));
            tmp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PrintJob printJob = frame.getToolkit().getPrintJob(frame, "JTA Terminal", null);
                    if (printJob == null) {
                        return;
                    }
                    ((JComponent)setup.getComponents().get("Terminal")).print(printJob.getGraphics());
                    printJob.end();
                }
            });
            file.addSeparator();
        }
        tmp = new JMenuItem("Exit");
        file.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frame.dispose();
                System.exit(0);
            }
        });
        mb.add(file);
        JMenu edit = new JMenu("Edit");
        tmp = new JMenuItem("Copy");
        edit.add(tmp);
        tmp.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (focussedPlugin instanceof VisualTransferPlugin) {
                    ((VisualTransferPlugin)((Object)focussedPlugin)).copy(clipboard);
                }
            }
        });
        tmp = new JMenuItem("Paste");
        edit.add(tmp);
        tmp.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (focussedPlugin instanceof VisualTransferPlugin) {
                    ((VisualTransferPlugin)((Object)focussedPlugin)).paste(clipboard);
                }
            }
        });
        mb.add(edit);
        Map menuList = setup.getMenus();
        for (String name : menuList.keySet()) {
            mb.add((JMenu)menuList.get(name));
        }
        JMenu help = new JMenu("Help");
        help.setMnemonic(156);
        tmp = new JMenuItem("General");
        help.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Help.show(frame, options.getProperty("Help.url"));
            }
        });
        mb.add(help);
        frame.setJMenuBar(mb);
        frame.pack();
        if (new Boolean(options.getProperty("Applet.detach.fullscreen")).booleanValue()) {
            frame.setSize(frame.getToolkit().getScreenSize());
        } else {
            frame.pack();
        }
        frame.setVisible(true);
        if (host != null && host.length() > 0) {
            setup.broadcast(new SocketRequest(host, Integer.parseInt(port)));
        }
        setup.broadcast(new ReturnFocusRequest());
    }

    private static String parseOptions(Properties options, String[] args) {
        boolean host = false;
        boolean port = false;
        for (int n = 0; n < args.length; ++n) {
            if (args[n].equals("-config")) {
                if (!args[n + 1].startsWith("-")) {
                    options.put("Main.config", args[++n]);
                    continue;
                }
                return "missing parameter for -config";
            }
            if (args[n].equals("-plugins")) {
                if (!args[n + 1].startsWith("-")) {
                    options.put("plugins", args[++n]);
                    continue;
                }
                return "missing parameter for -plugins";
            }
            if (args[n].equals("-addplugin")) {
                if (!args[n + 1].startsWith("-")) {
                    options.put("plugins", args[++n] + "," + options.get("plugins"));
                    continue;
                }
                return "missing parameter for -addplugin";
            }
            if (args[n].equals("-term")) {
                if (!args[n + 1].startsWith("-")) {
                    options.put("Terminal.id", args[++n]);
                    continue;
                }
                return "missing parameter for -term";
            }
            if (!host) {
                options.put("Socket.host", args[n]);
                host = true;
                continue;
            }
            if (host && !port) {
                options.put("Socket.port", args[n]);
                port = true;
                continue;
            }
            return "unknown parameter '" + args[n] + "'";
        }
        return null;
    }
}

