/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.telnet.ScriptHandler;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;

public class Wrapper {
    private static final int debug = 0;
    protected ScriptHandler scriptHandler = new ScriptHandler();
    private Thread reader;
    protected InputStream in;
    protected OutputStream out;
    protected Socket socket;
    protected String host;
    protected int port = 23;
    protected Vector script = new Vector();
    private String prompt = null;

    public void connect(String host, int port) throws IOException {
        try {
            this.socket = new Socket(host, port);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (Exception e) {
            System.err.println("Wrapper: " + e);
            this.disconnect();
            throw (IOException)e;
        }
    }

    public void disconnect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void login(String user, String pwd) throws IOException {
        this.waitfor("login:");
        this.send(user);
        this.waitfor("Password:");
        this.send(pwd);
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String send(String cmd) throws IOException {
        return null;
    }

    public String waitfor(String[] searchElements) throws IOException {
        ScriptHandler[] handlers = new ScriptHandler[searchElements.length];
        for (int i = 0; i < searchElements.length; ++i) {
            handlers[i] = new ScriptHandler();
            handlers[i].setup(searchElements[i]);
        }
        byte[] b1 = new byte[1];
        int n = 0;
        StringBuffer ret = new StringBuffer();
        while (n >= 0) {
            n = this.read(b1);
            if (n <= 0) continue;
            String current = new String(b1, 0, n);
            ret.append(current);
            for (int i = 0; i < handlers.length; ++i) {
                if (!handlers[i].match(ret.toString().getBytes(), ret.length())) continue;
                return ret.toString();
            }
        }
        return null;
    }

    public String waitfor(String match) throws IOException {
        String[] matches = new String[]{match};
        return this.waitfor(matches);
    }

    public int read(byte[] b) throws IOException {
        return -1;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public String getTerminalType() {
        return "dumb";
    }

    public Dimension getWindowSize() {
        return new Dimension(80, 24);
    }

    public void setLocalEcho(boolean echo) {
    }
}

