/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.SshCrypto;
import de.mud.ssh.SshMisc;
import de.mud.ssh.SshPacket;
import de.mud.ssh.SshPacket1;
import de.mud.ssh.SshPacket2;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public abstract class SshIO {
    private static MessageDigest md5;
    private String idstr = "";
    private String idstr_sent = "SSH/JTA (c) Marcus Meissner, Matthias L. Jugel\n";
    private static int debug;
    private SshCrypto crypto = null;
    String cipher_type = "IDEA";
    private int remotemajor;
    private int remoteminor;
    private int mymajor;
    private int myminor;
    private int useprotocol;
    private String login = "";
    private String password = "";
    public String dataToSend = null;
    public String hashHostKey = null;
    byte lastPacketSentType;
    private int phase = 0;
    private final int PHASE_INIT = 0;
    private final int PHASE_SSH_RECEIVE_PACKET = 1;
    BigInteger rsa_e;
    BigInteger rsa_n;
    private final byte SSH_MSG_DISCONNECT = 1;
    private final byte SSH_SMSG_PUBLIC_KEY = (byte)2;
    private final byte SSH_CMSG_SESSION_KEY = (byte)3;
    private final byte SSH_CMSG_USER = (byte)4;
    private final byte SSH_CMSG_AUTH_PASSWORD = (byte)9;
    private final byte SSH_CMSG_REQUEST_PTY = (byte)10;
    private final byte SSH_CMSG_WINDOW_SIZE = (byte)11;
    private final byte SSH_CMSG_EXEC_SHELL = (byte)12;
    private final byte SSH_SMSG_SUCCESS = (byte)14;
    private final byte SSH_SMSG_FAILURE = (byte)15;
    private final byte SSH_CMSG_STDIN_DATA = (byte)16;
    private final byte SSH_SMSG_STDOUT_DATA = (byte)17;
    private final byte SSH_SMSG_STDERR_DATA = (byte)18;
    private final byte SSH_SMSG_EXITSTATUS = (byte)20;
    private final byte SSH_MSG_IGNORE = (byte)32;
    private final byte SSH_CMSG_EXIT_CONFIRMATION = (byte)33;
    private final byte SSH_MSG_DEBUG = (byte)36;
    private final byte SSH2_MSG_DISCONNECT = 1;
    private final byte SSH2_MSG_IGNORE = (byte)2;
    private final byte SSH2_MSG_SERVICE_REQUEST = (byte)5;
    private final byte SSH2_MSG_SERVICE_ACCEPT = (byte)6;
    private final byte SSH2_MSG_KEXINIT = (byte)20;
    private final byte SSH2_MSG_NEWKEYS = (byte)21;
    private final byte SSH2_MSG_KEXDH_INIT = (byte)30;
    private final byte SSH2_MSG_KEXDH_REPLY = (byte)31;
    private String kexalgs;
    private String hostkeyalgs;
    private String encalgs2c;
    private String encalgc2s;
    private String macalgs2c;
    private String macalgc2s;
    private String compalgc2s;
    private String compalgs2c;
    private String langc2s;
    private String langs2;
    private int outgoingseq = 0;
    private int incomingseq = 0;
    private int SSH_CIPHER_NONE = 0;
    private int SSH_CIPHER_IDEA = 1;
    private int SSH_CIPHER_DES = 2;
    private int SSH_CIPHER_3DES = 3;
    private int SSH_CIPHER_TSS = 4;
    private int SSH_CIPHER_RC4 = 5;
    private int SSH_CIPHER_BLOWFISH = 6;
    private final int SSH_AUTH_RHOSTS = 1;
    private final int SSH_AUTH_RSA = 2;
    private final int SSH_AUTH_PASSWORD = 3;
    private final int SSH_AUTH_RHOSTS_RSA = 4;
    private boolean cansenddata = false;
    SshPacket currentpacket;
    byte[] one = new byte[1];

    public void setLogin(String user) {
        if (user == null) {
            user = "";
        }
        this.login = user;
    }

    public void setPassword(String password) {
        if (password == null) {
            password = "";
        }
        this.password = password;
    }

    protected abstract void write(byte[] var1) throws IOException;

    public abstract String getTerminalType();

    private void write(byte b) throws IOException {
        this.one[0] = b;
        this.write(this.one);
    }

    public void disconnect() {
        this.idstr = "";
        this.login = "";
        this.password = "";
        this.phase = 0;
        this.crypto = null;
    }

    public void setWindowSize(int columns, int rows) throws IOException {
        if (this.phase == 0) {
            System.err.println("sshio:setWindowSize(), sizing in init phase not supported.\n");
        }
        if (debug > 1) {
            System.err.println("SSHIO:setWindowSize(" + columns + "," + rows + ")");
        }
        this.Send_SSH_CMSG_WINDOW_SIZE(columns, rows);
    }

    public synchronized void sendData(String str) throws IOException {
        if (debug > 1) {
            System.out.println("SshIO.send(" + str + ")");
        }
        this.dataToSend = this.dataToSend == null ? str : this.dataToSend + str;
        if (this.cansenddata) {
            this.Send_SSH_CMSG_STDIN_DATA(this.dataToSend);
            this.dataToSend = null;
        }
    }

    public byte[] handleSSH(byte[] buff) throws IOException {
        if (debug > 1) {
            System.out.println("SshIO.getPacket(" + buff + "," + buff.length + ")");
        }
        if (this.phase == 0) {
            int boffset = 0;
            while (boffset < buff.length) {
                byte b = buff[boffset++];
                this.idstr = this.idstr + (char)b;
                if (b != 10) continue;
                if (!this.idstr.substring(0, 4).equals("SSH-")) {
                    if (debug > 0) {
                        System.out.print("Received data line: " + this.idstr);
                    }
                    this.idstr = "";
                    continue;
                }
                ++this.phase;
                this.remotemajor = Integer.parseInt(this.idstr.substring(4, 5));
                String minorverstr = this.idstr.substring(6, 8);
                if (!Character.isDigit(minorverstr.charAt(1))) {
                    minorverstr = minorverstr.substring(0, 1);
                }
                this.remoteminor = Integer.parseInt(minorverstr);
                System.out.println("remotemajor " + this.remotemajor);
                System.out.println("remoteminor " + this.remoteminor);
                if (this.remotemajor == 2) {
                    this.mymajor = 2;
                    this.myminor = 0;
                    this.useprotocol = 2;
                } else {
                    this.mymajor = 1;
                    this.myminor = 5;
                    this.useprotocol = 1;
                }
                this.idstr_sent = "SSH-" + this.mymajor + "." + this.myminor + "-" + this.idstr_sent;
                this.write(this.idstr_sent.getBytes());
                if (this.useprotocol == 2) {
                    this.currentpacket = new SshPacket2(null);
                    continue;
                }
                this.currentpacket = new SshPacket1(null);
            }
            if (boffset == buff.length) {
                return "".getBytes();
            }
            return "Must not have left over data after PHASE_INIT!\n".getBytes();
        }
        String result = "";
        byte[] rest = this.currentpacket.addPayload(buff);
        if (this.currentpacket.isFinished()) {
            if (this.useprotocol == 1) {
                result = result + this.handlePacket1((SshPacket1)this.currentpacket);
                this.currentpacket = new SshPacket1(this.crypto);
            } else {
                result = result + this.handlePacket2((SshPacket2)this.currentpacket);
                this.currentpacket = new SshPacket2(this.crypto);
            }
        }
        while (rest != null) {
            rest = this.currentpacket.addPayload(rest);
            if (!this.currentpacket.isFinished()) continue;
            if (this.useprotocol == 1) {
                result = result + this.handlePacket1((SshPacket1)this.currentpacket);
                this.currentpacket = new SshPacket1(this.crypto);
                continue;
            }
            result = result + this.handlePacket2((SshPacket2)this.currentpacket);
            this.currentpacket = new SshPacket2(this.crypto);
        }
        return result.getBytes();
    }

    private String handlePacket2(SshPacket2 p) throws IOException {
        switch (p.getType()) {
            case 2: {
                System.out.println("SSH2: SSH2_MSG_IGNORE");
                break;
            }
            case 1: {
                int discreason = p.getInt32();
                String discreason1 = p.getString();
                System.out.println("SSH2: SSH2_MSG_DISCONNECT(" + discreason + "," + discreason1 + "," + ")");
                return "\nSSH2 disconnect: " + discreason1 + "\n";
            }
            case 21: {
                System.out.println("SSH2: SSH2_MSG_NEWKEYS");
                this.sendPacket2(new SshPacket2(21));
                byte[] session_key = new byte[16];
                this.crypto = new SshCrypto(this.cipher_type, session_key);
                SshPacket2 pn = new SshPacket2(5);
                pn.putString("ssh-userauth");
                this.sendPacket2(pn);
                break;
            }
            case 6: {
                System.out.println("Service Accept: " + p.getString());
                break;
            }
            case 20: {
                System.out.println("SSH2: SSH2_MSG_KEXINIT");
                byte[] kexcookie = p.getBytes(16);
                String kexalgs = p.getString();
                System.out.println("- " + kexalgs);
                String hostkeyalgs = p.getString();
                System.out.println("- " + hostkeyalgs);
                String encalgc2s = p.getString();
                System.out.println("- " + encalgc2s);
                String encalgs2c = p.getString();
                System.out.println("- " + encalgs2c);
                String macalgc2s = p.getString();
                System.out.println("- " + macalgc2s);
                String macalgs2c = p.getString();
                System.out.println("- " + macalgs2c);
                String compalgc2s = p.getString();
                System.out.println("- " + compalgc2s);
                String compalgs2c = p.getString();
                System.out.println("- " + compalgs2c);
                String langc2s = p.getString();
                System.out.println("- " + langc2s);
                String langs2c = p.getString();
                System.out.println("- " + langs2c);
                byte[] fupp = p.getBytes(1);
                System.out.println("- first_kex_follows: " + fupp[0]);
                SshPacket2 pn = new SshPacket2(20);
                byte[] kexsend = new byte[16];
                pn.putBytes(kexsend);
                pn.putString("diffie-hellman-group1-sha1");
                pn.putString("ssh-rsa");
                this.cipher_type = "NONE";
                String ciphername = "none";
                pn.putString("none");
                pn.putString("none");
                pn.putString("hmac-md5");
                pn.putString("hmac-md5");
                pn.putString("none");
                pn.putString("none");
                pn.putString("");
                pn.putString("");
                pn.putByte((byte)0);
                pn.putInt32(0);
                this.sendPacket2(pn);
                pn = new SshPacket2(30);
                pn.putMpInt(BigInteger.valueOf(-559038737L));
                this.sendPacket2(pn);
                break;
            }
            case 31: {
                System.out.println("SSH2_MSG_KEXDH_REPLY");
                int bloblen = p.getInt32();
                System.out.println("bloblen is " + bloblen);
                String keytype = p.getString();
                System.out.println("KEXDH: " + keytype);
                if (!keytype.equals("ssh-rsa")) {
                    return "\n\rUnsupported kexdh algorithm " + keytype + "!\n\r";
                }
                this.rsa_e = p.getMpInt();
                this.rsa_n = p.getMpInt();
                String result = "\n\rSSH-RSA (" + this.rsa_n + "," + this.rsa_e + ")\n\r";
                BigInteger dhserverpub = p.getMpInt();
                result = result + "DH Server Pub: " + dhserverpub + "\n\r";
                int siglen = p.getInt32();
                String sigstr = p.getString();
                result = result + "Signature: ktype is " + sigstr + "\r\n";
                byte[] sigdata = p.getBytes(p.getInt32());
                return result;
            }
            default: {
                return "SSH2: handlePacket2 Unknown type " + p.getType();
            }
        }
        return "";
    }

    private String handlePacket1(SshPacket1 p) throws IOException {
        if (debug > 0) {
            System.out.println("1 packet to handle, type " + p.getType());
        }
        switch (p.getType()) {
            case 32: {
                return "";
            }
            case 1: {
                String str = p.getString();
                this.disconnect();
                return str;
            }
            case 2: {
                byte[] anti_spoofing_cookie = p.getBytes(8);
                byte[] server_key_bits = p.getBytes(4);
                byte[] server_key_public_exponent = p.getMpInt();
                byte[] server_key_public_modulus = p.getMpInt();
                byte[] host_key_bits = p.getBytes(4);
                byte[] host_key_public_exponent = p.getMpInt();
                byte[] host_key_public_modulus = p.getMpInt();
                byte[] protocol_flags = p.getBytes(4);
                byte[] supported_ciphers_mask = p.getBytes(4);
                byte[] supported_authentications_mask = p.getBytes(4);
                String ret = this.Send_SSH_CMSG_SESSION_KEY(anti_spoofing_cookie, server_key_public_modulus, host_key_public_modulus, supported_ciphers_mask, server_key_public_exponent, host_key_public_exponent);
                if (ret != null) {
                    return ret;
                }
                if (this.hashHostKey == null || this.hashHostKey.compareTo("") == 0) break;
                byte[] Md5_hostKey = md5.digest(host_key_public_modulus);
                String hashHostKeyBis = "";
                for (int i = 0; i < Md5_hostKey.length; ++i) {
                    String hex = "";
                    int[] v = new int[]{(Md5_hostKey[i] & 0xF0) >> 4, Md5_hostKey[i] & 0xF};
                    block20: for (int j = 0; j < 1; ++j) {
                        switch (v[j]) {
                            case 10: {
                                hex = hex + "a";
                                continue block20;
                            }
                            case 11: {
                                hex = hex + "b";
                                continue block20;
                            }
                            case 12: {
                                hex = hex + "c";
                                continue block20;
                            }
                            case 13: {
                                hex = hex + "d";
                                continue block20;
                            }
                            case 14: {
                                hex = hex + "e";
                                continue block20;
                            }
                            case 15: {
                                hex = hex + "f";
                                continue block20;
                            }
                            default: {
                                hex = hex + String.valueOf(v[j]);
                            }
                        }
                    }
                    hashHostKeyBis = hashHostKeyBis + hex;
                }
                if (hashHostKeyBis.compareTo(this.hashHostKey) == 0) break;
                this.password = "";
                this.login = "";
                return "\nHash value of the host key not correct \r\nlogin & password have been reset \r\n- erase the 'hashHostKey' parameter in the Html\r\n(it is used for auhentificating the server and prevent you from connecting \r\nto any other)\r\n";
            }
            case 14: {
                if (debug > 0) {
                    System.out.println("SSH_SMSG_SUCCESS (last packet was " + this.lastPacketSentType + ")");
                }
                if (this.lastPacketSentType == 3) {
                    this.Send_SSH_CMSG_USER();
                    break;
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "\nEmpty password login.\r\n";
                }
                if (this.lastPacketSentType == 9) {
                    if (debug > 0) {
                        System.out.println("login succesful");
                    }
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "\nLogin & password accepted\r\n";
                }
                if (this.lastPacketSentType == 10) {
                    this.cansenddata = true;
                    if (this.dataToSend != null) {
                        this.Send_SSH_CMSG_STDIN_DATA(this.dataToSend);
                        this.dataToSend = null;
                    }
                    this.Send_SSH_CMSG_EXEC_SHELL();
                    break;
                }
                if (this.lastPacketSentType != 12) break;
                break;
            }
            case 15: {
                if (debug > 1) {
                    System.err.println("SSH_SMSG_FAILURE");
                }
                if (this.lastPacketSentType == 9) {
                    System.out.println("failed to log in");
                    this.Send_SSH_MSG_DISCONNECT("Failed to log in.");
                    this.disconnect();
                    return "\nLogin & password not accepted\r\n";
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_AUTH_PASSWORD();
                    break;
                }
                if (this.lastPacketSentType != 10) break;
                break;
            }
            case 17: {
                return p.getString();
            }
            case 18: {
                String str = "Error : " + p.getString();
                System.out.println("SshIO.handlePacket : STDERR_DATA " + str);
                return str;
            }
            case 20: {
                int value = p.getInt32();
                this.Send_SSH_CMSG_EXIT_CONFIRMATION();
                System.out.println("SshIO : Exit status " + value);
                this.disconnect();
                break;
            }
            case 36: {
                String str = p.getString();
                if (debug > 0) {
                    System.out.println("SshIO.handlePacket :  DEBUG " + str);
                    return str;
                }
                return "";
            }
            default: {
                System.err.print("SshIO.handlePacket1: Packet Type unknown: " + p.getType());
            }
        }
        return "";
    }

    private void sendPacket1(SshPacket1 packet) throws IOException {
        this.write(packet.getPayLoad(this.crypto));
        this.lastPacketSentType = packet.getType();
    }

    private void sendPacket2(SshPacket2 packet) throws IOException {
        this.write(packet.getPayLoad(this.crypto, this.outgoingseq));
        ++this.outgoingseq;
        this.lastPacketSentType = packet.getType();
    }

    private String Send_SSH_CMSG_SESSION_KEY(byte[] anti_spoofing_cookie, byte[] server_key_public_modulus, byte[] host_key_public_modulus, byte[] supported_ciphers_mask, byte[] server_key_public_exponent, byte[] host_key_public_exponent) throws IOException {
        byte cipher_types;
        byte[] session_id_byte = new byte[host_key_public_modulus.length + server_key_public_modulus.length + anti_spoofing_cookie.length];
        System.arraycopy(host_key_public_modulus, 0, session_id_byte, 0, host_key_public_modulus.length);
        System.arraycopy(server_key_public_modulus, 0, session_id_byte, host_key_public_modulus.length, server_key_public_modulus.length);
        System.arraycopy(anti_spoofing_cookie, 0, session_id_byte, host_key_public_modulus.length + server_key_public_modulus.length, anti_spoofing_cookie.length);
        byte[] hash_md5 = md5.digest(session_id_byte);
        if ((supported_ciphers_mask[3] & (byte)(1 << this.SSH_CIPHER_BLOWFISH)) != 0) {
            cipher_types = (byte)this.SSH_CIPHER_BLOWFISH;
            this.cipher_type = "Blowfish";
        } else if ((supported_ciphers_mask[3] & 1 << this.SSH_CIPHER_IDEA) != 0) {
            cipher_types = (byte)this.SSH_CIPHER_IDEA;
            this.cipher_type = "IDEA";
        } else if ((supported_ciphers_mask[3] & 1 << this.SSH_CIPHER_3DES) != 0) {
            cipher_types = (byte)this.SSH_CIPHER_3DES;
            this.cipher_type = "DES3";
        } else if ((supported_ciphers_mask[3] & 1 << this.SSH_CIPHER_DES) != 0) {
            cipher_types = (byte)this.SSH_CIPHER_DES;
            this.cipher_type = "DES";
        } else {
            System.err.println("SshIO: remote server does not supported IDEA, BlowFish or 3DES, support cypher mask is " + supported_ciphers_mask[3] + ".\n");
            this.Send_SSH_MSG_DISCONNECT("No more auth methods available.");
            this.disconnect();
            return "\rRemote server does not support IDEA/Blowfish/3DES blockcipher, closing connection.\r\n";
        }
        if (debug > 0) {
            System.out.println("SshIO: Using " + this.cipher_type + " blockcipher.\n");
        }
        byte[] random_bits1 = new byte[16];
        byte[] random_bits2 = new byte[16];
        SecureRandom random = new SecureRandom(random_bits1);
        random.nextBytes(random_bits1);
        random.nextBytes(random_bits2);
        byte[] session_key = SshMisc.addArrayOfBytes(random_bits1, random_bits2);
        byte[] session_keyXored = SshMisc.XORArrayOfBytes(random_bits1, hash_md5);
        session_keyXored = SshMisc.addArrayOfBytes(session_keyXored, random_bits2);
        byte[] encrypted_session_key = SshCrypto.encrypteRSAPkcs1Twice(session_keyXored, server_key_public_exponent, server_key_public_modulus, host_key_public_exponent, host_key_public_modulus);
        int protocol_flags = 0;
        SshPacket1 packet = new SshPacket1(3);
        packet.putByte(cipher_types);
        packet.putBytes(anti_spoofing_cookie);
        packet.putBytes(encrypted_session_key);
        packet.putInt32(protocol_flags);
        this.sendPacket1(packet);
        this.crypto = new SshCrypto(this.cipher_type, session_key);
        return "";
    }

    private String Send_SSH_MSG_DISCONNECT(String reason) throws IOException {
        SshPacket1 p = new SshPacket1(1);
        p.putString(reason);
        this.sendPacket1(p);
        return "";
    }

    private String Send_SSH_CMSG_USER() throws IOException {
        if (debug > 0) {
            System.err.println("Send_SSH_CMSG_USER(" + this.login + ")");
        }
        SshPacket1 p = new SshPacket1(4);
        p.putString(this.login);
        this.sendPacket1(p);
        return "";
    }

    private String Send_SSH_CMSG_AUTH_PASSWORD() throws IOException {
        SshPacket1 p = new SshPacket1(9);
        p.putString(this.password);
        this.sendPacket1(p);
        return "";
    }

    private String Send_SSH_CMSG_EXEC_SHELL() throws IOException {
        SshPacket1 packet = new SshPacket1(12);
        this.sendPacket1(packet);
        return "";
    }

    private String Send_SSH_CMSG_STDIN_DATA(String str) throws IOException {
        SshPacket1 packet = new SshPacket1(16);
        packet.putString(str);
        this.sendPacket1(packet);
        return "";
    }

    private String Send_SSH_CMSG_WINDOW_SIZE(int c, int r) throws IOException {
        SshPacket1 p = new SshPacket1(11);
        p.putInt32(r);
        p.putInt32(c);
        p.putInt32(0);
        p.putInt32(0);
        this.sendPacket1(p);
        return "";
    }

    private String Send_SSH_CMSG_REQUEST_PTY() throws IOException {
        SshPacket1 p = new SshPacket1(10);
        p.putString(this.getTerminalType());
        p.putInt32(24);
        p.putInt32(80);
        p.putInt32(0);
        p.putInt32(0);
        p.putByte((byte)0);
        this.sendPacket1(p);
        return "";
    }

    private String Send_SSH_CMSG_EXIT_CONFIRMATION() throws IOException {
        SshPacket1 packet = new SshPacket1(33);
        this.sendPacket1(packet);
        return "";
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("SshIO: unable to load message digest algorithm: " + e);
            e.printStackTrace();
        }
        debug = 0;
    }
}

