/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.AssertionFailedException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.MysqlDefs;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static final int DEFERRABILITY = 13;
    private static final int DELETE_RULE = 10;
    private static final int FK_NAME = 11;
    private static final int FKCOLUMN_NAME = 7;
    private static final int FKTABLE_CAT = 4;
    private static final int FKTABLE_NAME = 6;
    private static final int FKTABLE_SCHEM = 5;
    private static final int KEY_SEQ = 8;
    private static final int PK_NAME = 12;
    private static final int PKCOLUMN_NAME = 3;
    private static final int PKTABLE_CAT = 0;
    private static final int PKTABLE_NAME = 2;
    private static final int PKTABLE_SCHEM = 1;
    private static final String SUPPORTS_FK = "SUPPORTS_FK";
    private static final byte[] TABLE_AS_BYTES = "TABLE".getBytes();
    private static final int UPDATE_RULE = 9;
    private static final byte[] VIEW_AS_BYTES = "VIEW".getBytes();
    protected Connection conn;
    private String database;
    private String quotedId;

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    private final java.sql.ResultSet buildResultSet(Field[] fields, ArrayList rows) throws SQLException {
        int fieldsLength = fields.length;
        int i = 0;
        while (i < fieldsLength) {
            fields[i].setConnection(this.conn);
            ++i;
        }
        return new ResultSet(this.conn.getCatalog(), fields, new RowDataStatic(rows), this.conn, null);
    }

    private final void convertToJdbcFunctionList(String catalog, java.sql.ResultSet proceduresRs, boolean needsClientFiltering, String db, Map procedureRowsOrderedByName, int nameIndex) throws SQLException {
        while (proceduresRs.next()) {
            boolean shouldAdd = true;
            if (needsClientFiltering) {
                shouldAdd = false;
                String procDb = proceduresRs.getString(1);
                if (db == null && procDb == null) {
                    shouldAdd = true;
                } else {
                    boolean bl = false;
                    if (db != null) {
                        bl = true;
                    }
                    if (bl & db.equals(procDb)) {
                        shouldAdd = true;
                    }
                }
            }
            if (!shouldAdd) continue;
            String functionName = proceduresRs.getString(nameIndex);
            byte[][] rowData = new byte[][]{catalog == null ? null : this.s2b(catalog), null, this.s2b(functionName), null, null, null, null, this.s2b(Integer.toString(2))};
            procedureRowsOrderedByName.put(functionName, rowData);
        }
    }

    private final void convertToJdbcProcedureList(boolean fromSelect, String catalog, java.sql.ResultSet proceduresRs, boolean needsClientFiltering, String db, Map procedureRowsOrderedByName, int nameIndex) throws SQLException {
        while (proceduresRs.next()) {
            boolean isFunction;
            boolean shouldAdd = true;
            if (needsClientFiltering) {
                shouldAdd = false;
                String procDb = proceduresRs.getString(1);
                if (db == null && procDb == null) {
                    shouldAdd = true;
                } else {
                    boolean bl = false;
                    if (db != null) {
                        bl = true;
                    }
                    if (bl & db.equals(procDb)) {
                        shouldAdd = true;
                    }
                }
            }
            if (!shouldAdd) continue;
            String procedureName = proceduresRs.getString(nameIndex);
            byte[][] rowData = new byte[8][];
            rowData[0] = catalog == null ? null : this.s2b(catalog);
            rowData[1] = null;
            rowData[2] = this.s2b(procedureName);
            rowData[3] = null;
            rowData[4] = null;
            rowData[5] = null;
            rowData[6] = null;
            boolean bl = false;
            if (fromSelect) {
                bl = "FUNCTION".equalsIgnoreCase(proceduresRs.getString("type"));
            }
            rowData[7] = this.s2b((isFunction = bl) ? Integer.toString(2) : Integer.toString(0));
            procedureRowsOrderedByName.put(procedureName, rowData);
        }
    }

    private final byte[][] convertTypeDescriptorToProcedureRow(byte[] procNameAsBytes, String paramName, boolean isOutParam, boolean isInParam, boolean isReturnParam, TypeDescriptor typeDesc) throws SQLException {
        byte[][] row = new byte[14][];
        row[0] = null;
        row[1] = null;
        row[2] = procNameAsBytes;
        row[3] = this.s2b(paramName);
        row[4] = isInParam && isOutParam ? this.s2b(String.valueOf(2)) : (isInParam ? this.s2b(String.valueOf(1)) : (isOutParam ? this.s2b(String.valueOf(4)) : (isReturnParam ? this.s2b(String.valueOf(5)) : this.s2b(String.valueOf(0)))));
        row[5] = this.s2b(Short.toString(typeDesc.dataType));
        row[6] = this.s2b(typeDesc.typeName);
        row[7] = this.s2b(Integer.toString(typeDesc.columnSize));
        row[8] = this.s2b(Integer.toString(typeDesc.bufferLength));
        row[9] = this.s2b(Integer.toString(typeDesc.decimalDigits));
        row[10] = this.s2b(Integer.toString(typeDesc.numPrecRadix));
        switch (typeDesc.nullability) {
            case 0: {
                row[11] = this.s2b(Integer.toString(0));
                break;
            }
            case 1: {
                row[11] = this.s2b(Integer.toString(1));
                break;
            }
            case 2: {
                row[11] = this.s2b(Integer.toString(2));
                break;
            }
            default: {
                throw new SQLException("Internal error while parsing callable statement metadata (unknown nullability value fount)", "S1000");
            }
        }
        row[12] = null;
        return row;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public List extractForeignKeyForTable(ArrayList rows, java.sql.ResultSet rs, String catalog) throws SQLException {
        byte[][] row = new byte[3][];
        row[0] = rs.getBytes(1);
        row[1] = this.s2b(SUPPORTS_FK);
        String createTableString = rs.getString(2);
        StringTokenizer lineTokenizer = new StringTokenizer(createTableString, "\n");
        StringBuffer commentBuf = new StringBuffer("comment; ");
        boolean firstTime = true;
        String quoteChar = this.getIdentifierQuoteString();
        if (quoteChar == null) {
            quoteChar = "`";
        }
        while (lineTokenizer.hasMoreTokens()) {
            int afterFk;
            int indexOfRef;
            String line = lineTokenizer.nextToken().trim();
            String constraintName = null;
            if (StringUtils.startsWithIgnoreCase(line, "CONSTRAINT")) {
                boolean usingBackTicks = true;
                int beginPos = line.indexOf(quoteChar);
                if (beginPos == -1) {
                    beginPos = line.indexOf("\"");
                    usingBackTicks = false;
                }
                if (beginPos != -1) {
                    int endPos = -1;
                    endPos = usingBackTicks ? line.indexOf(quoteChar, beginPos + 1) : line.indexOf("\"", beginPos + 1);
                    if (endPos != -1) {
                        constraintName = line.substring(beginPos + 1, endPos);
                        line = line.substring(endPos + 1, line.length()).trim();
                    }
                }
            }
            if (!line.startsWith("FOREIGN KEY")) continue;
            if (line.endsWith(",")) {
                line = line.substring(0, line.length() - 1);
            }
            char quote = this.quotedId.charAt(0);
            int indexOfFK = line.indexOf("FOREIGN KEY");
            String localColumnName = null;
            String referencedCatalogName = this.quotedId + catalog + this.quotedId;
            String referencedTableName = null;
            String referencedColumnName = null;
            if (indexOfFK != -1 && (indexOfRef = StringUtils.indexOfIgnoreCaseRespectQuotes(afterFk = indexOfFK + "FOREIGN KEY".length(), line, "REFERENCES", quote, true)) != -1) {
                int indexOfParenOpen = line.indexOf(40, afterFk);
                int indexOfParenClose = StringUtils.indexOfIgnoreCaseRespectQuotes(indexOfParenOpen, line, ")", quote, true);
                if (indexOfParenOpen != -1) {
                    // empty if block
                }
                localColumnName = line.substring(indexOfParenOpen + 1, indexOfParenClose);
                int afterRef = indexOfRef + "REFERENCES".length();
                int referencedColumnBegin = StringUtils.indexOfIgnoreCaseRespectQuotes(afterRef, line, "(", quote, true);
                if (referencedColumnBegin != -1) {
                    int indexOfCatalogSep;
                    referencedTableName = line.substring(afterRef, referencedColumnBegin);
                    int referencedColumnEnd = StringUtils.indexOfIgnoreCaseRespectQuotes(referencedColumnBegin + 1, line, ")", quote, true);
                    if (referencedColumnEnd != -1) {
                        referencedColumnName = line.substring(referencedColumnBegin + 1, referencedColumnEnd);
                    }
                    if ((indexOfCatalogSep = StringUtils.indexOfIgnoreCaseRespectQuotes(0, referencedTableName, ".", quote, true)) != -1) {
                        referencedCatalogName = referencedTableName.substring(0, indexOfCatalogSep);
                        referencedTableName = referencedTableName.substring(indexOfCatalogSep + 1);
                    }
                }
            }
            if (!firstTime) {
                commentBuf.append("; ");
            } else {
                firstTime = false;
            }
            if (constraintName != null) {
                commentBuf.append(constraintName);
            } else {
                commentBuf.append("not_available");
            }
            commentBuf.append("(");
            commentBuf.append(localColumnName);
            commentBuf.append(") REFER ");
            commentBuf.append(referencedCatalogName);
            commentBuf.append("/");
            commentBuf.append(referencedTableName);
            commentBuf.append("(");
            commentBuf.append(referencedColumnName);
            commentBuf.append(")");
            int lastParenIndex = line.lastIndexOf(")");
            if (lastParenIndex == line.length() - 1) continue;
            String cascadeOptions = line.substring(lastParenIndex + 1);
            commentBuf.append(" ");
            commentBuf.append(cascadeOptions);
        }
        row[2] = this.s2b(commentBuf.toString());
        rows.add(row);
        return rows;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet extractForeignKeyFromCreateTable(String catalog, String tableName) throws SQLException {
        Field[] fields;
        ArrayList rows;
        Statement stmt;
        java.sql.ResultSet rs;
        block18: {
            ArrayList<String> tableList = new ArrayList<String>();
            rs = null;
            stmt = null;
            if (tableName != null) {
                tableList.add(tableName);
            } else {
                block17: {
                    try {
                        rs = this.getTables(catalog, "", "%", new String[]{"TABLE"});
                        while (rs.next()) {
                            tableList.add(rs.getString("TABLE_NAME"));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (rs != null) {
                            rs.close();
                        }
                        rs = null;
                        throw throwable;
                    }
                    {
                        Object var7_9 = null;
                        if (rs == null) break block17;
                    }
                    rs.close();
                }
                rs = null;
            }
            rows = new ArrayList();
            fields = new Field[]{new Field("", "Name", 1, Integer.MAX_VALUE), new Field("", "Type", 1, 255), new Field("", "Comment", 1, Integer.MAX_VALUE)};
            int numTables = tableList.size();
            stmt = this.conn.getMetadataSafeStatement();
            String quoteChar = this.getIdentifierQuoteString();
            if (quoteChar == null) {
                quoteChar = "`";
            }
            try {
                int i = 0;
                block7: while (i < numTables) {
                    String tableToExtract = (String)tableList.get(i);
                    String query = "SHOW CREATE TABLE " + quoteChar + catalog + quoteChar + "." + quoteChar + tableToExtract + quoteChar;
                    rs = stmt.executeQuery(query);
                    while (true) {
                        if (!rs.next()) {
                            ++i;
                            continue block7;
                        }
                        this.extractForeignKeyForTable(rows, rs, catalog);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (rs != null) {
                    rs.close();
                }
                rs = null;
                if (stmt != null) {
                    stmt.close();
                }
                stmt = null;
                throw throwable;
            }
            {
                Object var11_17 = null;
                if (rs == null) break block18;
            }
            rs.close();
        }
        rs = null;
        if (stmt != null) {
            stmt.close();
        }
        stmt = null;
        return this.buildResultSet(fields, rows);
    }

    public java.sql.ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_CAT", 1, 32), new Field("", "TYPE_SCHEM", 1, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "ATTR_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 32), new Field("", "ATTR_TYPE_NAME", 1, 32), new Field("", "ATTR_SIZE", 4, 32), new Field("", "DECIMAL_DIGITS", 4, 32), new Field("", "NUM_PREC_RADIX", 4, 32), new Field("", "NULLABLE ", 4, 32), new Field("", "REMARKS", 1, 32), new Field("", "ATTR_DEF", 1, 32), new Field("", "SQL_DATA_TYPE", 4, 32), new Field("", "SQL_DATETIME_SUB", 4, 32), new Field("", "CHAR_OCTET_LENGTH", 4, 32), new Field("", "ORDINAL_POSITION", 4, 32), new Field("", "IS_NULLABLE", 1, 32), new Field("", "SCOPE_CATALOG", 1, 32), new Field("", "SCOPE_SCHEMA", 1, 32), new Field("", "SCOPE_TABLE", 1, 32), new Field("", "SOURCE_DATA_TYPE", 5, 32)};
        return this.buildResultSet(fields, new ArrayList());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet getBestRowIdentifier(String catalog, String schema, final String table, int scope, boolean nullable) throws SQLException {
        if (table == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        Field[] fields = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "COLUMN_SIZE", 4, 10), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "PSEUDO_COLUMN", 5, 5)};
        final ArrayList rows = new ArrayList();
        final Statement stmt = this.conn.getMetadataSafeStatement();
        try {
            new IterateBlock(this, this.getCatalogIterator(catalog)){

                /*
                 * Exception decompiling
                 */
                final void forEach(Object catalogStr) throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 528->532)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.doForAll();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        {
            Object var10_11 = null;
            if (stmt == null) return this.buildResultSet(fields, rows);
        }
        stmt.close();
        return this.buildResultSet(fields, rows);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void getCallStmtParameterTypes(String catalog, String procName, String parameterNamePattern, List resultRows) throws SQLException {
        block68: {
            block69: {
                block66: {
                    block67: {
                        block64: {
                            block65: {
                                paramRetrievalStmt = null;
                                paramRetrievalRs = null;
                                if (parameterNamePattern == null) {
                                    if (!this.conn.getNullNamePatternMatchesAll()) {
                                        throw new SQLException("Parameter/Column name pattern can not be NULL or empty.", "S1009");
                                    }
                                    parameterNamePattern = "%";
                                }
                                procNameAsBytes = null;
                                try {
                                    procNameAsBytes = procName.getBytes("UTF-8");
                                }
                                catch (UnsupportedEncodingException ueEx) {
                                    procNameAsBytes = this.s2b(procName);
                                }
                                quoteChar = this.getIdentifierQuoteString();
                                storageDefnDelims = "(" + quoteChar;
                                storageDefnClosures = ")" + quoteChar;
                                parameterDef = null;
                                paramRetrievalPreparedStatement = null;
                                try {
                                    paramRetrievalStmt = this.conn.getMetadataSafeStatement();
                                    if (this.conn.lowerCaseTableNames() && catalog != null && catalog.length() != 0) {
                                        oldCatalog = this.conn.getCatalog();
                                        rs = null;
                                        try {
                                            this.conn.setCatalog(catalog);
                                            rs = paramRetrievalStmt.executeQuery("SELECT DATABASE()");
                                            rs.next();
                                            catalog = rs.getString(1);
                                        }
                                        catch (Throwable var19_17) {
                                            var20_19 = null;
                                            this.conn.setCatalog(oldCatalog);
                                            rs.close();
                                            throw var19_17;
                                        }
                                        {
                                            var20_20 = null;
                                        }
                                        this.conn.setCatalog(oldCatalog);
                                        rs.close();
                                    }
                                    dotIndex = -1;
                                    dotIndex = " ".equals(quoteChar) == false ? StringUtils.indexOfIgnoreCaseRespectQuotes(0, procName, ".", quoteChar.charAt(0), this.conn.isNoBackslashEscapesSet() ^ true) : procName.indexOf(".");
                                    dbName = null;
                                    if (dotIndex != -1 && dotIndex + 1 < procName.length()) {
                                        dbName = procName.substring(0, dotIndex);
                                        procName = procName.substring(dotIndex + 1);
                                    } else {
                                        dbName = catalog;
                                    }
                                    procNameBuf = new StringBuffer();
                                    if (dbName != null) {
                                        if (!" ".equals(quoteChar) && !dbName.startsWith(quoteChar)) {
                                            procNameBuf.append(quoteChar);
                                        }
                                        procNameBuf.append(dbName);
                                        if (!" ".equals(quoteChar) && !dbName.startsWith(quoteChar)) {
                                            procNameBuf.append(quoteChar);
                                        }
                                        procNameBuf.append(".");
                                    }
                                    procNameIsNotQuoted = procName.startsWith(quoteChar) ^ true;
                                    if (!" ".equals(quoteChar) && procNameIsNotQuoted) {
                                        procNameBuf.append(quoteChar);
                                    }
                                    procNameBuf.append(procName);
                                    if (!" ".equals(quoteChar) && procNameIsNotQuoted) {
                                        procNameBuf.append(quoteChar);
                                    }
                                    parsingFunction = false;
                                    try {
                                        paramRetrievalRs = paramRetrievalStmt.executeQuery("SHOW CREATE PROCEDURE " + procNameBuf.toString());
                                        parsingFunction = false;
                                    }
                                    catch (SQLException sqlEx) {
                                        try {
                                            paramRetrievalRs = paramRetrievalStmt.executeQuery("SHOW CREATE FUNCTION " + procNameBuf.toString());
                                            parsingFunction = true;
                                        }
                                        catch (SQLException ex) {
                                            throw sqlEx;
                                        }
                                    }
                                    if (paramRetrievalRs.next()) {
                                        procedureDef = parsingFunction != false ? paramRetrievalRs.getString("Create Function") : paramRetrievalRs.getString("Create Procedure");
                                        openParenIndex = StringUtils.indexOfIgnoreCaseRespectQuotes(0, procedureDef, "(", quoteChar.charAt(0), this.conn.isNoBackslashEscapesSet() ^ true);
                                        beforeBegin = null;
                                        beginIndex = 0;
                                        if (!parsingFunction) {
                                            beginIndex = StringUtils.indexOfIgnoreCaseRespectQuotes(0, procedureDef, "\nbegin", quoteChar.charAt(0), this.conn.isNoBackslashEscapesSet() ^ true);
                                        } else {
                                            returnsIndex = StringUtils.indexOfIgnoreCaseRespectQuotes(0, procedureDef, " RETURNS ", quoteChar.charAt(0), this.conn.isNoBackslashEscapesSet() ^ true);
                                            beginIndex = StringUtils.indexOfIgnoreCaseRespectQuotes(returnsIndex, procedureDef, "\nbegin", quoteChar.charAt(0), this.conn.isNoBackslashEscapesSet() ^ true);
                                            if (beginIndex == -1) {
                                                beginIndex = StringUtils.indexOfIgnoreCaseRespectQuotes(0, procedureDef, "\n", quoteChar.charAt(0), this.conn.isNoBackslashEscapesSet() ^ true);
                                            }
                                            if (beginIndex == -1) {
                                                throw new SQLException("Driver requires declaration of procedure to either contain a '\\nbegin' or '\\n' to follow argument declaration, or SELECT privilege on mysql.proc to parse column types.", "S1000");
                                            }
                                            returnsDefn = procedureDef.substring(returnsIndex + "RETURNS ".length(), beginIndex);
                                            returnDescriptor = new TypeDescriptor(returnsDefn, null);
                                            resultRows.add(this.convertTypeDescriptorToProcedureRow(procNameAsBytes, "", false, false, true, returnDescriptor));
                                            beginIndex = returnsIndex;
                                        }
                                        if (beginIndex != -1) {
                                            beforeBegin = procedureDef.substring(0, beginIndex);
                                        } else {
                                            beginIndex = StringUtils.indexOfIgnoreCaseRespectQuotes(0, procedureDef, "\n", quoteChar.charAt(0), this.conn.isNoBackslashEscapesSet() ^ true);
                                            if (beginIndex == -1) {
                                                throw new SQLException("Driver requires declaration of procedure to either contain a '\\nbegin' or '\\n' to follow argument declaration, or SELECT privilege on mysql.proc to parse column types.", "S1000");
                                            }
                                            beforeBegin = procedureDef.substring(0, beginIndex);
                                        }
                                        endParenIndex = beforeBegin.lastIndexOf(41);
                                        if (openParenIndex == -1 || endParenIndex == -1) {
                                            throw new SQLException("Internal error when parsing callable statement metadata", "S1000");
                                        }
                                        parameterDef = procedureDef.substring(openParenIndex + 1, endParenIndex);
                                    }
                                }
                                catch (Throwable var13_39) {
                                    var14_40 = null;
                                    sqlExRethrow = null;
                                    if (paramRetrievalRs != null) {
                                        try {
                                            paramRetrievalRs.close();
                                        }
                                        catch (SQLException sqlEx) {
                                            sqlExRethrow = sqlEx;
                                        }
                                        paramRetrievalRs = null;
                                    }
                                    if (paramRetrievalPreparedStatement != null) {
                                        try {
                                            paramRetrievalPreparedStatement.close();
                                        }
                                        catch (SQLException sqlEx) {
                                            sqlExRethrow = sqlEx;
                                        }
                                        paramRetrievalPreparedStatement = null;
                                    }
                                    if (paramRetrievalStmt != null) {
                                        try {
                                            paramRetrievalStmt.close();
                                        }
                                        catch (SQLException sqlEx) {
                                            sqlExRethrow = sqlEx;
                                        }
                                        paramRetrievalStmt = null;
                                    }
                                    if (sqlExRethrow != null) {
                                        throw sqlExRethrow;
                                    }
                                    throw var13_39;
                                }
                                {
                                    var14_41 = null;
                                    sqlExRethrow = null;
                                    if (paramRetrievalRs == null) break block64;
                                }
                                ** try [egrp 6[TRYBLOCK] [6 : 971->981)] { 
lbl146:
                                // 1 sources

                                paramRetrievalRs.close();
                                break block65;
lbl148:
                                // 1 sources

                                catch (SQLException sqlEx) {
                                    sqlExRethrow = sqlEx;
                                }
                            }
                            paramRetrievalRs = null;
                        }
                        if (paramRetrievalPreparedStatement == null) break block66;
                        ** try [egrp 7[TRYBLOCK] [7 : 995->1003)] { 
lbl155:
                        // 1 sources

                        paramRetrievalPreparedStatement.close();
                        break block67;
lbl157:
                        // 1 sources

                        catch (SQLException sqlEx) {
                            sqlExRethrow = sqlEx;
                        }
                    }
                    paramRetrievalPreparedStatement = null;
                }
                if (paramRetrievalStmt == null) break block68;
                ** try [egrp 8[TRYBLOCK] [8 : 1017->1027)] { 
lbl164:
                // 1 sources

                paramRetrievalStmt.close();
                break block69;
lbl166:
                // 1 sources

                catch (SQLException sqlEx) {
                    sqlExRethrow = sqlEx;
                }
            }
            paramRetrievalStmt = null;
        }
        if (sqlExRethrow != null) {
            throw sqlExRethrow;
        }
        if (parameterDef != null) {
            parseList = StringUtils.split(parameterDef, ",", storageDefnDelims, storageDefnClosures, true);
            parseListLen = parseList.size();
            i = 0;
            block21: while (i < parseListLen) {
                declaration = (String)parseList.get(i);
                declarationTok = new StringTokenizer(declaration, " \t");
                paramName = null;
                isOutParam = false;
                isInParam = false;
                if (!declarationTok.hasMoreTokens()) {
                    throw new SQLException("Internal error when parsing callable statement metadata (unknown output from 'SHOW CREATE PROCEDURE')", "S1000");
                }
                possibleParamName = declarationTok.nextToken();
                if (possibleParamName.equalsIgnoreCase("OUT")) {
                    isOutParam = true;
                    if (!declarationTok.hasMoreTokens()) {
                        throw new SQLException("Internal error when parsing callable statement metadata (missing parameter name)", "S1000");
                    }
                    paramName = declarationTok.nextToken();
                } else if (possibleParamName.equalsIgnoreCase("INOUT")) {
                    isOutParam = true;
                    isInParam = true;
                    if (!declarationTok.hasMoreTokens()) {
                        throw new SQLException("Internal error when parsing callable statement metadata (missing parameter name)", "S1000");
                    }
                    paramName = declarationTok.nextToken();
                } else if (possibleParamName.equalsIgnoreCase("IN")) {
                    isOutParam = false;
                    isInParam = true;
                    if (!declarationTok.hasMoreTokens()) {
                        throw new SQLException("Internal error when parsing callable statement metadata (missing parameter name)", "S1000");
                    }
                    paramName = declarationTok.nextToken();
                } else {
                    isOutParam = false;
                    isInParam = true;
                    paramName = possibleParamName;
                }
                typeDesc = null;
                if (!declarationTok.hasMoreTokens()) {
                    throw new SQLException("Internal error when parsing callable statement metadata (missing parameter type)", "S1000");
                }
                typeInfoBuf = new StringBuffer(declarationTok.nextToken());
                while (true) {
                    if (!declarationTok.hasMoreTokens()) {
                        typeInfo = typeInfoBuf.toString();
                        typeDesc = new TypeDescriptor(typeInfo, null);
                        wildCompareRes = StringUtils.wildCompare(paramName, parameterNamePattern);
                        if (wildCompareRes != -1) {
                            row = this.convertTypeDescriptorToProcedureRow(procNameAsBytes, paramName, isOutParam, isInParam, false, typeDesc);
                            resultRows.add(row);
                        }
                        ++i;
                        continue block21;
                    }
                    typeInfoBuf.append(declarationTok.nextToken());
                }
            }
        }
    }

    private final int getCascadeDeleteOption(String cascadeOptions) {
        int onDeletePos = cascadeOptions.indexOf("ON DELETE");
        if (onDeletePos != -1) {
            String deleteOptions = cascadeOptions.substring(onDeletePos, cascadeOptions.length());
            if (deleteOptions.startsWith("ON DELETE CASCADE")) {
                return 0;
            }
            if (deleteOptions.startsWith("ON DELETE SET NULL")) {
                return 2;
            }
            if (deleteOptions.startsWith("ON DELETE RESTRICT")) {
                return 1;
            }
            if (deleteOptions.startsWith("ON DELETE NO ACTION")) {
                return 3;
            }
        }
        return 3;
    }

    private final int getCascadeUpdateOption(String cascadeOptions) {
        int onUpdatePos = cascadeOptions.indexOf("ON UPDATE");
        if (onUpdatePos != -1) {
            String updateOptions = cascadeOptions.substring(onUpdatePos, cascadeOptions.length());
            if (updateOptions.startsWith("ON UPDATE CASCADE")) {
                return 0;
            }
            if (updateOptions.startsWith("ON UPDATE SET NULL")) {
                return 2;
            }
            if (updateOptions.startsWith("ON UPDATE RESTRICT")) {
                return 1;
            }
            if (updateOptions.startsWith("ON UPDATE NO ACTION")) {
                return 3;
            }
        }
        return 3;
    }

    protected IteratorWithCleanup getCatalogIterator(String catalogSpec) throws SQLException {
        IteratorWithCleanup allCatalogsIter = catalogSpec != null ? (!catalogSpec.equals("") ? new SingleStringIterator(catalogSpec) : new SingleStringIterator(this.database)) : (this.conn.getNullCatalogMeansCurrent() ? new SingleStringIterator(this.database) : new ResultSetIterator(this.getCatalogs(), 1));
        return allCatalogsIter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getCatalogs() throws SQLException {
        SQLException sqlEx22;
        java.sql.ResultSet resultSet;
        Statement stmt;
        block11: {
            java.sql.ResultSet results = null;
            stmt = null;
            try {
                stmt = this.conn.createStatement();
                stmt.setEscapeProcessing(false);
                results = stmt.executeQuery("SHOW DATABASES");
                ResultSetMetaData resultsMD = results.getMetaData();
                Field[] fields = new Field[]{new Field("", "TABLE_CAT", 12, resultsMD.getColumnDisplaySize(1))};
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                while (results.next()) {
                    byte[][] rowVal = new byte[][]{results.getBytes(1)};
                    tuples.add(rowVal);
                }
                resultSet = this.buildResultSet(fields, tuples);
                Object var4_8 = null;
                if (results == null) break block11;
            }
            catch (Throwable throwable) {
                block14: {
                    SQLException sqlEx22;
                    Object var4_9 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException sqlEx22) {
                            AssertionFailedException.shouldNotHappen(sqlEx22);
                        }
                        results = null;
                    }
                    if (stmt == null) break block14;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlEx22) {
                        AssertionFailedException.shouldNotHappen(sqlEx22);
                    }
                    stmt = null;
                }
                throw throwable;
            }
            try {
                results.close();
            }
            catch (SQLException sqlEx22) {
                AssertionFailedException.shouldNotHappen(sqlEx22);
            }
            results = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sqlEx22) {
                AssertionFailedException.shouldNotHappen(sqlEx22);
            }
            stmt = null;
        }
        return resultSet;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        block19: {
            block17: {
                block18: {
                    fields = new Field[]{new Field("", "TABLE_CAT", 1, 64), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 64), new Field("", "COLUMN_NAME", 1, 64), new Field("", "GRANTOR", 1, 77), new Field("", "GRANTEE", 1, 77), new Field("", "PRIVILEGE", 1, 64), new Field("", "IS_GRANTABLE", 1, 3)};
                    grantQuery = new StringBuffer("SELECT c.host, c.db, t.grantor, c.user, c.table_name, c.column_name, c.column_priv from mysql.columns_priv c, mysql.tables_priv t where c.host = t.host and c.db = t.db and c.table_name = t.table_name ");
                    if (catalog != null && catalog.length() != 0) {
                        grantQuery.append(" AND c.db='");
                        grantQuery.append(catalog);
                        grantQuery.append("' ");
                    }
                    grantQuery.append(" AND c.table_name ='");
                    grantQuery.append(table);
                    grantQuery.append("' AND c.column_name like '");
                    grantQuery.append(columnNamePattern);
                    grantQuery.append("'");
                    stmt = null;
                    results = null;
                    grantRows = new ArrayList<byte[][]>();
                    try {
                        stmt = this.conn.createStatement();
                        stmt.setEscapeProcessing(false);
                        results = stmt.executeQuery(grantQuery.toString());
                        while (results.next()) {
                            host = results.getString(1);
                            db = results.getString(2);
                            grantor = results.getString(3);
                            user = results.getString(4);
                            if (user == null || user.length() == 0) {
                                user = "%";
                            }
                            fullUser = new StringBuffer(user);
                            if (host != null && this.conn.getUseHostsInPrivileges()) {
                                fullUser.append("@");
                                fullUser.append(host);
                            }
                            columnName = results.getString(6);
                            allPrivileges = results.getString(7);
                            if (allPrivileges == null) continue;
                            allPrivileges = allPrivileges.toUpperCase(Locale.ENGLISH);
                            st = new StringTokenizer(allPrivileges, ",");
                            while (st.hasMoreTokens()) {
                                privilege = st.nextToken().trim();
                                tuple = new byte[][]{this.s2b(db), null, this.s2b(table), this.s2b(columnName), (byte[])(grantor != null ? this.s2b(grantor) : null), this.s2b(fullUser.toString()), this.s2b(privilege), null};
                                grantRows.add(tuple);
                            }
                        }
                    }
                    catch (Throwable var10_20) {
                        var11_21 = null;
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            results = null;
                        }
                        if (stmt == null) throw var10_20;
                        try {
                            stmt.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        stmt = null;
                        throw var10_20;
                    }
                    {
                        var11_22 = null;
                        if (results == null) break block17;
                    }
                    ** try [egrp 1[TRYBLOCK] [1 : 609->619)] { 
lbl76:
                    // 1 sources

                    results.close();
                    break block18;
lbl78:
                    // 1 sources

                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                results = null;
            }
            if (stmt == null) return this.buildResultSet(fields, grantRows);
            ** try [egrp 2[TRYBLOCK] [2 : 629->639)] { 
lbl85:
            // 1 sources

            stmt.close();
            break block19;
lbl87:
            // 1 sources

            catch (Exception ex) {
                // empty catch block
            }
        }
        stmt = null;
        return this.buildResultSet(fields, grantRows);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet getColumns(final String catalog, final String schemaPattern, final String tableNamePattern, String columnNamePattern) throws SQLException {
        if (columnNamePattern == null) {
            if (!this.conn.getNullNamePatternMatchesAll()) {
                throw new SQLException("Column name pattern can not be NULL or empty.", "S1009");
            }
            columnNamePattern = "%";
        }
        final String colPattern = columnNamePattern;
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10), new Field("", "NULLABLE", 4, 10), new Field("", "REMARKS", 1, 0), new Field("", "COLUMN_DEF", 1, 0), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "CHAR_OCTET_LENGTH", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "ORDINAL_POSITION", 4, 10), new Field("", "IS_NULLABLE", 1, 3)};
        final ArrayList rows = new ArrayList();
        final Statement stmt = this.conn.getMetadataSafeStatement();
        try {
            new IterateBlock(this, this.getCatalogIterator(catalog)){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                final void forEach(Object catalogStr) throws SQLException {
                    block36: {
                        block41: {
                            block39: {
                                tableNameList = new ArrayList<String>();
                                if (tableNamePattern != null) break block39;
                                tables = null;
                                try {
                                    tables = DatabaseMetaData.this.getTables(catalog, schemaPattern, "%", new String[0]);
                                    while (tables.next()) {
                                        tableNameFromList = tables.getString("TABLE_NAME");
                                        tableNameList.add(tableNameFromList);
                                    }
                                }
                                catch (Throwable var4_5) {
                                    var5_8 = null;
                                    if (tables != null) {
                                        try {
                                            tables.close();
                                        }
                                        catch (Exception sqlEx) {
                                            AssertionFailedException.shouldNotHappen(sqlEx);
                                        }
                                        tables = null;
                                    }
                                    throw var4_5;
                                }
                                {
                                    block40: {
                                        var5_9 = null;
                                        if (tables == null) break block36;
                                        ** try [egrp 1[TRYBLOCK] [1 : 85->94)] { 
lbl27:
                                        // 1 sources

                                        tables.close();
                                        break block40;
lbl29:
                                        // 1 sources

                                        catch (Exception sqlEx) {
                                            AssertionFailedException.shouldNotHappen(sqlEx);
                                        }
                                    }
                                    tables = null;
                                    break block36;
                                }
                            }
                            tables = null;
                            try {
                                tables = DatabaseMetaData.this.getTables(catalog, schemaPattern, tableNamePattern, new String[0]);
                                while (tables.next()) {
                                    tableNameFromList = tables.getString("TABLE_NAME");
                                    tableNameList.add(tableNameFromList);
                                }
                            }
                            catch (Throwable var4_6) {
                                var5_10 = null;
                                if (tables != null) {
                                    try {
                                        tables.close();
                                    }
                                    catch (SQLException sqlEx) {
                                        AssertionFailedException.shouldNotHappen(sqlEx);
                                    }
                                    tables = null;
                                }
                                throw var4_6;
                            }
                            {
                                var5_9 = null;
                                if (tables == null) break block36;
                            }
                            ** try [egrp 4[TRYBLOCK] [4 : 183->192)] { 
lbl59:
                            // 1 sources

                            tables.close();
                            break block41;
lbl61:
                            // 1 sources

                            catch (SQLException sqlEx) {
                                AssertionFailedException.shouldNotHappen(sqlEx);
                            }
                        }
                        tables = null;
                    }
                    tableNames = tableNameList.iterator();
                    while (true) {
                        block42: {
                            if (!tableNames.hasNext()) {
                                return;
                            }
                            tableName = (String)tableNames.next();
                            results = null;
                            try {
                                queryBuf = new StringBuffer("SHOW ");
                                if (DatabaseMetaData.this.conn.versionMeetsMinimum(4, 1, 0)) {
                                    queryBuf.append("FULL ");
                                }
                                queryBuf.append("COLUMNS FROM ");
                                queryBuf.append(DatabaseMetaData.access$0(DatabaseMetaData.this));
                                queryBuf.append(tableName);
                                queryBuf.append(DatabaseMetaData.access$0(DatabaseMetaData.this));
                                queryBuf.append(" FROM ");
                                queryBuf.append(DatabaseMetaData.access$0(DatabaseMetaData.this));
                                queryBuf.append(catalogStr.toString());
                                queryBuf.append(DatabaseMetaData.access$0(DatabaseMetaData.this));
                                queryBuf.append(" LIKE '");
                                queryBuf.append(colPattern);
                                queryBuf.append("'");
                                fixUpOrdinalsRequired = false;
                                ordinalFixUpMap = null;
                                if (!colPattern.equals("%")) {
                                    fixUpOrdinalsRequired = true;
                                    fullColumnQueryBuf = new StringBuffer("SHOW ");
                                    if (DatabaseMetaData.this.conn.versionMeetsMinimum(4, 1, 0)) {
                                        fullColumnQueryBuf.append("FULL ");
                                    }
                                    fullColumnQueryBuf.append("COLUMNS FROM ");
                                    fullColumnQueryBuf.append(DatabaseMetaData.access$0(DatabaseMetaData.this));
                                    fullColumnQueryBuf.append(tableName);
                                    fullColumnQueryBuf.append(DatabaseMetaData.access$0(DatabaseMetaData.this));
                                    fullColumnQueryBuf.append(" FROM ");
                                    fullColumnQueryBuf.append(DatabaseMetaData.access$0(DatabaseMetaData.this));
                                    fullColumnQueryBuf.append(catalogStr.toString());
                                    fullColumnQueryBuf.append(DatabaseMetaData.access$0(DatabaseMetaData.this));
                                    results = stmt.executeQuery(fullColumnQueryBuf.toString());
                                    ordinalFixUpMap = new HashMap<String, Integer>();
                                    fullOrdinalPos = 1;
                                    while (results.next()) {
                                        fullOrdColName = results.getString("Field");
                                        ordinalFixUpMap.put(fullOrdColName, new Integer(fullOrdinalPos++));
                                    }
                                }
                                results = stmt.executeQuery(queryBuf.toString());
                                ordPos = 1;
                                while (results.next()) {
                                    rowVal = new byte[18][];
                                    rowVal[0] = DatabaseMetaData.access$1(DatabaseMetaData.this, catalog);
                                    rowVal[1] = null;
                                    rowVal[2] = DatabaseMetaData.access$1(DatabaseMetaData.this, tableNamePattern);
                                    rowVal[3] = results.getBytes("Field");
                                    typeDesc = new TypeDescriptor(results.getString("Type"), results.getString("Null"));
                                    rowVal[4] = Short.toString(typeDesc.dataType).getBytes();
                                    rowVal[5] = DatabaseMetaData.access$1(DatabaseMetaData.this, typeDesc.typeName);
                                    rowVal[6] = DatabaseMetaData.access$1(DatabaseMetaData.this, Integer.toString(typeDesc.columnSize));
                                    rowVal[7] = DatabaseMetaData.access$1(DatabaseMetaData.this, Integer.toString(typeDesc.bufferLength));
                                    rowVal[8] = DatabaseMetaData.access$1(DatabaseMetaData.this, Integer.toString(typeDesc.decimalDigits));
                                    rowVal[9] = DatabaseMetaData.access$1(DatabaseMetaData.this, Integer.toString(typeDesc.numPrecRadix));
                                    rowVal[10] = DatabaseMetaData.access$1(DatabaseMetaData.this, Integer.toString(typeDesc.nullability));
                                    try {
                                        rowVal[11] = DatabaseMetaData.this.conn.versionMeetsMinimum(4, 1, 0) ? results.getBytes("Comment") : results.getBytes("Extra");
                                    }
                                    catch (Exception E) {
                                        rowVal[11] = new byte[0];
                                    }
                                    rowVal[12] = results.getBytes("Default");
                                    rowVal[13] = new byte[]{48};
                                    rowVal[14] = new byte[]{48};
                                    rowVal[15] = rowVal[6];
                                    if (!fixUpOrdinalsRequired) {
                                        rowVal[16] = Integer.toString(ordPos++).getBytes();
                                    } else {
                                        origColName = results.getString("Field");
                                        realOrdinal = (Integer)ordinalFixUpMap.get(origColName);
                                        if (realOrdinal == null) {
                                            throw new SQLException("Can not find column in full column list to determine true ordinal position.", "S1000");
                                        }
                                        rowVal[16] = realOrdinal.toString().getBytes();
                                    }
                                    rowVal[17] = DatabaseMetaData.access$1(DatabaseMetaData.this, typeDesc.isNullable);
                                    rows.add(rowVal);
                                }
                            }
                            catch (Throwable var6_14) {
                                var7_4 = null;
                                if (results != null) {
                                    try {
                                        results.close();
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                    results = null;
                                }
                                throw var6_14;
                            }
                            {
                                var7_4 = null;
                                if (results == null) continue;
                            }
                            ** try [egrp 8[TRYBLOCK] [8 : 1077->1087)] { 
lbl184:
                            // 1 sources

                            results.close();
                            break block42;
lbl186:
                            // 1 sources

                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        results = null;
                    }
                }
            }.doForAll();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        {
            Object var10_11 = null;
            if (stmt == null) return this.buildResultSet(fields, rows);
        }
        stmt.close();
        return this.buildResultSet(fields, rows);
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.conn;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet getCrossReference(final String primaryCatalog, final String primarySchema, final String primaryTable, final String foreignCatalog, final String foreignSchema, final String foreignTable) throws SQLException {
        if (primaryTable == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 0), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        final ArrayList tuples = new ArrayList();
        if (!this.conn.versionMeetsMinimum(3, 23, 0)) return this.buildResultSet(fields, tuples);
        final Statement stmt = this.conn.getMetadataSafeStatement();
        try {
            new IterateBlock(this, this.getCatalogIterator(foreignCatalog)){

                /*
                 * Exception decompiling
                 */
                final void forEach(Object catalogStr) throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 655->659)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.doForAll();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        {
            Object var11_12 = null;
            if (stmt == null) return this.buildResultSet(fields, tuples);
        }
        stmt.close();
        return this.buildResultSet(fields, tuples);
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.conn.getServerMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.conn.getServerMinorVersion();
    }

    public String getDatabaseProductName() throws SQLException {
        return "MySQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.conn.getServerVersion();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.conn.supportsIsolationLevel()) {
            return 2;
        }
        return 0;
    }

    public int getDriverMajorVersion() {
        return NonRegisteringDriver.getMajorVersionInternal();
    }

    public int getDriverMinorVersion() {
        return NonRegisteringDriver.getMinorVersionInternal();
    }

    public String getDriverName() throws SQLException {
        return "MySQL-AB JDBC Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "mysql-connector-java-3.1.11 ( $Date: 2005-09-21 18:20:03 +0000 (Wed, 21 Sep 2005) $, $Revision: 4287 $ )";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet getExportedKeys(String catalog, String schema, final String table) throws SQLException {
        if (table == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 255), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        final ArrayList rows = new ArrayList();
        if (!this.conn.versionMeetsMinimum(3, 23, 0)) return this.buildResultSet(fields, rows);
        final Statement stmt = this.conn.getMetadataSafeStatement();
        try {
            new IterateBlock(this, this.getCatalogIterator(catalog)){

                /*
                 * Exception decompiling
                 */
                final void forEach(Object catalogStr) throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 284->288)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.doForAll();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        {
            Object var8_9 = null;
            if (stmt == null) return this.buildResultSet(fields, rows);
        }
        stmt.close();
        return this.buildResultSet(fields, rows);
    }

    private final void getExportKeyResults(String catalog, String exportingTable, String keysComment, List tuples, String fkTableName) throws SQLException {
        this.getResultsImpl(catalog, exportingTable, keysComment, tuples, fkTableName, true);
    }

    public String getExtraNameCharacters() throws SQLException {
        return "#@";
    }

    private final int[] getForeignKeyActions(String commentString) {
        int[] actions = new int[]{3, 3};
        int lastParenIndex = commentString.lastIndexOf(")");
        if (lastParenIndex != commentString.length() - 1) {
            String cascadeOptions = commentString.substring(lastParenIndex + 1).trim().toUpperCase(Locale.ENGLISH);
            actions[0] = this.getCascadeDeleteOption(cascadeOptions);
            actions[1] = this.getCascadeUpdateOption(cascadeOptions);
        }
        return actions;
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (this.conn.supportsQuotedIdentifiers()) {
            if (!this.conn.useAnsiQuotedIdentifiers()) {
                return "`";
            }
            return "\"";
        }
        return " ";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet getImportedKeys(String catalog, String schema, final String table) throws SQLException {
        if (table == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 255), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        final ArrayList rows = new ArrayList();
        if (!this.conn.versionMeetsMinimum(3, 23, 0)) return this.buildResultSet(fields, rows);
        final Statement stmt = this.conn.getMetadataSafeStatement();
        try {
            new IterateBlock(this, this.getCatalogIterator(catalog)){

                /*
                 * Exception decompiling
                 */
                final void forEach(Object catalogStr) throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 302->306)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.doForAll();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        {
            Object var8_9 = null;
            if (stmt == null) return this.buildResultSet(fields, rows);
        }
        stmt.close();
        return this.buildResultSet(fields, rows);
    }

    private final void getImportKeyResults(String catalog, String importingTable, String keysComment, List tuples) throws SQLException {
        this.getResultsImpl(catalog, importingTable, keysComment, tuples, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getIndexInfo(String catalog, String schema, final String table, final boolean unique, boolean approximate) throws SQLException {
        java.sql.ResultSet resultSet;
        block2: {
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "NON_UNIQUE", 1, 4), new Field("", "INDEX_QUALIFIER", 1, 1), new Field("", "INDEX_NAME", 1, 32), new Field("", "TYPE", 1, 32), new Field("", "ORDINAL_POSITION", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "ASC_OR_DESC", 1, 1), new Field("", "CARDINALITY", 4, 10), new Field("", "PAGES", 4, 10), new Field("", "FILTER_CONDITION", 1, 32)};
            final ArrayList rows = new ArrayList();
            final Statement stmt = this.conn.getMetadataSafeStatement();
            try {
                java.sql.ResultSet indexInfo;
                new IterateBlock(this, this.getCatalogIterator(catalog)){

                    /*
                     * Exception decompiling
                     */
                    final void forEach(Object catalogStr) throws SQLException {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 426->430)] java.lang.Throwable
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                }.doForAll();
                resultSet = indexInfo = this.buildResultSet(fields, rows);
                Object var10_11 = null;
                if (stmt == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var10_12 = null;
                    if (stmt == null) break block3;
                    stmt.close();
                }
                throw throwable;
            }
            stmt.close();
        }
        return resultSet;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 32;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 256;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 512;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 64;
    }

    public int getMaxIndexLength() throws SQLException {
        return 256;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0x7FFFFFF7;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxStatementLength() throws SQLException {
        return MysqlIO.getMaxBuf() - 4;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 64;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 256;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 16;
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,BIT_COUNT,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MAX,MIN,MOD,PI,POW,POWER,RADIANS,RAND,ROUND,SIN,SQRT,TAN,TRUNCATE";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet getPrimaryKeys(String catalog, String schema, final String table) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "COLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 5), new Field("", "PK_NAME", 1, 32)};
        if (table == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        final ArrayList rows = new ArrayList();
        final Statement stmt = this.conn.getMetadataSafeStatement();
        try {
            new IterateBlock(this, this.getCatalogIterator(catalog)){

                /*
                 * Exception decompiling
                 */
                final void forEach(Object catalogStr) throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 363->367)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.doForAll();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        {
            Object var8_9 = null;
            if (stmt == null) return this.buildResultSet(fields, rows);
        }
        stmt.close();
        return this.buildResultSet(fields, rows);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        block21: {
            block20: {
                block19: {
                    block22: {
                        fields = new Field[]{new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "COLUMN_NAME", 1, 0), new Field("", "COLUMN_TYPE", 1, 0), new Field("", "DATA_TYPE", 5, 0), new Field("", "TYPE_NAME", 1, 0), new Field("", "PRECISION", 4, 0), new Field("", "LENGTH", 4, 0), new Field("", "SCALE", 5, 0), new Field("", "RADIX", 5, 0), new Field("", "NULLABLE", 5, 0), new Field("", "REMARKS", 1, 0)};
                        proceduresToExtractList = new ArrayList<String>();
                        if (!this.supportsStoredProcedures()) break block21;
                        if (procedureNamePattern.indexOf("%") != -1 || procedureNamePattern.indexOf("?") != -1) break block22;
                        proceduresToExtractList.add(procedureNamePattern);
                        break block21;
                    }
                    procedureNameStmt = null;
                    procedureNameRs = null;
                    try {
                        procedureNameRs = this.getProcedures(catalog, schemaPattern, procedureNamePattern);
                        while (true) {
                            block23: {
                                if (procedureNameRs.next()) break block23;
                                Collections.sort(proceduresToExtractList);
                                break;
                            }
                            proceduresToExtractList.add(procedureNameRs.getString(3));
                        }
                    }
                    catch (Throwable var9_9) {
                        var10_11 = null;
                        rethrowSqlEx = null;
                        if (procedureNameRs != null) {
                            try {
                                procedureNameRs.close();
                            }
                            catch (SQLException sqlEx) {
                                rethrowSqlEx = sqlEx;
                            }
                        }
                        if (procedureNameStmt != null) {
                            try {
                                procedureNameStmt.close();
                            }
                            catch (SQLException sqlEx) {
                                rethrowSqlEx = sqlEx;
                            }
                        }
                        if (rethrowSqlEx != null) {
                            throw rethrowSqlEx;
                        }
                        throw var9_9;
                    }
                    {
                        var10_12 = null;
                        rethrowSqlEx = null;
                        if (procedureNameRs == null) break block19;
                    }
                    ** try [egrp 1[TRYBLOCK] [1 : 381->391)] { 
lbl46:
                    // 1 sources

                    procedureNameRs.close();
                    break block19;
lbl48:
                    // 1 sources

                    catch (SQLException sqlEx) {
                        rethrowSqlEx = sqlEx;
                    }
                }
                if (procedureNameStmt != null) {
                    ** try [egrp 2[TRYBLOCK] [2 : 402->410)] { 
lbl53:
                    // 1 sources

                    procedureNameStmt.close();
                    break block20;
lbl55:
                    // 1 sources

                    catch (SQLException sqlEx) {
                        rethrowSqlEx = sqlEx;
                    }
                }
            }
            if (rethrowSqlEx != null) {
                throw rethrowSqlEx;
            }
        }
        resultRows = new ArrayList<E>();
        iter = proceduresToExtractList.iterator();
        while (true) {
            if (!iter.hasNext()) {
                return this.buildResultSet(fields, resultRows);
            }
            procName = (String)iter.next();
            this.getCallStmtParameterTypes(catalog, procName, columnNamePattern, resultRows);
        }
    }

    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (procedureNamePattern == null || procedureNamePattern.length() == 0) {
            if (this.conn.getNullNamePatternMatchesAll()) {
                procedureNamePattern = "%";
            } else {
                throw new SQLException("Procedure name pattern can not be NULL or empty.", "S1009");
            }
        }
        Field[] fields = new Field[]{new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "reserved1", 1, 0), new Field("", "reserved2", 1, 0), new Field("", "reserved3", 1, 0), new Field("", "REMARKS", 1, 0), new Field("", "PROCEDURE_TYPE", 5, 0)};
        final ArrayList procedureRows = new ArrayList();
        if (this.supportsStoredProcedures()) {
            final String procNamePattern = procedureNamePattern;
            final TreeMap procedureRowsOrderedByName = new TreeMap();
            new IterateBlock(this, this.getCatalogIterator(catalog)){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                final void forEach(Object catalogStr) throws SQLException {
                    block27: {
                        block26: {
                            db = catalogStr.toString();
                            fromSelect = false;
                            proceduresRs = null;
                            needsClientFiltering = true;
                            proceduresStmt = DatabaseMetaData.this.conn.clientPrepareStatement("SELECT name, type FROM mysql.proc WHERE name like ? and db <=> ? ORDER BY name");
                            try {
                                hasTypeColumn = false;
                                if (db != null) {
                                    proceduresStmt.setString(2, db);
                                } else {
                                    proceduresStmt.setNull(2, 12);
                                }
                                nameIndex = 1;
                                if (proceduresStmt.getMaxRows() != 0) {
                                    proceduresStmt.setMaxRows(0);
                                }
                                proceduresStmt.setString(1, procNamePattern);
                                try {
                                    proceduresRs = proceduresStmt.executeQuery();
                                    fromSelect = true;
                                    needsClientFiltering = false;
                                    hasTypeColumn = true;
                                }
                                catch (SQLException sqlEx) {
                                    proceduresStmt.close();
                                    fromSelect = false;
                                    nameIndex = DatabaseMetaData.this.conn.versionMeetsMinimum(5, 0, 1) != false ? 2 : 1;
                                    proceduresStmt = DatabaseMetaData.this.conn.clientPrepareStatement("SHOW PROCEDURE STATUS LIKE ?");
                                    if (proceduresStmt.getMaxRows() != 0) {
                                        proceduresStmt.setMaxRows(0);
                                    }
                                    proceduresStmt.setString(1, procNamePattern);
                                    proceduresRs = proceduresStmt.executeQuery();
                                }
                                DatabaseMetaData.access$9(DatabaseMetaData.this, fromSelect, db, proceduresRs, needsClientFiltering, db, procedureRowsOrderedByName, nameIndex);
                                if (!hasTypeColumn) {
                                    if (proceduresStmt != null) {
                                        proceduresStmt.close();
                                    }
                                    if ((proceduresStmt = DatabaseMetaData.this.conn.clientPrepareStatement("SHOW FUNCTION STATUS LIKE ?")).getMaxRows() != 0) {
                                        proceduresStmt.setMaxRows(0);
                                    }
                                    proceduresStmt.setString(1, procNamePattern);
                                    proceduresRs = proceduresStmt.executeQuery();
                                    DatabaseMetaData.access$10(DatabaseMetaData.this, db, proceduresRs, needsClientFiltering, db, procedureRowsOrderedByName, nameIndex);
                                }
                                proceduresIter = procedureRowsOrderedByName.values().iterator();
                                while (proceduresIter.hasNext()) {
                                    procedureRows.add(proceduresIter.next());
                                }
                            }
                            catch (Throwable var7_11) {
                                var8_12 = null;
                                rethrowSqlEx = null;
                                if (proceduresRs != null) {
                                    try {
                                        proceduresRs.close();
                                    }
                                    catch (SQLException sqlEx) {
                                        rethrowSqlEx = sqlEx;
                                    }
                                }
                                if (proceduresStmt != null) {
                                    try {
                                        proceduresStmt.close();
                                    }
                                    catch (SQLException sqlEx) {
                                        rethrowSqlEx = sqlEx;
                                    }
                                }
                                if (rethrowSqlEx != null) {
                                    throw rethrowSqlEx;
                                }
                                throw var7_11;
                            }
                            {
                                var8_13 = null;
                                rethrowSqlEx = null;
                                if (proceduresRs == null) break block26;
                            }
                            ** try [egrp 2[TRYBLOCK] [2 : 340->350)] { 
lbl71:
                            // 1 sources

                            proceduresRs.close();
                            break block26;
lbl73:
                            // 1 sources

                            catch (SQLException sqlEx) {
                                rethrowSqlEx = sqlEx;
                            }
                        }
                        if (proceduresStmt != null) {
                            ** try [egrp 3[TRYBLOCK] [3 : 361->369)] { 
lbl78:
                            // 1 sources

                            proceduresStmt.close();
                            break block27;
lbl80:
                            // 1 sources

                            catch (SQLException sqlEx) {
                                rethrowSqlEx = sqlEx;
                            }
                        }
                    }
                    if (rethrowSqlEx != null) {
                        throw rethrowSqlEx;
                    }
                }
            }.doForAll();
        }
        return this.buildResultSet(fields, procedureRows);
    }

    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    private final void getResultsImpl(String catalog, String table, String keysComment, List tuples, String fkTableName, boolean isExport) throws SQLException {
        LocalAndReferencedColumns parsedInfo = this.parseTableStatusIntoLocalAndReferencedColumns(keysComment);
        if (isExport && !parsedInfo.referencedTable.equals(table)) {
            return;
        }
        if (parsedInfo.localColumnsList.size() != parsedInfo.referencedColumnsList.size()) {
            throw new SQLException("Error parsing foreign keys definition,number of local and referenced columns is not the same.", "S1000");
        }
        Iterator localColumnNames = parsedInfo.localColumnsList.iterator();
        Iterator referColumnNames = parsedInfo.referencedColumnsList.iterator();
        int keySeqIndex = 1;
        while (localColumnNames.hasNext()) {
            byte[][] tuple = new byte[14][];
            String lColumnName = this.removeQuotedId(localColumnNames.next().toString());
            String rColumnName = this.removeQuotedId(referColumnNames.next().toString());
            tuple[4] = catalog == null ? new byte[]{} : this.s2b(catalog);
            tuple[5] = null;
            tuple[6] = this.s2b(isExport ? fkTableName : table);
            tuple[7] = this.s2b(lColumnName);
            tuple[0] = this.s2b(parsedInfo.referencedCatalog);
            tuple[1] = null;
            tuple[2] = this.s2b(isExport ? table : parsedInfo.referencedTable);
            tuple[3] = this.s2b(rColumnName);
            tuple[8] = this.s2b(Integer.toString(keySeqIndex++));
            int[] actions = this.getForeignKeyActions(keysComment);
            tuple[9] = this.s2b(Integer.toString(actions[1]));
            tuple[10] = this.s2b(Integer.toString(actions[0]));
            tuple[11] = this.s2b(parsedInfo.constraintName);
            tuple[12] = null;
            tuple[13] = this.s2b(Integer.toString(7));
            tuples.add(tuple);
        }
    }

    private final LocalAndReferencedColumns parseTableStatusIntoLocalAndReferencedColumns(String keysComment) throws SQLException {
        char quoteChar;
        int indexOfOpenParenLocalColumns;
        String columnsDelimitter = ",";
        char c = '\u0000';
        if (this.quotedId.length() != 0) {
            c = this.quotedId.charAt(0);
        }
        if ((indexOfOpenParenLocalColumns = StringUtils.indexOfIgnoreCaseRespectQuotes(0, keysComment, "(", quoteChar = c, true)) == -1) {
            throw new SQLException("Error parsing foreign keys definition, couldn't find start of local columns list.", "S1000");
        }
        String constraintName = this.removeQuotedId(keysComment.substring(0, indexOfOpenParenLocalColumns).trim());
        String keysCommentTrimmed = (keysComment = keysComment.substring(indexOfOpenParenLocalColumns, keysComment.length())).trim();
        int indexOfCloseParenLocalColumns = StringUtils.indexOfIgnoreCaseRespectQuotes(0, keysCommentTrimmed, ")", quoteChar, true);
        if (indexOfCloseParenLocalColumns == -1) {
            throw new SQLException("Error parsing foreign keys definition, couldn't find end of local columns list.", "S1000");
        }
        String localColumnNamesString = keysCommentTrimmed.substring(1, indexOfCloseParenLocalColumns);
        int indexOfRefer = StringUtils.indexOfIgnoreCaseRespectQuotes(0, keysCommentTrimmed, "REFER ", this.quotedId.charAt(0), true);
        if (indexOfRefer == -1) {
            throw new SQLException("Error parsing foreign keys definition, couldn't find start of referenced tables list.", "S1000");
        }
        int indexOfOpenParenReferCol = StringUtils.indexOfIgnoreCaseRespectQuotes(indexOfRefer, keysCommentTrimmed, "(", quoteChar, false);
        if (indexOfOpenParenReferCol == -1) {
            throw new SQLException("Error parsing foreign keys definition, couldn't find start of referenced columns list.", "S1000");
        }
        String referCatalogTableString = keysCommentTrimmed.substring(indexOfRefer + "REFER ".length(), indexOfOpenParenReferCol);
        int indexOfSlash = StringUtils.indexOfIgnoreCaseRespectQuotes(0, referCatalogTableString, "/", this.quotedId.charAt(0), false);
        if (indexOfSlash == -1) {
            throw new SQLException("Error parsing foreign keys definition, couldn't find name of referenced catalog.", "S1000");
        }
        String referCatalog = this.removeQuotedId(referCatalogTableString.substring(0, indexOfSlash));
        String referTable = this.removeQuotedId(referCatalogTableString.substring(indexOfSlash + 1).trim());
        int indexOfCloseParenRefer = StringUtils.indexOfIgnoreCaseRespectQuotes(indexOfOpenParenReferCol, keysCommentTrimmed, ")", quoteChar, true);
        if (indexOfCloseParenRefer == -1) {
            throw new SQLException("Error parsing foreign keys definition, couldn't find end of referenced columns list.", "S1000");
        }
        String referColumnNamesString = keysCommentTrimmed.substring(indexOfOpenParenReferCol + 1, indexOfCloseParenRefer);
        List referColumnsList = StringUtils.split(referColumnNamesString, columnsDelimitter, this.quotedId, this.quotedId, false);
        List localColumnsList = StringUtils.split(localColumnNamesString, columnsDelimitter, this.quotedId, this.quotedId, false);
        return new LocalAndReferencedColumns(localColumnsList, referColumnsList, constraintName, referCatalog, referTable);
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_SCHEM", 1, 0)};
        ArrayList tuples = new ArrayList();
        java.sql.ResultSet results = this.buildResultSet(fields, tuples);
        return results;
    }

    public String getSchemaTerm() throws SQLException {
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getSQLKeywords() throws SQLException {
        return "AUTO_INCREMENT,BINARY,BLOB,ENUM,INFILE,LOAD,MEDIUMINT,OPTION,OUTFILE,REPLACE,SET,TEXT,UNSIGNED,ZEROFILL";
    }

    public int getSQLStateType() throws SQLException {
        if (this.conn.versionMeetsMinimum(4, 1, 0)) {
            return 2;
        }
        if (this.conn.getUseSqlStateCodes()) {
            return 2;
        }
        return 1;
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,BIN,BIT_LENGTH,CHAR,CHARACTER_LENGTH,CHAR_LENGTH,CONCAT,CONCAT_WS,CONV,ELT,EXPORT_SET,FIELD,FIND_IN_SET,HEX,INSERT,INSTR,LCASE,LEFT,LENGTH,LOAD_FILE,LOCATE,LOCATE,LOWER,LPAD,LTRIM,MAKE_SET,MATCH,MID,OCT,OCTET_LENGTH,ORD,POSITION,QUOTE,REPEAT,REPLACE,REVERSE,RIGHT,RPAD,RTRIM,SOUNDEX,SPACE,STRCMP,SUBSTRING,SUBSTRING,SUBSTRING,SUBSTRING,SUBSTRING_INDEX,TRIM,UCASE,UPPER";
    }

    public java.sql.ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 32), new Field("", "TABLE_SCHEM", 1, 32), new Field("", "TABLE_NAME", 1, 32), new Field("", "SUPERTABLE_NAME", 1, 32)};
        return this.buildResultSet(fields, new ArrayList());
    }

    public java.sql.ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 32), new Field("", "TABLE_SCHEM", 1, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "SUPERTYPE_CAT", 1, 32), new Field("", "SUPERTYPE_SCHEM", 1, 32), new Field("", "SUPERTYPE_NAME", 1, 32)};
        return this.buildResultSet(fields, new ArrayList());
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,PASSWORD,ENCRYPT,LAST_INSERT_ID,VERSION";
    }

    private final String getTableNameWithCase(String table) {
        String tableNameWithCase = this.conn.lowerCaseTableNames() ? table.toLowerCase() : table;
        return tableNameWithCase;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        block27: {
            block25: {
                block26: {
                    if (tableNamePattern == null) {
                        if (this.conn.getNullNamePatternMatchesAll() == false) throw new SQLException("Table name pattern can not be NULL or empty.", "S1009");
                        tableNamePattern = "%";
                    }
                    fields = new Field[]{new Field("", "TABLE_CAT", 1, 64), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 64), new Field("", "GRANTOR", 1, 77), new Field("", "GRANTEE", 1, 77), new Field("", "PRIVILEGE", 1, 64), new Field("", "IS_GRANTABLE", 1, 3)};
                    grantQuery = new StringBuffer("SELECT host,db,table_name,grantor,user,table_priv from mysql.tables_priv ");
                    grantQuery.append(" WHERE ");
                    if (catalog != null && catalog.length() != 0) {
                        grantQuery.append(" db='");
                        grantQuery.append(catalog);
                        grantQuery.append("' AND ");
                    }
                    grantQuery.append("table_name like '");
                    grantQuery.append(tableNamePattern);
                    grantQuery.append("'");
                    results = null;
                    grantRows = new ArrayList<byte[][]>();
                    stmt = null;
                    try {
                        stmt = this.conn.createStatement();
                        stmt.setEscapeProcessing(false);
                        results = stmt.executeQuery(grantQuery.toString());
                        while (results.next()) {
                            host = results.getString(1);
                            db = results.getString(2);
                            table = results.getString(3);
                            grantor = results.getString(4);
                            user = results.getString(5);
                            if (user == null || user.length() == 0) {
                                user = "%";
                            }
                            fullUser = new StringBuffer(user);
                            if (host != null && this.conn.getUseHostsInPrivileges()) {
                                fullUser.append("@");
                                fullUser.append(host);
                            }
                            if ((allPrivileges = results.getString(6)) == null) continue;
                            allPrivileges = allPrivileges.toUpperCase(Locale.ENGLISH);
                            st = new StringTokenizer(allPrivileges, ",");
                            while (st.hasMoreTokens()) {
                                privilege = st.nextToken().trim();
                                columnResults = null;
                                try {
                                    columnResults = this.getColumns(catalog, schemaPattern, table, "%");
                                    while (columnResults.next()) {
                                        tuple = new byte[8][];
                                        tuple[0] = this.s2b(db);
                                        tuple[1] = null;
                                        tuple[2] = this.s2b(table);
                                        tuple[3] = (byte[])(grantor != null ? this.s2b(grantor) : null);
                                        tuple[4] = this.s2b(fullUser.toString());
                                        tuple[5] = this.s2b(privilege);
                                        tuple[6] = null;
                                        grantRows.add(tuple);
                                    }
                                }
                                catch (Throwable var23_22) {
                                    var24_19 = null;
                                    if (columnResults == null) throw var23_22;
                                    try {
                                        columnResults.close();
                                        throw var23_22;
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                    throw var23_22;
                                }
                                {
                                    var24_19 = null;
                                    if (columnResults == null) continue;
                                }
                                try {}
                                catch (Exception ex) {
                                    // empty catch block
                                    continue;
                                }
                                columnResults.close();
                            }
                        }
                    }
                    catch (Throwable var9_23) {
                        var10_24 = null;
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            results = null;
                        }
                        if (stmt == null) throw var9_23;
                        try {
                            stmt.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        stmt = null;
                        throw var9_23;
                    }
                    {
                        var10_25 = null;
                        if (results == null) break block25;
                    }
                    ** try [egrp 4[TRYBLOCK] [4 : 668->678)] { 
lbl106:
                    // 1 sources

                    results.close();
                    break block26;
lbl108:
                    // 1 sources

                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                results = null;
            }
            if (stmt == null) return this.buildResultSet(fields, grantRows);
            ** try [egrp 5[TRYBLOCK] [5 : 688->698)] { 
lbl115:
            // 1 sources

            stmt.close();
            break block27;
lbl117:
            // 1 sources

            catch (Exception ex) {
                // empty catch block
            }
        }
        stmt = null;
        return this.buildResultSet(fields, grantRows);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, final String[] types) throws SQLException {
        if (tableNamePattern == null) {
            if (!this.conn.getNullNamePatternMatchesAll()) {
                throw new SQLException("Table name pattern can not be NULL or empty.", "S1009");
            }
            tableNamePattern = "%";
        }
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 12, 255), new Field("", "TABLE_SCHEM", 12, 0), new Field("", "TABLE_NAME", 12, 255), new Field("", "TABLE_TYPE", 12, 5), new Field("", "REMARKS", 12, 0)};
        final ArrayList tuples = new ArrayList();
        final Statement stmt = this.conn.getMetadataSafeStatement();
        final String tableNamePat = tableNamePattern;
        try {
            new IterateBlock(this, this.getCatalogIterator(catalog)){

                /*
                 * Exception decompiling
                 */
                final void forEach(Object catalogStr) throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 710->714)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.doForAll();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        {
            Object var10_11 = null;
            if (stmt == null) return this.buildResultSet(fields, tuples);
        }
        stmt.close();
        return this.buildResultSet(fields, tuples);
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        Field[] fields = new Field[]{new Field("", "TABLE_TYPE", 12, 5)};
        byte[][] tableTypeRow = new byte[][]{TABLE_AS_BYTES};
        tuples.add(tableTypeRow);
        if (this.conn.versionMeetsMinimum(5, 0, 1)) {
            byte[][] viewTypeRow = new byte[][]{VIEW_AS_BYTES};
            tuples.add(viewTypeRow);
        }
        byte[][] tempTypeRow = new byte[][]{this.s2b("LOCAL TEMPORARY")};
        tuples.add(tempTypeRow);
        return this.buildResultSet(fields, tuples);
    }

    public String getTimeDateFunctions() throws SQLException {
        return "DAYOFWEEK,WEEKDAY,DAYOFMONTH,DAYOFYEAR,MONTH,DAYNAME,MONTHNAME,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,PERIOD_ADD,PERIOD_DIFF,TO_DAYS,FROM_DAYS,DATE_FORMAT,TIME_FORMAT,CURDATE,CURRENT_DATE,CURTIME,CURRENT_TIME,NOW,SYSDATE,CURRENT_TIMESTAMP,UNIX_TIMESTAMP,FROM_UNIXTIME,SEC_TO_TIME,TIME_TO_SEC";
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "PRECISION", 4, 10), new Field("", "LITERAL_PREFIX", 1, 4), new Field("", "LITERAL_SUFFIX", 1, 4), new Field("", "CREATE_PARAMS", 1, 32), new Field("", "NULLABLE", 5, 5), new Field("", "CASE_SENSITIVE", 1, 3), new Field("", "SEARCHABLE", 5, 3), new Field("", "UNSIGNED_ATTRIBUTE", 1, 3), new Field("", "FIXED_PREC_SCALE", 1, 3), new Field("", "AUTO_INCREMENT", 1, 3), new Field("", "LOCAL_TYPE_NAME", 1, 32), new Field("", "MINIMUM_SCALE", 5, 5), new Field("", "MAXIMUM_SCALE", 5, 5), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10)};
        Object rowVal = null;
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BIT");
        rowVal[1] = Integer.toString(-7).getBytes();
        rowVal[2] = this.s2b("1");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("BIT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BOOL");
        rowVal[1] = Integer.toString(-7).getBytes();
        rowVal[2] = this.s2b("1");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("BOOL");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TINYINT");
        rowVal[1] = Integer.toString(-6).getBytes();
        rowVal[2] = this.s2b("3");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("TINYINT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BIGINT");
        rowVal[1] = Integer.toString(-5).getBytes();
        rowVal[2] = this.s2b("19");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("BIGINT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("LONG VARBINARY");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = this.s2b("16777215");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("LONG VARBINARY");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("MEDIUMBLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = this.s2b("16777215");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("MEDIUMBLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("LONGBLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = Integer.toString(Integer.MAX_VALUE).getBytes();
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("LONGBLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = this.s2b("65535");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("BLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TINYBLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("TINYBLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("VARBINARY");
        rowVal[1] = Integer.toString(-3).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("(M)");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("VARBINARY");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BINARY");
        rowVal[1] = Integer.toString(-2).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("(M)");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("BINARY");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("LONG VARCHAR");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = this.s2b("16777215");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("LONG VARCHAR");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("MEDIUMTEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = this.s2b("16777215");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("MEDIUMTEXT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("LONGTEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = Integer.toString(Integer.MAX_VALUE).getBytes();
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("LONGTEXT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = this.s2b("65535");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("TEXT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TINYTEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("TINYTEXT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("CHAR");
        rowVal[1] = Integer.toString(1).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("(M)");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("CHAR");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("NUMERIC");
        rowVal[1] = Integer.toString(2).getBytes();
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M[,D])] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("NUMERIC");
        rowVal[13] = this.s2b("-308");
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("DECIMAL");
        rowVal[1] = Integer.toString(3).getBytes();
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M[,D])] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("DECIMAL");
        rowVal[13] = this.s2b("-308");
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("INTEGER");
        rowVal[1] = Integer.toString(4).getBytes();
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("INTEGER");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("INT");
        rowVal[1] = Integer.toString(4).getBytes();
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("INT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("MEDIUMINT");
        rowVal[1] = Integer.toString(4).getBytes();
        rowVal[2] = this.s2b("7");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("MEDIUMINT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("SMALLINT");
        rowVal[1] = Integer.toString(5).getBytes();
        rowVal[2] = this.s2b("5");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("SMALLINT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("FLOAT");
        rowVal[1] = Integer.toString(7).getBytes();
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("FLOAT");
        rowVal[13] = this.s2b("-38");
        rowVal[14] = this.s2b("38");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("DOUBLE");
        rowVal[1] = Integer.toString(8).getBytes();
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("DOUBLE");
        rowVal[13] = this.s2b("-308");
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("DOUBLE PRECISION");
        rowVal[1] = Integer.toString(8).getBytes();
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("DOUBLE PRECISION");
        rowVal[13] = this.s2b("-308");
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("REAL");
        rowVal[1] = Integer.toString(8).getBytes();
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("REAL");
        rowVal[13] = this.s2b("-308");
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("VARCHAR");
        rowVal[1] = Integer.toString(12).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("(M)");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("VARCHAR");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("ENUM");
        rowVal[1] = Integer.toString(12).getBytes();
        rowVal[2] = this.s2b("65535");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("ENUM");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("SET");
        rowVal[1] = Integer.toString(12).getBytes();
        rowVal[2] = this.s2b("64");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("SET");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("DATE");
        rowVal[1] = Integer.toString(91).getBytes();
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("DATE");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TIME");
        rowVal[1] = Integer.toString(92).getBytes();
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("TIME");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("DATETIME");
        rowVal[1] = Integer.toString(93).getBytes();
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("DATETIME");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TIMESTAMP");
        rowVal[1] = Integer.toString(93).getBytes();
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("[(M)]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("TIMESTAMP");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        return this.buildResultSet(fields, tuples);
    }

    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_CAT", 12, 32), new Field("", "TYPE_SCHEM", 12, 32), new Field("", "TYPE_NAME", 12, 32), new Field("", "CLASS_NAME", 12, 32), new Field("", "DATA_TYPE", 12, 32), new Field("", "REMARKS", 12, 32)};
        ArrayList tuples = new ArrayList();
        return this.buildResultSet(fields, tuples);
    }

    public String getURL() throws SQLException {
        return this.conn.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() throws SQLException {
        if (this.conn.getUseHostsInPrivileges()) {
            Exception ex22;
            String string;
            Statement stmt;
            block12: {
                stmt = null;
                java.sql.ResultSet rs = null;
                try {
                    stmt = this.conn.createStatement();
                    stmt.setEscapeProcessing(false);
                    rs = stmt.executeQuery("SELECT USER()");
                    rs.next();
                    string = rs.getString(1);
                    Object var4_4 = null;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    Exception ex22;
                    Object var4_5 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex22) {
                            AssertionFailedException.shouldNotHappen(ex22);
                        }
                        rs = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex22) {
                            AssertionFailedException.shouldNotHappen(ex22);
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (Exception ex22) {
                    AssertionFailedException.shouldNotHappen(ex22);
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex22) {
                    AssertionFailedException.shouldNotHappen(ex22);
                }
                stmt = null;
            }
            return string;
        }
        return this.conn.getUser();
    }

    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Field[] fields = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 1, 16), new Field("", "BUFFER_LENGTH", 1, 16), new Field("", "DECIMAL_DIGITS", 1, 16), new Field("", "PSEUDO_COLUMN", 5, 5)};
        return this.buildResultSet(fields, new ArrayList());
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return this.conn.getEmulateLocators() ^ true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        boolean bl = false;
        if (this.conn.versionMeetsMinimum(4, 0, 2) && !this.conn.versionMeetsMinimum(4, 0, 11)) {
            bl = true;
        }
        return bl;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return this.nullsAreSortedHigh() ^ true;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    private final byte[] s2b(String s) throws SQLException {
        if (s == null) {
            return null;
        }
        if (this.conn != null && this.conn.getUseUnicode()) {
            try {
                String encoding = this.conn.getEncoding();
                if (encoding == null) {
                    return s.getBytes();
                }
                SingleByteCharsetConverter converter = this.conn.getCharsetConverter(encoding);
                if (converter != null) {
                    return converter.toBytes(s);
                }
                return s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException E) {
                return s.getBytes();
            }
        }
        return s.getBytes();
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.conn.lowerCaseTableNames() ^ true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.conn.lowerCaseTableNames() ^ true;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.conn.lowerCaseTableNames() ^ true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.conn.lowerCaseTableNames() ^ true;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.conn.versionMeetsMinimum(3, 22, 0);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 1111: {
                        return true;
                    }
                }
                return false;
            }
            case -7: {
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return false;
            }
            case 1111: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.conn.versionMeetsMinimum(4, 1, 0);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.conn.lowerCaseTableNames() ^ true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.conn.lowerCaseTableNames() ^ true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        switch (type) {
            case 1004: {
                if (concurrency == 1007 || concurrency == 1008) {
                    return true;
                }
                throw new SQLException("Illegal arguments to supportsResultSetConcurrency()", "S1009");
            }
            case 1003: {
                if (concurrency == 1007 || concurrency == 1008) {
                    return true;
                }
                throw new SQLException("Illegal arguments to supportsResultSetConcurrency()", "S1009");
            }
            case 1005: {
                return false;
            }
        }
        throw new SQLException("Illegal arguments to supportsResultSetConcurrency()", "S1009");
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        boolean bl = false;
        if (holdability == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        boolean bl = false;
        if (type == 1004) {
            bl = true;
        }
        return bl;
    }

    public boolean supportsSavepoints() throws SQLException {
        boolean bl = false;
        if (this.conn.versionMeetsMinimum(4, 0, 14) || this.conn.versionMeetsMinimum(4, 1, 1)) {
            bl = true;
        }
        return bl;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return this.conn.versionMeetsMinimum(4, 0, 0);
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return this.conn.versionMeetsMinimum(5, 0, 0);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.conn.versionMeetsMinimum(4, 1, 0);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.conn.versionMeetsMinimum(4, 1, 0);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.conn.versionMeetsMinimum(4, 1, 0);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.conn.versionMeetsMinimum(4, 1, 0);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (this.conn.supportsIsolationLevel()) {
            switch (level) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean supportsTransactions() throws SQLException {
        return this.conn.supportsTransactions();
    }

    public boolean supportsUnion() throws SQLException {
        return this.conn.versionMeetsMinimum(4, 0, 0);
    }

    public boolean supportsUnionAll() throws SQLException {
        return this.conn.versionMeetsMinimum(4, 0, 0);
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    private final String removeQuotedId(String s) {
        if (s == null) {
            return null;
        }
        if (this.quotedId.equals("")) {
            return s;
        }
        s = s.trim();
        int frontOffset = 0;
        int backOffset = s.length();
        int quoteLength = this.quotedId.length();
        if (s.startsWith(this.quotedId)) {
            frontOffset = quoteLength;
        }
        if (s.endsWith(this.quotedId)) {
            backOffset -= quoteLength;
        }
        return s.substring(frontOffset, backOffset);
    }

    static /* synthetic */ String access$0(DatabaseMetaData databaseMetaData) {
        return databaseMetaData.quotedId;
    }

    static final /* synthetic */ byte[] access$1(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        return databaseMetaData.s2b(string);
    }

    static final /* synthetic */ String access$2(DatabaseMetaData databaseMetaData, String string) {
        return databaseMetaData.getTableNameWithCase(string);
    }

    static /* synthetic */ String access$3() {
        return SUPPORTS_FK;
    }

    static final /* synthetic */ LocalAndReferencedColumns access$4(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        return databaseMetaData.parseTableStatusIntoLocalAndReferencedColumns(string);
    }

    static final /* synthetic */ String access$5(DatabaseMetaData databaseMetaData, String string) {
        return databaseMetaData.removeQuotedId(string);
    }

    static final /* synthetic */ int[] access$6(DatabaseMetaData databaseMetaData, String string) {
        return databaseMetaData.getForeignKeyActions(string);
    }

    static final /* synthetic */ void access$7(DatabaseMetaData databaseMetaData, String string, String string2, String string3, List list, String string4) throws SQLException {
        databaseMetaData.getExportKeyResults(string, string2, string3, list, string4);
    }

    static final /* synthetic */ void access$8(DatabaseMetaData databaseMetaData, String string, String string2, String string3, List list) throws SQLException {
        databaseMetaData.getImportKeyResults(string, string2, string3, list);
    }

    static final /* synthetic */ void access$9(DatabaseMetaData databaseMetaData, boolean bl, String string, java.sql.ResultSet resultSet, boolean bl2, String string2, Map map, int n) throws SQLException {
        databaseMetaData.convertToJdbcProcedureList(bl, string, resultSet, bl2, string2, map, n);
    }

    static final /* synthetic */ void access$10(DatabaseMetaData databaseMetaData, String string, java.sql.ResultSet resultSet, boolean bl, String string2, Map map, int n) throws SQLException {
        databaseMetaData.convertToJdbcFunctionList(string, resultSet, bl, string2, map, n);
    }

    static /* synthetic */ byte[] access$11() {
        return TABLE_AS_BYTES;
    }

    static /* synthetic */ byte[] access$12() {
        return VIEW_AS_BYTES;
    }

    private final /* synthetic */ void this() {
        this.database = null;
        this.quotedId = null;
    }

    public DatabaseMetaData(Connection connToSet, String databaseToSet) {
        this.this();
        this.conn = connToSet;
        this.database = databaseToSet;
        try {
            this.quotedId = this.conn.supportsQuotedIdentifiers() ? this.getIdentifierQuoteString() : "";
        }
        catch (SQLException sqlEx) {
            AssertionFailedException.shouldNotHappen(sqlEx);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TypeDescriptor {
        int bufferLength;
        int charOctetLength;
        int columnSize;
        short dataType;
        int decimalDigits;
        String isNullable;
        int nullability;
        int numPrecRadix;
        String typeName;

        private final /* synthetic */ void this() {
            this.numPrecRadix = 10;
        }

        TypeDescriptor(String typeInfo, String nullabilityInfo) throws SQLException {
            this.this();
            String mysqlType = "";
            String fullMysqlType = null;
            mysqlType = typeInfo.indexOf("(") != -1 ? typeInfo.substring(0, typeInfo.indexOf("(")) : typeInfo;
            int indexOfUnsignedInMysqlType = StringUtils.indexOfIgnoreCase(mysqlType, "unsigned");
            if (indexOfUnsignedInMysqlType != -1) {
                mysqlType = mysqlType.substring(0, indexOfUnsignedInMysqlType - 1);
            }
            fullMysqlType = StringUtils.indexOfIgnoreCase(typeInfo, "unsigned") != -1 ? mysqlType + " unsigned" : mysqlType;
            if (DatabaseMetaData.this.conn.getCapitalizeTypeNames()) {
                fullMysqlType = fullMysqlType.toUpperCase(Locale.ENGLISH);
            }
            this.dataType = (short)MysqlDefs.mysqlToJavaType(mysqlType);
            this.typeName = fullMysqlType;
            if (typeInfo != null) {
                if (StringUtils.startsWithIgnoreCase(typeInfo, "enum") || StringUtils.startsWithIgnoreCase(typeInfo, "set")) {
                    String temp = typeInfo.substring(typeInfo.indexOf("("), typeInfo.lastIndexOf(")"));
                    StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                    int maxLength = 0;
                    while (tokenizer.hasMoreTokens()) {
                        maxLength = Math.max(maxLength, tokenizer.nextToken().length() - 2);
                    }
                    this.columnSize = maxLength;
                    this.decimalDigits = 0;
                } else if (typeInfo.indexOf(",") != -1) {
                    this.columnSize = Integer.parseInt(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(",")));
                    this.decimalDigits = Integer.parseInt(typeInfo.substring(typeInfo.indexOf(",") + 1, typeInfo.indexOf(")")));
                } else {
                    this.columnSize = 0;
                    if (typeInfo.indexOf("(") != -1) {
                        int endParenIndex = typeInfo.indexOf(")");
                        if (endParenIndex == -1) {
                            endParenIndex = typeInfo.length();
                        }
                        this.columnSize = Integer.parseInt(typeInfo.substring(typeInfo.indexOf("(") + 1, endParenIndex));
                        if (DatabaseMetaData.this.conn.getTinyInt1isBit() && this.columnSize == 1 && StringUtils.startsWithIgnoreCase(typeInfo, 0, "tinyint")) {
                            if (DatabaseMetaData.this.conn.getTransformedBitIsBoolean()) {
                                this.dataType = (short)16;
                                this.typeName = "BOOLEAN";
                            } else {
                                this.dataType = (short)-7;
                                this.typeName = "BIT";
                            }
                        }
                    } else if (typeInfo.equalsIgnoreCase("tinyint")) {
                        this.columnSize = 1;
                    } else if (typeInfo.equalsIgnoreCase("smallint")) {
                        this.columnSize = 6;
                    } else if (typeInfo.equalsIgnoreCase("mediumint")) {
                        this.columnSize = 6;
                    } else if (typeInfo.equalsIgnoreCase("int")) {
                        this.columnSize = 11;
                    } else if (typeInfo.equalsIgnoreCase("integer")) {
                        this.columnSize = 11;
                    } else if (typeInfo.equalsIgnoreCase("bigint")) {
                        this.columnSize = 25;
                    } else if (typeInfo.equalsIgnoreCase("int24")) {
                        this.columnSize = 25;
                    } else if (typeInfo.equalsIgnoreCase("real")) {
                        this.columnSize = 12;
                    } else if (typeInfo.equalsIgnoreCase("float")) {
                        this.columnSize = 12;
                    } else if (typeInfo.equalsIgnoreCase("decimal")) {
                        this.columnSize = 12;
                    } else if (typeInfo.equalsIgnoreCase("numeric")) {
                        this.columnSize = 12;
                    } else if (typeInfo.equalsIgnoreCase("double")) {
                        this.columnSize = 22;
                    } else if (typeInfo.equalsIgnoreCase("char")) {
                        this.columnSize = 1;
                    } else if (typeInfo.equalsIgnoreCase("varchar")) {
                        this.columnSize = 255;
                    } else if (typeInfo.equalsIgnoreCase("date")) {
                        this.columnSize = 10;
                    } else if (typeInfo.equalsIgnoreCase("time")) {
                        this.columnSize = 8;
                    } else if (typeInfo.equalsIgnoreCase("timestamp")) {
                        this.columnSize = 19;
                    } else if (typeInfo.equalsIgnoreCase("datetime")) {
                        this.columnSize = 19;
                    } else if (typeInfo.equalsIgnoreCase("tinyblob")) {
                        this.columnSize = 255;
                    } else if (typeInfo.equalsIgnoreCase("blob")) {
                        this.columnSize = (char)-1;
                    } else if (typeInfo.equalsIgnoreCase("mediumblob")) {
                        this.columnSize = 16277215;
                    } else if (typeInfo.equalsIgnoreCase("longblob")) {
                        this.columnSize = Integer.MAX_VALUE;
                    } else if (typeInfo.equalsIgnoreCase("tinytext")) {
                        this.columnSize = 255;
                    } else if (typeInfo.equalsIgnoreCase("text")) {
                        this.columnSize = (char)-1;
                    } else if (typeInfo.equalsIgnoreCase("mediumtext")) {
                        this.columnSize = 16277215;
                    } else if (typeInfo.equalsIgnoreCase("longtext")) {
                        this.columnSize = Integer.MAX_VALUE;
                    } else if (typeInfo.equalsIgnoreCase("enum")) {
                        this.columnSize = 255;
                    } else if (typeInfo.equalsIgnoreCase("set")) {
                        this.columnSize = 255;
                    }
                    this.decimalDigits = 0;
                }
            } else {
                this.decimalDigits = 0;
                this.columnSize = 0;
            }
            this.bufferLength = MysqlIO.getMaxBuf();
            this.numPrecRadix = 10;
            if (nullabilityInfo != null) {
                if (nullabilityInfo.equals("YES")) {
                    this.nullability = 1;
                    this.isNullable = "YES";
                } else {
                    this.nullability = 0;
                    this.isNullable = "NO";
                }
            } else {
                this.nullability = 0;
                this.isNullable = "NO";
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class SingleStringIterator
    extends IteratorWithCleanup {
        boolean onFirst;
        String value;

        void close() throws SQLException {
        }

        boolean hasNext() throws SQLException {
            return this.onFirst;
        }

        Object next() throws SQLException {
            this.onFirst = false;
            return this.value;
        }

        private final /* synthetic */ void this() {
            this.onFirst = true;
        }

        SingleStringIterator(String s) {
            this.this();
            this.value = s;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ResultSetIterator
    extends IteratorWithCleanup {
        int colIndex;
        java.sql.ResultSet resultSet;

        void close() throws SQLException {
            this.resultSet.close();
        }

        boolean hasNext() throws SQLException {
            return this.resultSet.next();
        }

        Object next() throws SQLException {
            return this.resultSet.getObject(this.colIndex);
        }

        ResultSetIterator(java.sql.ResultSet rs, int index) {
            this.resultSet = rs;
            this.colIndex = index;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LocalAndReferencedColumns {
        List localColumnsList;
        List referencedColumnsList;
        String constraintName;
        String referencedTable;
        String referencedCatalog;

        LocalAndReferencedColumns(List localColumns, List refColumns, String constName, String refCatalog, String refTable) {
            this.localColumnsList = localColumns;
            this.referencedColumnsList = refColumns;
            this.constraintName = constName;
            this.referencedTable = refTable;
            this.referencedCatalog = refCatalog;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class IteratorWithCleanup {
        abstract void close() throws SQLException;

        abstract boolean hasNext() throws SQLException;

        abstract Object next() throws SQLException;

        protected IteratorWithCleanup() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class IterateBlock {
        IteratorWithCleanup iterator;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doForAll() throws SQLException {
            try {
                while (this.iterator.hasNext()) {
                    this.forEach(this.iterator.next());
                }
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.iterator.close();
                throw throwable;
            }
            {
                Object var2_3 = null;
            }
            this.iterator.close();
        }

        abstract void forEach(Object var1) throws SQLException;

        IterateBlock(IteratorWithCleanup i) {
            this.iterator = i;
        }
    }
}

