/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlDefs;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Field {
    private static final int AUTO_INCREMENT_FLAG = 512;
    private static final int NO_CHARSET_INFO = -1;
    private byte[] buffer;
    private int charsetIndex;
    private String charsetName;
    private int colDecimals;
    private short colFlag;
    private String collationName;
    private Connection connection;
    private String databaseName;
    private int databaseNameLength;
    private int databaseNameStart;
    private int defaultValueLength;
    private int defaultValueStart;
    private String fullName;
    private String fullOriginalName;
    private boolean isImplicitTempTable;
    private long length;
    private int mysqlType;
    private String name;
    private int nameLength;
    private int nameStart;
    private String originalColumnName;
    private int originalColumnNameLength;
    private int originalColumnNameStart;
    private String originalTableName;
    private int originalTableNameLength;
    private int originalTableNameStart;
    private int precisionAdjustFactor;
    private int sqlType;
    private String tableName;
    private int tableNameLength;
    private int tableNameStart;
    private boolean useOldNameMetadata;

    private final void checkForImplicitTemporaryTable() {
        boolean bl = false;
        if (this.tableNameLength > 5 && this.buffer[this.tableNameStart] == 35 && this.buffer[this.tableNameStart + 1] == 115 && this.buffer[this.tableNameStart + 2] == 113 && this.buffer[this.tableNameStart + 3] == 108 && this.buffer[this.tableNameStart + 4] == 95) {
            bl = true;
        }
        this.isImplicitTempTable = bl;
    }

    public String getCharacterSet() {
        return this.charsetName;
    }

    /*
     * Exception decompiling
     */
    public synchronized String getCollation() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 309->312)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getColumnLabel() throws SQLException {
        return this.getName();
    }

    public String getDatabaseName() throws SQLException {
        if (this.databaseName == null && this.databaseNameStart != -1 && this.databaseNameLength != -1) {
            this.databaseName = this.getStringFromBytes(this.databaseNameStart, this.databaseNameLength);
        }
        return this.databaseName;
    }

    int getDecimals() {
        return this.colDecimals;
    }

    public String getFullName() throws SQLException {
        if (this.fullName == null) {
            StringBuffer fullNameBuf = new StringBuffer(this.getTableName().length() + 1 + this.getName().length());
            fullNameBuf.append(this.tableName);
            fullNameBuf.append('.');
            fullNameBuf.append(this.name);
            this.fullName = fullNameBuf.toString();
            Object var1_1 = null;
        }
        return this.fullName;
    }

    public String getFullOriginalName() throws SQLException {
        this.getOriginalName();
        if (this.originalColumnName == null) {
            return null;
        }
        if (this.fullName == null) {
            StringBuffer fullOriginalNameBuf = new StringBuffer(this.getOriginalTableName().length() + 1 + this.getOriginalName().length());
            fullOriginalNameBuf.append(this.originalTableName);
            fullOriginalNameBuf.append('.');
            fullOriginalNameBuf.append(this.originalColumnName);
            this.fullOriginalName = fullOriginalNameBuf.toString();
            Object var1_1 = null;
        }
        return this.fullOriginalName;
    }

    public long getLength() {
        return this.length;
    }

    public int getMaxBytesPerCharacter() throws SQLException {
        return this.connection.getMaxBytesPerChar(this.getCharacterSet());
    }

    public int getMysqlType() {
        return this.mysqlType;
    }

    public String getName() throws SQLException {
        if (this.name == null) {
            this.name = this.getStringFromBytes(this.nameStart, this.nameLength);
        }
        return this.name;
    }

    public String getNameNoAliases() throws SQLException {
        if (this.useOldNameMetadata) {
            return this.getName();
        }
        if (this.connection != null && this.connection.versionMeetsMinimum(4, 1, 0)) {
            return this.getOriginalName();
        }
        return this.getName();
    }

    public String getOriginalName() throws SQLException {
        if (this.originalColumnName == null && this.originalColumnNameStart != -1 && this.originalColumnNameLength != -1) {
            this.originalColumnName = this.getStringFromBytes(this.originalColumnNameStart, this.originalColumnNameLength);
        }
        return this.originalColumnName;
    }

    public String getOriginalTableName() throws SQLException {
        if (this.originalTableName == null && this.originalTableNameStart != -1 && this.originalTableNameLength != -1) {
            this.originalTableName = this.getStringFromBytes(this.originalTableNameStart, this.originalTableNameLength);
        }
        return this.originalTableName;
    }

    public int getPrecisionAdjustFactor() {
        return this.precisionAdjustFactor;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    private final String getStringFromBytes(int stringStart, int stringLength) throws SQLException {
        if (stringStart == -1 || stringLength == -1) {
            return null;
        }
        String stringVal = null;
        if (this.connection != null) {
            if (this.connection.getUseUnicode()) {
                String encoding = this.connection.getCharacterSetMetadata();
                if (encoding == null) {
                    encoding = this.connection.getEncoding();
                }
                if (encoding != null) {
                    SingleByteCharsetConverter converter = null;
                    if (this.connection != null) {
                        converter = this.connection.getCharsetConverter(encoding);
                    }
                    if (converter != null) {
                        stringVal = converter.toString(this.buffer, stringStart, stringLength);
                    } else {
                        byte[] stringBytes = new byte[stringLength];
                        int endIndex = stringStart + stringLength;
                        int pos = 0;
                        int i = stringStart;
                        while (i < endIndex) {
                            stringBytes[pos++] = this.buffer[i];
                            ++i;
                        }
                        try {
                            stringVal = new String(stringBytes, encoding);
                        }
                        catch (UnsupportedEncodingException ue) {
                            throw new RuntimeException(Messages.getString("Field.12") + encoding + Messages.getString("Field.13"));
                        }
                    }
                } else {
                    stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
                }
            } else {
                stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
            }
        } else {
            stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
        }
        return stringVal;
    }

    public String getTable() throws SQLException {
        return this.getTableName();
    }

    public String getTableName() throws SQLException {
        if (this.tableName == null) {
            this.tableName = this.getStringFromBytes(this.tableNameStart, this.tableNameLength);
        }
        return this.tableName;
    }

    public String getTableNameNoAliases() throws SQLException {
        if (this.connection.versionMeetsMinimum(4, 1, 0)) {
            return this.getOriginalTableName();
        }
        return this.getTableName();
    }

    public boolean isAutoIncrement() {
        boolean bl = false;
        if ((this.colFlag & 0x200) > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isBinary() {
        boolean bl = false;
        if ((this.colFlag & 0x80) > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isBlob() {
        boolean bl = false;
        if ((this.colFlag & 0x10) > 0) {
            bl = true;
        }
        return bl;
    }

    private final boolean isImplicitTemporaryTable() {
        return this.isImplicitTempTable;
    }

    public boolean isMultipleKey() {
        boolean bl = false;
        if ((this.colFlag & 8) > 0) {
            bl = true;
        }
        return bl;
    }

    boolean isNotNull() {
        boolean bl = false;
        if ((this.colFlag & 1) > 0) {
            bl = true;
        }
        return bl;
    }

    boolean isOpaqueBinary() throws SQLException {
        if (this.charsetIndex == 63 && this.isBinary() && (this.getMysqlType() == 254 || this.getMysqlType() == 253)) {
            if (this.originalTableNameLength == 0) {
                return false;
            }
            return this.isImplicitTemporaryTable() ^ true;
        }
        boolean bl = false;
        if (this.connection.versionMeetsMinimum(4, 1, 0) && "binary".equalsIgnoreCase(this.getCharacterSet())) {
            bl = true;
        }
        return bl;
    }

    public boolean isPrimaryKey() {
        boolean bl = false;
        if ((this.colFlag & 2) > 0) {
            bl = true;
        }
        return bl;
    }

    boolean isReadOnly() throws SQLException {
        if (this.connection.versionMeetsMinimum(4, 1, 0)) {
            String orgColumnName = this.getOriginalName();
            String orgTableName = this.getOriginalTableName();
            boolean bl = false;
            if (orgColumnName != null && orgColumnName.length() > 0 && orgTableName != null && orgTableName.length() > 0) {
                bl = true;
            }
            return bl ^ true;
        }
        return false;
    }

    public boolean isUniqueKey() {
        boolean bl = false;
        if ((this.colFlag & 4) > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isUnsigned() {
        boolean bl = false;
        if ((this.colFlag & 0x20) > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isZeroFill() {
        boolean bl = false;
        if ((this.colFlag & 0x40) > 0) {
            bl = true;
        }
        return bl;
    }

    private final void setBlobTypeBasedOnLength() {
        if (this.length == 255L) {
            this.mysqlType = 249;
        } else if (this.length == 65535L) {
            this.mysqlType = 252;
        } else if (this.length == 0xFFFFFFL) {
            this.mysqlType = 250;
        } else if (this.length == 0xFFFFFFFFL) {
            this.mysqlType = 251;
        }
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
        this.charsetName = this.connection.getEncoding();
    }

    void setMysqlType(int type) {
        this.mysqlType = type;
        this.sqlType = MysqlDefs.mysqlToJavaType(this.mysqlType);
    }

    protected void setUseOldNameMetadata(boolean useOldNameMetadata) {
        this.useOldNameMetadata = useOldNameMetadata;
    }

    public String toString() {
        try {
            return this.getDatabaseName() + " . " + this.getTableName() + '(' + this.getOriginalTableName() + ") . " + this.getName() + '(' + this.getOriginalName() + "), Mysql type: " + this.getMysqlType();
        }
        catch (SQLException sqlEx) {
            return super.toString();
        }
    }

    private final /* synthetic */ void this() {
        this.charsetIndex = 0;
        this.charsetName = null;
        this.collationName = null;
        this.connection = null;
        this.databaseName = null;
        this.databaseNameLength = -1;
        this.databaseNameStart = -1;
        this.defaultValueLength = -1;
        this.defaultValueStart = -1;
        this.fullName = null;
        this.fullOriginalName = null;
        this.isImplicitTempTable = false;
        this.mysqlType = -1;
        this.originalColumnName = null;
        this.originalColumnNameLength = -1;
        this.originalColumnNameStart = -1;
        this.originalTableName = null;
        this.originalTableNameLength = -1;
        this.originalTableNameStart = -1;
        this.precisionAdjustFactor = 0;
        this.sqlType = -1;
        this.useOldNameMetadata = false;
    }

    Field(Connection conn, byte[] buffer, int databaseNameStart, int databaseNameLength, int tableNameStart, int tableNameLength, int originalTableNameStart, int originalTableNameLength, int nameStart, int nameLength, int originalColumnNameStart, int originalColumnNameLength, long length, int mysqlType, short colFlag, int colDecimals, int defaultValueStart, int defaultValueLength, int charsetIndex) throws SQLException {
        this.this();
        this.connection = conn;
        this.buffer = buffer;
        this.nameStart = nameStart;
        this.nameLength = nameLength;
        this.tableNameStart = tableNameStart;
        this.tableNameLength = tableNameLength;
        this.length = length;
        this.colFlag = colFlag;
        this.colDecimals = colDecimals;
        this.mysqlType = mysqlType;
        this.databaseNameStart = databaseNameStart;
        this.databaseNameLength = databaseNameLength;
        this.originalTableNameStart = originalTableNameStart;
        this.originalTableNameLength = originalTableNameLength;
        this.originalColumnNameStart = originalColumnNameStart;
        this.originalColumnNameLength = originalColumnNameLength;
        this.defaultValueStart = defaultValueStart;
        this.defaultValueLength = defaultValueLength;
        this.charsetIndex = charsetIndex;
        this.charsetName = this.connection.getCharsetNameForIndex(this.charsetIndex);
        this.sqlType = MysqlDefs.mysqlToJavaType(this.mysqlType);
        if (this.mysqlType == 252) {
            if (this.charsetIndex == 63 || !this.connection.versionMeetsMinimum(4, 1, 0)) {
                this.setBlobTypeBasedOnLength();
                this.sqlType = MysqlDefs.mysqlToJavaType(this.mysqlType);
            } else {
                this.mysqlType = 253;
                this.sqlType = -1;
            }
        }
        boolean isBinary = this.isBinary();
        if (this.connection.versionMeetsMinimum(4, 1, 0) && this.mysqlType == 253 && isBinary && this.charsetIndex == 63 && this.isOpaqueBinary()) {
            this.sqlType = -3;
        }
        if (this.connection.versionMeetsMinimum(4, 1, 0) && this.mysqlType == 254 && isBinary && this.charsetIndex == 63 && this.isOpaqueBinary()) {
            this.sqlType = -2;
        }
        if (this.sqlType == -6 && this.length == 1L && this.connection.getTinyInt1isBit() && conn.getTinyInt1isBit()) {
            this.sqlType = conn.getTransformedBitIsBoolean() ? 16 : -7;
        }
        if (this.mysqlType == 16) {
            if (this.length == 0L) {
                this.sqlType = -7;
            } else {
                this.sqlType = -3;
                this.colFlag = (short)(this.colFlag | 0x80);
                this.colFlag = (short)(this.colFlag | 0x10);
            }
        }
        if (this.sqlType == -4 && !isBinary) {
            this.sqlType = -1;
        } else if (this.sqlType == -3 && !isBinary) {
            this.sqlType = 12;
        }
        if (!this.isUnsigned()) {
            switch (this.mysqlType) {
                case 0: 
                case 246: {
                    this.precisionAdjustFactor = -1;
                    break;
                }
                case 4: 
                case 5: {
                    this.precisionAdjustFactor = 1;
                    break;
                }
            }
        } else {
            switch (this.mysqlType) {
                case 4: 
                case 5: {
                    this.precisionAdjustFactor = 1;
                    break;
                }
            }
        }
        this.checkForImplicitTemporaryTable();
    }

    Field(Connection conn, byte[] buffer, int nameStart, int nameLength, int tableNameStart, int tableNameLength, int length, int mysqlType, short colFlag, int colDecimals) throws SQLException {
        this(conn, buffer, -1, -1, tableNameStart, tableNameLength, -1, -1, nameStart, nameLength, -1, -1, length, mysqlType, colFlag, colDecimals, -1, -1, -1);
    }

    Field(String tableName, String columnName, int jdbcType, int length) {
        this.this();
        this.tableName = tableName;
        this.name = columnName;
        this.length = length;
        this.sqlType = jdbcType;
        this.colFlag = 0;
        this.colDecimals = 0;
    }
}

