/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SocketFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StandardSocketFactory
implements SocketFactory {
    protected String host;
    protected int port;
    protected Socket rawSocket;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$lang$String;

    public Socket afterHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket connect(String hostname, int portNumber, Properties props) throws SocketException, IOException {
        if (props != null) {
            this.host = hostname;
            this.port = portNumber;
            boolean hasConnectTimeoutMethod = false;
            Method connectWithTimeoutMethod = null;
            try {
                Class<?> socketAddressClass = Class.forName("java.net.SocketAddress");
                Class clazz = class$java$net$Socket;
                if (clazz == null) {
                    clazz = class$java$net$Socket = StandardSocketFactory.class("[Ljava.net.Socket;", false);
                }
                connectWithTimeoutMethod = clazz.getMethod("connect", socketAddressClass, Integer.TYPE);
                hasConnectTimeoutMethod = true;
            }
            catch (NoClassDefFoundError noClassDefFound) {
                hasConnectTimeoutMethod = false;
            }
            catch (NoSuchMethodException noSuchMethodEx) {
                hasConnectTimeoutMethod = false;
            }
            catch (Throwable catchAll) {
                hasConnectTimeoutMethod = false;
            }
            int connectTimeout = 0;
            String connectTimeoutStr = props.getProperty("connectTimeout");
            if (connectTimeoutStr != null) {
                try {
                    connectTimeout = Integer.parseInt(connectTimeoutStr);
                }
                catch (NumberFormatException nfe) {
                    throw new SocketException("Illegal value '" + connectTimeoutStr + "' for connectTimeout");
                }
            }
            if (this.host != null) {
                if (!hasConnectTimeoutMethod || connectTimeout == 0) {
                    InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
                    Exception caughtWhileConnecting = null;
                    int i = 0;
                    while (i < possibleAddresses.length) {
                        try {
                            this.rawSocket = new Socket(possibleAddresses[i], this.port);
                            break;
                        }
                        catch (Exception ex) {
                            caughtWhileConnecting = ex;
                            ++i;
                        }
                    }
                    if (this.rawSocket == null) {
                        throw new SocketException(caughtWhileConnecting.toString());
                    }
                } else {
                    try {
                        Class<?> inetSocketAddressClass = Class.forName("java.net.InetSocketAddress");
                        Class[] classArray = new Class[2];
                        Class clazz = class$java$lang$String;
                        if (clazz == null) {
                            clazz = class$java$lang$String = StandardSocketFactory.class("[Ljava.lang.String;", false);
                        }
                        classArray[0] = clazz;
                        classArray[1] = Integer.TYPE;
                        Constructor<?> addrConstructor = inetSocketAddressClass.getConstructor(classArray);
                        InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
                        Throwable caughtWhileConnecting = null;
                        int i = 0;
                        while (i < possibleAddresses.length) {
                            try {
                                Object sockAddr = addrConstructor.newInstance(this.host, new Integer(this.port));
                                this.rawSocket = new Socket();
                                connectWithTimeoutMethod.invoke((Object)this.rawSocket, sockAddr, new Integer(connectTimeout));
                                break;
                            }
                            catch (Exception ex) {
                                this.rawSocket = null;
                                caughtWhileConnecting = ex;
                                ++i;
                            }
                        }
                        if (this.rawSocket == null) {
                            throw new SocketException(caughtWhileConnecting.toString());
                        }
                    }
                    catch (Throwable t) {
                        if (!(t instanceof SocketException)) {
                            throw new SocketException(t.toString());
                        }
                        throw (SocketException)t;
                    }
                }
                try {
                    this.rawSocket.setTcpNoDelay(true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return this.rawSocket;
            }
        }
        throw new SocketException("Unable to create socket");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.host = null;
        this.port = 3306;
        this.rawSocket = null;
    }

    public StandardSocketFactory() {
        this.this();
    }
}

