/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SingleByteCharsetConverter;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StringUtils {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes = new byte[256];
    private static char[] byteToChars = new char[256];
    private static Method toPlainStringMethod;
    static final int WILD_COMPARE_MATCH_NO_WILD = 0;
    static final int WILD_COMPARE_MATCH_WITH_WILD = 1;
    static final int WILD_COMPARE_NO_MATCH = -1;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public static String consistentToString(BigDecimal decimal) {
        if (decimal == null) {
            return null;
        }
        if (toPlainStringMethod != null) {
            try {
                return (String)toPlainStringMethod.invoke((Object)decimal, null);
            }
            catch (InvocationTargetException invokeEx) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return decimal.toString();
    }

    public static final String dumpAsHex(byte[] byteBuffer, int length) {
        StringBuffer outputBuf = new StringBuffer(length * 4);
        int p = 0;
        int rows = length / 8;
        int i = 0;
        while (i < rows && p < length) {
            int ptemp = p;
            int j = 0;
            while (j < 8) {
                String hexVal = Integer.toHexString(byteBuffer[ptemp] & 0xFF);
                if (hexVal.length() == 1) {
                    hexVal = "0" + hexVal;
                }
                outputBuf.append(hexVal + ' ');
                ++ptemp;
                ++j;
            }
            outputBuf.append("    ");
            j = 0;
            while (j < 8) {
                if (byteBuffer[p] > 32 && byteBuffer[p] < 127) {
                    outputBuf.append("" + (char)byteBuffer[p] + ' ');
                } else {
                    outputBuf.append(". ");
                }
                ++p;
                ++j;
            }
            outputBuf.append("\n");
            ++i;
        }
        int n = 0;
        int i2 = p;
        while (i2 < length) {
            String hexVal = Integer.toHexString(byteBuffer[i2] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            outputBuf.append(hexVal + ' ');
            ++n;
            ++i2;
        }
        i2 = n;
        while (i2 < 8) {
            outputBuf.append("   ");
            ++i2;
        }
        outputBuf.append("    ");
        i2 = p;
        while (i2 < length) {
            if (byteBuffer[i2] > 32 && byteBuffer[i2] < 127) {
                outputBuf.append("" + (char)byteBuffer[i2] + ' ');
            } else {
                outputBuf.append(". ");
            }
            ++i2;
        }
        outputBuf.append("\n");
        return outputBuf.toString();
    }

    private static final boolean endsWith(byte[] dataFrom, String suffix) {
        int i = 1;
        while (i <= suffix.length()) {
            int dfOffset = dataFrom.length - i;
            int suffixOffset = suffix.length() - i;
            if (dataFrom[dfOffset] != suffix.charAt(suffixOffset)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] escapeEasternUnicodeByteStream(byte[] origBytes, String origString, int offset, int length) {
        if (origBytes == null || origBytes.length == 0) {
            return origBytes;
        }
        int bytesLen = origBytes.length;
        int bufIndex = 0;
        int strIndex = 0;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(bytesLen);
        while (true) {
            if (origString.charAt(strIndex) == '\\') {
                bytesOut.write(origBytes[bufIndex++]);
            } else {
                int hiByte;
                int loByte = origBytes[bufIndex];
                if (loByte < 0) {
                    loByte += 256;
                }
                bytesOut.write(loByte);
                if (loByte >= 128) {
                    if (bufIndex < bytesLen - 1) {
                        hiByte = origBytes[bufIndex + 1];
                        if (hiByte < 0) {
                            hiByte += 256;
                        }
                        bytesOut.write(hiByte);
                        ++bufIndex;
                        if (hiByte == 92) {
                            bytesOut.write(hiByte);
                        }
                    }
                } else if (loByte == 92 && bufIndex < bytesLen - 1) {
                    hiByte = origBytes[bufIndex + 1];
                    if (hiByte < 0) {
                        hiByte += 256;
                    }
                    if (hiByte == 98) {
                        bytesOut.write(92);
                        bytesOut.write(98);
                        ++bufIndex;
                    }
                }
                ++bufIndex;
            }
            if (bufIndex >= bytesLen) break;
            ++strIndex;
        }
        return bytesOut.toByteArray();
    }

    public static char firstNonWsCharUc(String searchIn) {
        if (searchIn == null) {
            return '\u0000';
        }
        int length = searchIn.length();
        int i = 0;
        while (i < length) {
            char c = searchIn.charAt(i);
            if (!Character.isWhitespace(c)) {
                return Character.toUpperCase(c);
            }
            ++i;
        }
        return '\u0000';
    }

    public static final String fixDecimalExponent(String dString) {
        char maybeMinusChar;
        int ePos = dString.indexOf("E");
        if (ePos == -1) {
            ePos = dString.indexOf("e");
        }
        if (ePos != -1 && dString.length() > ePos + 1 && (maybeMinusChar = dString.charAt(ePos + 1)) != '-' && maybeMinusChar != '+') {
            StringBuffer buf = new StringBuffer(dString.length() + 1);
            buf.append(dString.substring(0, ePos + 1));
            buf.append('+');
            buf.append(dString.substring(ePos + 1, dString.length()));
            dString = buf.toString();
        }
        return dString;
    }

    public static final byte[] getBytes(char[] c, SingleByteCharsetConverter converter, String encoding, String serverEncoding, boolean parserKnowsUnicode) throws SQLException {
        try {
            byte[] b = null;
            if (converter != null) {
                b = converter.toBytes(c);
            } else if (encoding == null) {
                b = new String(c).getBytes();
            } else {
                String s = new String(c);
                b = s.getBytes(encoding);
                if (!parserKnowsUnicode && (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK")) && !encoding.equalsIgnoreCase(serverEncoding)) {
                    b = StringUtils.escapeEasternUnicodeByteStream(b, s, 0, s.length());
                }
            }
            return b;
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.5") + encoding + Messages.getString("StringUtils.6"), "S1009");
        }
    }

    public static final byte[] getBytes(char[] c, SingleByteCharsetConverter converter, String encoding, String serverEncoding, int offset, int length, boolean parserKnowsUnicode) throws SQLException {
        try {
            byte[] b = null;
            if (converter != null) {
                b = converter.toBytes(c, offset, length);
            } else if (encoding == null) {
                byte[] temp = new String(c, offset, length).getBytes();
                length = temp.length;
                b = new byte[length];
                System.arraycopy(temp, 0, b, 0, length);
            } else {
                String s = new String(c, offset, length);
                byte[] temp = s.getBytes(encoding);
                length = temp.length;
                b = new byte[length];
                System.arraycopy(temp, 0, b, 0, length);
                if (!parserKnowsUnicode && (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK")) && !encoding.equalsIgnoreCase(serverEncoding)) {
                    b = StringUtils.escapeEasternUnicodeByteStream(b, s, offset, length);
                }
            }
            return b;
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.10") + encoding + Messages.getString("StringUtils.11"), "S1009");
        }
    }

    public static final byte[] getBytes(char[] c, String encoding, String serverEncoding, boolean parserKnowsUnicode) throws SQLException {
        try {
            SingleByteCharsetConverter converter = SingleByteCharsetConverter.getInstance(encoding, null);
            return StringUtils.getBytes(c, converter, encoding, serverEncoding, parserKnowsUnicode);
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.0") + encoding + Messages.getString("StringUtils.1"), "S1009");
        }
    }

    public static final byte[] getBytes(String s, SingleByteCharsetConverter converter, String encoding, String serverEncoding, boolean parserKnowsUnicode) throws SQLException {
        try {
            byte[] b = null;
            if (converter != null) {
                b = converter.toBytes(s);
            } else if (encoding == null) {
                b = s.getBytes();
            } else {
                b = s.getBytes(encoding);
                if (!parserKnowsUnicode && (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK")) && !encoding.equalsIgnoreCase(serverEncoding)) {
                    b = StringUtils.escapeEasternUnicodeByteStream(b, s, 0, s.length());
                }
            }
            return b;
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.5") + encoding + Messages.getString("StringUtils.6"), "S1009");
        }
    }

    public static final byte[] getBytes(String s, SingleByteCharsetConverter converter, String encoding, String serverEncoding, int offset, int length, boolean parserKnowsUnicode) throws SQLException {
        try {
            byte[] b = null;
            if (converter != null) {
                b = converter.toBytes(s, offset, length);
            } else if (encoding == null) {
                byte[] temp = s.substring(offset, offset + length).getBytes();
                length = temp.length;
                b = new byte[length];
                System.arraycopy(temp, 0, b, 0, length);
            } else {
                byte[] temp = s.substring(offset, offset + length).getBytes(encoding);
                length = temp.length;
                b = new byte[length];
                System.arraycopy(temp, 0, b, 0, length);
                if (!parserKnowsUnicode && (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK")) && !encoding.equalsIgnoreCase(serverEncoding)) {
                    b = StringUtils.escapeEasternUnicodeByteStream(b, s, offset, length);
                }
            }
            return b;
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.10") + encoding + Messages.getString("StringUtils.11"), "S1009");
        }
    }

    public static final byte[] getBytes(String s, String encoding, String serverEncoding, boolean parserKnowsUnicode) throws SQLException {
        try {
            SingleByteCharsetConverter converter = SingleByteCharsetConverter.getInstance(encoding, null);
            return StringUtils.getBytes(s, converter, encoding, serverEncoding, parserKnowsUnicode);
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.0") + encoding + Messages.getString("StringUtils.1"), "S1009");
        }
    }

    public static int getInt(byte[] buf) throws NumberFormatException {
        char base = '\n';
        int s = 0;
        while (Character.isWhitespace((char)buf[s]) && s < buf.length) {
            ++s;
        }
        if (s == buf.length) {
            throw new NumberFormatException(new String(buf));
        }
        boolean negative = false;
        if ((char)buf[s] == '-') {
            negative = true;
            ++s;
        } else if ((char)buf[s] == '+') {
            ++s;
        }
        int save = s;
        int cutoff = Integer.MAX_VALUE / base;
        int cutlim = Integer.MAX_VALUE % base;
        if (negative) {
            ++cutlim;
        }
        boolean overflow = false;
        int i = 0;
        while (s < buf.length) {
            char c = (char)buf[s];
            if (Character.isDigit(c)) {
                c = (char)(c - 48);
            } else {
                if (!Character.isLetter(c)) break;
                c = (char)(Character.toUpperCase(c) - 65 + 10);
            }
            if (c >= base) break;
            if (i > cutoff || i == cutoff && c > cutlim) {
                overflow = true;
            } else {
                i *= base;
                i += c;
            }
            ++s;
        }
        if (s == save) {
            throw new NumberFormatException(new String(buf));
        }
        if (overflow) {
            throw new NumberFormatException(new String(buf));
        }
        return negative ? -i : i;
    }

    public static long getLong(byte[] buf) throws NumberFormatException {
        char base = '\n';
        int s = 0;
        while (Character.isWhitespace((char)buf[s]) && s < buf.length) {
            ++s;
        }
        if (s == buf.length) {
            throw new NumberFormatException(new String(buf));
        }
        boolean negative = false;
        if ((char)buf[s] == '-') {
            negative = true;
            ++s;
        } else if ((char)buf[s] == '+') {
            ++s;
        }
        int save = s;
        long cutoff = Long.MAX_VALUE / (long)base;
        long cutlim = (int)(Long.MAX_VALUE % (long)base);
        if (negative) {
            ++cutlim;
        }
        boolean overflow = false;
        long i = 0L;
        while (s < buf.length) {
            char c = (char)buf[s];
            if (Character.isDigit(c)) {
                c = (char)(c - 48);
            } else {
                if (!Character.isLetter(c)) break;
                c = (char)(Character.toUpperCase(c) - 65 + 10);
            }
            if (c >= base) break;
            if (i > cutoff || i == cutoff && (long)c > cutlim) {
                overflow = true;
            } else {
                i *= (long)base;
                i += (long)c;
            }
            ++s;
        }
        if (s == save) {
            throw new NumberFormatException(new String(buf));
        }
        if (overflow) {
            throw new NumberFormatException(new String(buf));
        }
        return negative ? -i : i;
    }

    public static short getShort(byte[] buf) throws NumberFormatException {
        char base = '\n';
        int s = 0;
        while (Character.isWhitespace((char)buf[s]) && s < buf.length) {
            ++s;
        }
        if (s == buf.length) {
            throw new NumberFormatException(new String(buf));
        }
        boolean negative = false;
        if ((char)buf[s] == '-') {
            negative = true;
            ++s;
        } else if ((char)buf[s] == '+') {
            ++s;
        }
        int save = s;
        short cutoff = (short)(Short.MAX_VALUE / base);
        short cutlim = (short)(Short.MAX_VALUE % base);
        if (negative) {
            cutlim = (short)(cutlim + 1);
        }
        boolean overflow = false;
        short i = 0;
        while (s < buf.length) {
            char c = (char)buf[s];
            if (Character.isDigit(c)) {
                c = (char)(c - 48);
            } else {
                if (!Character.isLetter(c)) break;
                c = (char)(Character.toUpperCase(c) - 65 + 10);
            }
            if (c >= base) break;
            if (i > cutoff || i == cutoff && c > cutlim) {
                overflow = true;
            } else {
                i = (short)(i * base);
                i = (short)(i + c);
            }
            ++s;
        }
        if (s == save) {
            throw new NumberFormatException(new String(buf));
        }
        if (overflow) {
            throw new NumberFormatException(new String(buf));
        }
        return negative ? (short)(-i) : i;
    }

    public static final int indexOfIgnoreCase(int startingPosition, String searchIn, String searchFor) {
        if (searchIn == null || searchFor == null || startingPosition > searchIn.length()) {
            return -1;
        }
        int patternLength = searchFor.length();
        int stringLength = searchIn.length();
        int stopSearchingAt = stringLength - patternLength;
        int i = startingPosition;
        if (patternLength == 0) {
            return -1;
        }
        char firstCharOfPatternUc = Character.toUpperCase(searchFor.charAt(0));
        char firstCharOfPatternLc = Character.toLowerCase(searchFor.charAt(0));
        block0: while (true) {
            if (i < stopSearchingAt && Character.toUpperCase(searchIn.charAt(i)) != firstCharOfPatternUc && Character.toLowerCase(searchIn.charAt(i)) != firstCharOfPatternLc) {
                ++i;
                continue;
            }
            if (i > stopSearchingAt) {
                return -1;
            }
            int j = i + 1;
            int end = j + patternLength - 1;
            int k = 1;
            while (j < end) {
                int searchInPos = j++;
                int searchForPos = k++;
                if (Character.toUpperCase(searchIn.charAt(searchInPos)) != Character.toUpperCase(searchFor.charAt(searchForPos))) {
                    ++i;
                    continue block0;
                }
                if (Character.toLowerCase(searchIn.charAt(searchInPos)) == Character.toLowerCase(searchFor.charAt(searchForPos))) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static final int indexOfIgnoreCase(String searchIn, String searchFor) {
        return StringUtils.indexOfIgnoreCase(0, searchIn, searchFor);
    }

    public static int indexOfIgnoreCaseRespectMarker(int startAt, String src, String target, String marker, String markerCloses, boolean allowBackslashEscapes) {
        char contextMarker = '\u0000';
        boolean escaped = false;
        int markerTypeFound = 0;
        int srcLength = src.length();
        int ind = 0;
        int i = startAt;
        while (i < srcLength) {
            char c = src.charAt(i);
            if (allowBackslashEscapes && c == '\\') {
                escaped ^= true;
            } else if (c == markerCloses.charAt(markerTypeFound) && !escaped) {
                contextMarker = '\u0000';
            } else {
                ind = marker.indexOf(c);
                if (ind != -1 && !escaped && contextMarker == '\u0000') {
                    markerTypeFound = ind;
                    contextMarker = c;
                } else if (c == target.charAt(0) && !escaped && contextMarker == '\u0000' && StringUtils.indexOfIgnoreCase(i, src, target) != -1) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfIgnoreCaseRespectQuotes(int startAt, String src, String target, char quoteChar, boolean allowBackslashEscapes) {
        char contextMarker = '\u0000';
        boolean escaped = false;
        int srcLength = src.length();
        int i = startAt;
        while (i < srcLength) {
            char c = src.charAt(i);
            if (allowBackslashEscapes && c == '\\') {
                escaped ^= true;
            } else if (c == contextMarker && !escaped) {
                contextMarker = '\u0000';
            } else if (c == quoteChar && !escaped && contextMarker == '\u0000') {
                contextMarker = c;
            } else if (c == target.charAt(0) && !escaped && contextMarker == '\u0000' && StringUtils.startsWithIgnoreCase(src, i, target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final List split(String stringToSplit, String delimitter, boolean trim) {
        if (stringToSplit == null) {
            return new ArrayList();
        }
        if (delimitter == null) {
            throw new IllegalArgumentException();
        }
        StringTokenizer tokenizer = new StringTokenizer(stringToSplit, delimitter, false);
        ArrayList<String> splitTokens = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (trim) {
                token = token.trim();
            }
            splitTokens.add(token);
        }
        return splitTokens;
    }

    public static final List split(String stringToSplit, String delimiter, String markers, String markerCloses, boolean trim) {
        String token;
        if (stringToSplit == null) {
            return new ArrayList();
        }
        if (delimiter == null) {
            throw new IllegalArgumentException();
        }
        int delimPos = 0;
        int currentPos = 0;
        ArrayList<String> splitTokens = new ArrayList<String>();
        while ((delimPos = StringUtils.indexOfIgnoreCaseRespectMarker(currentPos, stringToSplit, delimiter, markers, markerCloses, false)) != -1) {
            token = stringToSplit.substring(currentPos, delimPos);
            if (trim) {
                token = token.trim();
            }
            splitTokens.add(token);
            currentPos = delimPos + 1;
        }
        if (currentPos < stringToSplit.length()) {
            token = stringToSplit.substring(currentPos);
            if (trim) {
                token = token.trim();
            }
            splitTokens.add(token);
        }
        return splitTokens;
    }

    private static final boolean startsWith(byte[] dataFrom, String chars) {
        int i = 0;
        while (i < chars.length()) {
            if (dataFrom[i] != chars.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, startAt, searchFor, 0, searchFor.length());
    }

    public static boolean startsWithIgnoreCase(String searchIn, String searchFor) {
        return StringUtils.startsWithIgnoreCase(searchIn, 0, searchFor);
    }

    public static boolean startsWithIgnoreCaseAndNonAlphaNumeric(String searchIn, String searchFor) {
        if (searchIn == null) {
            boolean bl = false;
            if (searchFor == null) {
                bl = true;
            }
            return bl;
        }
        int beginPos = 0;
        int inLength = searchIn.length();
        beginPos = 0;
        while (beginPos < inLength) {
            char c = searchIn.charAt(beginPos);
            if (Character.isLetterOrDigit(c)) break;
            ++beginPos;
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        if (searchIn == null) {
            boolean bl = false;
            if (searchFor == null) {
                bl = true;
            }
            return bl;
        }
        int beginPos = 0;
        int inLength = searchIn.length();
        beginPos = 0;
        while (beginPos < inLength) {
            if (!Character.isWhitespace(searchIn.charAt(beginPos))) break;
            ++beginPos;
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static byte[] stripEnclosure(byte[] source, String prefix, String suffix) {
        if (source.length >= prefix.length() + suffix.length() && StringUtils.startsWith(source, prefix) && StringUtils.endsWith(source, suffix)) {
            int totalToStrip = prefix.length() + suffix.length();
            int enclosedLength = source.length - totalToStrip;
            byte[] enclosed = new byte[enclosedLength];
            int startPos = prefix.length();
            int numToCopy = enclosed.length;
            System.arraycopy(source, startPos, enclosed, 0, numToCopy);
            return enclosed;
        }
        return source;
    }

    public static final String toAsciiString(byte[] buffer) {
        return StringUtils.toAsciiString(buffer, 0, buffer.length);
    }

    public static final String toAsciiString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        int i = 0;
        while (i < length) {
            charArray[i] = (char)buffer[readpoint];
            ++readpoint;
            ++i;
        }
        return new String(charArray);
    }

    public static int wildCompare(String searchIn, String searchForWildcard) {
        if (searchIn == null || searchForWildcard == null) {
            return -1;
        }
        if (searchForWildcard.equals("%")) {
            return 1;
        }
        int result = -1;
        char wildcardMany = '%';
        char wildcardOne = '_';
        char wildcardEscape = '\\';
        int searchForPos = 0;
        int searchForEnd = searchForWildcard.length();
        int searchInPos = 0;
        int searchInEnd = searchIn.length();
        while (searchForPos != searchForEnd) {
            char wildstrChar = searchForWildcard.charAt(searchForPos);
            while (searchForWildcard.charAt(searchForPos) != wildcardMany && wildstrChar != wildcardOne) {
                if (searchForWildcard.charAt(searchForPos) == wildcardEscape && searchForPos + 1 != searchForEnd) {
                    ++searchForPos;
                }
                if (searchInPos == searchInEnd || Character.toUpperCase(searchForWildcard.charAt(searchForPos++)) != Character.toUpperCase(searchIn.charAt(searchInPos++))) {
                    return 1;
                }
                if (searchForPos == searchForEnd) {
                    int n = 0;
                    if (searchInPos != searchInEnd) {
                        n = 1;
                    }
                    return n;
                }
                result = 1;
            }
            if (searchForWildcard.charAt(searchForPos) == wildcardOne) {
                do {
                    if (searchInPos == searchInEnd) {
                        return result;
                    }
                    ++searchInPos;
                } while (++searchForPos < searchForEnd && searchForWildcard.charAt(searchForPos) == wildcardOne);
                if (searchForPos == searchForEnd) break;
            }
            if (searchForWildcard.charAt(searchForPos) != wildcardMany) continue;
            ++searchForPos;
            while (searchForPos != searchForEnd) {
                if (searchForWildcard.charAt(searchForPos) != wildcardMany) {
                    if (searchForWildcard.charAt(searchForPos) != wildcardOne) break;
                    if (searchInPos == searchInEnd) {
                        return -1;
                    }
                    ++searchInPos;
                }
                ++searchForPos;
            }
            if (searchForPos == searchForEnd) {
                return 0;
            }
            if (searchInPos == searchInEnd) {
                return -1;
            }
            char cmp = searchForWildcard.charAt(searchForPos);
            if (cmp == wildcardEscape && searchForPos + 1 != searchForEnd) {
                cmp = searchForWildcard.charAt(++searchForPos);
            }
            ++searchForPos;
            while (true) {
                if (searchInPos != searchInEnd && Character.toUpperCase(searchIn.charAt(searchInPos)) != Character.toUpperCase(cmp)) {
                    ++searchInPos;
                    continue;
                }
                if (searchInPos++ == searchInEnd) {
                    return -1;
                }
                int tmp = StringUtils.wildCompare(searchIn, searchForWildcard);
                if (tmp <= 0) {
                    return tmp;
                }
                if (searchInPos == searchInEnd || searchForWildcard.charAt(0) == wildcardMany) break;
            }
            return -1;
        }
        int n = 0;
        if (searchInPos != searchInEnd) {
            n = 1;
        }
        return n;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int i = -128;
        while (i <= 127) {
            StringUtils.allBytes[i - -128] = (byte)i;
            ++i;
        }
        String allBytesString = new String(allBytes, 0, 255);
        int allBytesStringLen = allBytesString.length();
        int i2 = 0;
        while (i2 < 255 && i2 < allBytesStringLen) {
            StringUtils.byteToChars[i2] = allBytesString.charAt(i2);
            ++i2;
        }
        try {
            Class clazz = class$java$math$BigDecimal;
            if (clazz == null) {
                clazz = class$java$math$BigDecimal = StringUtils.class("[Ljava.math.BigDecimal;", false);
            }
            toPlainStringMethod = clazz.getMethod("toPlainString", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

