/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.util;

import com.mysql.jdbc.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ServerController {
    public static final String BASEDIR_KEY = "basedir";
    public static final String DATADIR_KEY = "datadir";
    public static final String DEFAULTS_FILE_KEY = "defaults-file";
    public static final String EXECUTABLE_NAME_KEY = "executable";
    public static final String EXECUTABLE_PATH_KEY = "executablePath";
    private Process serverProcess;
    private Properties serverProps;
    private Properties systemProps;

    public void setBaseDir(String baseDir) {
        this.getServerProps().setProperty(BASEDIR_KEY, baseDir);
    }

    public void setDataDir(String dataDir) {
        this.getServerProps().setProperty(DATADIR_KEY, dataDir);
    }

    public Process start() throws IOException {
        if (this.serverProcess != null) {
            throw new IllegalArgumentException("Server already started");
        }
        this.serverProcess = Runtime.getRuntime().exec(this.getCommandLine());
        return this.serverProcess;
    }

    public void stop(boolean forceIfNecessary) throws IOException {
        if (this.serverProcess != null) {
            String basedir = this.getServerProps().getProperty(BASEDIR_KEY);
            StringBuffer pathBuf = new StringBuffer(basedir);
            if (!basedir.endsWith(File.separator)) {
                pathBuf.append(File.separator);
            }
            String defaultsFilePath = this.getServerProps().getProperty(DEFAULTS_FILE_KEY);
            pathBuf.append("bin");
            pathBuf.append(File.separator);
            pathBuf.append("mysqladmin shutdown");
            System.out.println(pathBuf.toString());
            Process mysqladmin = Runtime.getRuntime().exec(pathBuf.toString());
            int exitStatus = -1;
            try {
                exitStatus = mysqladmin.waitFor();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (exitStatus != 0 && forceIfNecessary) {
                this.forceStop();
            }
        }
    }

    public void forceStop() {
        if (this.serverProcess != null) {
            this.serverProcess.destroy();
            this.serverProcess = null;
        }
    }

    public synchronized Properties getServerProps() {
        if (this.serverProps == null) {
            this.serverProps = new Properties();
        }
        return this.serverProps;
    }

    private final String getCommandLine() {
        StringBuffer commandLine = new StringBuffer(this.getFullExecutablePath());
        commandLine.append(this.buildOptionalCommandLine());
        return commandLine.toString();
    }

    private final String getFullExecutablePath() {
        StringBuffer pathBuf = new StringBuffer();
        String optionalExecutablePath = this.getServerProps().getProperty(EXECUTABLE_PATH_KEY);
        if (optionalExecutablePath == null) {
            String basedir = this.getServerProps().getProperty(BASEDIR_KEY);
            pathBuf.append(basedir);
            if (!basedir.endsWith(File.separator)) {
                pathBuf.append(File.separatorChar);
            }
            if (this.runningOnWindows()) {
                pathBuf.append("bin");
            } else {
                pathBuf.append("libexec");
            }
            pathBuf.append(File.separatorChar);
        } else {
            pathBuf.append(optionalExecutablePath);
            if (!optionalExecutablePath.endsWith(File.separator)) {
                pathBuf.append(File.separatorChar);
            }
        }
        String executableName = this.getServerProps().getProperty(EXECUTABLE_NAME_KEY, "mysqld");
        pathBuf.append(executableName);
        return pathBuf.toString();
    }

    private final String buildOptionalCommandLine() {
        StringBuffer commandLineBuf = new StringBuffer();
        if (this.serverProps != null) {
            Iterator<Object> iter = this.serverProps.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = this.serverProps.getProperty(key);
                if (this.isNonCommandLineArgument(key)) continue;
                if (value != null && value.length() > 0) {
                    commandLineBuf.append(" \"");
                    commandLineBuf.append("--");
                    commandLineBuf.append(key);
                    commandLineBuf.append("=");
                    commandLineBuf.append(value);
                    commandLineBuf.append("\"");
                    continue;
                }
                commandLineBuf.append(" --");
                commandLineBuf.append(key);
            }
        }
        return commandLineBuf.toString();
    }

    private final boolean isNonCommandLineArgument(String propName) {
        boolean bl = false;
        if (propName.equals(EXECUTABLE_NAME_KEY) || propName.equals(EXECUTABLE_PATH_KEY)) {
            bl = true;
        }
        return bl;
    }

    private final synchronized Properties getSystemProperties() {
        if (this.systemProps == null) {
            this.systemProps = System.getProperties();
        }
        return this.systemProps;
    }

    private final boolean runningOnWindows() {
        boolean bl = false;
        if (StringUtils.indexOfIgnoreCase(this.getSystemProperties().getProperty("os.name"), "WINDOWS") != -1) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.serverProcess = null;
        this.serverProps = null;
        this.systemProps = null;
    }

    public ServerController(String baseDir) {
        this.this();
        this.setBaseDir(baseDir);
    }

    public ServerController(String basedir, String datadir) {
        this.this();
    }
}

