/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.util.ByteBuf;
import com.sun.jimi.core.util.LEDataInputStream;
import com.sun.jimi.util.ExpandableArray;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SeekInputStream
extends FilterInputStream
implements DataInput {
    InputStream in;
    int curOffset;
    ExpandableArray bufs;
    DataInput setD;
    InputStream setDIS;
    boolean be;
    boolean underlying;

    public SeekInputStream(boolean bl, InputStream inputStream, int n) throws IOException {
        super(inputStream);
        this.be = bl;
        this.in = inputStream;
        this.bufs = new ExpandableArray();
        this.curOffset = n;
        this.setInputStream(this.curOffset);
    }

    public int available() throws IOException {
        return this.setDIS.available();
    }

    public void close() throws IOException {
        this.setD = null;
        this.in.close();
        this.in = null;
        this.bufs = null;
        this.curOffset = 0;
    }

    protected InputStream getBufIS(int n) throws IOException {
        int n2 = 0;
        while (n2 < this.bufs.size()) {
            ByteBuf byteBuf = (ByteBuf)this.bufs.elementAt(n2);
            if (n >= byteBuf.offset && n < byteBuf.offset + byteBuf.buf.length) {
                int n3 = n - byteBuf.offset;
                return new ByteArrayInputStream(byteBuf.buf, n3, byteBuf.buf.length - n3);
            }
            ++n2;
        }
        throw new IOException("not buffered");
    }

    public synchronized void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public final synchronized int read() throws IOException {
        int n = this.setDIS.read();
        if (n >= 0 && this.underlying) {
            ++this.curOffset;
        }
        return n;
    }

    public final synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.setDIS.read(byArray, n, n2);
        if (n3 < 0) {
            if (!this.underlying) {
                this.setInputStream(this.curOffset);
                return 0;
            }
            return n3;
        }
        if (this.underlying) {
            this.curOffset += n3;
        }
        return n3;
    }

    public final boolean readBoolean() throws IOException {
        if (this.underlying) {
            ++this.curOffset;
        }
        return this.setD.readBoolean();
    }

    public final byte readByte() throws IOException {
        byte by = this.setD.readByte();
        if (by >= 0) {
            ++this.curOffset;
        }
        return by;
    }

    public final char readChar() throws IOException {
        char c = this.setD.readChar();
        if (this.underlying) {
            this.curOffset += 2;
        }
        return c;
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    protected static int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n3, n2 - n3);
            if (n4 < 0) {
                return -n3;
            }
            n3 += n4;
        }
        return n3;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.setD.readFully(byArray, 0, byArray.length);
        if (this.underlying) {
            this.curOffset += byArray.length;
        }
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.setD.readFully(byArray, n, n2);
        if (this.underlying) {
            this.curOffset += n2;
        }
    }

    public final int readInt() throws IOException {
        int n = this.setD.readInt();
        if (this.underlying) {
            this.curOffset += 4;
        }
        return n;
    }

    public final String readLine() throws IOException {
        return new String();
    }

    public final long readLong() throws IOException {
        long l = this.setD.readLong();
        if (this.underlying) {
            this.curOffset += 8;
        }
        return l;
    }

    public final short readShort() throws IOException {
        short s = this.setD.readShort();
        if (this.underlying) {
            this.curOffset += 2;
        }
        return s;
    }

    public final String readUTF() throws IOException {
        return this.setD.readUTF();
    }

    public final String readUTF(DataInput dataInput) throws IOException {
        return DataInputStream.readUTF(dataInput);
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.setD.readUnsignedByte();
        if (n >= 0) {
            ++this.curOffset;
        }
        return n;
    }

    public final int readUnsignedShort() throws IOException {
        int n = this.setD.readUnsignedShort();
        if (n >= 0 && this.underlying) {
            this.curOffset += 2;
        }
        return n;
    }

    public synchronized void reset() throws IOException {
    }

    public synchronized void seek(int n) throws IOException {
        this.setInputStream(n);
    }

    protected void setInputStream(int n) throws IOException {
        InputStream inputStream;
        this.underlying = false;
        if (n == this.curOffset) {
            inputStream = this.in;
            this.underlying = true;
        } else if (n > this.curOffset) {
            int n2 = n - this.curOffset;
            ByteBuf byteBuf = new ByteBuf(this.curOffset, n2);
            int n3 = SeekInputStream.readFully(this.in, byteBuf.buf, 0, n2);
            if (n3 < 0) {
                this.curOffset += -n3;
                throw new IOException();
            }
            this.curOffset += n3;
            this.bufs.addElement(byteBuf);
            inputStream = this.in;
            this.underlying = true;
        } else {
            inputStream = this.getBufIS(n);
        }
        this.setD = this.be ? new DataInputStream(inputStream) : new LEDataInputStream(inputStream);
        this.setDIS = (InputStream)((Object)this.setD);
    }

    public long skip(long l) throws IOException {
        long l2 = this.setDIS.skip(l);
        if (l2 < 0L) {
            if (!this.underlying) {
                this.setInputStream(this.curOffset);
                return 0L;
            }
            return l2;
        }
        if (this.underlying) {
            this.curOffset = (int)((long)this.curOffset + l2);
        }
        return l2;
    }

    public final int skipBytes(int n) throws IOException {
        int n2 = this.setD.skipBytes(n);
        if (this.underlying) {
            this.curOffset += n2;
        }
        return n2;
    }
}

