/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Comparator;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.SortedBag;

public class BagUtils {
    private BagUtils() {
    }

    public static Bag predicatedBag(Bag bag, Predicate predicate) {
        return new PredicatedBag(bag, predicate);
    }

    public static Bag unmodifiableBag(Bag bag) {
        return new UnmodifiableBag(bag);
    }

    public static Bag synchronizedBag(Bag bag) {
        return new SynchronizedBag(bag);
    }

    public static SortedBag predicatedSortedBag(SortedBag sortedBag, Predicate predicate) {
        return new PredicatedSortedBag(sortedBag, predicate);
    }

    public static SortedBag unmodifiableSortedBag(SortedBag sortedBag) {
        return new UnmodifiableSortedBag(sortedBag);
    }

    public static SortedBag synchronizedSortedBag(SortedBag sortedBag) {
        return new SynchronizedSortedBag(sortedBag);
    }

    static class PredicatedBag
    extends CollectionUtils.PredicatedCollection
    implements Bag {
        public PredicatedBag(Bag bag, Predicate predicate) {
            super(bag, predicate);
        }

        public boolean add(Object object, int n) {
            this.validate(object);
            return this.getBag().add(object, n);
        }

        public boolean remove(Object object, int n) {
            return this.getBag().remove(object, n);
        }

        public Set uniqueSet() {
            return this.getBag().uniqueSet();
        }

        public int getCount(Object object) {
            return this.getBag().getCount(object);
        }

        private Bag getBag() {
            return (Bag)this.collection;
        }
    }

    static class UnmodifiableBag
    extends CollectionUtils.UnmodifiableCollection
    implements Bag {
        public UnmodifiableBag(Bag bag) {
            super(bag);
        }

        private Bag getBag() {
            return (Bag)this.collection;
        }

        public boolean add(Object object, int n) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object, int n) {
            throw new UnsupportedOperationException();
        }

        public Set uniqueSet() {
            return ((Bag)this.collection).uniqueSet();
        }

        public int getCount(Object object) {
            return ((Bag)this.collection).getCount(object);
        }
    }

    static class SynchronizedBag
    extends CollectionUtils.SynchronizedCollection
    implements Bag {
        public SynchronizedBag(Bag bag) {
            super(bag);
        }

        public synchronized boolean add(Object object, int n) {
            return this.getBag().add(object, n);
        }

        public synchronized boolean remove(Object object, int n) {
            return this.getBag().remove(object, n);
        }

        public synchronized Set uniqueSet() {
            return this.getBag().uniqueSet();
        }

        public synchronized int getCount(Object object) {
            return this.getBag().getCount(object);
        }

        private Bag getBag() {
            return (Bag)this.collection;
        }
    }

    static class PredicatedSortedBag
    extends PredicatedBag
    implements SortedBag {
        public PredicatedSortedBag(SortedBag sortedBag, Predicate predicate) {
            super(sortedBag, predicate);
        }

        public Comparator comparator() {
            return this.getSortedBag().comparator();
        }

        public Object first() {
            return this.getSortedBag().first();
        }

        public Object last() {
            return this.getSortedBag().last();
        }

        private SortedBag getSortedBag() {
            return (SortedBag)this.collection;
        }
    }

    static class SynchronizedSortedBag
    extends SynchronizedBag
    implements SortedBag {
        public SynchronizedSortedBag(SortedBag sortedBag) {
            super(sortedBag);
        }

        public synchronized Comparator comparator() {
            return this.getSortedBag().comparator();
        }

        public synchronized Object first() {
            return this.getSortedBag().first();
        }

        public synchronized Object last() {
            return this.getSortedBag().last();
        }

        private SortedBag getSortedBag() {
            return (SortedBag)this.collection;
        }
    }

    static class UnmodifiableSortedBag
    extends UnmodifiableBag
    implements SortedBag {
        public UnmodifiableSortedBag(SortedBag sortedBag) {
            super(sortedBag);
        }

        public Comparator comparator() {
            return this.getSortedBag().comparator();
        }

        public Object first() {
            return this.getSortedBag().first();
        }

        public Object last() {
            return this.getSortedBag().last();
        }

        private SortedBag getSortedBag() {
            return (SortedBag)this.collection;
        }
    }
}

