/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowData;
import com.mysql.jdbc.Util;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import java.sql.SQLException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RowDataDynamic
implements RowData {
    private int columnCount;
    private Field[] fields;
    private int index;
    private MysqlIO io;
    private boolean isAfterEnd;
    private boolean isAtEnd;
    private boolean isBinaryEncoded;
    private Object[] nextRow;
    private ResultSet owner;
    private boolean streamerClosed;

    public void addRow(byte[][] row) throws SQLException {
        this.notSupported();
    }

    public void afterLast() throws SQLException {
        this.notSupported();
    }

    public void beforeFirst() throws SQLException {
        this.notSupported();
    }

    public void beforeLast() throws SQLException {
        this.notSupported();
    }

    public void close() throws SQLException {
        Connection conn;
        boolean hadMore = false;
        int howMuchMore = 0;
        while (this.hasNext()) {
            this.next();
            hadMore = true;
            if (++howMuchMore % 100 != 0) continue;
            Thread.yield();
        }
        if (this.owner != null && (conn = this.owner.connection) != null && conn.getUseUsageAdvisor() && hadMore) {
            ProfileEventSink eventSink = ProfileEventSink.getInstance(conn);
            eventSink.consumeEvent(new ProfilerEvent(0, "", this.owner.owningStatement == null ? "N/A" : this.owner.owningStatement.currentCatalog, conn.getId(), this.owner.owningStatement == null ? -1 : this.owner.owningStatement.getId(), -1, System.currentTimeMillis(), 0, null, null, Messages.getString("RowDataDynamic.2") + howMuchMore + Messages.getString("RowDataDynamic.3") + Messages.getString("RowDataDynamic.4") + Messages.getString("RowDataDynamic.5") + Messages.getString("RowDataDynamic.6") + this.owner.pointOfOrigin));
        }
        this.fields = null;
        this.owner = null;
    }

    public Object[] getAt(int ind) throws SQLException {
        this.notSupported();
        return null;
    }

    public int getCurrentRowNumber() throws SQLException {
        this.notSupported();
        return -1;
    }

    public ResultSet getOwner() {
        return this.owner;
    }

    public boolean hasNext() throws SQLException {
        boolean hasNext;
        boolean bl = false;
        if (this.nextRow != null) {
            bl = true;
        }
        if (!(hasNext = bl) && !this.streamerClosed) {
            this.io.closeStreamer(this);
            this.streamerClosed = true;
        }
        return hasNext;
    }

    public boolean isAfterLast() throws SQLException {
        return this.isAfterEnd;
    }

    public boolean isBeforeFirst() throws SQLException {
        boolean bl = false;
        if (this.index < 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isEmpty() throws SQLException {
        this.notSupported();
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.notSupported();
        return false;
    }

    public boolean isLast() throws SQLException {
        this.notSupported();
        return false;
    }

    public void moveRowRelative(int rows) throws SQLException {
        this.notSupported();
    }

    public Object[] next() throws SQLException {
        if (this.index != Integer.MAX_VALUE) {
            ++this.index;
        }
        Object[] ret = this.nextRow;
        this.nextRecord();
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private final void nextRecord() throws SQLException {
        try {
            if (!this.isAtEnd) {
                this.nextRow = this.io.nextRow(this.fields, this.columnCount, this.isBinaryEncoded, 1007);
                if (this.nextRow == null) {
                    this.isAtEnd = true;
                }
            } else {
                this.isAfterEnd = true;
            }
        }
        catch (SQLException sqlEx) {
            void ex;
            throw ex;
        }
        catch (Exception ex) {
            String exceptionType = ex.getClass().getName();
            String exceptionMessage = ex.getMessage();
            exceptionMessage = exceptionMessage + Messages.getString("RowDataDynamic.7");
            exceptionMessage = exceptionMessage + Util.stackTraceToString(ex);
            throw new SQLException(Messages.getString("RowDataDynamic.8") + exceptionType + Messages.getString("RowDataDynamic.9") + exceptionMessage, "S1000");
        }
    }

    private final void notSupported() throws SQLException {
        throw new OperationNotSupportedException();
    }

    public void removeRow(int ind) throws SQLException {
        this.notSupported();
    }

    public void setCurrentRow(int rowNumber) throws SQLException {
        this.notSupported();
    }

    public void setOwner(ResultSet rs) {
        this.owner = rs;
    }

    public int size() {
        return -1;
    }

    private final /* synthetic */ void this() {
        this.index = -1;
        this.isAfterEnd = false;
        this.isAtEnd = false;
        this.isBinaryEncoded = false;
        this.streamerClosed = false;
    }

    public RowDataDynamic(MysqlIO io, int colCount, Field[] fields, boolean isBinaryEncoded) throws SQLException {
        this.this();
        this.io = io;
        this.columnCount = colCount;
        this.isBinaryEncoded = isBinaryEncoded;
        this.fields = fields;
        this.nextRecord();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class OperationNotSupportedException
    extends SQLException {
        OperationNotSupportedException() {
            super(Messages.getString("RowDataDynamic.10"), "S1009");
        }
    }
}

