/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowData;
import java.util.ArrayList;
import java.util.List;

public class RowDataStatic
implements RowData {
    private int index = -1;
    ResultSet owner;
    private List rows;

    public void addRow(byte[][] row) {
        this.rows.add(row);
    }

    public void afterLast() {
        this.index = this.rows.size();
    }

    public void beforeFirst() {
        this.index = -1;
    }

    public void beforeLast() {
        this.index = this.rows.size() - 2;
    }

    public void close() {
    }

    public Object[] getAt(int atIndex) {
        if (atIndex < 0 || atIndex >= this.rows.size()) {
            return null;
        }
        return (Object[])this.rows.get(atIndex);
    }

    public int getCurrentRowNumber() {
        return this.index;
    }

    public ResultSet getOwner() {
        return this.owner;
    }

    public boolean hasNext() {
        boolean bl = false;
        if (this.index + 1 < this.rows.size()) {
            bl = true;
        }
        boolean hasMore = bl;
        return hasMore;
    }

    public boolean isAfterLast() {
        boolean bl = false;
        if (this.index >= this.rows.size()) {
            bl = true;
        }
        return bl;
    }

    public boolean isBeforeFirst() {
        boolean bl = false;
        if (this.index == -1 && this.rows.size() != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.rows.size() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isFirst() {
        boolean bl = false;
        if (this.index == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isLast() {
        if (this.rows.size() == 0) {
            return false;
        }
        boolean bl = false;
        if (this.index == this.rows.size() - 1) {
            bl = true;
        }
        return bl;
    }

    public void moveRowRelative(int rowsToMove) {
        this.index += rowsToMove;
    }

    public Object[] next() {
        ++this.index;
        if (this.index < this.rows.size()) {
            return (Object[])this.rows.get(this.index);
        }
        return null;
    }

    public void removeRow(int atIndex) {
        this.rows.remove(atIndex);
    }

    public void setCurrentRow(int newIndex) {
        this.index = newIndex;
    }

    public void setOwner(ResultSet rs) {
        this.owner = rs;
    }

    public int size() {
        return this.rows.size();
    }

    public RowDataStatic(ArrayList rows) {
        this.rows = rows;
    }
}

